/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.helpers.command;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.py.debugger.JupyterDebugProcess;
import com.intellij.jupyter.py.helpers.JupyterPyHelperProvider;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/py/helpers/command/JupyterPyHelperCommandBuilder;", "", "<init>", "()V", "createHelpersCommand", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "unzipOnServerCode", "zipHelperRelativeSessionPath", "Ljava/nio/file/Path;", "intellij.jupyter.py"})
public final class JupyterPyHelperCommandBuilder {
    @NotNull
    public static final JupyterPyHelperCommandBuilder INSTANCE = new JupyterPyHelperCommandBuilder();

    private JupyterPyHelperCommandBuilder() {
    }

    @NotNull
    public final String createHelpersCommand(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        StringBuilder command = new StringBuilder();
        command.append("# pydev_util_command\n");
        command.append(JupyterDebugProcess.Companion.getDONT_WRITE_BYTECODE());
        List<Path> libsPaths = JupyterPyHelperProvider.Companion.getRequiredLibPaths(virtualFile, project);
        if (libsPaths.isEmpty()) {
            return "";
        }
        String joinedPaths = CollectionsKt.joinToString$default((Iterable)libsPaths, (CharSequence)" ,", null, null, (int)0, null, JupyterPyHelperCommandBuilder::createHelpersCommand$lambda$0, (int)30, null);
        command.append(StringsKt.trimMargin$default((String)("\n            |def initPycharmLibs():\n            |    import sys\n            |    import os\n            |    \n            |    paths = [" + joinedPaths + "]\n            |    for path in paths:\n            |        normed_path = os.path.normpath(path)\n            |        os_valid_path = os.path.normpath(os.path.join(os.getcwd(), normed_path))\n            |        if path not in sys.path:\n            |            sys.path.insert(0, os_valid_path)\n            |    import importlib\n            |    importlib.invalidate_caches()\n            |initPycharmLibs()\n            |del initPycharmLibs\n            |"), null, (int)1, null));
        command.append("from pydev_jupyter_utils import remove_imported_pydev_package\nremove_imported_pydev_package()\ndel remove_imported_pydev_package\n");
        String string = command.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String unzipOnServerCode(@NotNull Path zipHelperRelativeSessionPath) {
        Intrinsics.checkNotNullParameter((Object)zipHelperRelativeSessionPath, (String)"zipHelperRelativeSessionPath");
        String code = StringsKt.trimMargin$default((String)("\n      |def jupyter_extract_zip():\n      |  import zipfile\n      |  import os\n      |  import traceback\n      |  zip_path = os.path.normpath('" + zipHelperRelativeSessionPath + "')\n      |  folder_path = os.path.splitext(zip_path)[0]  # gets 'jupyter_debug'\n      |  with zipfile.ZipFile(zip_path, 'r') as zip_ref:\n      |      zip_ref.extractall(folder_path)\n      |  os.remove(zip_path)\n      |jupyter_extract_zip()\n      |del jupyter_extract_zip\n      |\n      "), null, (int)1, null);
        return code;
    }

    private static final CharSequence createHelpersCommand$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }
}

