/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ElementCreation;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ElementRemotion;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicExtension;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.migration.DbMigrationElement;
import com.intellij.database.model.migration.DbMigrationRequest;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.model.migration.DbMigrationTreeModelKt;
import com.intellij.database.model.migration.DiffStatus;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.structure.DvDisplayNodesComparator;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.SqlFileType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.tree.AbstractTreeModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0005STUVWB)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u001b\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000bJ\b\u0010%\u001a\u00020&H\u0002J\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(2\u0006\u0010+\u001a\u00020\bJ\u0014\u0010,\u001a\u00060\u0011R\u00020\u00002\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u0010/\u001a\u000200J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020&H\u0002J\u0010\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030605J\u0006\u00107\u001a\u000202J\b\u00108\u001a\u000202H\u0002J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\b\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020\bH\u0002J\u001e\u0010=\u001a\u00020\b2\n\u0010>\u001a\u00060\rR\u00020\u00002\b\b\u0002\u0010?\u001a\u00020\bH\u0007J\u0014\u0010@\u001a\u00020\b2\n\u0010A\u001a\u0006\u0012\u0002\b\u000306H\u0002J\u0010\u0010B\u001a\u00020\b2\u0006\u0010C\u001a\u00020)H\u0002J\u0010\u0010D\u001a\u00020\b2\u0006\u0010E\u001a\u00020)H\u0002J\u0014\u0010F\u001a\u00020\b2\n\u0010>\u001a\u00060\rR\u00020\u0000H\u0002J\u0012\u0010G\u001a\u00020\b2\b\u0010C\u001a\u0004\u0018\u00010)H\u0002J\u0010\u0010H\u001a\u00020\b2\u0006\u0010C\u001a\u00020)H\u0014J\u001e\u0010I\u001a\f\u0012\b\u0012\u00060\rR\u00020\u00000\u001a2\n\u0010>\u001a\u00060\rR\u00020\u0000H\u0014J\u001a\u0010J\u001a\u0002022\u0010\u0010K\u001a\f\u0012\b\u0012\u00060\rR\u00020\u000005H\u0002JT\u0010L\u001a\f\u0012\b\u0012\u00060\rR\u00020\u000005\"\u0004\b\u0000\u0010M2\n\u0010N\u001a\u00060\rR\u00020\u00002\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\u0012\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002HM0RH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\u00060\rR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0010\u001a\u00060\u0011R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0016\u001a\u00060\u0011R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0017\u0010\u0013R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006X"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "", "origin", "Lcom/intellij/database/model/migration/DbMigrationElement;", "target", "request", "Lcom/intellij/database/model/migration/DbMigrationRequest;", "showIdentical", "", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationElement;Lcom/intellij/database/model/migration/DbMigrationElement;Lcom/intellij/database/model/migration/DbMigrationRequest;Z)V", "(Lcom/intellij/database/model/migration/DbMigrationRequest;Z)V", "rootNode", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "getRootNode", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "originTreeModel", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$PresentableTreeModel;", "getOriginTreeModel", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$PresentableTreeModel;", "originTreeModel$delegate", "Lkotlin/Lazy;", "targetTreeModel", "getTargetTreeModel", "targetTreeModel$delegate", "dividerMapping", "", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingItem;", "getDividerMapping", "()Ljava/util/List;", "setDividerMapping", "(Ljava/util/List;)V", "value", "getShowIdentical", "()Z", "setShowIdentical", "(Z)V", "getScriptGenerator", "Lcom/intellij/database/script/generator/ScriptGenerator;", "prepare", "", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/basic/BasicModElement;", "withSources", "getTreeModel", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "getUnifiedTreeModel", "Lcom/intellij/util/ui/tree/AbstractTreeModel;", "initialize", "", "generator", "computeCorrespondence", "", "Lcom/intellij/database/model/ElementDelta;", "recomputeDividerMappingAndCounters", "setCountersToZero", "computeDividerMappingAndCounters", "identifierCasing", "Lcom/intellij/database/util/Case;", "shouldShowExtensionMembers", "filterNode", "node", "showExtensions", "filterElementDelta", "delta", "filterBasicElement", "element", "filterImplicitObjects", "base", "hasExtensionObject", "isExtensionObject", "customFilter", "computeChildren", "sortChildren", "children", "matchChildren", "Key", "parent", "originChildren", "targetChildren", "keyExtractor", "Lkotlin/Function1;", "Side", "MappingItem", "PresentableTreeModel", "MappingState", "Node", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMigrationTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationTreeModel.kt\ncom/intellij/database/model/migration/DbMigrationTreeModel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,703:1\n23#2:704\n13#2:709\n23#2:712\n1915#3,2:705\n1915#3,2:707\n1915#3,2:710\n*S KotlinDebug\n*F\n+ 1 DbMigrationTreeModel.kt\ncom/intellij/database/model/migration/DbMigrationTreeModel\n*L\n240#1:704\n640#1:709\n657#1:712\n266#1:705,2\n301#1:707,2\n284#1:710,2\n*E\n"})
public class DbMigrationTreeModel {
    @NotNull
    private final DbMigrationRequest request;
    @NotNull
    private final Node rootNode;
    @NotNull
    private final Lazy originTreeModel$delegate;
    @NotNull
    private final Lazy targetTreeModel$delegate;
    @NotNull
    private List<MappingItem> dividerMapping;
    private boolean showIdentical;

    private DbMigrationTreeModel(DbMigrationElement origin, DbMigrationElement target, DbMigrationRequest request, boolean showIdentical) {
        BasicModModel altModel;
        this.request = request;
        this.rootNode = new Node(null, origin, target);
        this.originTreeModel$delegate = LazyKt.lazy(() -> DbMigrationTreeModel.originTreeModel_delegate$lambda$0(this));
        this.targetTreeModel$delegate = LazyKt.lazy(() -> DbMigrationTreeModel.targetTreeModel_delegate$lambda$0(this));
        this.showIdentical = showIdentical;
        DbMigrationElement dbMigrationElement = this.rootNode.getOrigin();
        BasicModModel basicModModel = dbMigrationElement != null && (dbMigrationElement = dbMigrationElement.getAltElement()) != null ? (BasicModModel)dbMigrationElement.getModel() : (altModel = null);
        if (altModel != null) {
            BaseModel.modifyFast((BasicModel)((BasicModel)altModel), (ModelModifier)new ModelModifier(){

                public final void perform(BasicModRoot it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Map<BasicElement, BasicModElement> index = this.prepare(!request.getOptions().getIgnoreSourceCode());
                    this.getRootNode().pullDeps(index);
                }
            });
        } else {
            DbMigrationTreeModel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DbMigrationTreeModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Root alt model not initialized");
        }
        this.initialize(this.getScriptGenerator());
        this.dividerMapping = this.computeDividerMappingAndCounters();
    }

    @JvmOverloads
    public DbMigrationTreeModel(@NotNull DbMigrationRequest request, boolean showIdentical) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this(DbMigrationTreeModelKt.access$initializeRootElement(request, Side.ORIGIN), DbMigrationTreeModelKt.access$initializeRootElement(request, Side.TARGET), request, showIdentical);
    }

    public /* synthetic */ DbMigrationTreeModel(DbMigrationRequest dbMigrationRequest, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(dbMigrationRequest, bl);
    }

    @NotNull
    public final Node getRootNode() {
        return this.rootNode;
    }

    @NotNull
    public final PresentableTreeModel getOriginTreeModel() {
        Lazy lazy = this.originTreeModel$delegate;
        return (PresentableTreeModel)((Object)lazy.getValue());
    }

    @NotNull
    public final PresentableTreeModel getTargetTreeModel() {
        Lazy lazy = this.targetTreeModel$delegate;
        return (PresentableTreeModel)((Object)lazy.getValue());
    }

    @NotNull
    public final List<MappingItem> getDividerMapping() {
        return this.dividerMapping;
    }

    public final void setDividerMapping(@NotNull List<MappingItem> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dividerMapping = list;
    }

    public final boolean getShowIdentical() {
        return this.showIdentical;
    }

    public final void setShowIdentical(boolean value) {
        this.showIdentical = value;
        this.getOriginTreeModel().treeStructureChanged();
        this.getTargetTreeModel().treeStructureChanged();
    }

    private final ScriptGenerator getScriptGenerator() {
        BasicModel model;
        BasicModel basicModel = model = this.request.getElement(Side.ORIGIN).getModel();
        Intrinsics.checkNotNull((Object)basicModel);
        return ScriptGenerators.INSTANCE.byModel(basicModel);
    }

    @NotNull
    public final Map<BasicElement, BasicModElement> prepare(boolean withSources) {
        Map index = new LinkedHashMap();
        this.rootNode.prepare(index, withSources);
        return index;
    }

    private final PresentableTreeModel getTreeModel(Side side) {
        return new PresentableTreeModel(side);
    }

    @NotNull
    public final AbstractTreeModel getUnifiedTreeModel() {
        return new PresentableTreeModel(null);
    }

    private final void initialize(ScriptGenerator generator) {
        JBIterable jBIterable = ((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DbMigrationTreeModel.initialize$lambda$0((Function1)initialize.1.INSTANCE, arg_0)).withRoot((Object)this.rootNode)).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            it.initDeltaAndDiffStatus(generator);
            it.initExtensionFlag();
        }
    }

    @NotNull
    public final List<ElementDelta<?>> computeCorrespondence() {
        List result2 = new ArrayList();
        DbMigrationTreeModel.computeCorrespondence$computeCorrespondenceImpl(this, result2, this.rootNode);
        return result2;
    }

    public final void recomputeDividerMappingAndCounters() {
        this.setCountersToZero();
        this.dividerMapping = this.computeDividerMappingAndCounters();
    }

    private final void setCountersToZero() {
        JBIterable jBIterable = ((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DbMigrationTreeModel.setCountersToZero$lambda$0((Function1)setCountersToZero.1.INSTANCE, arg_0)).withRoot((Object)this.rootNode)).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            it.setIncludedChildrenMappingCount(0);
            it.setChildrenMappingCount(0);
        }
    }

    private final List<MappingItem> computeDividerMappingAndCounters() {
        List result2 = new ArrayList();
        DbMigrationTreeModel.computeDividerMappingAndCounters$computeDividerMappingImpl(this, result2, this.rootNode, new TreePath(this.rootNode));
        return result2;
    }

    private final Case identifierCasing() {
        return (Boolean)this.request.getOptions().getScriptingOptions().get(ScriptingOptionStatic.IGNORE_CASE_CHANGES) != false ? Case.LOWER : Case.MIXED;
    }

    private final boolean shouldShowExtensionMembers() {
        return (Boolean)this.request.getOptions().getScriptingOptions().get(ScriptingOptionStatic.IGNORE_EXTENSION_MEMBERS) == false;
    }

    @JvmOverloads
    public final boolean filterNode(@NotNull Node node, boolean showExtensions) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ElementDelta<BasicElement> delta = node.getElementDelta();
        return !(delta != null && !this.filterElementDelta(delta) || !showExtensions && node.getHasExtensionObject());
    }

    public static /* synthetic */ boolean filterNode$default(DbMigrationTreeModel dbMigrationTreeModel, Node node, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: filterNode");
        }
        if ((n & 2) != 0) {
            bl = dbMigrationTreeModel.shouldShowExtensionMembers();
        }
        return dbMigrationTreeModel.filterNode(node, bl);
    }

    private final boolean filterElementDelta(ElementDelta<?> delta) {
        BasicElement source = delta.getSourceElement();
        BasicElement target = delta.getTargetElement();
        if (source != null && !this.filterBasicElement(source)) {
            return false;
        }
        return target == null || this.filterBasicElement(target);
    }

    private final boolean filterBasicElement(BasicElement element) {
        return this.filterImplicitObjects(element) && this.customFilter(element);
    }

    private final boolean filterImplicitObjects(BasicElement base) {
        return !this.request.getOptions().getIgnoreImplicitObjects() || !DbDiffElement.isImplicitObject(base);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasExtensionObject(Node node) {
        DbMigrationElement dbMigrationElement = node.getOrigin();
        BasicNode basicNode = dbMigrationElement != null ? dbMigrationElement.getBase() : null;
        if (this.isExtensionObject(basicNode instanceof BasicElement ? (BasicElement)basicNode : null)) return true;
        DbMigrationElement dbMigrationElement2 = node.getTarget();
        BasicNode basicNode2 = dbMigrationElement2 != null ? dbMigrationElement2.getBase() : null;
        if (!this.isExtensionObject(basicNode2 instanceof BasicElement ? (BasicElement)basicNode2 : null)) return false;
        return true;
    }

    private final boolean isExtensionObject(BasicElement element) {
        Family extensions;
        if (element == null) {
            return false;
        }
        BasicDatabase basicDatabase = element.getDatabase();
        Object object = extensions = basicDatabase != null ? basicDatabase.familyOf(ObjectKind.EXTENSION) : null;
        if (extensions != null) {
            for (BasicElement e : extensions) {
                if ((e instanceof BasicExtension ? (BasicExtension)e : null) == null) continue;
                for (BasicReferenceInfo info2 : ((BasicExtension)e).getMemberRefInfos()) {
                    if (!info2.matches(element)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean customFilter(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.request.getElementFilter() == null || this.request.getElementFilter().filter(element);
    }

    @NotNull
    protected List<Node> computeChildren(@NotNull Node node) {
        Object targetChildren;
        Object object;
        Object originChildren;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object object2 = node.getOrigin();
        if (object2 == null || (object2 = ((DbMigrationElement)object2).getChildren()) == null) {
            object2 = originChildren = CollectionsKt.emptyList();
        }
        if ((object = node.getTarget()) == null || (object = ((DbMigrationElement)object).getChildren()) == null) {
            object = targetChildren = CollectionsKt.emptyList();
        }
        if (originChildren.isEmpty() && targetChildren.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)node, (Object)this.rootNode) && this.request.isComparingLeaves()) {
            if (originChildren.size() != 1 || targetChildren.size() != 1) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(DbMigrationTreeModel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Wrong manipulation with real root elements?");
                return CollectionsKt.emptyList();
            }
            Node child = new Node(node, (DbMigrationElement)CollectionsKt.first((List)originChildren), (DbMigrationElement)CollectionsKt.first((List)targetChildren));
            return CollectionsKt.listOf((Object)child);
        }
        Function1 keyExtractor = arg_0 -> DbMigrationTreeModel.computeChildren$lambda$0(this, arg_0);
        List<Node> children = this.matchChildren(node, (List<DbMigrationElement>)originChildren, (List<DbMigrationElement>)targetChildren, keyExtractor);
        boolean areChildrenFamilies = node.isBasicElementNode();
        if (areChildrenFamilies) {
            this.sortChildren(children);
        }
        return children;
    }

    private final void sortChildren(List<Node> children) {
        Comparator comparator = (Comparator)DvDisplayNodesComparator.INSTANCE;
        Comparator cmp = new Comparator(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                Node n;
                Node node = (Node)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                DbMigrationElement dbMigrationElement = n.getOrigin();
                if (dbMigrationElement == null) {
                    dbMigrationElement = n.getTarget();
                }
                Intrinsics.checkNotNull((Object)dbMigrationElement);
                DbMigrationElement someElement = dbMigrationElement;
                n = (Node)b;
                BasicNode basicNode = someElement.getBase();
                bl = false;
                DbMigrationElement dbMigrationElement2 = n.getOrigin();
                if (dbMigrationElement2 == null) {
                    dbMigrationElement2 = n.getTarget();
                }
                Intrinsics.checkNotNull((Object)dbMigrationElement2);
                someElement = dbMigrationElement2;
                BasicNode basicNode2 = someElement.getBase();
                return comparator.compare(basicNode, basicNode2);
            }
        };
        CollectionsKt.sortWith(children, (Comparator)cmp);
    }

    private final <Key> List<Node> matchChildren(Node parent2, List<DbMigrationElement> originChildren, List<DbMigrationElement> targetChildren, Function1<? super DbMigrationElement, ? extends Key> keyExtractor) {
        Map originChildrenByKey = new LinkedHashMap();
        for (DbMigrationElement originElement : originChildren) {
            Object key;
            if (keyExtractor.invoke((Object)originElement) == null) continue;
            originChildrenByKey.put(key, originElement);
        }
        List children = new ArrayList();
        for (DbMigrationElement targetElement : targetChildren) {
            Object key;
            if (keyExtractor.invoke((Object)targetElement) == null) continue;
            DbMigrationElement originElement = (DbMigrationElement)originChildrenByKey.remove(key);
            children.add(new Node(parent2, originElement, targetElement));
        }
        for (DbMigrationElement originElement : originChildrenByKey.values()) {
            children.add(new Node(parent2, originElement, null));
        }
        return children;
    }

    @JvmOverloads
    public DbMigrationTreeModel(@NotNull DbMigrationRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this(request, false, 2, null);
    }

    @JvmOverloads
    public final boolean filterNode(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return DbMigrationTreeModel.filterNode$default(this, node, false, 2, null);
    }

    private static final PresentableTreeModel originTreeModel_delegate$lambda$0(DbMigrationTreeModel this$0) {
        return this$0.getTreeModel(Side.ORIGIN);
    }

    private static final PresentableTreeModel targetTreeModel_delegate$lambda$0(DbMigrationTreeModel this$0) {
        return this$0.getTreeModel(Side.TARGET);
    }

    private static final Iterable initialize$lambda$0(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final void computeCorrespondence$computeCorrespondenceImpl(DbMigrationTreeModel this$0, List<ElementDelta<?>> result2, Node node) {
        boolean addedOrDeleted;
        ElementDelta<BasicElement> delta;
        if (!DbMigrationTreeModel.filterNode$default(this$0, node, false, 2, null)) {
            return;
        }
        if (node.isBasicElementNode() && (!node.getContainsMapping() || node.getIncluded()) && (delta = node.getElementDelta()) != null) {
            ((Collection)result2).add(delta);
        }
        boolean bl = addedOrDeleted = node.getStatus() == DiffStatus.ADDED || node.getStatus() == DiffStatus.DELETED;
        if (node.getContainsMapping() && !node.getIncluded() && addedOrDeleted) {
            return;
        }
        Iterable $this$forEach$iv = node.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node p0 = (Node)element$iv;
            boolean bl2 = false;
            DbMigrationTreeModel.computeCorrespondence$computeCorrespondenceImpl(this$0, result2, p0);
        }
    }

    private static final Iterable setCountersToZero$lambda$0(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final int computeDividerMappingAndCounters$computeDividerMappingImpl$lambda$0(TreePath $path, DbMigrationTreeModel this$0, List $result, Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TreePath treePath = $path.pathByAddingChild(it);
        Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"pathByAddingChild(...)");
        return DbMigrationTreeModel.computeDividerMappingAndCounters$computeDividerMappingImpl(this$0, $result, it, treePath);
    }

    private static final int computeDividerMappingAndCounters$computeDividerMappingImpl(DbMigrationTreeModel this$0, List<MappingItem> result2, Node node, TreePath path) {
        boolean addedOrDeletedMapping;
        if (node.getStatus() == null) {
            return 0;
        }
        if (!DbMigrationTreeModel.filterNode$default(this$0, node, false, 2, null)) {
            return 0;
        }
        boolean bl = addedOrDeletedMapping = node.isBasicElementNode() && (node.getStatus() == DiffStatus.ADDED || node.getStatus() == DiffStatus.DELETED);
        if (!addedOrDeletedMapping) {
            node.setChildrenMappingCount(SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)node.getChildren()), arg_0 -> DbMigrationTreeModel.computeDividerMappingAndCounters$computeDividerMappingImpl$lambda$0(path, this$0, result2, arg_0))));
            node.setIncludedChildrenMappingCount(node.getChildrenMappingCount());
        }
        int count = node.getChildrenMappingCount();
        if (!Intrinsics.areEqual((Object)node, (Object)this$0.rootNode) && node.isBasicElementNode() && node.getStatus() != DiffStatus.SAME) {
            node.setMappingState(new MappingState(false, 1, null));
            Collection collection = result2;
            DiffStatus diffStatus = node.getStatus();
            Intrinsics.checkNotNull((Object)((Object)diffStatus));
            collection.add(new MappingItem(diffStatus, path));
            ++count;
        }
        return count;
    }

    private static final Object computeChildren$lambda$0(DbMigrationTreeModel this$0, DbMigrationElement it) {
        Triple triple;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BasicNode base = it.getBase();
        if (base instanceof BasicElement) {
            Case casing = this$0.identifierCasing();
            String identity = casing.apply(ObjectPaths.getIdentity((DasObject)((DasObject)base), (boolean)true, (boolean)false));
            String name = casing.apply(((BasicElement)base).getNaturalName());
            triple = new Triple((Object)((BasicElement)base).getKind(), (Object)name, (Object)identity);
        } else if (base instanceof Family) {
            triple = new Triple((Object)((Family)base).getMetaObject().kind, null, null);
        } else {
            DbMigrationTreeModel $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DbMigrationTreeModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Extra nodes must be skipped: " + base);
            triple = null;
        }
        return triple;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingItem;", "", "status", "Lcom/intellij/database/model/migration/DiffStatus;", "path", "Ljavax/swing/tree/TreePath;", "<init>", "(Lcom/intellij/database/model/migration/DiffStatus;Ljavax/swing/tree/TreePath;)V", "getStatus", "()Lcom/intellij/database/model/migration/DiffStatus;", "getPath", "()Ljavax/swing/tree/TreePath;", "intellij.database.impl"})
    public static final class MappingItem {
        @NotNull
        private final DiffStatus status;
        @NotNull
        private final TreePath path;

        public MappingItem(@NotNull DiffStatus status, @NotNull TreePath path) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.status = status;
            this.path = path;
        }

        @NotNull
        public final DiffStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final TreePath getPath() {
            return this.path;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\t"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingState;", "", "included", "", "<init>", "(Z)V", "getIncluded", "()Z", "setIncluded", "intellij.database.impl"})
    public static final class MappingState {
        private boolean included;

        public MappingState(boolean included) {
            this.included = included;
        }

        public /* synthetic */ MappingState(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(bl);
        }

        public final boolean getIncluded() {
            return this.included;
        }

        public final void setIncluded(boolean bl) {
            this.included = bl;
        }

        public MappingState() {
            this(false, 1, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\f\u00108\u001a\b\u0018\u00010\u0000R\u00020\u0003J\b\u00109\u001a\u0004\u0018\u00010,J\u0010\u0010C\u001a\u00020(2\u0006\u0010D\u001a\u00020\u0018H\u0002J\u001a\u0010G\u001a\u00020(2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020J0IJ\"\u0010K\u001a\u00020(2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020J0L2\u0006\u0010M\u001a\u00020\u0018J\u0016\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010R\u001a\u00020S2\u0006\u0010P\u001a\u00020Q2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\"H\u0002J(\u0010W\u001a\n Y*\u0004\u0018\u00010X0X2\u0006\u0010P\u001a\u00020Q2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020SH\u0002J\u0006\u0010`\u001a\u00020(J\n\u0010a\u001a\u00020bH\u0096\u0080\u0004R\u0017\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR%\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00030\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0011\u00101\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0019R$\u00104\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010\u0019\"\u0004\b6\u00107R\u001a\u0010:\u001a\u00020;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010=\"\u0004\bB\u0010?R\u0011\u0010E\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u0019R\u001a\u0010]\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010\u0019\"\u0004\b_\u00107\u00a8\u0006c"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "", "parent", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "origin", "Lcom/intellij/database/model/migration/DbMigrationElement;", "target", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationTreeModel;Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;Lcom/intellij/database/model/migration/DbMigrationElement;Lcom/intellij/database/model/migration/DbMigrationElement;)V", "getParent", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "getOrigin", "()Lcom/intellij/database/model/migration/DbMigrationElement;", "getTarget", "get", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "children", "", "getChildren", "()Ljava/util/List;", "children$delegate", "Lkotlin/Lazy;", "isBasicElementNode", "", "()Z", "status", "Lcom/intellij/database/model/migration/DiffStatus;", "getStatus", "()Lcom/intellij/database/model/migration/DiffStatus;", "setStatus", "(Lcom/intellij/database/model/migration/DiffStatus;)V", "elementDelta", "Lcom/intellij/database/model/ElementDelta;", "Lcom/intellij/database/model/basic/BasicElement;", "getElementDelta", "()Lcom/intellij/database/model/ElementDelta;", "setElementDelta", "(Lcom/intellij/database/model/ElementDelta;)V", "initDeltaAndDiffStatus", "", "generator", "Lcom/intellij/database/script/generator/ScriptGenerator;", "mappingState", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingState;", "getMappingState", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingState;", "setMappingState", "(Lcom/intellij/database/model/migration/DbMigrationTreeModel$MappingState;)V", "containsMapping", "getContainsMapping", "value", "included", "getIncluded", "setIncluded", "(Z)V", "enclosingMappingNode", "enclosingMapping", "childrenMappingCount", "", "getChildrenMappingCount", "()I", "setChildrenMappingCount", "(I)V", "includedChildrenMappingCount", "getIncludedChildrenMappingCount", "setIncludedChildrenMappingCount", "updateMappingCountUpward", "increase", "identical", "getIdentical", "pullDeps", "index", "", "Lcom/intellij/database/model/basic/BasicModElement;", "prepare", "", "withSources", "getContent", "Lcom/intellij/diff/contents/DiffContent;", "project", "Lcom/intellij/openapi/project/Project;", "getCreationScript", "Lcom/intellij/database/model/properties/CompositeText;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "element", "createDocument", "Lcom/intellij/openapi/editor/Document;", "kotlin.jvm.PlatformType", "language", "Lcom/intellij/lang/Language;", "script", "hasExtensionObject", "getHasExtensionObject", "setHasExtensionObject", "initExtensionFlag", "toString", "", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbMigrationTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationTreeModel.kt\ncom/intellij/database/model/migration/DbMigrationTreeModel$Node\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,703:1\n13#2:704\n13#2:705\n1915#3,2:706\n1915#3,2:708\n*S KotlinDebug\n*F\n+ 1 DbMigrationTreeModel.kt\ncom/intellij/database/model/migration/DbMigrationTreeModel$Node\n*L\n501#1:704\n520#1:705\n570#1:706,2\n575#1:708,2\n*E\n"})
    public final class Node {
        @Nullable
        private final Node parent;
        @Nullable
        private final DbMigrationElement origin;
        @Nullable
        private final DbMigrationElement target;
        @NotNull
        private final Lazy children$delegate;
        @Nullable
        private DiffStatus status;
        @Nullable
        private ElementDelta<? extends BasicElement> elementDelta;
        @Nullable
        private MappingState mappingState;
        private int childrenMappingCount;
        private int includedChildrenMappingCount;
        private boolean hasExtensionObject;

        public Node(@Nullable Node parent2, @Nullable DbMigrationElement origin, DbMigrationElement target) {
            this.parent = parent2;
            this.origin = origin;
            this.target = target;
            this.children$delegate = LazyKt.lazy(() -> Node.children_delegate$lambda$0(DbMigrationTreeModel.this, this));
        }

        @Nullable
        public final Node getParent() {
            return this.parent;
        }

        @Nullable
        public final DbMigrationElement getOrigin() {
            return this.origin;
        }

        @Nullable
        public final DbMigrationElement getTarget() {
            return this.target;
        }

        @Nullable
        public final DbMigrationElement get(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            return switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
                case 1 -> this.origin;
                case 2 -> this.target;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public final List<Node> getChildren() {
            Lazy lazy = this.children$delegate;
            return (List)lazy.getValue();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isBasicElementNode() {
            DbMigrationElement dbMigrationElement = this.origin;
            if ((dbMigrationElement != null ? dbMigrationElement.getBase() : null) instanceof BasicElement) return true;
            DbMigrationElement dbMigrationElement2 = this.target;
            if (!((dbMigrationElement2 != null ? dbMigrationElement2.getBase() : null) instanceof BasicElement)) return false;
            return true;
        }

        @Nullable
        public final DiffStatus getStatus() {
            return this.status;
        }

        public final void setStatus(@Nullable DiffStatus diffStatus) {
            this.status = diffStatus;
        }

        @Nullable
        public final ElementDelta<BasicElement> getElementDelta() {
            return this.elementDelta;
        }

        public final void setElementDelta(@Nullable ElementDelta<? extends BasicElement> elementDelta) {
            this.elementDelta = elementDelta;
        }

        public final void initDeltaAndDiffStatus(@NotNull ScriptGenerator generator) {
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            if (this.isBasicElementNode()) {
                DiffStatus diffStatus;
                BasicModElement t;
                DbMigrationElement dbMigrationElement = this.target;
                BasicNode basicNode = dbMigrationElement != null ? dbMigrationElement.getBase() : null;
                BasicElement s = basicNode instanceof BasicElement ? (BasicElement)basicNode : null;
                DbMigrationElement dbMigrationElement2 = this.origin;
                Object object = t = dbMigrationElement2 != null ? dbMigrationElement2.getAltElement() : null;
                if (s == null && t == null) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(DbMigrationTreeModel.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Both source and target are null for " + this);
                    return;
                }
                this.elementDelta = ElementDelta.Companion.create(s, (BasicElement)t);
                ElementDelta<? extends BasicElement> elementDelta = this.elementDelta;
                Intrinsics.checkNotNull(elementDelta);
                ElementDelta<? extends BasicElement> elementDelta2 = elementDelta;
                if (elementDelta2 instanceof ElementAlteration) {
                    BasicElement basicElement = s;
                    Intrinsics.checkNotNull((Object)basicElement);
                    BasicModElement basicModElement = t;
                    Intrinsics.checkNotNull((Object)basicModElement);
                    diffStatus = generator.isEqual(basicElement, (BasicElement)basicModElement, DbMigrationTreeModel.this.request.getOptions().getScriptingOptions()) ? DiffStatus.SAME : DiffStatus.MODIFIED;
                } else if (elementDelta2 instanceof ElementCreation) {
                    diffStatus = DiffStatus.ADDED;
                } else if (elementDelta2 instanceof ElementRemotion) {
                    diffStatus = DiffStatus.DELETED;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.status = diffStatus;
            } else {
                DiffStatus diffStatus;
                if (this.origin != null && this.target != null) {
                    diffStatus = DiffStatus.SAME;
                } else if (this.origin != null) {
                    diffStatus = DiffStatus.ADDED;
                } else if (this.target != null) {
                    diffStatus = DiffStatus.DELETED;
                } else {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(DbMigrationTreeModel.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("A node with null origin and target, parent=" + this.parent);
                    diffStatus = null;
                }
                this.status = diffStatus;
            }
        }

        @Nullable
        public final MappingState getMappingState() {
            return this.mappingState;
        }

        public final void setMappingState(@Nullable MappingState mappingState) {
            this.mappingState = mappingState;
        }

        public final boolean getContainsMapping() {
            return this.mappingState != null;
        }

        public final boolean getIncluded() {
            MappingState mappingState = this.mappingState;
            Intrinsics.checkNotNull((Object)mappingState);
            return mappingState.getIncluded();
        }

        public final void setIncluded(boolean value) {
            MappingState mappingState = this.mappingState;
            Intrinsics.checkNotNull((Object)mappingState);
            if (mappingState.getIncluded() != value) {
                MappingState mappingState2 = this.mappingState;
                Intrinsics.checkNotNull((Object)mappingState2);
                mappingState2.setIncluded(value);
                this.updateMappingCountUpward(value);
            }
        }

        @Nullable
        public final Node enclosingMappingNode() {
            Node current = this;
            while (current != null) {
                if (current.getContainsMapping()) {
                    return current;
                }
                current = current.parent;
            }
            return null;
        }

        @Nullable
        public final MappingState enclosingMapping() {
            Node node = this.enclosingMappingNode();
            return node != null ? node.mappingState : null;
        }

        public final int getChildrenMappingCount() {
            return this.childrenMappingCount;
        }

        public final void setChildrenMappingCount(int n) {
            this.childrenMappingCount = n;
        }

        public final int getIncludedChildrenMappingCount() {
            return this.includedChildrenMappingCount;
        }

        public final void setIncludedChildrenMappingCount(int n) {
            this.includedChildrenMappingCount = n;
        }

        private final void updateMappingCountUpward(boolean increase) {
            Node current = this.parent;
            while (current != null) {
                Node node = current;
                node.includedChildrenMappingCount = node.includedChildrenMappingCount + (increase ? 1 : -1);
                current = current.parent;
            }
        }

        public final boolean getIdentical() {
            return this.status == DiffStatus.SAME && this.childrenMappingCount == 0;
        }

        public final void pullDeps(@NotNull Map<BasicElement, ? extends BasicModElement> index) {
            Intrinsics.checkNotNullParameter(index, (String)"index");
            DbMigrationElement dbMigrationElement = this.origin;
            if (dbMigrationElement != null) {
                dbMigrationElement.pullDeps(index);
            }
            Iterable $this$forEach$iv = this.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it = (Node)element$iv;
                boolean bl = false;
                it.pullDeps(index);
            }
        }

        public final void prepare(@NotNull Map<BasicElement, BasicModElement> index, boolean withSources) {
            Intrinsics.checkNotNullParameter(index, (String)"index");
            DbMigrationElement dbMigrationElement = this.origin;
            if (dbMigrationElement != null) {
                dbMigrationElement.prepare(index, this.target, withSources);
            }
            Iterable $this$forEach$iv = this.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it = (Node)element$iv;
                boolean bl = false;
                it.prepare(index, withSources);
            }
        }

        @NotNull
        public final DiffContent getContent(@NotNull Project project, @NotNull Side side) {
            DocumentContent documentContent;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            DbDiffRoot dbDiffRoot = DbMigrationTreeModel.this.request.getRoot(side).getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)dbDiffRoot, (String)"getRoot(...)");
            DbDiffRoot root = dbDiffRoot;
            DbMigrationElement migrationElement = switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
                case 1 -> this.origin;
                case 2 -> this.target;
                default -> throw new NoWhenBranchMatchedException();
            };
            if (migrationElement == null) {
                EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
                Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"createEmpty(...)");
                return (DiffContent)emptyContent;
            }
            if (!this.isBasicElementNode()) {
                throw new AssertionError();
            }
            BasicNode basicNode = migrationElement.getBase();
            Intrinsics.checkNotNull((Object)basicNode, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicElement");
            BasicElement element = (BasicElement)basicNode;
            BasicModel basicModel = root.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)basicModel, (String)"getModel(...)");
            CompositeText script2 = this.getCreationScript(project, basicModel, element);
            Language language = root.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            Document document = this.createDocument(project, language, script2);
            DocumentContent $this$getContent_u24lambda_u240 = documentContent = DiffContentFactory.getInstance().create(project, document);
            boolean bl = false;
            $this$getContent_u24lambda_u240.putUserData(DiffUserDataKeys.LANGUAGE, (Object)root.getLanguage());
            DocumentContent documentContent2 = documentContent;
            Intrinsics.checkNotNullExpressionValue((Object)documentContent2, (String)"apply(...)");
            return (DiffContent)documentContent2;
        }

        private final CompositeText getCreationScript(Project project, BasicModel model, BasicElement element) {
            ScriptingSingleModelTaskBuilder scriptingSingleModelTaskBuilder = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.CREATE_COMPLETE);
            DbMigrationTreeModel dbMigrationTreeModel = DbMigrationTreeModel.this;
            ScriptingSingleModelTaskBuilder $this$getCreationScript_u24lambda_u240 = scriptingSingleModelTaskBuilder;
            boolean bl = false;
            $this$getCreationScript_u24lambda_u240.getElements().add(element);
            $this$getCreationScript_u24lambda_u240.setOptions(dbMigrationTreeModel.request.getOptions().getScriptingOptions());
            $this$getCreationScript_u24lambda_u240.setCurrentNamespace((BasicNamespace)DasUtil.getParentOfClass((DasObject)((DasObject)element), BasicNamespace.class, (boolean)false));
            ScriptingSingleModelTaskBuilder taskBuilder = scriptingSingleModelTaskBuilder;
            return ScriptGenerators.INSTANCE.makeScript(project, (ScriptingTask)taskBuilder.build()).getScript();
        }

        private final Document createDocument(Project project, Language language, CompositeText script2) {
            return (Document)ReadAction.compute(() -> Node.createDocument$lambda$0(project, language, script2));
        }

        public final boolean getHasExtensionObject() {
            return this.hasExtensionObject;
        }

        public final void setHasExtensionObject(boolean bl) {
            this.hasExtensionObject = bl;
        }

        public final void initExtensionFlag() {
            this.hasExtensionObject = DbMigrationTreeModel.this.hasExtensionObject(this);
        }

        @NotNull
        public String toString() {
            return "Node(origin=" + this.origin + ", target=" + this.target + ")";
        }

        private static final List children_delegate$lambda$0(DbMigrationTreeModel this$0, Node this$1) {
            return this$0.computeChildren(this$1);
        }

        private static final Document createDocument$lambda$0(Project $project, Language $language, CompositeText $script) {
            Document document;
            try {
                PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)$project);
                PsiFile psiFile = psiFileFactory.createFileFromText("a." + SqlFileType.INSTANCE.getDefaultExtension(), $language, (CharSequence)StringUtil.convertLineSeparators((String)((Object)$script.getText()).toString()), false, true);
                VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                VirtualFile virtualFile2 = virtualFile;
                if (virtualFile2 instanceof LightVirtualFile) {
                    ((LightVirtualFile)virtualFile2).setWritable(false);
                }
                Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile2);
                Intrinsics.checkNotNull((Object)document2);
                document = document2;
            }
            catch (IOException e) {
                throw new DiffRequestProducerException((Throwable)e);
            }
            return document;
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Side.values().length];
                try {
                    nArray[Side.ORIGIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Side.TARGET.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0006\u001a\u00060\u0007R\u00020\bH\u0016J\u001c\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010\u0012\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u0014\u001a\u00020\u00102\n\u0010\u0015\u001a\u00060\u0007R\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0010J\u0014\u0010\u0017\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0007R\u00020\bH\u0002J\u0014\u0010\u0018\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0007R\u00020\bH\u0002J\u0014\u0010\u0019\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0007R\u00020\bH\u0002J\u001e\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u0007R\u00020\b0\u001b2\n\u0010\u0011\u001a\u00060\u0007R\u00020\bH\u0007J\u0006\u0010\u001c\u001a\u00020\u001dR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTreeModel$PresentableTreeModel;", "Lcom/intellij/util/ui/tree/AbstractTreeModel;", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationTreeModel;Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;)V", "getRoot", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Node;", "Lcom/intellij/database/model/migration/DbMigrationTreeModel;", "getChild", "", "parent", "index", "", "getChildCount", "isLeaf", "", "node", "getIndexOfChild", "child", "filter", "it", "showExtensions", "filterBySide", "filterIdentical", "filterEmptyFamilies", "getChildren", "", "treeStructureChanged", "", "intellij.database.impl"})
    public final class PresentableTreeModel
    extends AbstractTreeModel {
        @Nullable
        private final Side side;

        public PresentableTreeModel(Side side) {
            this.side = side;
        }

        @NotNull
        public Node getRoot() {
            return DbMigrationTreeModel.this.getRootNode();
        }

        @Nullable
        public Object getChild(@Nullable Object parent2, int index) {
            boolean showExtensions = DbMigrationTreeModel.this.shouldShowExtensionMembers();
            Intrinsics.checkNotNull((Object)parent2, (String)"null cannot be cast to non-null type com.intellij.database.model.migration.DbMigrationTreeModel.Node");
            Node cfr_ignored_0 = (Node)parent2;
            int current = -1;
            for (Node n : ((Node)parent2).getChildren()) {
                if (!this.filter(n, showExtensions) || ++current != index) continue;
                return n;
            }
            return null;
        }

        public int getChildCount(@Nullable Object parent2) {
            boolean showExtensions = DbMigrationTreeModel.this.shouldShowExtensionMembers();
            Intrinsics.checkNotNull((Object)parent2, (String)"null cannot be cast to non-null type com.intellij.database.model.migration.DbMigrationTreeModel.Node");
            Node cfr_ignored_0 = (Node)parent2;
            int count = 0;
            for (Node n : ((Node)parent2).getChildren()) {
                if (!this.filter(n, showExtensions)) continue;
                ++count;
            }
            return count;
        }

        public boolean isLeaf(@Nullable Object node) {
            return this.getChildCount(node) == 0;
        }

        public int getIndexOfChild(@Nullable Object parent2, @Nullable Object child) {
            boolean showExtensions = DbMigrationTreeModel.this.shouldShowExtensionMembers();
            Intrinsics.checkNotNull((Object)parent2, (String)"null cannot be cast to non-null type com.intellij.database.model.migration.DbMigrationTreeModel.Node");
            Node cfr_ignored_0 = (Node)parent2;
            int current = -1;
            for (Node n : ((Node)parent2).getChildren()) {
                if (!this.filter(n, showExtensions)) continue;
                ++current;
                if (!Intrinsics.areEqual((Object)n, (Object)child)) continue;
                return current;
            }
            return -1;
        }

        public final boolean filter(@NotNull Node it, boolean showExtensions) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getStatus() != null && this.filterBySide(it) && this.filterIdentical(it) && DbMigrationTreeModel.this.filterNode(it, showExtensions) && this.filterEmptyFamilies(it);
        }

        private final boolean filterBySide(Node node) {
            return this.side != Side.ORIGIN || node.getStatus() != DiffStatus.DELETED;
        }

        private final boolean filterIdentical(Node node) {
            return DbMigrationTreeModel.this.getShowIdentical() || !node.getIdentical();
        }

        private final boolean filterEmptyFamilies(Node node) {
            return node.isBasicElementNode() || !this.isLeaf(node);
        }

        @TestOnly
        @NotNull
        public final List<Node> getChildren(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List children = new ArrayList();
            boolean showExtensions = DbMigrationTreeModel.this.shouldShowExtensionMembers();
            for (Node n : node.getChildren()) {
                if (!this.filter(n, showExtensions)) continue;
                ((Collection)children).add(n);
            }
            return children;
        }

        public final void treeStructureChanged() {
            this.treeStructureChanged(null, null, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0006\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\t"}, d2={"Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "", "<init>", "(Ljava/lang/String;I)V", "ORIGIN", "TARGET", "opposite", "getOpposite", "()Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "intellij.database.impl"})
    public static final class Side
    extends Enum<Side> {
        public static final /* enum */ Side ORIGIN = new Side();
        public static final /* enum */ Side TARGET = new Side();
        private static final /* synthetic */ Side[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final Side getOpposite() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> TARGET;
                case 2 -> ORIGIN;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static Side[] values() {
            return (Side[])$VALUES.clone();
        }

        public static Side valueOf(String value) {
            return Enum.valueOf(Side.class, value);
        }

        @NotNull
        public static EnumEntries<Side> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sideArray = new Side[]{Side.ORIGIN, Side.TARGET};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Side.values().length];
                try {
                    nArray[Side.ORIGIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Side.TARGET.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

