/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.esotericsoftware.kryo.kryo5.io.ByteBufferInput;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.ByteBufferUtil;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/workspace/storage/impl/KryoInput;", "Lcom/esotericsoftware/kryo/kryo5/io/ByteBufferInput;", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "readLongs", "", "length", "", "readInts", "", "readInt", "readLong", "", "close", "", "intellij.platform.workspace.storage"})
public final class KryoInput
extends ByteBufferInput {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KryoInput(@NotNull Path file) {
        MappedByteBuffer mappedByteBuffer;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = FileChannel.open(file, (Set<? extends OpenOption>)EnumSet.of((Enum)StandardOpenOption.READ), new FileAttribute[0]);
        KryoInput kryoInput = this;
        Throwable throwable = null;
        try {
            FileChannel fileChannel = (FileChannel)closeable;
            boolean bl = false;
            mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        kryoInput.byteBuffer = mappedByteBuffer;
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setVariableLengthEncoding(false);
        this.capacity = this.byteBuffer.capacity();
        this.limit = this.byteBuffer.limit();
    }

    @NotNull
    public long[] readLongs(int length) {
        if (length == 0) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_LONG_ARRAY, (String)"EMPTY_LONG_ARRAY");
            return ArrayUtilRt.EMPTY_LONG_ARRAY;
        }
        long[] array = new long[length];
        this.byteBuffer.asLongBuffer().get(array);
        this.byteBuffer.position(this.byteBuffer.position() + 8 * length);
        this.position = this.byteBuffer.position();
        return array;
    }

    @NotNull
    public int[] readInts(int length) {
        if (length == 0) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_INT_ARRAY, (String)"EMPTY_INT_ARRAY");
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int[] array = new int[length];
        this.byteBuffer.asIntBuffer().get(array);
        this.byteBuffer.position(this.byteBuffer.position() + 4 * length);
        this.position = this.byteBuffer.position();
        return array;
    }

    public int readInt() {
        int result = this.byteBuffer.getInt();
        this.position += 4;
        return result;
    }

    public long readLong() {
        long result = this.byteBuffer.getLong();
        this.position += 8;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            super.close();
        }
        finally {
            ByteBufferUtil.cleanBuffer((ByteBuffer)this.byteBuffer);
        }
    }
}

