/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.documentation;

import com.intellij.python.community.impl.huggingFace.HuggingFaceEntityKind;
import com.intellij.python.community.impl.huggingFace.api.HuggingFaceURLProvider;
import com.intellij.python.community.impl.huggingFace.service.PyHuggingFaceBundle;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/python/community/impl/huggingFace/documentation/HuggingFaceDocumentationPlaceholdersUtil;", "", "<init>", "()V", "generateGatedEntityMarkdownString", "", "entityId", "entityKind", "Lcom/intellij/python/community/impl/huggingFace/HuggingFaceEntityKind;", "noReadmePlaceholder", "noInternetConnectionPlaceholder", "notFoundErrorPlaceholder", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
public final class HuggingFaceDocumentationPlaceholdersUtil {
    @NotNull
    public static final HuggingFaceDocumentationPlaceholdersUtil INSTANCE = new HuggingFaceDocumentationPlaceholdersUtil();

    private HuggingFaceDocumentationPlaceholdersUtil() {
    }

    @Nls
    @NotNull
    public final String generateGatedEntityMarkdownString(@NotNull String entityId, @NotNull HuggingFaceEntityKind entityKind) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)((Object)entityKind), (String)"entityKind");
        Object[] objectArray = new Object[]{entityKind.getPrintName(), HuggingFaceURLProvider.INSTANCE.getEntityCardLink(entityId, entityKind), entityKind.getPrintName()};
        String msg = PyHuggingFaceBundle.INSTANCE.message("python.hugging.face.placeholder.gated.model", objectArray);
        return msg;
    }

    @Nls
    @NotNull
    public final String noReadmePlaceholder(@NotNull String entityId, @NotNull HuggingFaceEntityKind entityKind) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)((Object)entityKind), (String)"entityKind");
        URL cardUrl = HuggingFaceURLProvider.INSTANCE.getEntityCardLink(entityId, entityKind);
        Object[] objectArray = new Object[]{cardUrl};
        String msg = PyHuggingFaceBundle.INSTANCE.message("python.hugging.face.placeholder.no.readme", objectArray);
        return msg;
    }

    @Nls
    @NotNull
    public final String noInternetConnectionPlaceholder(@NotNull String entityId) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Object[] objectArray = new Object[]{entityId};
        return PyHuggingFaceBundle.INSTANCE.message("python.hugging.face.placeholder.no.internet", objectArray);
    }

    @Nls
    @NotNull
    public final String notFoundErrorPlaceholder(@NotNull String entityId) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Object[] objectArray = new Object[]{entityId};
        return PyHuggingFaceBundle.INSTANCE.message("python.hugging.face.placeholder.not.found", objectArray);
    }
}

