/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.endpoints.webStructure;

import com.intellij.codeInsight.navigation.GotoTargetPresentationProvider;
import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.python.endpoints.CommonKt;
import com.intellij.python.endpoints.ModuleWebApplication;
import com.intellij.python.endpoints.PythonEndpointsIcons;
import com.intellij.python.endpoints.WebApplication;
import com.intellij.python.endpoints.WebApplicationLogo;
import com.intellij.python.endpoints.webStructure.WebStructureNavigatablePsiElement;
import com.jetbrains.python.extensions.PsiFileSystemItemExtKt;
import com.jetbrains.python.psi.PyFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/python/endpoints/webStructure/WebStructureGotoTargetPresentationProvider;", "Lcom/intellij/codeInsight/navigation/GotoTargetPresentationProvider;", "<init>", "()V", "getTargetPresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "element", "Lcom/intellij/psi/PsiElement;", "differentNames", "", "intellij.python.endpoints"})
public final class WebStructureGotoTargetPresentationProvider
implements GotoTargetPresentationProvider {
    @Nullable
    public TargetPresentation getTargetPresentation(@NotNull PsiElement element, boolean differentNames) {
        String locationText;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof WebStructureNavigatablePsiElement)) {
            return null;
        }
        String presentableText = CommonKt.toStringWithLeadingSlash(((WebStructureNavigatablePsiElement)element).getUrlPath());
        PsiFile psiFile = ((WebStructureNavigatablePsiElement)element).getContainingFile();
        PyFile pyFile = psiFile instanceof PyFile ? (PyFile)psiFile : null;
        String string = locationText = pyFile != null && (pyFile = PsiFileSystemItemExtKt.getQName((PsiFileSystemItem)((PsiFileSystemItem)pyFile))) != null ? pyFile.toString() : null;
        Object object = ((WebStructureNavigatablePsiElement)element).getModuleWebApplication();
        if (object == null || (object = ((ModuleWebApplication)object).getWebApplication()) == null || (object = ((WebApplication)object).getProvider()) == null || (object = object.getWebApplicationLogo()) == null) {
            object = WebApplicationLogo.APP_NEUTRAL;
        }
        Object webApplicationLogo = object;
        Icon locationIcon = ((WebApplicationLogo)((Object)webApplicationLogo)).getIcon();
        Project project = ((WebStructureNavigatablePsiElement)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = ((WebStructureNavigatablePsiElement)element).getPsiElement().getContainingFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        TextAttributes textAttributes = UtilKt.fileStatusAttributes((Project)project, (VirtualFile)virtualFile);
        return TargetPresentation.Companion.builder(presentableText).icon(PythonEndpointsIcons.WebStructure.BackNavigation).containerText(((WebStructureNavigatablePsiElement)element).getContainingFile().getName()).locationText(locationText, locationIcon).presentableTextAttributes(textAttributes).presentation();
    }
}

