/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.celery.ref;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.python.pro.celery.CeleryUtilsKt;
import com.intellij.python.pro.celery.ref.CeleryBeatScheduleReferenceProvider;
import com.intellij.python.pro.celery.ref.CeleryScheduleClassTaskQuickFix;
import com.intellij.python.pro.celery.ref.CeleryScheduleFunctionAppTaskQuickFix;
import com.intellij.python.pro.celery.ref.CeleryScheduleFunctionSharedTaskQuickFix;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/python/pro/celery/ref/CeleryBeatScheduleTaskInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "getShortName", "", "Lorg/jetbrains/annotations/NonNls;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "CeleryFunctionTaskVisitor", "intellij.python"})
@ApiStatus.Internal
public final class CeleryBeatScheduleTaskInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "BeatScheduleCeleryTaskInspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext((LocalInspectionToolSession)session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new CeleryFunctionTaskVisitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/python/pro/celery/ref/CeleryBeatScheduleTaskInspection$CeleryFunctionTaskVisitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "myHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyElement", "", "node", "Lcom/jetbrains/python/psi/PyElement;", "intellij.python"})
    @SourceDebugExtension(value={"SMAP\nCeleryBeatScheduleTaskInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CeleryBeatScheduleTaskInspection.kt\ncom/intellij/python/pro/celery/ref/CeleryBeatScheduleTaskInspection$CeleryFunctionTaskVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
    private static final class CeleryFunctionTaskVisitor
    extends PyInspectionVisitor {
        @NotNull
        private final ProblemsHolder myHolder;
        @NotNull
        private final TypeEvalContext context;

        public CeleryFunctionTaskVisitor(@NotNull ProblemsHolder myHolder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)myHolder, (String)"myHolder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(myHolder, context);
            this.myHolder = myHolder;
            this.context = context;
        }

        public void visitPyElement(@NotNull PyElement node) {
            Object object;
            block10: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!Registry.Companion.is("django.celery.enabled")) {
                    super.visitPyElement(node);
                    return;
                }
                PsiReference[] psiReferenceArray = node.getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                for (Object object2 : (Object[])psiReferenceArray) {
                    PsiReference ref = (PsiReference)object2;
                    boolean bl = false;
                    if (!(ref instanceof CeleryBeatScheduleReferenceProvider.CeleryBeatScheduleReferenceSet.CeleryBeatScheduleReference && ((CeleryBeatScheduleReferenceProvider.CeleryBeatScheduleReferenceSet.CeleryBeatScheduleReference)ref).isLast())) continue;
                    object = object2;
                    break block10;
                }
                object = null;
            }
            PsiReference psiReference = (PsiReference)object;
            if (psiReference == null) {
                return;
            }
            PsiReference reference = psiReference;
            PsiElement psiElement = reference.resolve();
            if (psiElement == null) {
                return;
            }
            PsiElement resolvedReference = psiElement;
            boolean inProject = node.getManager().isInProject(resolvedReference);
            LocalQuickFix[] quickFixes = new LocalQuickFix[]{};
            if (resolvedReference instanceof PyFunction && !CeleryUtilsKt.hasCeleryDecorator((PyFunction)resolvedReference)) {
                if (inProject) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new CeleryScheduleFunctionSharedTaskQuickFix((PyFunction)resolvedReference), new CeleryScheduleFunctionAppTaskQuickFix((PyFunction)resolvedReference)};
                    quickFixes = localQuickFixArray;
                }
                this.myHolder.registerProblem((PsiElement)node, reference.getRangeInElement(), PythonProBundle.message((String)"celery.inspection.unregistered-task-function"), Arrays.copyOf(quickFixes, quickFixes.length));
            } else if (resolvedReference instanceof PyClass && !CeleryUtilsKt.hasTaskInheritance((PyClass)resolvedReference, this.context)) {
                if (inProject) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new CeleryScheduleClassTaskQuickFix((PyClass)resolvedReference)};
                    quickFixes = localQuickFixArray;
                }
                this.myHolder.registerProblem((PsiElement)node, reference.getRangeInElement(), PythonProBundle.message((String)"celery.inspection.unregistered-task-class"), Arrays.copyOf(quickFixes, quickFixes.length));
            } else {
                super.visitPyElement(node);
            }
        }
    }
}

