/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.flask.console;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.pro.flask.FlaskUtilsKt;
import com.intellij.python.pro.flask.configuration.FlaskConfiguration;
import com.intellij.python.pro.flask.configuration.FlaskConfigurationKt;
import com.intellij.python.pro.flask.console.FlaskConsoleOptions;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleOptionsProvider;
import com.jetbrains.python.console.PyConsoleParameters;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/python/pro/flask/console/FlaskConsoleOptionsProvider;", "Lcom/jetbrains/python/console/PyConsoleOptionsProvider;", "<init>", "()V", "isApplicableTo", "", "project", "Lcom/intellij/openapi/project/Project;", "getName", "", "getHelpTopic", "getSettings", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "getConsoleParameters", "Lcom/jetbrains/python/console/PyConsoleParameters;", "module", "Lcom/intellij/openapi/module/Module;", "customizeEnvVariables", "", "environmentVariablesToBeCustomized", "", "intellij.python"})
@SourceDebugExtension(value={"SMAP\nFlaskConsoleOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlaskConsoleOptionsProvider.kt\ncom/intellij/python/pro/flask/console/FlaskConsoleOptionsProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,50:1\n13225#2,2:51\n*S KotlinDebug\n*F\n+ 1 FlaskConsoleOptionsProvider.kt\ncom/intellij/python/pro/flask/console/FlaskConsoleOptionsProvider\n*L\n19#1:51,2\n*E\n"})
public final class FlaskConsoleOptionsProvider
implements PyConsoleOptionsProvider {
    public boolean isApplicableTo(@NotNull Project project) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Module[] $this$any$iv = ModuleManager.Companion.getInstance(project).getModules();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                Sdk sdk;
                Module element$iv;
                Module it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(PythonSdkUtil.findPythonSdk((Module)it) == null ? false : FlaskUtilsKt.isFlaskInstalled(sdk, project))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public String getName() {
        String string = PythonProBundle.message((String)"flask.console.tab.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        return "";
    }

    @NotNull
    public PyConsoleOptions.PyConsoleSettings getSettings(@Nullable Project project) {
        Project project2 = project;
        Intrinsics.checkNotNull((Object)project2);
        return FlaskConsoleOptions.Companion.getInstance(project2).getState();
    }

    @Nullable
    public PyConsoleParameters getConsoleParameters(@NotNull Module module) {
        VirtualFile moduleDir;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        FlaskConfiguration configuration = FlaskConfigurationKt.getFlaskConfiguration(module);
        if (configuration.getEnabled() && (moduleDir = ProjectUtil.guessModuleDir((Module)module)) != null) {
            String string = moduleDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return new PyConsoleParameters(module, string, FlaskConsoleOptions.Companion.getInstance(project).getState(), new PyConsoleType("flask", PythonProBundle.message((String)"flask.console.tab.name")));
        }
        return null;
    }

    public void customizeEnvVariables(@NotNull Module module, @NotNull Map<String, String> environmentVariablesToBeCustomized) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(environmentVariablesToBeCustomized, (String)"environmentVariablesToBeCustomized");
    }
}

