/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.python.profiler.CallTreeCellRenderer;
import com.intellij.python.profiler.CallTreeNode;
import com.intellij.python.profiler.FunctionStat;
import com.intellij.python.profiler.ProfilerViewKt;
import java.nio.file.Path;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/python/profiler/CallTreeView;", "Ljavax/swing/JTree;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "callTreeRoot", "Lcom/intellij/python/profiler/CallTreeNode;", "localPathFunction", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "Lcom/intellij/python/profiler/LocalPathFunction;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/python/profiler/CallTreeNode;Lkotlin/jvm/functions/Function1;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "walk", "", "treeItem", "Ljavax/swing/tree/DefaultMutableTreeNode;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.python.profiler"})
public final class CallTreeView
extends JTree
implements UiDataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final Function1<Path, Path> localPathFunction;

    public CallTreeView(@NotNull Project project, @NotNull CallTreeNode callTreeRoot, @NotNull Function1<? super Path, ? extends Path> localPathFunction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)callTreeRoot, (String)"callTreeRoot");
        Intrinsics.checkNotNullParameter(localPathFunction, (String)"localPathFunction");
        super(new DefaultTreeModel(new DefaultMutableTreeNode(callTreeRoot)));
        this.project = project;
        this.localPathFunction = localPathFunction;
        Object object = this.treeModel.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        this.walk((DefaultMutableTreeNode)object);
        CallTreeCellRenderer renderer = new CallTreeCellRenderer();
        renderer.getIcon();
        this.setCellRenderer(renderer);
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.expandRow(i);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void walk(DefaultMutableTreeNode treeItem) {
        Object object = treeItem.getUserObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.python.profiler.CallTreeNode");
        CallTreeNode value2 = (CallTreeNode)object;
        for (CallTreeNode childNode : value2.getChildren()) {
            if (!childNode.isVisible()) continue;
            DefaultMutableTreeNode childItem = new DefaultMutableTreeNode(childNode);
            treeItem.add(childItem);
            this.walk(childItem);
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Object object = this.getSelectionPath();
        if (object == null || (object = ((TreePath)object).getLastPathComponent()) == null) {
            return;
        }
        Object selectedObject = object;
        sink.set(ProfilerViewKt.access$getFUNCTION_STAT$p(), (Object)(selectedObject instanceof FunctionStat ? (FunctionStat)selectedObject : null));
        Object object2 = ((DefaultMutableTreeNode)selectedObject).getUserObject();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.python.profiler.CallTreeNode");
        CallTreeNode callNode = (CallTreeNode)object2;
        DataKey dataKey = CommonDataKeys.NAVIGATABLE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"NAVIGATABLE_ARRAY");
        sink.lazy(dataKey, () -> CallTreeView.uiDataSnapshot$lambda$0(this, callNode));
    }

    private static final Navigatable[] uiDataSnapshot$lambda$0(CallTreeView this$0, CallTreeNode $callNode) {
        return ProfilerViewKt.findNavigatables(this$0.project, $callNode, this$0.localPathFunction);
    }
}

