/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.profiler.BinaryProcessHandler;
import com.intellij.python.profiler.BinaryProcessOutput;
import com.intellij.python.profiler.ProfileStatData;
import com.intellij.python.profiler.ProfileStats;
import com.intellij.python.profiler.ProfilerCommunicationKt;
import com.intellij.python.profiler.ProfilerLogKt;
import com.intellij.python.profiler.ProfilerResponse;
import com.intellij.python.profiler.PythonProfilerBundle;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a-\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\t\u001a-\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\r\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"openProfile", "Lcom/intellij/python/profiler/ProfileStats;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "file", "", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/python/profiler/ProfileStats;", "loadProfileFromFile", "Lcom/intellij/python/profiler/ProfileStatData;", "filePath", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/python/profiler/ProfileStatData;", "buildLoadPstatCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.python.profiler"})
public final class ProfileReaderKt {
    @Nullable
    public static final ProfileStats openProfile(@Nullable Sdk sdk, @NotNull String file, @NotNull VirtualFile[] roots) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        if (sdk != null) {
            ProfileStatData stats = ProfileReaderKt.loadProfileFromFile(sdk, file, roots);
            if (stats != null) {
                return stats;
            }
        } else {
            UIUtil.invokeLaterIfNeeded(ProfileReaderKt::openProfile$lambda$0);
        }
        return null;
    }

    @Nullable
    public static final ProfileStatData loadProfileFromFile(@NotNull Sdk sdk, @Nullable String filePath2, @NotNull VirtualFile[] roots) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        String sdkPath = sdk.getHomePath();
        if (sdkPath == null || filePath2 == null) {
            return null;
        }
        GeneralCommandLine cmd = ProfileReaderKt.buildLoadPstatCommandLine(sdk, filePath2);
        PythonEnvUtil.resetHomePathChanges((String)sdkPath, (Map)cmd.getEnvironment());
        BinaryProcessHandler processHandler = new BinaryProcessHandler(cmd);
        BinaryProcessOutput po = processHandler.runProcess();
        if (po.getExitCode() == 0) {
            try {
                ProfilerResponse response = ProfilerCommunicationKt.readResponseFromArray(po.getBinaryOutput());
                return new ProfileStatData(response.getYstats(), response.getTree_stats(), roots);
            }
            catch (Exception e) {
                Attachment[] attachmentArray = new Attachment[]{new Attachment("stdout", po.getBinaryOutput(), "[Binary content]")};
                ProfilerLogKt.getLOG().error("Error parsing profiler output", (Throwable)e, attachmentArray);
                UIUtil.invokeLaterIfNeeded(ProfileReaderKt::loadProfileFromFile$lambda$0);
                return null;
            }
        }
        UIUtil.invokeLaterIfNeeded(() -> ProfileReaderKt.loadProfileFromFile$lambda$1(po));
        return null;
    }

    private static final GeneralCommandLine buildLoadPstatCommandLine(Sdk sdk, String filePath2) {
        String[] stringArray = new String[]{sdk.getHomePath()};
        GeneralCommandLine cmd = new GeneralCommandLine(stringArray);
        ParamsGroup paramsGroup = cmd.getParametersList().addParamsGroup("Script");
        Intrinsics.checkNotNullExpressionValue((Object)paramsGroup, (String)"addParamsGroup(...)");
        ParamsGroup scriptParamsGroup = paramsGroup;
        PythonHelper.LOAD_PSTAT.addToGroup(scriptParamsGroup, cmd);
        scriptParamsGroup.addParameter(filePath2);
        PythonEnvUtil.initPythonPath((Map)cmd.getEnvironment(), (boolean)false, (Collection)new ArrayList());
        PythonSdkType.patchCommandLineForVirtualenv((GeneralCommandLine)cmd, (Sdk)sdk);
        return cmd;
    }

    private static final void openProfile$lambda$0() {
        Messages.showErrorDialog((String)PythonProfilerBundle.message("python.sdk.not.found.error.message", new Object[0]), (String)PythonProfilerBundle.message("error.opening.snapshot.dialog.title", new Object[0]));
    }

    private static final void loadProfileFromFile$lambda$0() {
        Messages.showErrorDialog((String)PythonProfilerBundle.message("error.opening.snapshot.dialog.unexpected.error.message", new Object[0]), (String)PythonProfilerBundle.message("error.opening.snapshot.dialog.title", new Object[0]));
    }

    private static final void loadProfileFromFile$lambda$1(BinaryProcessOutput $po) {
        String string = $po.getProcessOutput().getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
        String error = string;
        if (StringsKt.contains$default((CharSequence)error, (CharSequence)"ValueError: bad marshal data (unknown type code)", (boolean)false, (int)2, null)) {
            Messages.showErrorDialog((String)PythonProfilerBundle.message("incorrect.snapshot.format.dialog.message", new Object[0]), (String)PythonProfilerBundle.message("incorrect.snapshot.format.dialog.title", new Object[0]));
        } else {
            ProfilerLogKt.getLOG().error(error);
            Object[] objectArray = new Object[]{$po.getExitCode()};
            Messages.showErrorDialog((String)PythonProfilerBundle.message("error.opening.snapshot.dialog.error.exit.code.message", objectArray), (String)PythonProfilerBundle.message("error.opening.snapshot.dialog.title", new Object[0]));
        }
    }
}

