/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.ui.MainCallTreeDataComponentKt;
import com.intellij.python.profiler.OpenSnapshotKt;
import com.intellij.python.profiler.ProfileReaderKt;
import com.intellij.python.profiler.ProfileSessionKt;
import com.intellij.python.profiler.ProfileStatData;
import com.intellij.python.profiler.ProfileStats;
import com.intellij.python.profiler.ProfilerCommunicationKt;
import com.intellij.python.profiler.ProfilerRequest;
import com.intellij.python.profiler.ProfilerResponse;
import com.intellij.python.profiler.ProfilerView;
import com.intellij.python.profiler.SaveSnapshot_Req;
import com.intellij.python.profiler.Stats;
import com.intellij.python.profiler.TreeStats;
import com.intellij.python.profiler.statistics.PyProfilerUsageCollector;
import com.jetbrains.python.run.PathMappingsUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.thrift.TBase;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160 J2\u0010!\u001a\b\u0012\u0004\u0012\u0002H\"0 \"\u0004\b\u0000\u0010\"2\u0006\u0010#\u001a\u00020$2\u0014\u0010%\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u0002H\"0&H\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J(\u0010(\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00162\b\u0010\b\u001a\u0004\u0018\u00010\tJ4\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0&H\u0002J,\u0010.\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0&H\u0002J.\u0010/\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\b\u00100\u001a\u0004\u0018\u0001012\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0&H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u0012\u001a*\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0013j\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/python/profiler/ProfilerCommunication;", "", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "serverSocket", "Ljava/net/ServerSocket;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/net/ServerSocket;Lcom/intellij/execution/process/ProcessHandler;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "writer", "Ljava/io/DataOutputStream;", "responses", "Ljava/util/HashMap;", "", "Lcom/google/common/util/concurrent/SettableFuture;", "Lcom/intellij/python/profiler/ProfilerResponse;", "Lkotlin/collections/HashMap;", "acceptConnection", "", "handleResponses", "socket", "Ljava/net/Socket;", "reader", "Ljava/io/DataInputStream;", "captureSnapshot", "Lcom/google/common/util/concurrent/ListenableFuture;", "sendRequest", "T", "request", "Lcom/intellij/python/profiler/ProfilerRequest;", "f", "Lkotlin/Function1;", "writeMessage", "processResponse", "response", "handleSnapshotFilepath", "snapshotFilePath", "Ljava/nio/file/Path;", "localPathFunction", "handleYStatsResponse", "initProfilerViewInEDT", "profileStats", "Lcom/intellij/python/profiler/ProfileStats;", "Companion", "intellij.python.profiler"})
@SourceDebugExtension(value={"SMAP\nProfilerCommunication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerCommunication.kt\ncom/intellij/python/profiler/ProfilerCommunication\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class ProfilerCommunication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final ServerSocket serverSocket;
    @Nullable
    private final ProcessHandler processHandler;
    @Nullable
    private DataOutputStream writer;
    @NotNull
    private final HashMap<Integer, SettableFuture<ProfilerResponse>> responses;
    @NotNull
    private static AtomicInteger id = new AtomicInteger(0);

    public ProfilerCommunication(@NotNull Project project, @NotNull Sdk sdk, @NotNull ServerSocket serverSocket2, @Nullable ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)serverSocket2, (String)"serverSocket");
        this.project = project;
        this.sdk = sdk;
        this.serverSocket = serverSocket2;
        this.processHandler = processHandler;
        this.responses = new HashMap();
        this.acceptConnection();
        PyProfilerUsageCollector.Companion.logStartProfilingProcess(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Sdk getSdk() {
        return this.sdk;
    }

    private final void acceptConnection() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProfilerCommunication.acceptConnection$lambda$0(this));
    }

    private final void handleResponses(Socket socket, DataInputStream reader) {
        while (true) {
            try {
                ProfilerResponse response = ProfilerCommunicationKt.readProfilerResponse(reader);
                SettableFuture<ProfilerResponse> responseProcessor = this.responses.get(response.getId());
                if (responseProcessor != null) {
                    responseProcessor.set((Object)response);
                    continue;
                }
                this.processResponse(this.project, this.sdk, response, this.processHandler);
            }
            catch (EOFException exception) {
                socket.close();
                break;
            }
            catch (SocketException exception) {
                socket.close();
                break;
            }
        }
    }

    @NotNull
    public final ListenableFuture<ProfilerResponse> captureSnapshot() {
        ProfilerRequest request = new ProfilerRequest(Companion.nextId()).setSave_snapshot(new SaveSnapshot_Req(ProfilerCommunicationKt.generateSnapshotPath(this.project)));
        Intrinsics.checkNotNull((Object)request);
        return this.sendRequest(request, ProfilerCommunication::captureSnapshot$lambda$0);
    }

    private final <T> ListenableFuture<T> sendRequest(ProfilerRequest request, Function1<? super ProfilerResponse, ? extends T> f) {
        SettableFuture settableFuture = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"create(...)");
        SettableFuture future = settableFuture;
        ((Map)this.responses).put(request.getId(), future);
        this.writeMessage(request);
        ListenableFuture listenableFuture = Futures.transform((ListenableFuture)((ListenableFuture)future), arg_0 -> ProfilerCommunication.sendRequest$lambda$0(f, arg_0), ProfilerCommunication::sendRequest$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"transform(...)");
        return listenableFuture;
    }

    private final void writeMessage(ProfilerRequest request) {
        TSerializer serializer2 = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        byte[] bytes = serializer2.serialize((TBase)request);
        DataOutputStream dataOutputStream = this.writer;
        Intrinsics.checkNotNull((Object)dataOutputStream);
        dataOutputStream.writeInt(bytes.length);
        DataOutputStream dataOutputStream2 = this.writer;
        Intrinsics.checkNotNull((Object)dataOutputStream2);
        dataOutputStream2.write(bytes);
        DataOutputStream dataOutputStream3 = this.writer;
        Intrinsics.checkNotNull((Object)dataOutputStream3);
        dataOutputStream3.flush();
    }

    /*
     * Unable to fully structure code
     */
    public final void processResponse(@NotNull Project project, @NotNull Sdk sdk, @NotNull ProfilerResponse response, @Nullable ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        v0 = response.getSnapshot_filepath();
        if (v0 != null) {
            it = v0;
            $i$a$-let-ProfilerCommunication$processResponse$snapshotFilepath$1 = false;
            v1 = Paths.get((String)it, new String[0]);
        } else {
            v1 = null;
        }
        snapshotFilepath = v1;
        try {
            if (processHandler == null || (var7_10 = PathMappingsUtil.guessPathMapper((ProcessHandler)processHandler)) == null || (it = ProfileSessionKt.asLocalPathFunction(var7_10)) == null) ** GOTO lbl-1000
            it = it;
            $i$a$-let-ProfilerCommunication$processResponse$localPathFunction$1 = false;
            var9_8 = (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, processResponse$lambda$1$0(kotlin.jvm.functions.Function1 java.nio.file.Path ), (Ljava/nio/file/Path;)Ljava/nio/file/Path;)(it);
            if (var9_8 != null) {
                v2 = var9_8;
            } else lbl-1000:
            // 2 sources

            {
                v2 = ProfileSessionKt.getIdentityFunction();
            }
            var7_10 = v2;
        }
        catch (InvalidPathException e) {
            throw new IllegalStateException(new IOException(e.getMessage()).toString());
        }
        localPathFunction = var7_10;
        v3 = snapshotFilepath;
        if (v3 != null) {
            this.handleSnapshotFilepath(v3, project, sdk, (Function1<? super Path, ? extends Path>)localPathFunction);
        } else if (response.getYstats() != null) {
            this.handleYStatsResponse(response, project, (Function1<? super Path, ? extends Path>)localPathFunction);
        } else {
            throw new IllegalStateException("Response should contain snapshot path or snapshot data");
        }
    }

    private final void handleSnapshotFilepath(Path snapshotFilePath, Project project, Sdk sdk, Function1<? super Path, ? extends Path> localPathFunction) {
        if (Registry.Companion.is("python.profiler.use.toolwindow.with.flamegraph")) {
            String string = ((Object)snapshotFilePath).toString();
            VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            ProfileStats profileStats = ProfileReaderKt.openProfile(sdk, string, virtualFileArray);
            this.initProfilerViewInEDT(project, profileStats, localPathFunction);
        } else {
            OpenSnapshotKt.openSnapshotInEditor(sdk, project, ((Object)snapshotFilePath).toString());
        }
    }

    private final void handleYStatsResponse(ProfilerResponse response, Project project, Function1<? super Path, ? extends Path> localPathFunction) {
        Stats stats = response.ystats;
        TreeStats treeStats = response.tree_stats;
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        ProfileStatData profileStatData = new ProfileStatData(stats, treeStats, virtualFileArray);
        if (Registry.Companion.is("python.profiler.use.toolwindow.with.flamegraph")) {
            this.initProfilerViewInEDT(project, profileStatData, localPathFunction);
        } else {
            ProfileSessionKt.openProfileResultsInEditor(project, profileStatData, null, localPathFunction);
        }
    }

    private final void initProfilerViewInEDT(Project project, ProfileStats profileStats, Function1<? super Path, ? extends Path> localPathFunction) {
        if (project.isDisposed()) {
            return;
        }
        CoroutineScope scope = MainCallTreeDataComponentKt.profilerUiScope((Project)project);
        BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(profileStats, project, localPathFunction, null){
            int label;
            final /* synthetic */ ProfileStats $profileStats;
            final /* synthetic */ Project $project;
            final /* synthetic */ Function1<Path, Path> $localPathFunction;
            {
                this.$profileStats = $profileStats;
                this.$project = $project;
                this.$localPathFunction = $localPathFunction;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ProfileStats profileStats = this.$profileStats;
                        if (profileStats != null) {
                            ProfileStats profileStats2 = profileStats;
                            Project project = this.$project;
                            Function1<Path, Path> function1 = this.$localPathFunction;
                            ProfileStats it = profileStats2;
                            boolean bl = false;
                            ProfilerView profileView = new ProfilerView();
                            profileView.init(project, it, function1);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private static final void acceptConnection$lambda$0$0(ProfilerCommunication this$0, Socket $socket, DataInputStream $reader) {
        Intrinsics.checkNotNull((Object)$socket);
        this$0.handleResponses($socket, $reader);
    }

    private static final void acceptConnection$lambda$0(ProfilerCommunication this$0) {
        Socket socket = this$0.serverSocket.accept();
        this$0.writer = new DataOutputStream(socket.getOutputStream());
        DataInputStream reader = new DataInputStream(socket.getInputStream());
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProfilerCommunication.acceptConnection$lambda$0$0(this$0, socket, reader));
    }

    private static final ProfilerResponse captureSnapshot$lambda$0(ProfilerResponse x) {
        return x;
    }

    private static final Object sendRequest$lambda$0(Function1 $tmp0, Object input) {
        return $tmp0.invoke(input);
    }

    private static final void sendRequest$lambda$1(Runnable command) {
        ApplicationManager.getApplication().executeOnPooledThread(command);
    }

    private static final Path processResponse$lambda$1$0(Function1 $it, Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return Paths.get((String)$it.invoke((Object)path2), new String[0]);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/python/profiler/ProfilerCommunication$Companion;", "", "<init>", "()V", "id", "Ljava/util/concurrent/atomic/AtomicInteger;", "nextId", "", "intellij.python.profiler"})
    public static final class Companion {
        private Companion() {
        }

        public final int nextId() {
            return id.incrementAndGet();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

