/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.profiler.OpenSnapshotKt;
import com.intellij.python.profiler.ProfilerSessionVirtualFileImpl;
import com.intellij.python.profiler.PythonProfilerBundle;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/profiler/PyOpenPStatAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findPythonSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.python.profiler"})
@SourceDebugExtension(value={"SMAP\nOpenSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSnapshot.kt\ncom/intellij/python/profiler/PyOpenPStatAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,76:1\n3938#2:77\n4474#2,2:78\n*S KotlinDebug\n*F\n+ 1 OpenSnapshot.kt\ncom/intellij/python/profiler/PyOpenPStatAction\n*L\n31#1:77\n31#1:78,2\n*E\n"})
public final class PyOpenPStatAction
extends AnAction {
    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FileChooserDescriptor d = FileChooserDescriptorFactory.createSingleFileDescriptor().withTitle(PythonProfilerBundle.message("pstat.file.chooser.title", new Object[0]));
        Project project = e.getProject();
        VirtualFile pstatFile = FileChooser.chooseFile((FileChooserDescriptor)d, (Project)project, null);
        if (pstatFile != null) {
            Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
            if (project != null) {
                void $this$filterTo$iv$iv;
                VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
                Object[] $this$filter$iv = virtualFileArray;
                boolean $i$f$filter = false;
                Object[] objectArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    VirtualFile f = (VirtualFile)element$iv$iv;
                    boolean bl = false;
                    if (!(f instanceof ProfilerSessionVirtualFileImpl && pstatFile.equals((Object)((ProfilerSessionVirtualFileImpl)f).getOriginalFile()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                if (((List)destination$iv$iv).isEmpty()) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> PyOpenPStatAction.actionPerformed$lambda$1(this, module, project, pstatFile));
                }
            }
        }
    }

    private final Sdk findPythonSdk(Module module, Project project) {
        Sdk sdk = PythonSdkUtil.findPythonSdk((Module)module);
        if (sdk != null && !PythonSdkUtil.isRemote((Sdk)sdk)) {
            return sdk;
        }
        for (Module m : ModuleManager.Companion.getInstance(project).getModules()) {
            sdk = PythonSdkUtil.findPythonSdk((Module)m);
            if (sdk == null || PythonSdkUtil.isRemote((Sdk)sdk)) continue;
            return sdk;
        }
        sdk = PythonSdkType.findLocalCPython((Module)module);
        return sdk;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setVisible(e.getProject() != null);
    }

    private static final void actionPerformed$lambda$1(PyOpenPStatAction this$0, Module $module, Project $project, VirtualFile $pstatFile) {
        Sdk sdk = this$0.findPythonSdk($module, $project);
        String string = $pstatFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        OpenSnapshotKt.openSnapshotInEditor(sdk, $project, string);
    }
}

