/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.python.profiler.ProfileData;
import com.intellij.python.profiler.ProfileSession;
import com.intellij.python.profiler.ProfilerCommunicationKt;
import com.intellij.python.profiler.ProfilerLogKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonRunner;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScriptTargetedCommandLineBuilder;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import java.net.ServerSocket;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0087@\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/python/profiler/PythonProfileRunner;", "Lcom/jetbrains/python/run/PythonRunner;", "<init>", "()V", "getRunnerDescriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "(Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/intellij/execution/configurations/RunProfileState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "execute", "Lorg/jetbrains/concurrency/AsyncPromise;", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "createConfigurationData", "Lcom/intellij/python/profiler/ProfileData;", "settingsProvider", "Lcom/intellij/execution/configurations/ConfigurationInfoProvider;", "getRunnerId", "Companion", "PythonProfilerTargetedCommandLineBuilder", "intellij.python.profiler"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPythonProfileRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonProfileRunner.kt\ncom/intellij/python/profiler/PythonProfileRunner\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n+ 3 AsyncPromise.kt\norg/jetbrains/concurrency/AsyncPromiseKt\n*L\n1#1,143:1\n200#2,10:144\n231#3,6:154\n*S KotlinDebug\n*F\n+ 1 PythonProfileRunner.kt\ncom/intellij/python/profiler/PythonProfileRunner\n*L\n63#1:144,10\n50#1:154,6\n*E\n"})
public final class PythonProfileRunner
extends PythonRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PYTHON_PROFILER_RUNNER = "PythonProfile";
    @NotNull
    private static final String PYCHARM_SEND_STAT = "PYCHARM_SEND_STAT";
    @NotNull
    private static final String PYCHARM_SNAPSHOT_PATH = "PYCHARM_SNAPSHOT_PATH";

    @TestOnly
    @Nullable
    public final Object getRunnerDescriptor(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, @NotNull Continuation<? super RunContentDescriptor> $completion) {
        return Promises.await((Promise)((Promise)this.execute(environment, state)), $completion);
    }

    @NotNull
    protected AsyncPromise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        FileDocumentManager.getInstance().saveAllDocuments();
        AsyncPromise promise = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(() -> PythonProfileRunner.execute$lambda$0(promise, state, this, environment));
        return promise;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return Intrinsics.areEqual((Object)executorId, (Object)"Profiler") && profile instanceof AbstractPythonRunConfiguration;
    }

    @NotNull
    public ProfileData createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
        return new ProfileData();
    }

    @NotNull
    public String getRunnerId() {
        return PYTHON_PROFILER_RUNNER;
    }

    private static final Unit execute$lambda$0$0$1(AsyncPromise $promise, ExecutionEnvironment $environment, PythonCommandLineState $pyState, ExecutionResult $result, ServerSocket $serverSocket) {
        block2: {
            RunContentDescriptor runContentDescriptor;
            AsyncPromise $this$compute$iv = $promise;
            boolean $i$f$compute = false;
            try {
                boolean bl = false;
                Project project = $environment.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Sdk sdk = $pyState.getSdk();
                Intrinsics.checkNotNull((Object)sdk);
                Intrinsics.checkNotNull((Object)$serverSocket);
                String string = $environment.getRunProfile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                runContentDescriptor = new ProfileSession(project, sdk, $result, $serverSocket, string).getContentDescriptor();
            }
            catch (Throwable e$iv) {
                $this$compute$iv.setError(e$iv);
                break block2;
            }
            RunContentDescriptor result$iv = runContentDescriptor;
            $this$compute$iv.setResult((Object)result$iv);
        }
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$0(AsyncPromise $promise, RunProfileState $state, PythonProfileRunner this$0, ExecutionEnvironment $environment) {
        AsyncPromise $this$catchError$iv = $promise;
        boolean $i$f$catchError = false;
        try {
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$state, (String)"null cannot be cast to non-null type com.jetbrains.python.run.PythonCommandLineState");
            PythonCommandLineState pyState = (PythonCommandLineState)$state;
            ServerSocket serverSocket2 = PythonCommandLineState.createServerSocket();
            int serverLocalPort = serverSocket2.getLocalPort();
            PythonProfileRunner $this$execute_u24lambda_u240_u240_u240 = this$0;
            boolean bl2 = false;
            Project project = $environment.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PythonProfilerTargetedCommandLineBuilder profilerTargetedCommandLineBuilder = new PythonProfilerTargetedCommandLineBuilder(project, pyState, serverLocalPort);
            ExecutionResult result = pyState.execute($environment.getExecutor(), (PythonScriptTargetedCommandLineBuilder)profilerTargetedCommandLineBuilder);
            if (result != null) {
                ActionsKt.invokeLater((ModalityState)ModalityState.any(), () -> PythonProfileRunner.execute$lambda$0$0$1($promise, $environment, pyState, result, serverSocket2));
            } else {
                ProfilerLogKt.getLOG().warn("Execution result of Python process is absent and the profiler session will not be started");
                $promise.setResult(null);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $this$catchError$iv.setError(e$iv);
            Object var14_15 = null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/python/profiler/PythonProfileRunner$Companion;", "", "<init>", "()V", "PYTHON_PROFILER_RUNNER", "", "PYCHARM_SEND_STAT", "PYCHARM_SNAPSHOT_PATH", "intellij.python.profiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J6\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u001c\u0010\u0018\u001a\u0018\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019j\b\u0012\u0004\u0012\u00020\u001b`\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/python/profiler/PythonProfileRunner$PythonProfilerTargetedCommandLineBuilder;", "Lcom/jetbrains/python/run/PythonScriptTargetedCommandLineBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/jetbrains/python/run/PythonCommandLineState;", "serverLocalPort", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/run/PythonCommandLineState;I)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getState", "()Lcom/jetbrains/python/run/PythonCommandLineState;", "getServerLocalPort", "()I", "build", "Lcom/jetbrains/python/run/PythonExecution;", "helpersAwareTargetRequest", "Lcom/jetbrains/python/run/target/HelpersAwareTargetEnvironmentRequest;", "pythonScript", "preparePythonProfilerScriptExecution", "Lcom/jetbrains/python/run/PythonScriptExecution;", "originalScript", "ideServerPort", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/HostPort;", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "intellij.python.profiler"})
    private static final class PythonProfilerTargetedCommandLineBuilder
    implements PythonScriptTargetedCommandLineBuilder {
        @NotNull
        private final Project project;
        @NotNull
        private final PythonCommandLineState state;
        private final int serverLocalPort;

        public PythonProfilerTargetedCommandLineBuilder(@NotNull Project project, @NotNull PythonCommandLineState state, int serverLocalPort) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.project = project;
            this.state = state;
            this.serverLocalPort = serverLocalPort;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final PythonCommandLineState getState() {
            return this.state;
        }

        public final int getServerLocalPort() {
            return this.serverLocalPort;
        }

        @NotNull
        public PythonExecution build(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest, @NotNull PythonExecution pythonScript) {
            Intrinsics.checkNotNullParameter((Object)helpersAwareTargetRequest, (String)"helpersAwareTargetRequest");
            Intrinsics.checkNotNullParameter((Object)pythonScript, (String)"pythonScript");
            TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareTargetRequest.getTargetEnvironmentRequest();
            TargetEnvironment.LocalPortBinding serverPortBinding = new TargetEnvironment.LocalPortBinding(this.serverLocalPort, null);
            ((Collection)targetEnvironmentRequest.getLocalPortBindings()).add(serverPortBinding);
            Function ideServerPort = TargetEnvironmentFunctions.getTargetEnvironmentValue((TargetEnvironment.LocalPortBinding)serverPortBinding);
            PythonScriptExecution profilerScript = this.preparePythonProfilerScriptExecution(pythonScript, ideServerPort, helpersAwareTargetRequest);
            PythonScripts.disableBuiltinBreakpoint((PythonExecution)((PythonExecution)profilerScript), (Sdk)this.state.getSdk());
            String snapshotPath = ProfilerCommunicationKt.generateSnapshotPath(this.project);
            if (!(targetEnvironmentRequest instanceof LocalTargetEnvironmentRequest) || !Registry.Companion.is("python.profiler.use.snapshot.file.locally")) {
                profilerScript.getEnvs().put(PythonProfileRunner.PYCHARM_SEND_STAT, TargetEnvironmentFunctions.constant((Object)"1"));
            }
            TargetEnvironment.DownloadRoot snapshotDownloadVolume = new TargetEnvironment.DownloadRoot(Paths.get(snapshotPath, new String[0]), (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), null, 4, null);
            ((Collection)targetEnvironmentRequest.getDownloadVolumes()).add(snapshotDownloadVolume);
            Function function = TargetEnvironmentFunctions.getTargetDownloadPath((TargetEnvironment.DownloadRoot)snapshotDownloadVolume);
            String string = this.project.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Function snapshotPathTargetValue = TargetEnvironmentFunctions.getRelativeTargetPath((Function)function, (String)string);
            profilerScript.addEnvironmentVariable(PythonProfileRunner.PYCHARM_SNAPSHOT_PATH, snapshotPathTargetValue);
            return (PythonExecution)profilerScript;
        }

        private final PythonScriptExecution preparePythonProfilerScriptExecution(PythonExecution originalScript, Function<TargetEnvironment, HostPort> ideServerPort, HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest) {
            PythonScriptExecution profilerScript = PythonScripts.prepareHelperScriptExecution((HelperPackage)((HelperPackage)PythonHelper.PROFILER), (HelpersAwareTargetEnvironmentRequest)helpersAwareTargetRequest);
            TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareTargetRequest.getTargetEnvironmentRequest();
            PythonScripts.extendEnvs((PythonExecution)((PythonExecution)profilerScript), (Map)originalScript.getEnvs(), (TargetPlatform)targetEnvironmentRequest.getTargetPlatform());
            Function<TargetEnvironment, String> function = ideServerPort.andThen(arg_0 -> PythonProfilerTargetedCommandLineBuilder.preparePythonProfilerScriptExecution$lambda$1(PythonProfilerTargetedCommandLineBuilder::preparePythonProfilerScriptExecution$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue(function, (String)"andThen(...)");
            profilerScript.addParameter(function);
            Function<TargetEnvironment, String> function2 = ideServerPort.andThen(arg_0 -> PythonProfilerTargetedCommandLineBuilder.preparePythonProfilerScriptExecution$lambda$3(PythonProfilerTargetedCommandLineBuilder::preparePythonProfilerScriptExecution$lambda$2, arg_0));
            Intrinsics.checkNotNullExpressionValue(function2, (String)"andThen(...)");
            profilerScript.addParameter(function2);
            PythonScripts.addPythonScriptAsParameter((PythonExecution)((PythonExecution)profilerScript), (PythonExecution)originalScript);
            profilerScript.getParameters().addAll(originalScript.getParameters());
            profilerScript.setWorkingDir(originalScript.getWorkingDir());
            return profilerScript;
        }

        private static final String preparePythonProfilerScriptExecution$lambda$0(HostPort hostPortOnTarget) {
            Intrinsics.checkNotNullParameter((Object)hostPortOnTarget, (String)"hostPortOnTarget");
            return hostPortOnTarget.getHost();
        }

        private static final String preparePythonProfilerScriptExecution$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final String preparePythonProfilerScriptExecution$lambda$2(HostPort hostPortOnTarget) {
            Intrinsics.checkNotNullParameter((Object)hostPortOnTarget, (String)"hostPortOnTarget");
            return String.valueOf(hostPortOnTarget.getPort());
        }

        private static final String preparePythonProfilerScriptExecution$lambda$3(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }
    }
}

