/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler.callgraph;

import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.services.GraphNodeRealizerService;
import com.intellij.openapi.graph.view.GenericNodeRealizer;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.python.profiler.FunctionStat;
import com.intellij.python.profiler.callgraph.CallGraphBuilder;
import com.intellij.python.profiler.callgraph.CallGraphNodeRenderer;
import com.intellij.python.profiler.callgraph.NavigateFromNodeToSourceAction;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00040\u0001B/\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/python/profiler/callgraph/CallGraphPresentationModel;", "Lcom/intellij/openapi/graph/builder/components/BasicGraphPresentationModel;", "Lcom/intellij/diagram/DiagramNode;", "Lcom/intellij/python/profiler/FunctionStat;", "Lcom/intellij/diagram/DiagramEdge;", "project", "Lcom/intellij/openapi/project/Project;", "graph", "Lcom/intellij/openapi/graph/base/Graph;", "localPathFunction", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "Lcom/intellij/python/profiler/LocalPathFunction;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/graph/base/Graph;Lkotlin/jvm/functions/Function1;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getNodeRealizer", "Lcom/intellij/openapi/graph/view/NodeRealizer;", "node", "getRenderer", "Lcom/intellij/python/profiler/callgraph/CallGraphNodeRenderer;", "getNodeActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "n", "getNodeTooltip", "", "intellij.python.profiler"})
public final class CallGraphPresentationModel
extends BasicGraphPresentationModel<DiagramNode<FunctionStat>, DiagramEdge<FunctionStat>> {
    @NotNull
    private final Project project;
    @NotNull
    private final Function1<Path, Path> localPathFunction;

    public CallGraphPresentationModel(@NotNull Project project, @NotNull Graph graph, @NotNull Function1<? super Path, ? extends Path> localPathFunction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(localPathFunction, (String)"localPathFunction");
        super(graph);
        this.project = project;
        this.localPathFunction = localPathFunction;
        this.getSettings().setShowGrid(false);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public NodeRealizer getNodeRealizer(@Nullable DiagramNode<FunctionStat> node) {
        GenericNodeRealizer genericNodeRealizer = GraphNodeRealizerService.getInstance().createGenericNodeRealizer("CallGraphRenderer", (NodeCellRenderer)this.getRenderer());
        Intrinsics.checkNotNullExpressionValue((Object)genericNodeRealizer, (String)"createGenericNodeRealizer(...)");
        return (NodeRealizer)genericNodeRealizer;
    }

    private final CallGraphNodeRenderer getRenderer() {
        GraphBuilder graphBuilder = this.getGraphBuilder();
        Intrinsics.checkNotNull((Object)graphBuilder, (String)"null cannot be cast to non-null type com.intellij.python.profiler.callgraph.CallGraphBuilder");
        return new CallGraphNodeRenderer(this.project, (CallGraphBuilder)graphBuilder);
    }

    @NotNull
    public DefaultActionGroup getNodeActionGroup(@Nullable DiagramNode<FunctionStat> n) {
        DefaultActionGroup actions = new DefaultActionGroup();
        if (n != null) {
            Object object = n.getIdentifyingElement();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getIdentifyingElement(...)");
            actions.add((AnAction)new NavigateFromNodeToSourceAction(this.project, (FunctionStat)object, this.localPathFunction));
        }
        return actions;
    }

    @Nullable
    public String getNodeTooltip(@Nullable DiagramNode<FunctionStat> n) {
        Object object = n;
        return object != null && (object = (FunctionStat)object.getIdentifyingElement()) != null ? object.getFile() : null;
    }
}

