/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler.callgraph;

import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.python.profiler.FunctionStat;
import com.intellij.python.profiler.callgraph.CallGraphViewKt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0010\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00130\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/intellij/python/profiler/callgraph/CallGraphView;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "localPathFunction", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "Lcom/intellij/python/profiler/LocalPathFunction;", "functionsStats", "", "Lcom/intellij/python/profiler/FunctionStat;", "showMe", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;Ljava/util/List;Lkotlin/jvm/functions/Function0;)V", "builder", "Lcom/intellij/openapi/graph/builder/GraphBuilder;", "Lcom/intellij/diagram/DiagramNode;", "Lcom/intellij/diagram/DiagramEdge;", "getBuilder", "()Lcom/intellij/openapi/graph/builder/GraphBuilder;", "createToolbarPanel", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "actionsGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "select", "funcStat", "intellij.python.profiler"})
@SourceDebugExtension(value={"SMAP\nCallGraphView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallGraphView.kt\ncom/intellij/python/profiler/callgraph/CallGraphView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n296#2,2:276\n*S KotlinDebug\n*F\n+ 1 CallGraphView.kt\ncom/intellij/python/profiler/callgraph/CallGraphView\n*L\n67#1:276,2\n*E\n"})
public final class CallGraphView
extends JPanel {
    @NotNull
    private final Function0<Unit> showMe;
    @NotNull
    private final GraphBuilder<DiagramNode<FunctionStat>, DiagramEdge<FunctionStat>> builder;

    public CallGraphView(@NotNull Project project, @NotNull Function1<? super Path, ? extends Path> localPathFunction, @NotNull List<? extends FunctionStat> functionsStats, @NotNull Function0<Unit> showMe) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(localPathFunction, (String)"localPathFunction");
        Intrinsics.checkNotNullParameter(functionsStats, (String)"functionsStats");
        Intrinsics.checkNotNullParameter(showMe, (String)"showMe");
        super(new BorderLayout());
        this.showMe = showMe;
        this.builder = CallGraphViewKt.createCallGraphBuilder(project, functionsStats, localPathFunction);
        Graph2DView view = (Graph2DView)ReadAction.compute(() -> CallGraphView._init_$lambda$0(this));
        JComponent jComponent = view.getJComponent();
        DefaultActionGroup defaultActionGroup = AbstractGraphAction.getCommonToolbarActions();
        Intrinsics.checkNotNullExpressionValue((Object)defaultActionGroup, (String)"getCommonToolbarActions(...)");
        ActionToolbar toolbar = this.createToolbarPanel(defaultActionGroup);
        toolbar.setTargetComponent(jComponent);
        this.add((Component)toolbar.getComponent(), "North");
        this.add((Component)jComponent, "Center");
    }

    @NotNull
    public final GraphBuilder<DiagramNode<FunctionStat>, DiagramEdge<FunctionStat>> getBuilder() {
        return this.builder;
    }

    private final ActionToolbar createToolbarPanel(DefaultActionGroup actionsGroup) {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)actionsGroup);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PyCallGraphView", (ActionGroup)actions, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        return actionToolbar;
    }

    public final void select(@NotNull FunctionStat funcStat) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)funcStat, (String)"funcStat");
            Collection collection = this.builder.getGraphDataModel().getNodes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNodes(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DiagramNode node = (DiagramNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)node.getIdentifyingElement(), (Object)funcStat)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        DiagramNode node = v1;
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.showMe.invoke();
        this.builder.getView().getGraph2D().selectAllNodesAndBends(false);
        this.builder.getView().getGraph2D().setSelected(this.builder.getNode((Object)node), true);
    }

    private static final Graph2DView _init_$lambda$0(CallGraphView this$0) {
        return this$0.builder.getView();
    }
}

