/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.cells;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.scientific.cells.PyCellBlockLineMarkerInfo;
import com.jetbrains.python.PyCellUtil;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.console.PyExecuteConsoleCustomizer;
import com.jetbrains.python.console.PythonConsoleView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/python/scientific/cells/PyCellLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "colorsManager", "Lcom/intellij/openapi/editor/colors/EditorColorsManager;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "element", "Lcom/intellij/psi/PsiElement;", "createBlockCellLineMarker", "hasCustomToolbar", "", "addIconToTheBeginning", "isBeginningOfFile", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.python.scientific"})
public final class PyCellLineMarkerProvider
implements LineMarkerProvider,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorColorsManager colorsManager;
    @NotNull
    private final AnAction action;
    @NotNull
    public static final String CELL_ACTION_ID = "PyExecuteCellAction";

    public PyCellLineMarkerProvider() {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"getInstance(...)");
        this.colorsManager = editorColorsManager;
        AnAction anAction = ActionManager.getInstance().getAction(CELL_ACTION_ID);
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
        this.action = anAction;
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        block4: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiFile file = element.getContainingFile();
                VirtualFile virtualFile = file.getVirtualFile();
                if (Intrinsics.areEqual((Object)true, (Object)virtualFile.getUserData(PythonConsoleView.CONSOLE_KEY))) {
                    return null;
                }
                boolean plainPython = Intrinsics.areEqual((Object)file.getViewProvider().getBaseLanguage(), (Object)PythonLanguage.getInstance());
                boolean isInjected = InjectedLanguageManager.getInstance((Project)element.getProject()).isInjectedFragment(file);
                if (!plainPython || isInjected) break block4;
                if (PyCellUtil.isBlockCell((PsiElement)element)) break block5;
                Intrinsics.checkNotNull((Object)file);
                if (!this.isBeginningOfFile(element, file) || !this.addIconToTheBeginning(element)) break block4;
            }
            return this.createBlockCellLineMarker(element, this.colorsManager);
        }
        return null;
    }

    private final LineMarkerInfo<PsiElement> createBlockCellLineMarker(PsiElement element, EditorColorsManager colorsManager) {
        PyCellBlockLineMarkerInfo info = new PyCellBlockLineMarkerInfo(element, this.action);
        EditorColorsScheme editorColorsScheme = colorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.TOP;
        return info;
    }

    private final boolean hasCustomToolbar(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        return PyExecuteConsoleCustomizer.Companion.getInstance().isCustomDescriptorSupported(virtualFile2);
    }

    private final boolean addIconToTheBeginning(PsiElement element) {
        return Registry.Companion.is("python.scientific.always_use_sci_view") && !this.hasCustomToolbar(element) || PyCellUtil.hasCells((PsiFile)element.getContainingFile());
    }

    private final boolean isBeginningOfFile(PsiElement element, PsiFile file) {
        return Intrinsics.areEqual((Object)element, (Object)PsiTreeUtil.getDeepestFirst((PsiElement)((PsiElement)file)));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/scientific/cells/PyCellLineMarkerProvider$Companion;", "", "<init>", "()V", "CELL_ACTION_ID", "", "intellij.python.scientific"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

