/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.providers.pandas;

import com.intellij.database.run.ui.table.statisticsPanel.types.ColumnDescriptionStatistics;
import com.intellij.database.run.ui.table.statisticsPanel.types.StatisticsDescriptionUnit;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.scientific.py.tables.api.PyDevdID;
import com.intellij.scientific.py.tables.commands.PyTableParserKt;
import com.intellij.scientific.py.tables.providers.PyStatisticsCapableProvider;
import com.intellij.scientific.py.tables.statistics.PyStatisticsTableStatisticsDataParsingUtils;
import com.intellij.scientific.tables.api.DSTableRawData;
import com.intellij.scientific.tables.api.DataId;
import com.intellij.scientific.tables.api.filters.FilterComparisonType;
import com.intellij.scientific.tables.api.filters.FilterExpression;
import com.intellij.scientific.tables.api.statisticsHeadersAndTooltips.StatisticsTooltipFields;
import com.intellij.scientific.tables.utils.exceptions.DSTableDataException;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J6\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\nH\u0004\u00a8\u0006\u0019"}, d2={"Lcom/intellij/scientific/py/tables/providers/pandas/PyPandasBaseProvider;", "Lcom/intellij/scientific/py/tables/providers/PyStatisticsCapableProvider;", "<init>", "()V", "getPydevdId", "Lcom/intellij/scientific/py/tables/api/PyDevdID;", "parseDescribeCommandResult", "", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/ColumnDescriptionStatistics;", "dataFrameRowsCount", "", "describeCommandResult", "", "composeFilterCommandOneColumn", "columnVariable", "filterExpression", "Lcom/intellij/scientific/tables/api/filters/FilterExpression$SingleExpression;", "getSortCommand", "tableVariable", "sortKeys", "Ljavax/swing/RowSorter$SortKey;", "cols", "indexColumnWidth", "PandasDescribeParsingUtils", "ForTestsPandasDescribeParsingObject", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nPyPandasBaseProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPandasBaseProvider.kt\ncom/intellij/scientific/py/tables/providers/pandas/PyPandasBaseProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1807#2,3:180\n*S KotlinDebug\n*F\n+ 1 PyPandasBaseProvider.kt\ncom/intellij/scientific/py/tables/providers/pandas/PyPandasBaseProvider\n*L\n43#1:180,3\n*E\n"})
public abstract class PyPandasBaseProvider
extends PyStatisticsCapableProvider {
    @NotNull
    public static final ForTestsPandasDescribeParsingObject ForTestsPandasDescribeParsingObject = new ForTestsPandasDescribeParsingObject(null);

    @Override
    @NotNull
    public PyDevdID getPydevdId() {
        return PyDevdID.PANDAS;
    }

    @Override
    @Nullable
    protected List<ColumnDescriptionStatistics> parseDescribeCommandResult(int dataFrameRowsCount, @NotNull String describeCommandResult) {
        Intrinsics.checkNotNullParameter((Object)describeCommandResult, (String)"describeCommandResult");
        return PandasDescribeParsingUtils.INSTANCE.parseDescribeCommandResult(dataFrameRowsCount, describeCommandResult);
    }

    @Override
    @NotNull
    public String composeFilterCommandOneColumn(@NotNull String columnVariable, @NotNull FilterExpression.SingleExpression filterExpression) {
        Intrinsics.checkNotNullParameter((Object)columnVariable, (String)"columnVariable");
        Intrinsics.checkNotNullParameter((Object)filterExpression, (String)"filterExpression");
        return switch (WhenMappings.$EnumSwitchMapping$0[filterExpression.getCondition().ordinal()]) {
            case 1 -> columnVariable + ".isna()";
            case 2 -> columnVariable + ".notna()";
            case 3 -> columnVariable + ".isin(" + filterExpression.getFilterValue() + ")";
            case 4 -> "~" + columnVariable + ".isin(" + filterExpression.getFilterValue() + ")";
            case 5 -> columnVariable + ".str.contains(" + filterExpression.getFilterValue() + ")";
            case 6 -> columnVariable + ".str.startswith(" + filterExpression.getFilterValue() + ")";
            case 7 -> columnVariable + ".str.endswith(" + filterExpression.getFilterValue() + ")";
            default -> this.composeFilterCommandOneColumnCommon(columnVariable, filterExpression);
        };
    }

    @NotNull
    protected final String getSortCommand(@NotNull String tableVariable, @NotNull List<? extends RowSorter.SortKey> sortKeys, @Nullable List<String> cols, int indexColumnWidth) {
        String string;
        boolean bl;
        String sortOrder;
        block7: {
            Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
            Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
            sortOrder = CollectionsKt.joinToString$default((Iterable)sortKeys, (CharSequence)",", null, null, (int)0, null, PyPandasBaseProvider::getSortCommand$lambda$0, (int)30, null);
            Iterable $this$any$iv = sortKeys;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RowSorter.SortKey it = (RowSorter.SortKey)element$iv;
                    boolean bl2 = false;
                    if (!(it.getColumn() < indexColumnWidth)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            if (sortKeys.size() == 1) {
                string = tableVariable + ".sort_index(ascending=" + sortOrder + ")";
            } else {
                sortBy = CollectionsKt.joinToString$default((Iterable)sortKeys, (CharSequence)",", null, null, (int)0, null, PyPandasBaseProvider::getSortCommand$lambda$2, (int)30, null);
                string = tableVariable + ".sort_index(level=[" + sortBy + "], ascending=[" + sortOrder + "])";
            }
        } else {
            sortBy = CollectionsKt.joinToString$default((Iterable)sortKeys, (CharSequence)",", null, null, (int)0, null, arg_0 -> PyPandasBaseProvider.getSortCommand$lambda$3(tableVariable, indexColumnWidth, arg_0), (int)30, null);
            string = cols != null ? tableVariable + ".sort_values(by=[" + sortBy + "], ascending=[" + sortOrder + "])" : tableVariable + ".sort_values(ascending=[" + sortOrder + "])";
        }
        return string;
    }

    private static final CharSequence getSortCommand$lambda$0(RowSorter.SortKey sortKey) {
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        return sortKey.getSortOrder() == SortOrder.ASCENDING ? (CharSequence)"True" : (CharSequence)"False";
    }

    private static final CharSequence getSortCommand$lambda$2(RowSorter.SortKey sortKey) {
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        return String.valueOf(sortKey.getColumn());
    }

    private static final CharSequence getSortCommand$lambda$3(String $tableVariable, int $indexColumnWidth, RowSorter.SortKey sortKey) {
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        return $tableVariable + ".columns[" + (sortKey.getColumn() - $indexColumnWidth) + "]";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/scientific/py/tables/providers/pandas/PyPandasBaseProvider$ForTestsPandasDescribeParsingObject;", "", "<init>", "()V", "parseDescribeCommandResult", "", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/ColumnDescriptionStatistics;", "dataFrameRowsCount", "", "describeCommandResult", "", "intellij.scientific.py.tables"})
    @TestOnly
    public static final class ForTestsPandasDescribeParsingObject {
        private ForTestsPandasDescribeParsingObject() {
        }

        @Nullable
        public final List<ColumnDescriptionStatistics> parseDescribeCommandResult(int dataFrameRowsCount, @NotNull String describeCommandResult) {
            Intrinsics.checkNotNullParameter((Object)describeCommandResult, (String)"describeCommandResult");
            return PandasDescribeParsingUtils.INSTANCE.parseDescribeCommandResult(dataFrameRowsCount, describeCommandResult);
        }

        public /* synthetic */ ForTestsPandasDescribeParsingObject(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u00c4\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/scientific/py/tables/providers/pandas/PyPandasBaseProvider$PandasDescribeParsingUtils;", "", "<init>", "()V", "parseDescribeCommandResult", "", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/ColumnDescriptionStatistics;", "dataFrameRowsCount", "", "describeCommandResult", "", "countMissingValuesStatistic", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/StatisticsDescriptionUnit;", "dataFrameRowsNumber", "countValues", "integerStatistics", "", "statisticsNamesMap", "", "PandasStatistics", "intellij.scientific.py.tables"})
    @SourceDebugExtension(value={"SMAP\nPyPandasBaseProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPandasBaseProvider.kt\ncom/intellij/scientific/py/tables/providers/pandas/PyPandasBaseProvider$PandasDescribeParsingUtils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n23#2:180\n1586#3:181\n1661#3,3:182\n296#3,2:185\n*S KotlinDebug\n*F\n+ 1 PyPandasBaseProvider.kt\ncom/intellij/scientific/py/tables/providers/pandas/PyPandasBaseProvider$PandasDescribeParsingUtils\n*L\n77#1:180\n84#1:181\n84#1:182,3\n97#1:185,2\n*E\n"})
    protected static final class PandasDescribeParsingUtils {
        @NotNull
        public static final PandasDescribeParsingUtils INSTANCE = new PandasDescribeParsingUtils();
        @NotNull
        private static final Set<String> integerStatistics;
        @NotNull
        private static final Map<String, String> statisticsNamesMap;

        private PandasDescribeParsingUtils() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<ColumnDescriptionStatistics> parseDescribeCommandResult(int dataFrameRowsCount, @NotNull String describeCommandResult) {
            void $this$mapTo$iv$iv;
            DSTableRawData dSTableRawData;
            Intrinsics.checkNotNullParameter((Object)describeCommandResult, (String)"describeCommandResult");
            if (StringsKt.isBlank((CharSequence)describeCommandResult)) {
                return null;
            }
            try {
                dSTableRawData = PyTableParserKt.parseTableHtmlToData(new DataId(0, 1, null), describeCommandResult);
            }
            catch (DSTableDataException dSTableDataException) {
                PandasDescribeParsingUtils $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(PandasDescribeParsingUtils.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("The invalid results of describe command was received: " + com.intellij.scientific.py.tables.util.UtilKt.cleanString(describeCommandResult));
                return null;
            }
            DSTableRawData describeResultsParsed = dSTableRawData;
            if (describeResultsParsed.getCols() == null) {
                return CollectionsKt.emptyList();
            }
            List transposedDescribeResults = new ArrayList();
            List list = describeResultsParsed.getCols();
            Intrinsics.checkNotNull((Object)list);
            Iterable $this$map$iv = (Iterable)list.get(0);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object t = item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            List statisticsNames = (List)destination$iv$iv;
            List list2 = describeResultsParsed.getCols();
            Intrinsics.checkNotNull((Object)list2);
            Iterator iterator = ((Iterable)list2).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object v3;
                List curColumnStatNameToStatValue;
                List currentColumnDescInfo;
                block9: {
                    int columnIndex = n++;
                    List currentColumnStatValues = (List)iterator.next();
                    if (columnIndex == 0) {
                        transposedDescribeResults.add(new ColumnDescriptionStatistics(CollectionsKt.emptyList()));
                        continue;
                    }
                    currentColumnDescInfo = new ArrayList();
                    curColumnStatNameToStatValue = CollectionsKt.zip((Iterable)statisticsNames, (Iterable)currentColumnStatValues);
                    Iterable $this$firstOrNull$iv = curColumnStatNameToStatValue;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Pair pair = (Pair)element$iv;
                        boolean bl = false;
                        String statName = (String)pair.component1();
                        if (!Intrinsics.areEqual((Object)statName, (Object)"count")) continue;
                        v3 = element$iv;
                        break block9;
                    }
                    v3 = null;
                }
                Pair pair = v3;
                Object countValue = pair != null ? pair.getSecond() : null;
                UtilKt.addIfNotNull((List)currentColumnDescInfo, (Object)this.countMissingValuesStatistic(dataFrameRowsCount, countValue));
                for (Pair pair2 : curColumnStatNameToStatValue) {
                    String statName = (String)pair2.component1();
                    Object statValue = pair2.component2();
                    UtilKt.addIfNotNull((List)currentColumnDescInfo, (Object)PyStatisticsTableStatisticsDataParsingUtils.INSTANCE.formatDescriptionPair(statName, statValue.toString(), integerStatistics, statisticsNamesMap));
                }
                transposedDescribeResults.add(new ColumnDescriptionStatistics(currentColumnDescInfo));
            }
            return transposedDescribeResults;
        }

        private final StatisticsDescriptionUnit countMissingValuesStatistic(int dataFrameRowsNumber, Object countValues) {
            Object object = countValues;
            if (object == null || (object = object.toString()) == null || (object = StringsKt.toFloatOrNull((String)object)) == null) {
                return null;
            }
            float parsedCountValue = ((Float)object).floatValue();
            String missingValue = String.valueOf((float)dataFrameRowsNumber - parsedCountValue);
            return PyStatisticsTableStatisticsDataParsingUtils.INSTANCE.formatDescriptionPair("missing", missingValue, integerStatistics, statisticsNamesMap);
        }

        static {
            Object[] objectArray = new String[]{"missing", "count", "unique", "freq"};
            integerStatistics = SetsKt.setOf((Object[])objectArray);
            objectArray = new Pair[]{TuplesKt.to((Object)"missing", (Object)StatisticsTooltipFields.INSTANCE.getMissing()), TuplesKt.to((Object)"count", (Object)StatisticsTooltipFields.INSTANCE.getCount()), TuplesKt.to((Object)"unique", (Object)StatisticsTooltipFields.INSTANCE.getDistinct()), TuplesKt.to((Object)"top", (Object)StatisticsTooltipFields.INSTANCE.getTop()), TuplesKt.to((Object)"freq", (Object)StatisticsTooltipFields.INSTANCE.getFrequency()), TuplesKt.to((Object)"5%", (Object)StatisticsTooltipFields.INSTANCE.getPercentile5()), TuplesKt.to((Object)"25%", (Object)StatisticsTooltipFields.INSTANCE.getPercentile25()), TuplesKt.to((Object)"50%", (Object)StatisticsTooltipFields.INSTANCE.getMedian()), TuplesKt.to((Object)"75%", (Object)StatisticsTooltipFields.INSTANCE.getPercentile75()), TuplesKt.to((Object)"95%", (Object)StatisticsTooltipFields.INSTANCE.getPercentile95()), TuplesKt.to((Object)"std", (Object)StatisticsTooltipFields.INSTANCE.getStdDeviation()), TuplesKt.to((Object)"min", (Object)StatisticsTooltipFields.INSTANCE.getMin()), TuplesKt.to((Object)"max", (Object)StatisticsTooltipFields.INSTANCE.getMax()), TuplesKt.to((Object)"mean", (Object)StatisticsTooltipFields.INSTANCE.getMean())};
            statisticsNamesMap = MapsKt.mapOf((Pair[])objectArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/scientific/py/tables/providers/pandas/PyPandasBaseProvider$PandasDescribeParsingUtils$PandasStatistics;", "", "<init>", "()V", "missing", "", "count", "unique", "freq", "top", "percentile5", "percentile25", "median", "percentile75", "percentile95", "stdDeviation", "min", "max", "mean", "intellij.scientific.py.tables"})
        private static final class PandasStatistics {
            @NotNull
            public static final PandasStatistics INSTANCE = new PandasStatistics();
            @NotNull
            public static final String missing = "missing";
            @NotNull
            public static final String count = "count";
            @NotNull
            public static final String unique = "unique";
            @NotNull
            public static final String freq = "freq";
            @NotNull
            public static final String top = "top";
            @NotNull
            public static final String percentile5 = "5%";
            @NotNull
            public static final String percentile25 = "25%";
            @NotNull
            public static final String median = "50%";
            @NotNull
            public static final String percentile75 = "75%";
            @NotNull
            public static final String percentile95 = "95%";
            @NotNull
            public static final String stdDeviation = "std";
            @NotNull
            public static final String min = "min";
            @NotNull
            public static final String max = "max";
            @NotNull
            public static final String mean = "mean";

            private PandasStatistics() {
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilterComparisonType.values().length];
            try {
                nArray[FilterComparisonType.IS_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.IS_NOT_NONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.IN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.NOT_IN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.CONTAINS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.STARTS_WITH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.ENDS_WITH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

