/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.providers.pyspark;

import com.intellij.openapi.components.Service;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableDataProvider;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.DSTableRawData;
import com.intellij.scientific.tables.api.DataId;
import com.intellij.scientific.tables.api.filters.FilterExpression;
import com.intellij.scientific.tables.api.statisticsHeadersAndTooltips.TableStatisticsData;
import com.intellij.scientific.tables.api.statisticsHeadersAndTooltips.TableVisualizationData;
import com.intellij.scientific.tables.nestedTable.ColumnTreeNode;
import com.intellij.scientific.tables.utils.exceptions.DSTableDataException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.RowSorter;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\u001fJ&\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010%J@\u0010&\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010*J:\u0010+\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\f2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010/\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u00100J(\u00101\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u00105J\u000e\u00106\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u00107R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/scientific/py/tables/providers/pyspark/PyPysparkDataFrameProvider;", "Lcom/intellij/scientific/tables/api/DSTableDataProvider;", "<init>", "()V", "getType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "pysparkShowStringSuffix", "", "tableHasSuffix", "", "lastRow", "splitTextToRawRows", "", "text", "getDelimiterCoordinates", "", "firstRawRow", "getColumnNames", "delimiterCoordinates", "extractRowValues", "startIndices", "row", "parseStaticTableToFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parsePysparkTableToFrameInfo", "parseStaticTableToTableData", "Lcom/intellij/scientific/tables/api/DSTableRawData;", "dataId", "Lcom/intellij/scientific/tables/api/DataId;", "table", "(Lcom/intellij/scientific/tables/api/DataId;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadDynamicTableDataFrameInfo", "commandExecutor", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "tableVariable", "textTableOutput", "(Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadDynamicTableData", "format", "start", "end", "(Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;Lcom/intellij/scientific/tables/api/DataId;Ljava/lang/String;Ljava/lang/String;IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSortingCommand", "sortKeys", "Ljavax/swing/RowSorter$SortKey;", "columns", "indexColumnWidth", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFilteringCommand", "filters", "Lcom/intellij/scientific/tables/api/filters/FilterExpression;", "tableColumnsNumber", "(Ljava/lang/String;Lcom/intellij/scientific/tables/api/filters/FilterExpression;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isFallbackToStaticTableSupported", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nPyPysparkDataFrameProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPysparkDataFrameProvider.kt\ncom/intellij/scientific/py/tables/providers/pyspark/PyPysparkDataFrameProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n777#2:115\n873#2,2:116\n1915#2,2:125\n1924#2,3:128\n1010#3:118\n1021#3:119\n1207#3,2:120\n1209#3:123\n1022#3:124\n1#4:122\n1#4:127\n*S KotlinDebug\n*F\n+ 1 PyPysparkDataFrameProvider.kt\ncom/intellij/scientific/py/tables/providers/pyspark/PyPysparkDataFrameProvider\n*L\n39#1:115\n39#1:116,2\n53#1:125,2\n88#1:128,3\n43#1:118\n43#1:119\n43#1:120,2\n43#1:123\n43#1:124\n43#1:122\n*E\n"})
public final class PyPysparkDataFrameProvider
implements DSTableDataProvider {
    @NonNls
    @NotNull
    private final String pysparkShowStringSuffix;

    public PyPysparkDataFrameProvider() {
        this.pysparkShowStringSuffix = "only showing top";
    }

    @NotNull
    public DSTableDataType getType() {
        return DSTableDataType.PYSPARK_TABLE;
    }

    private final boolean tableHasSuffix(String lastRow) {
        return StringsKt.startsWith$default((String)lastRow, (String)this.pysparkShowStringSuffix, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitTextToRawRows(String text) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getDelimiterCoordinates(String firstRawRow) {
        void $this$mapIndexedNotNullTo$iv$iv;
        CharSequence $this$mapIndexedNotNull$iv = firstRawRow;
        boolean $i$f$mapIndexedNotNull = false;
        CharSequence charSequence = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv$iv$iv.length(); ++i) {
            Integer it$iv$iv;
            void c;
            void element$iv$iv;
            char item$iv$iv$iv = $this$forEachIndexed$iv$iv$iv.charAt(i);
            int n = index$iv$iv$iv++;
            char c2 = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            void var15_15 = element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if ((c == 43 ? Integer.valueOf(index) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> getColumnNames(String text, List<Integer> delimiterCoordinates) {
        return this.extractRowValues(delimiterCoordinates, text);
    }

    private final List<String> extractRowValues(List<Integer> startIndices, String row) {
        List rowValues = new ArrayList();
        Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)startIndices);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int startIndex = ((Number)pair.component1()).intValue();
            int endIndex = ((Number)pair.component2()).intValue();
            String string = row.substring(startIndex + 1, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String substring = ((Object)StringsKt.trim((CharSequence)string)).toString();
            rowValues.add(substring);
        }
        return rowValues;
    }

    @Nullable
    public Object parseStaticTableToFrameInfo(@NotNull String text, @NotNull Continuation<? super DSDataFrameInfo> $completion) {
        DSDataFrameInfo dataFrameInfo = this.parsePysparkTableToFrameInfo(text);
        dataFrameInfo.setTableType(this.getType());
        return dataFrameInfo;
    }

    private final DSDataFrameInfo parsePysparkTableToFrameInfo(String text) {
        ArrayList<Object> arrayList;
        int indexColumnWidth = 0;
        List<String> rawRows = this.splitTextToRawRows(text);
        int rowsNumber = this.tableHasSuffix((String)CollectionsKt.last(rawRows)) ? rawRows.size() - 5 : rawRows.size() - 4;
        List<String> columnNames = this.getColumnNames(rawRows.get(1), this.getDelimiterCoordinates((String)CollectionsKt.first(rawRows)));
        Object[] objectArray = new Object[]{rowsNumber, columnNames.size() - indexColumnWidth};
        String dimensions = DSTableBundle.message((String)"ds.table.dimensions.info", (Object[])objectArray);
        int n = columnNames.size();
        List<String> list = columnNames;
        int n2 = indexColumnWidth;
        int n3 = rowsNumber;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
        int n4 = 0;
        while (n4 < n) {
            int n5;
            int n6 = n5 = n4++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(null);
        }
        arrayList = arrayList2;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n7 = 480;
        TableVisualizationData tableVisualizationData2 = null;
        TableStatisticsData tableStatisticsData2 = null;
        ColumnTreeNode columnTreeNode = null;
        DSTableDataType dSTableDataType = null;
        String string = dimensions;
        ArrayList<Object> arrayList3 = arrayList;
        List<String> list2 = list;
        int n8 = n2;
        int n9 = n3;
        return new DSDataFrameInfo(n9, n8, list2, arrayList3, string, dSTableDataType, columnTreeNode, tableStatisticsData2, tableVisualizationData2, n7, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object parseStaticTableToTableData(@NotNull DataId dataId, @NotNull String table, @NotNull Continuation<? super DSTableRawData> $completion) {
        List<String> rawRows = this.splitTextToRawRows(table);
        List<Integer> delimiterCoordinates = this.getDelimiterCoordinates((String)CollectionsKt.first(rawRows));
        List<String> columnNames = this.getColumnNames(rawRows.get(1), delimiterCoordinates);
        int n = columnNames.size();
        ArrayList<List> arrayList = new ArrayList<List>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<List> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new ArrayList());
        }
        List columns = arrayList;
        int bottomRowsNumber = this.tableHasSuffix((String)CollectionsKt.last(rawRows)) ? 2 : 1;
        for (String row : CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)rawRows, (int)3), (int)bottomRowsNumber)) {
            List<String> rowValues = this.extractRowValues(delimiterCoordinates, row);
            Iterable $this$forEachIndexed$iv = rowValues;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void value2;
                int n5;
                if ((n5 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n5;
                boolean bl = false;
                ((List)columns.get(index)).add(value2);
            }
        }
        return new DSTableRawData(dataId, columns);
    }

    @Nullable
    public Object loadDynamicTableDataFrameInfo(@NotNull DSTableCommandExecutor commandExecutor, @NotNull String tableVariable, @NotNull String textTableOutput, @NotNull Continuation<? super DSDataFrameInfo> $completion) throws DSTableDataException {
        throw new NotImplementedError(null, 1, null);
    }

    @Nullable
    public Object loadDynamicTableData(@NotNull DSTableCommandExecutor commandExecutor, @NotNull DataId dataId, @NotNull String tableVariable, @Nullable String format, int start, int end, @NotNull Continuation<? super DSTableRawData> $completion) {
        throw new NotImplementedError(null, 1, null);
    }

    @Nullable
    public Object getSortingCommand(@NotNull String tableVariable, @NotNull List<? extends RowSorter.SortKey> sortKeys, @NotNull List<String> columns, int indexColumnWidth, @NotNull Continuation<? super String> $completion) {
        throw new NotImplementedError(null, 1, null);
    }

    @Nullable
    public Object getFilteringCommand(@NotNull String tableVariable, @Nullable FilterExpression filters, int tableColumnsNumber, @NotNull Continuation<? super String> $completion) {
        throw new NotImplementedError(null, 1, null);
    }

    @Nullable
    public Object isFallbackToStaticTableSupported(@NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)true);
    }
}

