/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.modelApi;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.model.applications.DjangoAppConfig;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoField;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.django.model.modelApi.DjangoUrlModel;
import com.jetbrains.django.model.modelApi.NoSuchApplicationException;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoTemplateLoader;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoTemplateLoaderStrategy;
import com.jetbrains.django.util.DjangoCoreUtil;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.python.Result;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.management.PythonPackageManagerExt;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.ModuleExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u00014B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016J\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001c2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001cH\u0007J\u001c\u0010$\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0%0\u001cJ\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010\u001cJ\b\u0010)\u001a\u0004\u0018\u00010*J\u0016\u0010/\u001a\u0002002\u000e\u00101\u001a\n\u0012\u0006\b\u0000\u0012\u00020,02J\u0006\u00103\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010+\u001a\u0004\u0018\u00010,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u00065"}, d2={"Lcom/jetbrains/django/model/modelApi/DjangoModelApi;", "", "webSiteDirectory", "Lcom/intellij/psi/PsiDirectory;", "djangoModule", "Lcom/intellij/openapi/module/Module;", "djangoProjectRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "settingsFile", "<init>", "(Lcom/intellij/psi/PsiDirectory;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getDjangoModule", "()Lcom/intellij/openapi/module/Module;", "getSettingsFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "packageManager", "Lcom/jetbrains/python/packaging/management/PythonPackageManager;", "getPackageManager", "()Lcom/jetbrains/python/packaging/management/PythonPackageManager;", "isDjangoPackageMatches", "", "requirement", "Lcom/jetbrains/python/packaging/PyRequirement;", "defaultValue", "(Lcom/jetbrains/python/packaging/PyRequirement;)Ljava/lang/Boolean;", "getRootUrls", "", "Lcom/jetbrains/django/model/modelApi/DjangoUrlModel;", "getModelClasses", "Lcom/jetbrains/django/model/modelApi/DjangoModelClass;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "getApplications", "Lcom/jetbrains/django/model/applications/DjangoApplicationModel;", "getTemplateFolders", "Lcom/intellij/openapi/util/Pair;", "Ljava/lang/Class;", "getDjangoVersionParts", "", "getDjangoPackage", "Lcom/jetbrains/python/packaging/common/PythonPackage;", "urlConfFile", "Lcom/jetbrains/python/psi/PyFile;", "getUrlConfFile", "()Lcom/jetbrains/python/psi/PyFile;", "collectAllUrlsFromCache", "", "files", "", "getDjangoProjectRoot", "Companion", "intellij.django.core"})
@SourceDebugExtension(value={"SMAP\nDjangoModelApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DjangoModelApi.kt\ncom/jetbrains/django/model/modelApi/DjangoModelApi\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,267:1\n1#2:268\n*E\n"})
public final class DjangoModelApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiDirectory webSiteDirectory;
    @NotNull
    private final Module djangoModule;
    @NotNull
    private final VirtualFile djangoProjectRoot;
    @NotNull
    private final VirtualFile settingsFile;
    @Nullable
    private final Sdk sdk;
    @NotNull
    public static final String PACKAGE_NAME = "Django";

    private DjangoModelApi(PsiDirectory webSiteDirectory, Module djangoModule, VirtualFile djangoProjectRoot, VirtualFile settingsFile) {
        this.webSiteDirectory = webSiteDirectory;
        this.djangoModule = djangoModule;
        this.djangoProjectRoot = djangoProjectRoot;
        this.settingsFile = settingsFile;
        this.sdk = ModuleExKt.getPythonSdk((Module)this.djangoModule);
    }

    @NotNull
    public final Module getDjangoModule() {
        return this.djangoModule;
    }

    @NotNull
    public final VirtualFile getSettingsFile() {
        return this.settingsFile;
    }

    @Nullable
    public final PythonPackageManager getPackageManager() {
        PythonPackageManager pythonPackageManager;
        Sdk sdk = this.sdk;
        if (sdk != null) {
            Sdk it = sdk;
            boolean bl = false;
            Project project = this.djangoModule.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            pythonPackageManager = PythonPackageManager.Companion.forSdk(project, it);
        } else {
            pythonPackageManager = null;
        }
        return pythonPackageManager;
    }

    public final boolean isDjangoPackageMatches(@NotNull PyRequirement requirement, boolean defaultValue) {
        Boolean result;
        Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
        Boolean bl = result = this.isDjangoPackageMatches(requirement);
        return bl != null ? bl : defaultValue;
    }

    @Nullable
    public final Boolean isDjangoPackageMatches(@NotNull PyRequirement requirement) {
        Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
        PythonPackage pythonPackage = this.getDjangoPackage();
        if (pythonPackage == null) {
            return null;
        }
        PythonPackage aPackage = pythonPackage;
        return aPackage.matches(requirement);
    }

    @NotNull
    public final List<DjangoUrlModel> getRootUrls() {
        PyFile pyFile = this.getUrlConfFile();
        if (pyFile == null) {
            return CollectionsKt.emptyList();
        }
        PyFile mainUrlsPy = pyFile;
        List<DjangoUrlModel> list = DjangoUrlModel.getUrlsByFile(mainUrlsPy);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getUrlsByFile(...)");
        return list;
    }

    @NotNull
    public final List<DjangoModelClass> getModelClasses(@NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List result = new ArrayList();
        for (DjangoApplicationModel applicationModel : this.getApplications()) {
            List<DjangoModelClass> list = applicationModel.getModelClasses(context);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getModelClasses(...)");
            result.addAll((Collection)list);
        }
        return result;
    }

    @RequiresReadLock
    @NotNull
    public final List<DjangoApplicationModel> getApplications() {
        List result = new ArrayList();
        for (DjangoAppConfig appInfo : DjangoSettingsPy.getInstalledApps(this.djangoModule)) {
            try {
                result.add(new DjangoApplicationModel(appInfo, this.djangoModule, this.djangoProjectRoot));
            }
            catch (NoSuchApplicationException noSuchApplicationException) {}
        }
        return result;
    }

    @NotNull
    public final List<Pair<VirtualFile, Class<?>>> getTemplateFolders() {
        List result = new ArrayList();
        for (DjangoTemplateLoader loader : DjangoTemplateLoaderStrategy.getLoaders(this)) {
            for (VirtualFile templateFolder : loader.getTemplateFolders(this)) {
                Pair pair = Pair.create((Object)templateFolder, loader.getClass());
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                result.add(pair);
            }
        }
        return result;
    }

    @Nullable
    public final List<String> getDjangoVersionParts() {
        PythonPackage pythonPackage = this.getDjangoPackage();
        if (pythonPackage == null) {
            return null;
        }
        PythonPackage aPackage = pythonPackage;
        return DjangoCoreUtil.getDjangoVersionParts(aPackage.toPyPackage());
    }

    @Nullable
    public final PythonPackage getDjangoPackage() {
        PythonPackageManager pythonPackageManager = this.getPackageManager();
        return pythonPackageManager != null ? PythonPackageManagerExt.getInstalledPackageSnapshot$default((PythonPackageManager)pythonPackageManager, (String)PACKAGE_NAME, null, (int)2, null) : null;
    }

    @Nullable
    public final PyFile getUrlConfFile() {
        PsiFile result = null;
        String urlconf = DjangoSettingsPy.getRootUrlconf(this.djangoModule);
        if (urlconf != null) {
            result = DjangoPsiUtil.findFileInRoots(urlconf, (PsiElement)this.webSiteDirectory);
        }
        if (result == null) {
            result = this.webSiteDirectory.findFile("urls.py");
        }
        return (PyFile)PyUtil.as(result, PyFile.class);
    }

    public final void collectAllUrlsFromCache(@NotNull Set<? super PyFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Project project = this.djangoModule.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Collection collection = StubIndex.getElements((StubIndexKey)PyVariableNameIndex.KEY, (Object)"urlpatterns", (Project)project2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2), PyTargetExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getElements(...)");
        Collection urlPatternVars = collection;
        for (PyTargetExpression urlPatternVar : urlPatternVars) {
            PsiFile file = urlPatternVar.getContainingFile();
            if (!(file instanceof PyFile)) continue;
            files.add((PyFile)file);
        }
    }

    @NotNull
    public final VirtualFile getDjangoProjectRoot() {
        return this.djangoProjectRoot;
    }

    @JvmStatic
    @RequiresReadLock
    @NotNull
    public static final Result<DjangoModelApi, String> create(@NotNull Module djangoModule) {
        return Companion.create(djangoModule);
    }

    @JvmStatic
    @RequiresReadLock
    @NotNull
    public static final Result<DjangoModelApi, String> create(@NotNull PyElement djangoElement) {
        return Companion.create(djangoElement);
    }

    @JvmStatic
    public static final boolean notDjangoModule(@NotNull PsiElement element) {
        return Companion.notDjangoModule(element);
    }

    @JvmStatic
    @NotNull
    public static final List<DjangoField> getFieldsWithTypes(@NotNull TypeEvalContext context, @NotNull PyClass clazz, @NotNull Function<? super PyTargetExpression, ? extends PyType> typeProvider, @NotNull DjangoFQNamesProvider fieldParent) {
        return Companion.getFieldsWithTypes(context, clazz, typeProvider, fieldParent);
    }

    public /* synthetic */ DjangoModelApi(PsiDirectory webSiteDirectory, Module djangoModule, VirtualFile djangoProjectRoot, VirtualFile settingsFile, DefaultConstructorMarker $constructor_marker) {
        this(webSiteDirectory, djangoModule, djangoProjectRoot, settingsFile);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\t0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J!\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\t0\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J@\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u001b\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/django/model/modelApi/DjangoModelApi$Companion;", "", "<init>", "()V", "PACKAGE_NAME", "", "create", "Lcom/jetbrains/python/Result;", "Lcom/jetbrains/django/model/modelApi/DjangoModelApi;", "Lorg/jetbrains/annotations/NonNls;", "djangoModule", "Lcom/intellij/openapi/module/Module;", "djangoElement", "Lcom/jetbrains/python/psi/PyElement;", "notDjangoModule", "", "element", "Lcom/intellij/psi/PsiElement;", "getFieldsWithTypes", "", "Lcom/jetbrains/django/model/modelApi/DjangoField;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "clazz", "Lcom/jetbrains/python/psi/PyClass;", "typeProvider", "Ljava/util/function/Function;", "Lcom/jetbrains/python/psi/PyTargetExpression;", "Lcom/jetbrains/python/psi/types/PyType;", "fieldParent", "Lcom/jetbrains/django/DjangoFQNamesProvider;", "intellij.django.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @RequiresReadLock
        @NotNull
        public final Result<DjangoModelApi, String> create(@NotNull Module djangoModule) {
            Intrinsics.checkNotNullParameter((Object)djangoModule, (String)"djangoModule");
            DjangoFacet djangoFacet = DjangoFacet.getInstance(djangoModule);
            if (djangoFacet == null) {
                return (Result)new Result.Failure((Object)("Facet not found in module " + djangoModule));
            }
            DjangoFacet facet = djangoFacet;
            VirtualFile virtualFile = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile();
            if (virtualFile == null) {
                return (Result)new Result.Failure((Object)("Root not found in module " + djangoModule));
            }
            VirtualFile djangoProjectRoot = virtualFile;
            PsiManager psiManager = PsiManager.getInstance((Project)djangoModule.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
            PsiManager psiManager2 = psiManager;
            VirtualFile virtualFile2 = DjangoCoreUtil.getSettingsFile(facet);
            if (virtualFile2 == null) {
                return (Result)new Result.Failure((Object)("Settings file not found in module " + djangoModule));
            }
            VirtualFile settingsFile = virtualFile2;
            VirtualFile virtualFile3 = settingsFile.getParent();
            if (virtualFile3 == null) {
                return (Result)new Result.Failure((Object)("WebSite virtual folder not found in module " + djangoModule));
            }
            VirtualFile webSiteFolder = virtualFile3;
            PsiDirectory psiDirectory = psiManager2.findDirectory(webSiteFolder);
            if (psiDirectory == null) {
                return (Result)new Result.Failure((Object)("WebSite directory not found in module " + djangoModule));
            }
            PsiDirectory webSiteDirectory = psiDirectory;
            return (Result)new Result.Success((Object)new DjangoModelApi(webSiteDirectory, djangoModule, djangoProjectRoot, settingsFile, null));
        }

        @JvmStatic
        @RequiresReadLock
        @NotNull
        public final Result<DjangoModelApi, String> create(@NotNull PyElement djangoElement) {
            Intrinsics.checkNotNullParameter((Object)djangoElement, (String)"djangoElement");
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)djangoElement));
            if (module == null) {
                return (Result)new Result.Failure((Object)("No module found for element " + djangoElement));
            }
            Module module2 = module;
            return this.create(module2);
        }

        @JvmStatic
        public final boolean notDjangoModule(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            return module != null && !DjangoFacet.isPresent(module);
        }

        @JvmStatic
        @NotNull
        public final List<DjangoField> getFieldsWithTypes(@NotNull TypeEvalContext context, @NotNull PyClass clazz, @NotNull Function<? super PyTargetExpression, ? extends PyType> typeProvider, @NotNull DjangoFQNamesProvider fieldParent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter(typeProvider, (String)"typeProvider");
            Intrinsics.checkNotNullParameter((Object)((Object)fieldParent), (String)"fieldParent");
            List result = new ArrayList();
            for (PyTargetExpression targetExpression : clazz.getClassAttributesInherited(context)) {
                String name;
                PyExpression assignedValue;
                if (targetExpression.getName() == null || targetExpression.findAssignedValue() == null) continue;
                PyClassType fieldClassType = (PyClassType)PyUtil.as((Object)context.getType((PyTypedElement)assignedValue), PyClassType.class);
                Intrinsics.checkNotNull((Object)targetExpression);
                PyType fieldType = typeProvider.apply((PyTargetExpression)targetExpression);
                if (fieldType != null && fieldClassType != null) {
                    result.add(new DjangoField(targetExpression, fieldType, name, fieldClassType));
                    continue;
                }
                if (fieldClassType == null || !NameResolverTools.isSubclass((PyClass)fieldClassType.getPyClass(), (FQNamesProvider)fieldParent, (TypeEvalContext)context)) continue;
                result.add(new DjangoField(targetExpression, null, name, fieldClassType));
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

