/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.meta;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.index.SwIndexUtilsKt;
import com.intellij.swagger.core.meta.SwElementProvider;
import com.intellij.swagger.core.meta.SwElementsFactory;
import com.intellij.swagger.core.meta.SwElementsFactoryKt;
import com.intellij.swagger.core.model.SwSpecificationSchemaStorage;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.reference.SwaggerElementPatternsKt;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.MatchResult;
import com.jetbrains.jsonSchema.impl.tree.JsonSchemaNodeExpansionRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J&\u0010\b\u001a\u0004\u0018\u0001H\t\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0086\b\u00a2\u0006\u0002\u0010\nJ+\u0010\u000b\u001a\u001d\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\f\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JV\u0010 \u001a'\u0012\u0004\u0012\u00020\u0010\u0012\u001d\u0012\u001b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f\u00a2\u0006\u0002\b\u000e0\u001d*'\u0012\u0004\u0012\u00020\u0010\u0012\u001d\u0012\u001b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f\u00a2\u0006\u0002\b\u000e0\u001dH\u0002R5\u0010\u001c\u001a'\u0012\u0004\u0012\u00020\u0010\u0012\u001d\u0012\u001b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f\u00a2\u0006\u0002\b\u000e0\u001d8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u001e\u001a'\u0012\u0004\u0012\u00020\u0010\u0012\u001d\u0012\u001b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f\u00a2\u0006\u0002\b\u000e0\u001d8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u001f\u001a'\u0012\u0004\u0012\u00020\u0010\u0012\u001d\u0012\u001b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f\u00a2\u0006\u0002\b\u000e0\u001d8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/swagger/core/meta/SwElementProvider;", "", "<init>", "()V", "getModelElement", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "psiElement", "Lcom/intellij/psi/PsiElement;", "getTypedModelElement", "Type", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/swagger/core/model/api/SwModelElement;", "getInstantiator", "Lkotlin/Function2;", "Lcom/intellij/swagger/core/meta/SwElementsFactory;", "Lkotlin/ExtensionFunctionType;", "metaObjectCoordinates", "", "getOrComputeMeta", "Lcom/intellij/swagger/core/meta/SwElementProvider$ElementSchemaMeta;", "getOrComputeMeta$intellij_swagger_core", "getElementMeta", "getBundledSchemaWithoutProvidersPolling", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "psiFile", "Lcom/intellij/psi/PsiFile;", "findEffectiveElementToCheck", "walker", "Lcom/jetbrains/jsonSchema/extension/JsonLikePsiWalker;", "asyncapi2CoordinatesToBuilders", "", "openapi31CoordinatesToBuilders", "baseCoordinatesToBuilders", "considerDifferentSchemaFormats", "ElementSchemaMeta", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwElementProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwElementProvider.kt\ncom/intellij/swagger/core/meta/SwElementProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,284:1\n30#2,2:285\n*S KotlinDebug\n*F\n+ 1 SwElementProvider.kt\ncom/intellij/swagger/core/meta/SwElementProvider\n*L\n84#1:285,2\n*E\n"})
public final class SwElementProvider {
    @NotNull
    public static final SwElementProvider INSTANCE = new SwElementProvider();
    @NonNls
    @NotNull
    private static final Map<String, Function2<SwElementsFactory, PsiElement, SwModelElement>> asyncapi2CoordinatesToBuilders;
    @NonNls
    @NotNull
    private static final Map<String, Function2<SwElementsFactory, PsiElement, SwModelElement>> openapi31CoordinatesToBuilders;
    @NonNls
    @NotNull
    private static final Map<String, Function2<SwElementsFactory, PsiElement, SwModelElement>> baseCoordinatesToBuilders;

    private SwElementProvider() {
    }

    @Nullable
    public final SwModelElement getModelElement(@Nullable PsiElement psiElement) {
        PsiElement psiElement2 = psiElement;
        if (psiElement2 == null || (psiElement2 = psiElement2.getContainingFile()) == null || (psiElement2 = psiElement2.getOriginalFile()) == null) {
            return null;
        }
        PsiElement psiFile = psiElement2;
        ElementSchemaMeta elementSchemaMeta = this.getOrComputeMeta$intellij_swagger_core(psiElement.getOriginalElement());
        if (elementSchemaMeta == null) {
            return null;
        }
        ElementSchemaMeta meta = elementSchemaMeta;
        Function2<SwElementsFactory, PsiElement, SwModelElement> function2 = this.getInstantiator(meta.getResolvedObjectCoordinates());
        if (function2 == null) {
            return null;
        }
        Function2<SwElementsFactory, PsiElement, SwModelElement> instantiator = function2;
        SwElementsFactory swElementsFactory = SwElementsFactoryKt.getElementsFactory((PsiFile)psiFile);
        if (swElementsFactory == null) {
            return null;
        }
        SwElementsFactory elementsFactory = swElementsFactory;
        return (SwModelElement)instantiator.invoke((Object)elementsFactory, (Object)psiElement);
    }

    public final /* synthetic */ <Type extends SwModelElement> Type getTypedModelElement(PsiElement psiElement) {
        boolean $i$f$getTypedModelElement = false;
        SwModelElement swModelElement = this.getModelElement(psiElement);
        Intrinsics.reifiedOperationMarker((int)2, (String)"Type");
        return (Type)swModelElement;
    }

    private final Function2<SwElementsFactory, PsiElement, SwModelElement> getInstantiator(String metaObjectCoordinates) {
        Function2<SwElementsFactory, PsiElement, SwModelElement> function2 = baseCoordinatesToBuilders.get(metaObjectCoordinates);
        if (function2 == null && (function2 = openapi31CoordinatesToBuilders.get(metaObjectCoordinates)) == null) {
            function2 = asyncapi2CoordinatesToBuilders.get(metaObjectCoordinates);
        }
        return function2;
    }

    @Nullable
    public final ElementSchemaMeta getOrComputeMeta$intellij_swagger_core(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        return (ElementSchemaMeta)CachedValuesManager.getCachedValue((PsiElement)psiElement, () -> SwElementProvider.getOrComputeMeta$lambda$0(psiElement));
    }

    private final ElementSchemaMeta getElementMeta(PsiElement psiElement) {
        ProgressManager.checkCanceled();
        PsiFile psiFile = psiElement.getContainingFile().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        JsonSchemaObject jsonSchemaObject = this.getBundledSchemaWithoutProvidersPolling(psiFile);
        if (jsonSchemaObject == null) {
            return null;
        }
        JsonSchemaObject schema2 = jsonSchemaObject;
        JsonLikePsiWalker jsonLikePsiWalker = JsonLikePsiWalker.getWalker((PsiElement)psiElement, (JsonSchemaObject)schema2);
        if (jsonLikePsiWalker == null) {
            return null;
        }
        JsonLikePsiWalker walker = jsonLikePsiWalker;
        PsiElement psiElement2 = this.findEffectiveElementToCheck(psiElement, walker);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement elementToCheck = psiElement2;
        JsonPointerPosition jsonPointerPosition = walker.findPosition(elementToCheck, true);
        if (jsonPointerPosition == null) {
            return null;
        }
        JsonPointerPosition pointer = jsonPointerPosition;
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree((Project)psiElement.getProject(), (JsonSchemaNodeExpansionRequest)new JsonSchemaNodeExpansionRequest(walker.createValueAdapter(elementToCheck), true), (JsonSchemaObject)schema2, (JsonPointerPosition)pointer, (boolean)false);
        ProgressManager.checkCanceled();
        JsonSchemaObject targetSchema = JsonSchemaResolver.selectSchema((JsonSchemaTreeNode)node, (PsiElement)psiElement, (boolean)pointer.isEmpty());
        if (targetSchema != null) {
            return new ElementSchemaMeta(CollectionsKt.listOf((Object)targetSchema));
        }
        MatchResult schemaResolveResult = MatchResult.create((JsonSchemaTreeNode)node);
        List list = schemaResolveResult.mySchemas;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mySchemas");
        if (!((Collection)list).isEmpty()) {
            List list2 = schemaResolveResult.mySchemas;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"mySchemas");
            return new ElementSchemaMeta(list2);
        }
        List list3 = schemaResolveResult.myExcludingSchemas;
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"myExcludingSchemas");
        return new ElementSchemaMeta(CollectionsKt.flatten((Iterable)list3));
    }

    private final JsonSchemaObject getBundledSchemaWithoutProvidersPolling(PsiFile psiFile) {
        SwSpecificationType swSpecificationType = SwIndexUtilsKt.getPrecomputedSpecificationTypeFromUserData(psiFile);
        if (swSpecificationType == null) {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            swSpecificationType = SwSpecificationDetectionKt.detectSpecificationType(virtualFile, psiFile);
        }
        SwSpecificationType specificationType = swSpecificationType;
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<SwSpecificationSchemaStorage> serviceClass$iv = SwSpecificationSchemaStorage.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Pair<VirtualFile, JsonSchemaObject> pair = ((SwSpecificationSchemaStorage)object).getSchemaFor(specificationType);
        return pair != null ? (JsonSchemaObject)pair.getSecond() : null;
    }

    private final PsiElement findEffectiveElementToCheck(PsiElement psiElement, JsonLikePsiWalker walker) {
        return psiElement instanceof PsiFile ? psiElement : (psiElement instanceof YAMLKeyValue ? ((YAMLKeyValue)psiElement).getKey() : (Intrinsics.areEqual((Object)psiElement.getLanguage(), (Object)YAMLLanguage.INSTANCE) && SwaggerElementPatternsKt.isPropertyKey(psiElement) ? psiElement : walker.findElementToCheck(psiElement)));
    }

    private final Map<String, Function2<SwElementsFactory, PsiElement, SwModelElement>> considerDifferentSchemaFormats(Map<String, ? extends Function2<? super SwElementsFactory, ? super PsiElement, ? extends SwModelElement>> $this$considerDifferentSchemaFormats) {
        return MapsKt.toMap((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)$this$considerDifferentSchemaFormats.entrySet()), SwElementProvider::considerDifferentSchemaFormats$lambda$0));
    }

    private static final CachedValueProvider.Result getOrComputeMeta$lambda$0(PsiElement $psiElement) {
        ElementSchemaMeta elementSchemaMeta = INSTANCE.getElementMeta($psiElement);
        Object[] objectArray = new Object[1];
        Project project = $psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = SwaggerUtilsKt.getYamlJsonModificationTracker(project);
        return CachedValueProvider.Result.create((Object)elementSchemaMeta, (Object[])objectArray);
    }

    private static final Sequence considerDifferentSchemaFormats$lambda$0(Map.Entry entry) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String oldKey = (String)entry.getKey();
        Function2 value = (Function2)entry.getValue();
        if (StringsKt.contains$default((CharSequence)oldKey, (CharSequence)"/definitions/", (boolean)false, (int)2, null)) {
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)oldKey, (Object)value), TuplesKt.to((Object)StringsKt.replace$default((String)oldKey, (String)"/definitions/", (String)"/$defs/", (boolean)false, (int)4, null), (Object)value)};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else {
            sequence = SequencesKt.sequenceOf((Object)TuplesKt.to((Object)oldKey, (Object)value));
        }
        return sequence;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"/definitions/channels/additionalProperties", (Object)((Object)asyncapi2CoordinatesToBuilders.1.INSTANCE)), TuplesKt.to((Object)"/definitions/channelItem/properties/subscribe", (Object)((Object)asyncapi2CoordinatesToBuilders.2.INSTANCE)), TuplesKt.to((Object)"/definitions/channelItem/properties/publish", (Object)((Object)asyncapi2CoordinatesToBuilders.3.INSTANCE)), TuplesKt.to((Object)"/definitions/schemas/additionalProperties", (Object)((Object)asyncapi2CoordinatesToBuilders.4.INSTANCE)), TuplesKt.to((Object)"/definitions/messages/additionalProperties", (Object)((Object)asyncapi2CoordinatesToBuilders.5.INSTANCE)), TuplesKt.to((Object)"/definitions/serverVariables/additionalProperties/oneOf/0", (Object)((Object)asyncapi2CoordinatesToBuilders.6.INSTANCE)), TuplesKt.to((Object)"/definitions/parameters/additionalProperties/oneOf/0", (Object)((Object)asyncapi2CoordinatesToBuilders.7.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/messages/oneOf/0", (Object)((Object)asyncapi2CoordinatesToBuilders.8.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/correlationIds/patternProperties/^[\\w\\d\\.\\-_]+$/oneOf/0", (Object)((Object)asyncapi2CoordinatesToBuilders.9.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/securitySchemes/patternProperties/^[\\w\\d\\.\\-_]+$/oneOf/0", (Object)((Object)asyncapi2CoordinatesToBuilders.10.INSTANCE)), TuplesKt.to((Object)"/definitions/SecurityScheme/oneOf/0", (Object)((Object)asyncapi2CoordinatesToBuilders.11.INSTANCE)), TuplesKt.to((Object)"/definitions/SecurityScheme/oneOf/1", (Object)((Object)asyncapi2CoordinatesToBuilders.12.INSTANCE)), TuplesKt.to((Object)"/definitions/SecurityScheme/oneOf/2", (Object)((Object)asyncapi2CoordinatesToBuilders.13.INSTANCE)), TuplesKt.to((Object)"/definitions/SecurityScheme/oneOf/3", (Object)((Object)asyncapi2CoordinatesToBuilders.14.INSTANCE)), TuplesKt.to((Object)"/definitions/SecurityScheme/oneOf/4", (Object)((Object)asyncapi2CoordinatesToBuilders.15.INSTANCE)), TuplesKt.to((Object)"/definitions/SecurityScheme/oneOf/5", (Object)((Object)asyncapi2CoordinatesToBuilders.16.INSTANCE)), TuplesKt.to((Object)"/definitions/SecurityScheme/oneOf/6", (Object)((Object)asyncapi2CoordinatesToBuilders.17.INSTANCE)), TuplesKt.to((Object)"/definitions/SecurityScheme/oneOf/7", (Object)((Object)asyncapi2CoordinatesToBuilders.18.INSTANCE)), TuplesKt.to((Object)"/definitions/SecurityScheme/oneOf/8", (Object)((Object)asyncapi2CoordinatesToBuilders.19.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/operationTraits/additionalProperties", (Object)((Object)asyncapi2CoordinatesToBuilders.20.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/messageTraits/additionalProperties", (Object)((Object)asyncapi2CoordinatesToBuilders.21.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/serverBindings/additionalProperties", (Object)((Object)asyncapi2CoordinatesToBuilders.22.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/channelBindings/additionalProperties", (Object)((Object)asyncapi2CoordinatesToBuilders.23.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/operationBindings/additionalProperties", (Object)((Object)asyncapi2CoordinatesToBuilders.24.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/messageBindings/additionalProperties", (Object)((Object)asyncapi2CoordinatesToBuilders.25.INSTANCE))};
        asyncapi2CoordinatesToBuilders = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"/anyOf/0", (Object)((Object)openapi31CoordinatesToBuilders.1.INSTANCE)), TuplesKt.to((Object)"/properties/servers", (Object)((Object)openapi31CoordinatesToBuilders.2.INSTANCE)), TuplesKt.to((Object)"/$defs/operation/properties/parameters", (Object)((Object)openapi31CoordinatesToBuilders.3.INSTANCE)), TuplesKt.to((Object)"/$defs/path-item/properties/get", (Object)((Object)openapi31CoordinatesToBuilders.4.INSTANCE)), TuplesKt.to((Object)"/$defs/path-item/properties/post", (Object)((Object)openapi31CoordinatesToBuilders.5.INSTANCE)), TuplesKt.to((Object)"/$defs/path-item/properties/put", (Object)((Object)openapi31CoordinatesToBuilders.6.INSTANCE)), TuplesKt.to((Object)"/$defs/path-item/properties/head", (Object)((Object)openapi31CoordinatesToBuilders.7.INSTANCE)), TuplesKt.to((Object)"/$defs/path-item/properties/delete", (Object)((Object)openapi31CoordinatesToBuilders.8.INSTANCE)), TuplesKt.to((Object)"/$defs/path-item/properties/patch", (Object)((Object)openapi31CoordinatesToBuilders.9.INSTANCE)), TuplesKt.to((Object)"/$defs/path-item/properties/options", (Object)((Object)openapi31CoordinatesToBuilders.10.INSTANCE)), TuplesKt.to((Object)"/$defs/path-item/patternProperties/^(get|put|post|delete|options|head|patch|trace)$", (Object)((Object)openapi31CoordinatesToBuilders.11.INSTANCE)), TuplesKt.to((Object)"/$defs/components/properties/responses/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.12.INSTANCE)), TuplesKt.to((Object)"/$defs/responses/patternProperties/^[1-5](?:[0-9]{2}|XX)$", (Object)((Object)openapi31CoordinatesToBuilders.13.INSTANCE)), TuplesKt.to((Object)"/$defs/response-or-reference/else", (Object)((Object)openapi31CoordinatesToBuilders.14.INSTANCE)), TuplesKt.to((Object)"/$defs/components/properties/callbacks/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.15.INSTANCE)), TuplesKt.to((Object)"/$defs/components/properties/examples/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.16.INSTANCE)), TuplesKt.to((Object)"/$defs/components/properties/headers/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.17.INSTANCE)), TuplesKt.to((Object)"/$defs/components/properties/links/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.18.INSTANCE)), TuplesKt.to((Object)"/$defs/components/properties/securitySchemes/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.19.INSTANCE)), TuplesKt.to((Object)"/$defs/components/properties/parameters/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.20.INSTANCE)), TuplesKt.to((Object)"/$defs/parameter/oneOf/0", (Object)((Object)openapi31CoordinatesToBuilders.21.INSTANCE)), TuplesKt.to((Object)"/$defs/parameter/oneOf/1", (Object)((Object)openapi31CoordinatesToBuilders.22.INSTANCE)), TuplesKt.to((Object)"/$defs/operation/properties/parameters/items", (Object)((Object)openapi31CoordinatesToBuilders.23.INSTANCE)), TuplesKt.to((Object)"/$defs/components/properties/requestBodies/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.24.INSTANCE)), TuplesKt.to((Object)"/$defs/parameter-or-reference/then", (Object)((Object)openapi31CoordinatesToBuilders.25.INSTANCE)), TuplesKt.to((Object)"/$defs/response-or-reference/else", (Object)((Object)openapi31CoordinatesToBuilders.26.INSTANCE)), TuplesKt.to((Object)"/$defs/callbacks-or-reference/else", (Object)((Object)openapi31CoordinatesToBuilders.27.INSTANCE)), TuplesKt.to((Object)"/$defs/path-item-or-reference/else", (Object)((Object)openapi31CoordinatesToBuilders.28.INSTANCE)), TuplesKt.to((Object)"/$defs/example-or-reference/else", (Object)((Object)openapi31CoordinatesToBuilders.29.INSTANCE)), TuplesKt.to((Object)"/$defs/header-or-reference/else", (Object)((Object)openapi31CoordinatesToBuilders.30.INSTANCE)), TuplesKt.to((Object)"/$defs/header/oneOf/0", (Object)((Object)openapi31CoordinatesToBuilders.31.INSTANCE)), TuplesKt.to((Object)"/$defs/header/oneOf/1", (Object)((Object)openapi31CoordinatesToBuilders.32.INSTANCE)), TuplesKt.to((Object)"/$defs/link-or-reference/else", (Object)((Object)openapi31CoordinatesToBuilders.33.INSTANCE)), TuplesKt.to((Object)"/$defs/link/oneOf/0", (Object)((Object)openapi31CoordinatesToBuilders.34.INSTANCE)), TuplesKt.to((Object)"/$defs/link/oneOf/1", (Object)((Object)openapi31CoordinatesToBuilders.35.INSTANCE)), TuplesKt.to((Object)"/$defs/security-scheme-or-reference/else", (Object)((Object)openapi31CoordinatesToBuilders.36.INSTANCE)), TuplesKt.to((Object)"/$defs/parameter-or-reference/else", (Object)((Object)openapi31CoordinatesToBuilders.37.INSTANCE)), TuplesKt.to((Object)"/$defs/request-body-or-reference/else", (Object)((Object)openapi31CoordinatesToBuilders.38.INSTANCE)), TuplesKt.to((Object)"/$defs/parameter-or-reference/else", (Object)((Object)openapi31CoordinatesToBuilders.39.INSTANCE)), TuplesKt.to((Object)"/$defs/request-body-or-reference/else", (Object)((Object)openapi31CoordinatesToBuilders.40.INSTANCE)), TuplesKt.to((Object)"/$defs/components/properties/securitySchemes/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.41.INSTANCE)), TuplesKt.to((Object)"/$defs/components/properties/schemas/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.42.INSTANCE)), TuplesKt.to((Object)"/$defs/components/properties/schemas/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.43.INSTANCE)), TuplesKt.to((Object)"/$defs/content/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.44.INSTANCE)), TuplesKt.to((Object)"/$defs/license/oneOf/0", (Object)((Object)openapi31CoordinatesToBuilders.45.INSTANCE)), TuplesKt.to((Object)"/$defs/license/oneOf/1", (Object)((Object)openapi31CoordinatesToBuilders.46.INSTANCE)), TuplesKt.to((Object)"/$defs/server-variable", (Object)((Object)openapi31CoordinatesToBuilders.47.INSTANCE)), TuplesKt.to((Object)"/$defs/server/properties/variables/additionalProperties", (Object)((Object)openapi31CoordinatesToBuilders.48.INSTANCE)), TuplesKt.to((Object)"/$defs/media-type/properties/schema", (Object)((Object)openapi31CoordinatesToBuilders.49.INSTANCE)), TuplesKt.to((Object)"/$defs/schema/properties/oneOf/items", (Object)((Object)openapi31CoordinatesToBuilders.50.INSTANCE)), TuplesKt.to((Object)"/$defs/schema/properties/allOf/items", (Object)((Object)openapi31CoordinatesToBuilders.51.INSTANCE)), TuplesKt.to((Object)"/$defs/schema/properties/anyOf/items", (Object)((Object)openapi31CoordinatesToBuilders.52.INSTANCE))};
        openapi31CoordinatesToBuilders = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"/", (Object)((Object)baseCoordinatesToBuilders.1.INSTANCE)), TuplesKt.to((Object)"/properties/paths", (Object)((Object)baseCoordinatesToBuilders.2.INSTANCE)), TuplesKt.to((Object)"/properties/definitions", (Object)((Object)baseCoordinatesToBuilders.3.INSTANCE)), TuplesKt.to((Object)"/properties/parameters", (Object)((Object)baseCoordinatesToBuilders.4.INSTANCE)), TuplesKt.to((Object)"/properties/responses", (Object)((Object)baseCoordinatesToBuilders.5.INSTANCE)), TuplesKt.to((Object)"/properties/components", (Object)((Object)baseCoordinatesToBuilders.6.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/schemas", (Object)((Object)baseCoordinatesToBuilders.7.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/responses", (Object)((Object)baseCoordinatesToBuilders.8.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/parameters", (Object)((Object)baseCoordinatesToBuilders.9.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/requestBodies", (Object)((Object)baseCoordinatesToBuilders.10.INSTANCE)), TuplesKt.to((Object)"/definitions/operation/properties/responses", (Object)((Object)baseCoordinatesToBuilders.11.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/callbacks", (Object)((Object)baseCoordinatesToBuilders.12.INSTANCE)), TuplesKt.to((Object)"/definitions/operation/properties/callbacks", (Object)((Object)baseCoordinatesToBuilders.13.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/examples", (Object)((Object)baseCoordinatesToBuilders.14.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/headers", (Object)((Object)baseCoordinatesToBuilders.15.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/links", (Object)((Object)baseCoordinatesToBuilders.16.INSTANCE)), TuplesKt.to((Object)"/definitions/components/properties/securitySchemes", (Object)((Object)baseCoordinatesToBuilders.17.INSTANCE)), TuplesKt.to((Object)"/definitions/operation/properties/parameters", (Object)((Object)baseCoordinatesToBuilders.18.INSTANCE)), TuplesKt.to((Object)"/definitions/callbackOrReference/oneOf/0", (Object)((Object)baseCoordinatesToBuilders.19.INSTANCE)), TuplesKt.to((Object)"/definitions/exampleOrReference/oneOf/0", (Object)((Object)baseCoordinatesToBuilders.20.INSTANCE)), TuplesKt.to((Object)"/definitions/headerOrReference/oneOf/0", (Object)((Object)baseCoordinatesToBuilders.21.INSTANCE)), TuplesKt.to((Object)"/definitions/linkOrReference/oneOf/0", (Object)((Object)baseCoordinatesToBuilders.22.INSTANCE)), TuplesKt.to((Object)"/definitions/securitySchemeOrReference/oneOf/0", (Object)((Object)baseCoordinatesToBuilders.23.INSTANCE)), TuplesKt.to((Object)"/properties/info", (Object)((Object)baseCoordinatesToBuilders.24.INSTANCE)), TuplesKt.to((Object)"/definitions/info/properties/contact", (Object)((Object)baseCoordinatesToBuilders.25.INSTANCE)), TuplesKt.to((Object)"/definitions/info/properties/license", (Object)((Object)baseCoordinatesToBuilders.26.INSTANCE)), TuplesKt.to((Object)"/definitions/requestBodyOrReference/oneOf/0", (Object)((Object)baseCoordinatesToBuilders.27.INSTANCE)), TuplesKt.to((Object)"/definitions/requestBody", (Object)((Object)baseCoordinatesToBuilders.28.INSTANCE)), TuplesKt.to((Object)"/definitions/pathItem/properties/get", (Object)((Object)baseCoordinatesToBuilders.29.INSTANCE)), TuplesKt.to((Object)"/definitions/pathItem/properties/post", (Object)((Object)baseCoordinatesToBuilders.30.INSTANCE)), TuplesKt.to((Object)"/definitions/pathItem/properties/put", (Object)((Object)baseCoordinatesToBuilders.31.INSTANCE)), TuplesKt.to((Object)"/definitions/pathItem/properties/head", (Object)((Object)baseCoordinatesToBuilders.32.INSTANCE)), TuplesKt.to((Object)"/definitions/pathItem/properties/delete", (Object)((Object)baseCoordinatesToBuilders.33.INSTANCE)), TuplesKt.to((Object)"/definitions/pathItem/properties/patch", (Object)((Object)baseCoordinatesToBuilders.34.INSTANCE)), TuplesKt.to((Object)"/definitions/pathItem/properties/options", (Object)((Object)baseCoordinatesToBuilders.35.INSTANCE)), TuplesKt.to((Object)"/definitions/paths/patternProperties/^~1", (Object)((Object)baseCoordinatesToBuilders.36.INSTANCE)), TuplesKt.to((Object)"/properties/basePath", (Object)((Object)baseCoordinatesToBuilders.37.INSTANCE)), TuplesKt.to((Object)"/definitions/callback/patternProperties/^", (Object)((Object)baseCoordinatesToBuilders.38.INSTANCE)), TuplesKt.to((Object)"/definitions/schemesList/items", (Object)((Object)baseCoordinatesToBuilders.39.INSTANCE)), TuplesKt.to((Object)"/properties/host", (Object)((Object)baseCoordinatesToBuilders.40.INSTANCE)), TuplesKt.to((Object)"/definitions/mediaTypeList/items", (Object)((Object)baseCoordinatesToBuilders.41.INSTANCE)), TuplesKt.to((Object)"/definitions/mediaTypes/additionalProperties", (Object)((Object)baseCoordinatesToBuilders.42.INSTANCE)), TuplesKt.to((Object)"/definitions/definitions/additionalProperties", (Object)((Object)baseCoordinatesToBuilders.43.INSTANCE)), TuplesKt.to((Object)"/definitions/schemaOrReference/oneOf/0", (Object)((Object)baseCoordinatesToBuilders.44.INSTANCE)), TuplesKt.to((Object)"/definitions/responseDefinitions/additionalProperties", (Object)((Object)baseCoordinatesToBuilders.45.INSTANCE)), TuplesKt.to((Object)"/definitions/responseValue/oneOf/0", (Object)((Object)baseCoordinatesToBuilders.46.INSTANCE)), TuplesKt.to((Object)"/definitions/responseOrReference/oneOf/0", (Object)((Object)baseCoordinatesToBuilders.47.INSTANCE)), TuplesKt.to((Object)"/definitions/parameter/oneOf/0", (Object)((Object)baseCoordinatesToBuilders.48.INSTANCE)), TuplesKt.to((Object)"/definitions/parameterOrReference/oneOf/0", (Object)((Object)baseCoordinatesToBuilders.49.INSTANCE)), TuplesKt.to((Object)"/definitions/schema/properties/properties/additionalProperties", (Object)((Object)baseCoordinatesToBuilders.50.INSTANCE)), TuplesKt.to((Object)"/definitions/bodyParameter/properties/schema", (Object)((Object)baseCoordinatesToBuilders.51.INSTANCE)), TuplesKt.to((Object)"/properties/servers/items", (Object)((Object)baseCoordinatesToBuilders.52.INSTANCE)), TuplesKt.to((Object)"/definitions/encoding/properties/contentType", (Object)((Object)baseCoordinatesToBuilders.53.INSTANCE)), TuplesKt.to((Object)"/definitions/serverVariable", (Object)((Object)baseCoordinatesToBuilders.54.INSTANCE)), TuplesKt.to((Object)"/definitions/serverVariables/additionalProperties", (Object)((Object)baseCoordinatesToBuilders.55.INSTANCE))};
        baseCoordinatesToBuilders = INSTANCE.considerDifferentSchemaFormats(MapsKt.mapOf((Pair[])pairArray));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\u0004J\n\u0010\u0016\u001a\u00020\nH\u0096\u0080\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/swagger/core/meta/SwElementProvider$ElementSchemaMeta;", "", "alternativeSchemaObjects", "", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "<init>", "(Ljava/util/Collection;)V", "getAlternativeSchemaObjects", "()Ljava/util/Collection;", "resolvedObjectCoordinates", "", "getResolvedObjectCoordinates", "()Ljava/lang/String;", "allPossibleCoordinates", "", "getAllPossibleCoordinates", "()Ljava/util/Set;", "equals", "", "other", "hashCode", "", "toString", "intellij.swagger.core"})
    @SourceDebugExtension(value={"SMAP\nSwElementProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwElementProvider.kt\ncom/intellij/swagger/core/meta/SwElementProvider$ElementSchemaMeta\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,284:1\n1586#2:285\n1661#2,3:286\n19#3:289\n*S KotlinDebug\n*F\n+ 1 SwElementProvider.kt\ncom/intellij/swagger/core/meta/SwElementProvider$ElementSchemaMeta\n*L\n267#1:285\n267#1:286,3\n270#1:289\n*E\n"})
    public static final class ElementSchemaMeta {
        @NotNull
        private final Collection<JsonSchemaObject> alternativeSchemaObjects;

        public ElementSchemaMeta(@NotNull Collection<? extends JsonSchemaObject> alternativeSchemaObjects) {
            Intrinsics.checkNotNullParameter(alternativeSchemaObjects, (String)"alternativeSchemaObjects");
            this.alternativeSchemaObjects = alternativeSchemaObjects;
        }

        @NotNull
        public final Collection<JsonSchemaObject> getAlternativeSchemaObjects() {
            return this.alternativeSchemaObjects;
        }

        @NotNull
        public final String getResolvedObjectCoordinates() {
            Object object = (JsonSchemaObject)CollectionsKt.firstOrNull((Iterable)this.alternativeSchemaObjects);
            if (object == null || (object = object.getPointer()) == null) {
                object = "";
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> getAllPossibleCoordinates() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.alternativeSchemaObjects;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                JsonSchemaObject jsonSchemaObject = (JsonSchemaObject)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getPointer());
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        public boolean equals(@Nullable Object other) {
            Set<String> set;
            block5: {
                block4: {
                    set = other;
                    if (set == null) break block4;
                    Set<String> $this$asSafely$iv = set;
                    boolean $i$f$asSafely = false;
                    Set<String> set2 = $this$asSafely$iv;
                    if (!(set2 instanceof ElementSchemaMeta)) {
                        set2 = null;
                    }
                    if ((set = (ElementSchemaMeta)((Object)set2)) != null && (set = ((ElementSchemaMeta)((Object)set)).getAllPossibleCoordinates()) != null) break block5;
                }
                return false;
            }
            Set<String> otherPointers = set;
            Set<String> thisPointers = this.getAllPossibleCoordinates();
            return thisPointers.size() == otherPointers.size() && thisPointers.containsAll((Collection)otherPointers);
        }

        public int hashCode() {
            return ((Object)this.getAllPossibleCoordinates()).hashCode();
        }

        @NotNull
        public String toString() {
            return "SwaggerElementMetadata(Primary target: " + this.getResolvedObjectCoordinates() + " , All available targets: " + this.getAllPossibleCoordinates() + ")";
        }
    }
}

