/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0012\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0096\u0082\u0004J\u001a\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0096\u0080\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0015\u0010\u000e\u001a\u00020\u00048VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/debugger/sourcemap/StringViewCharSequence;", "", "sourceSequence", "start", "", "end", "<init>", "(Ljava/lang/CharSequence;II)V", "(Ljava/lang/CharSequence;)V", "getSourceSequence", "()Ljava/lang/CharSequence;", "getStart", "()I", "getEnd", "length", "getLength", "get", "", "index", "subSequence", "startIndex", "endIndex", "toString", "", "intellij.platform.scriptDebugger.backend"})
final class StringViewCharSequence
implements CharSequence {
    @NotNull
    private final CharSequence sourceSequence;
    private final int start;
    private final int end;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringViewCharSequence(CharSequence sourceSequence, int start, int end) {
        this.sourceSequence = sourceSequence;
        this.start = start;
        this.end = end;
        int n = this.end;
        int n2 = this.start;
        boolean bl = 0 <= n2 ? n2 <= n : false;
        if (bl) {
            boolean bl2;
            n = this.sourceSequence.length();
            n2 = this.end;
            if (0 <= n2) {
                if (n2 <= n) {
                    return;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return;
            }
        }
        boolean bl3 = false;
        if (bl3) return;
        boolean bl4 = false;
        String string = "Invalid sequence range: start=" + this.start + ", end=" + this.end + ", length=" + this.sourceSequence.length();
        throw new IllegalArgumentException(string.toString());
    }

    @NotNull
    public final CharSequence getSourceSequence() {
        return this.sourceSequence;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public StringViewCharSequence(@NotNull CharSequence sourceSequence) {
        Intrinsics.checkNotNullParameter((Object)sourceSequence, (String)"sourceSequence");
        this(sourceSequence, 0, sourceSequence.length());
    }

    public int getLength() {
        return this.end - this.start;
    }

    public char get(int index) {
        return this.sourceSequence.charAt(this.start + index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        if (startIndex == 0 && endIndex == this.length()) {
            return this;
        }
        return new StringViewCharSequence(this.sourceSequence, this.start + startIndex, this.start + endIndex);
    }

    @Override
    @NotNull
    public String toString() {
        return ((Object)this.sourceSequence.subSequence(this.start, this.end)).toString();
    }
}

