/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.Session;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.platform.ProjectTemplate;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

public class WizardContext
extends UserDataHolderBase {
    @Nullable
    private final Project myProject;
    private final Disposable myDisposable;
    private Session mySessionId = null;
    private Path myProjectFileDirectory;
    private String myProjectName;
    private String myCompilerOutputDirectory;
    private Sdk myProjectJdk;
    private ProjectBuilder myProjectBuilder;
    private ProjectBuilder myOriginalBuilder;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private StorageScheme myProjectStorageFormat = StorageScheme.DIRECTORY_BASED;
    private ModulesProvider myModulesProvider;
    private boolean myProjectFileDirectorySetExplicitly;
    private String myDefaultModuleName = "untitled";
    private int myScreen = 1;

    public void setProjectStorageFormat(StorageScheme format) {
        this.myProjectStorageFormat = format;
    }

    @Deprecated(forRemoval=true)
    public boolean isNewWizard() {
        return true;
    }

    public ModulesProvider getModulesProvider() {
        return this.myModulesProvider;
    }

    public void setModulesProvider(ModulesProvider modulesProvider) {
        this.myModulesProvider = modulesProvider;
    }

    public Disposable getDisposable() {
        return this.myDisposable;
    }

    public void setDefaultModuleName(String defaultModuleName) {
        this.myDefaultModuleName = defaultModuleName;
    }

    public String getDefaultModuleName() {
        return this.myDefaultModuleName;
    }

    public WizardContext(@Nullable Project project, Disposable parentDisposable) {
        this.myProject = project;
        this.myDisposable = parentDisposable;
        if (this.myProject != null) {
            this.myProjectJdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        if (this.isNewWizard()) {
            this.mySessionId = Session.createRandomId();
        }
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public @SystemDependent String getProjectFileDirectory() {
        String string = this.getProjectDirectory().toString();
        if (string == null) {
            WizardContext.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Path getProjectDirectory() {
        if (this.myProjectFileDirectory != null) {
            Path path = this.myProjectFileDirectory;
            if (path == null) {
                WizardContext.$$$reportNull$$$0(1);
            }
            return path;
        }
        Path path = Paths.get(RecentProjectsManager.getInstance().suggestNewProjectLocation(), new String[0]);
        if (path == null) {
            WizardContext.$$$reportNull$$$0(2);
        }
        return path;
    }

    public boolean isProjectFileDirectorySet() {
        return this.myProjectFileDirectory != null;
    }

    public boolean isProjectFileDirectorySetExplicitly() {
        return this.myProjectFileDirectorySetExplicitly;
    }

    public void setProjectFileDirectory(@Nullable String value) {
        this.setProjectFileDirectory(value == null ? null : Paths.get(value, new String[0]), false);
    }

    public void setProjectFileDirectory(@Nullable Path projectFileDirectory, boolean explicitly) {
        this.myProjectFileDirectorySetExplicitly = explicitly;
        this.myProjectFileDirectory = projectFileDirectory == null ? null : projectFileDirectory.normalize();
    }

    public String getCompilerOutputDirectory() {
        return this.myCompilerOutputDirectory;
    }

    public void setCompilerOutputDirectory(String compilerOutputDirectory) {
        this.myCompilerOutputDirectory = compilerOutputDirectory;
    }

    public String getProjectName() {
        return this.myProjectName;
    }

    public void setProjectName(String projectName) {
        this.myProjectName = projectName;
    }

    public boolean isCreatingNewProject() {
        return this.myProject == null;
    }

    public int isCreatingNewProjectInt() {
        return this.isCreatingNewProject() ? 1 : 0;
    }

    @Nullable
    public Icon getStepIcon() {
        return null;
    }

    public void requestWizardButtonsUpdate() {
        for (Listener listener : this.myListeners) {
            listener.buttonsUpdateRequested();
        }
    }

    public void requestNextStep() {
        for (Listener listener : this.myListeners) {
            listener.nextStepRequested();
        }
    }

    public void requestSwitchTo(@NotNull String placeId) {
        if (placeId == null) {
            WizardContext.$$$reportNull$$$0(3);
        }
        this.requestSwitchTo(placeId, __ -> {});
    }

    public void requestSwitchTo(@NotNull String placeId, @NotNull Consumer<? super Step> configure) {
        if (placeId == null) {
            WizardContext.$$$reportNull$$$0(4);
        }
        if (configure == null) {
            WizardContext.$$$reportNull$$$0(5);
        }
        for (Listener listener : this.myListeners) {
            listener.switchToRequested(placeId, configure);
        }
    }

    public void addContextListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void setProjectJdk(Sdk jdk) {
        this.myProjectJdk = jdk;
    }

    public Sdk getProjectJdk() {
        return this.myProjectJdk;
    }

    @Nullable
    public ProjectBuilder getProjectBuilder() {
        return this.myProjectBuilder;
    }

    public void setProjectBuilder(@Nullable ProjectBuilder projectBuilder) {
        this.myOriginalBuilder = this.myProjectBuilder = projectBuilder;
    }

    public void setProjectTemplate(@Nullable ProjectTemplate projectTemplate) {
        this.myProjectBuilder = projectTemplate != null ? projectTemplate.createModuleBuilder() : this.myOriginalBuilder;
    }

    public String getPresentationName() {
        return IdeCoreBundle.message((String)(this.myProject == null ? "project.new.wizard.project.identification" : "project.new.wizard.module.identification"), (Object[])new Object[0]);
    }

    public StorageScheme getProjectStorageFormat() {
        return this.myProjectStorageFormat;
    }

    public Session getSessionId() {
        return this.mySessionId;
    }

    public int getScreen() {
        return this.myScreen;
    }

    public void setScreen(int screen) {
        this.myScreen = screen;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/WizardContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFileDirectory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDirectory";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/WizardContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requestSwitchTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    public static interface Listener {
        default public void buttonsUpdateRequested() {
        }

        default public void nextStepRequested() {
        }

        default public void switchToRequested(@NotNull String placeId) {
            if (placeId == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        default public void switchToRequested(@NotNull String placeId, @NotNull Consumer<? super Step> configure) {
            if (placeId == null) {
                Listener.$$$reportNull$$$0(1);
            }
            if (configure == null) {
                Listener.$$$reportNull$$$0(2);
            }
            this.switchToRequested(placeId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "placeId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configure";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/util/projectWizard/WizardContext$Listener";
            objectArray[2] = "switchToRequested";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

