/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.download.SharedIndexLineup;
import com.intellij.indexing.shared.generator.BaseIndex;
import com.intellij.indexing.shared.generator.EnumeratedHashedIndexedFiles;
import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.indexing.shared.generator.HashedIndexedFiles;
import com.intellij.indexing.shared.generator.IndexChunk;
import com.intellij.indexing.shared.generator.IndexedFileContentLoader;
import com.intellij.indexing.shared.generator.IndexedFilesCollector;
import com.intellij.indexing.shared.generator.IndexedFilesReporter;
import com.intellij.indexing.shared.generator.IndexesExporterBasesLoaderKt;
import com.intellij.indexing.shared.generator.IndexesExporterEP;
import com.intellij.indexing.shared.generator.IndexesExporterGenerators;
import com.intellij.indexing.shared.generator.IndexesExporterHashEnumerateTask;
import com.intellij.indexing.shared.generator.IndexesExporterKt;
import com.intellij.indexing.shared.generator.IndexesExporterMainIndex;
import com.intellij.indexing.shared.generator.IndexesExporterRequest;
import com.intellij.indexing.shared.generator.IndexesExporterTaskResult;
import com.intellij.indexing.shared.generator.SharedIndexBase;
import com.intellij.indexing.shared.generator.diagnostic.IndexExportStatistics;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.metadata.SharedIndexGenerationStatistics;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.metadata.SharedIndexMetadataInfo;
import com.intellij.indexing.shared.platform.api.IdeSharedIndexesState;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\u00020\u0013*\u00020\u0013H\u0002J\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\f\u0010\u001d\u001a\u00020\u0013*\u00020\u0013H\u0002J\b\u0010\u001e\u001a\u00020\u0016H\u0002J0\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/indexing/shared/generator/IndexesExporterTask;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myState", "Lcom/intellij/indexing/shared/platform/api/IdeSharedIndexesState;", "myRequest", "Lcom/intellij/indexing/shared/generator/IndexesExporterRequest;", "myIndexExportStatistics", "Lcom/intellij/indexing/shared/generator/diagnostic/IndexExportStatistics;", "myErrorsCollector", "Lcom/intellij/indexing/shared/generator/ErrorsCollector;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/indexing/shared/platform/api/IdeSharedIndexesState;Lcom/intellij/indexing/shared/generator/IndexesExporterRequest;Lcom/intellij/indexing/shared/generator/diagnostic/IndexExportStatistics;Lcom/intellij/indexing/shared/generator/ErrorsCollector;)V", "exportIndexesChunk", "Lcom/intellij/indexing/shared/generator/IndexesExporterTaskResult;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "chunkRoot", "Ljava/nio/file/Path;", "tryExtractBaseIndex", "extract", "", "compression", "Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "target", "copyIjxRecursively", "", "ijxRoot", "unwrapIjx", "doesBaseIndexCompatible", "generateIndexes", "files", "Lcom/intellij/indexing/shared/generator/EnumeratedHashedIndexedFiles;", "fileContentLoader", "Lcom/intellij/indexing/shared/generator/IndexedFileContentLoader;", "additionalMetadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;", "Companion", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nIndexesExporterTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexesExporterTask.kt\ncom/intellij/indexing/shared/generator/IndexesExporterTask\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,206:1\n29#2,3:207\n*S KotlinDebug\n*F\n+ 1 IndexesExporterTask.kt\ncom/intellij/indexing/shared/generator/IndexesExporterTask\n*L\n49#1:207,3\n*E\n"})
public final class IndexesExporterTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeSharedIndexesState myState;
    @NotNull
    private final IndexesExporterRequest myRequest;
    @NotNull
    private final IndexExportStatistics myIndexExportStatistics;
    @NotNull
    private final ErrorsCollector myErrorsCollector;
    @NotNull
    private static final Logger LOG;

    public IndexesExporterTask(@NotNull Project myProject, @NotNull IdeSharedIndexesState myState, @NotNull IndexesExporterRequest myRequest, @NotNull IndexExportStatistics myIndexExportStatistics, @NotNull ErrorsCollector myErrorsCollector) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myState, (String)"myState");
        Intrinsics.checkNotNullParameter((Object)myRequest, (String)"myRequest");
        Intrinsics.checkNotNullParameter((Object)myIndexExportStatistics, (String)"myIndexExportStatistics");
        Intrinsics.checkNotNullParameter((Object)myErrorsCollector, (String)"myErrorsCollector");
        this.myProject = myProject;
        this.myState = myState;
        this.myRequest = myRequest;
        this.myIndexExportStatistics = myIndexExportStatistics;
        this.myErrorsCollector = myErrorsCollector;
    }

    @NotNull
    public final IndexesExporterTaskResult exportIndexesChunk(@NotNull ProgressIndicator indicator, @NotNull Path chunkRoot) throws Exception {
        boolean useBaseIndex;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)chunkRoot, (String)"chunkRoot");
        Set set = this.myState.getNoSizeLimitApplicableFileTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getNoSizeLimitApplicableFileTypes(...)");
        IndexedFileContentLoader fileContentLoader = new IndexedFileContentLoader(this.myProject, this.myErrorsCollector, set);
        IndexedFilesReporter reporter = null;
        Path targetForListDump = this.myRequest.getTargetIndexedFilesListDump();
        if (targetForListDump != null) {
            LOG.info("List of indexed files reports will be dumped to " + targetForListDump);
            reporter = new IndexedFilesReporter(targetForListDump);
        }
        if (useBaseIndex = this.doesBaseIndexCompatible()) {
            LOG.info("Copying base index to chunk root..");
            BaseIndex baseIndex = this.myRequest.getBase();
            Intrinsics.checkNotNull((Object)baseIndex);
            Path path = baseIndex.getPath();
            Intrinsics.checkNotNull((Object)path);
            Path baseIndexPath = path;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            PathKt.createDirectories((Path)chunkRoot);
            File file = this.unwrapIjx(this.tryExtractBaseIndex(baseIndexPath)).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            File file2 = chunkRoot.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            FilesKt.copyRecursively$default((File)file, (File)file2, (boolean)true, null, (int)4, null);
            long time = System.currentTimeMillis() - start$iv;
            LOG.info("Base index has been copied from " + baseIndexPath + " to chunk root " + chunkRoot + " in " + StringUtil.formatDuration((long)time));
        }
        Pair<HashedIndexedFiles, Integer> pair = new IndexedFilesCollector(this.myProject, this.myRequest, this.myErrorsCollector, reporter, useBaseIndex).collectFilesForIndexing(indicator, fileContentLoader);
        HashedIndexedFiles filesToBeIndexedSet = (HashedIndexedFiles)pair.component1();
        int allFileCount = ((Number)pair.component2()).intValue();
        EnumeratedHashedIndexedFiles hashEnumeration = new IndexesExporterHashEnumerateTask(this.myErrorsCollector, reporter).enumerateHashes(filesToBeIndexedSet, chunkRoot, indicator);
        SharedIndexMetadataInfo additionalMetadata = null;
        additionalMetadata = this.myRequest.getAdditionalMetadata();
        BaseIndex baseIndex = this.myRequest.getBase();
        if (baseIndex != null) {
            BaseIndex it = baseIndex;
            boolean bl = false;
            additionalMetadata = IndexesExporterKt.specifyLineup(this.myRequest.getAdditionalMetadata(), new SharedIndexLineup(it.getLineupName(), System.currentTimeMillis(), allFileCount));
        }
        this.myState.withActualHashGeneratorVersions(filesToBeIndexedSet.getUsedHashes());
        return this.generateIndexes(chunkRoot, hashEnumeration, fileContentLoader, additionalMetadata, indicator);
    }

    private final Path tryExtractBaseIndex(Path $this$tryExtractBaseIndex) {
        Path target = this.myRequest.getTempDir().resolve("base-index-uncompressed.ijx");
        SharedIndexCompression compression = this.myRequest.getCompression();
        Intrinsics.checkNotNull((Object)target);
        if (this.extract($this$tryExtractBaseIndex, compression, target)) {
            return target;
        }
        for (SharedIndexCompression fallbackCompression : SharedIndexCompression.values()) {
            if (fallbackCompression == compression || !this.extract($this$tryExtractBaseIndex, compression, target)) continue;
            return target;
        }
        throw new AssertionError((Object)("Failed to extract base index " + $this$tryExtractBaseIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean extract(Path $this$extract, SharedIndexCompression compression, Path target) {
        PathKt.delete((Path)target, (boolean)true);
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream($this$extract, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable = inputStream;
            int n = 8192;
            closeable = compression.createUnpackingStream((InputStream)(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n)));
            Throwable throwable = null;
            try {
                Closeable it = closeable;
                boolean bl = false;
                long l = Files.copy(it, target, new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return true;
        }
        catch (Exception e) {
            this.myErrorsCollector.genericError("Failed to unpack base index at " + $this$extract + " using " + compression, e);
            return false;
        }
    }

    private final void copyIjxRecursively(Path ijxRoot, Path target) {
        Files.walk(ijxRoot, new FileVisitOption[0]).skip(1L).filter(arg_0 -> IndexesExporterTask.copyIjxRecursively$lambda$1(IndexesExporterTask::copyIjxRecursively$lambda$0, arg_0)).forEach(arg_0 -> IndexesExporterTask.copyIjxRecursively$lambda$3(arg_0 -> IndexesExporterTask.copyIjxRecursively$lambda$2(target, arg_0), arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path unwrapIjx(Path $this$unwrapIjx) {
        Closeable closeable = (Closeable)UncompressedZipFileSystem.create((Path)$this$unwrapIjx);
        Throwable throwable = null;
        try {
            UncompressedZipFileSystem it = (UncompressedZipFileSystem)closeable;
            boolean bl = false;
            Path path = it.getRootDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getRootDirectory(...)");
            Path rootDirectory = path;
            Path target = this.myRequest.getTempDir().resolve("base-index-unwrapped");
            Intrinsics.checkNotNull((Object)target);
            PathKt.delete((Path)target, (boolean)true);
            this.copyIjxRecursively(rootDirectory, target);
            Path path2 = target;
            return path2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final boolean doesBaseIndexCompatible() {
        SharedIndexBase sharedIndexBase;
        BaseIndex baseIndex = this.myRequest.getBase();
        if (baseIndex == null) {
            return false;
        }
        BaseIndex baseIndex2 = baseIndex;
        Path path = baseIndex2.getPath();
        if (path == null) {
            return false;
        }
        Path baseIndexPath = path;
        SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = SharedIndexInfrastructureVersion.getIdeVersion();
        Intrinsics.checkNotNullExpressionValue((Object)sharedIndexInfrastructureVersion, (String)"getIdeVersion(...)");
        SharedIndexInfrastructureVersion ideVersion = sharedIndexInfrastructureVersion;
        try {
            sharedIndexBase = IndexesExporterBasesLoaderKt.loadSharedIndexAsBase(baseIndexPath, ideVersion, this.myRequest.getTempDir());
        }
        catch (Throwable t) {
            LOG.warn("Failed to load base shared index: " + baseIndexPath + ". " + t.getMessage(), t);
            return false;
        }
        SharedIndexBase baseSharedIndex = sharedIndexBase;
        SharedIndexInfrastructureVersion indexMetadata = baseSharedIndex.getMetadata().getIndexInfrastructureVersion();
        if (!Intrinsics.areEqual((Object)indexMetadata.getBaseIndexes(), (Object)ideVersion.getBaseIndexes())) {
            return false;
        }
        if (!ideVersion.getFileBasedIndexVersions().entrySet().containsAll(indexMetadata.getFileBasedIndexVersions().entrySet())) {
            LOG.warn("Incompatible base metadata from " + baseIndexPath + ": File based index versions differs");
            return false;
        }
        if (!ideVersion.getStubIndexVersions().entrySet().containsAll(indexMetadata.getStubIndexVersions().entrySet())) {
            LOG.warn("Incompatible base metadata from " + baseIndexPath + ": Stub index versions differs");
            return false;
        }
        if (!ideVersion.getStubFileElementTypeVersions().entrySet().containsAll(indexMetadata.getStubFileElementTypeVersions().entrySet())) {
            LOG.warn("Incompatible base metadata from " + baseIndexPath + ": Stub element versions differs");
            return false;
        }
        Set set = ideVersion.getCompositeBinaryStubFileBuilderVersions().entrySet();
        Set set2 = indexMetadata.getCompositeBinaryStubFileBuilderVersions().entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
        if (!set.containsAll(set2)) {
            LOG.warn("Incompatible base metadata from " + baseIndexPath + ": composite binary stub file builder versions differ");
            return false;
        }
        LOG.info("Base shared index to be used: " + baseSharedIndex);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IndexesExporterTaskResult generateIndexes(Path chunkRoot, EnumeratedHashedIndexedFiles files, IndexedFileContentLoader fileContentLoader, SharedIndexMetadataInfo additionalMetadata, ProgressIndicator indicator) throws Exception {
        boolean isSharedIndexEmpty;
        IndexesExporterGenerators generators = new IndexesExporterGenerators(chunkRoot, this.myState, this.myRequest, this.myIndexExportStatistics);
        AutoCloseable autoCloseable = generators.openAndClose(indicator);
        Throwable throwable = null;
        try {
            AutoCloseable ignored = autoCloseable;
            boolean bl = false;
            new IndexesExporterMainIndex(this.myProject, this.myErrorsCollector, fileContentLoader, this.myRequest).generateMainIndex(generators, files, indicator);
            new IndexesExporterEP(this.myProject, this.myRequest, this.myErrorsCollector, chunkRoot, this.myState).executeExtensionPoints(files, indicator);
            ignored = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        indicator.setIndeterminate(true);
        indicator.setText(SharedIndexesBundle.message((String)"progress.text.finalizing.indexes", (Object[])new Object[0]));
        IndexChunk chunk = this.myRequest.getChunk();
        SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = this.myState.getIndexVersion();
        Intrinsics.checkNotNullExpressionValue((Object)sharedIndexInfrastructureVersion, (String)"getIndexVersion(...)");
        SharedIndexInfrastructureVersion indexVersion = sharedIndexInfrastructureVersion;
        SharedIndexInfrastructureVersion testIndexVersionModifier = this.myRequest.getTestOnlyIndexVersionModifier();
        if (testIndexVersionModifier != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            throw new AssertionError((Object)"Index version can be modified only for testing purposes");
        }
        SharedIndexGenerationStatistics generationStatistics = this.myIndexExportStatistics.toGenerationStatistics();
        String string = chunk.getName();
        String string2 = chunk.getKind();
        SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion2 = testIndexVersionModifier;
        if (sharedIndexInfrastructureVersion2 == null || (sharedIndexInfrastructureVersion2 = (SharedIndexInfrastructureVersion)sharedIndexInfrastructureVersion2.apply(indexVersion)) == null) {
            sharedIndexInfrastructureVersion2 = indexVersion;
        }
        SharedIndexMetadata sharedIndexMetadata = new SharedIndexMetadata(string, string2, sharedIndexInfrastructureVersion2, additionalMetadata, generationStatistics, null, null, 96, null);
        SharedIndexMetadata.Companion.writeAsJson(sharedIndexMetadata, SharedIndexMetadata.Companion.getMetadataPath(chunkRoot), true);
        boolean bl = isSharedIndexEmpty = ContainerUtil.find((Iterable)this.myIndexExportStatistics.getFileTypeToNumberOfIndexedFiles().values(), arg_0 -> IndexesExporterTask.generateIndexes$lambda$2(IndexesExporterTask::generateIndexes$lambda$1, arg_0)) == null;
        if (isSharedIndexEmpty) {
            throw new RuntimeException("Generated shared index is empty and must not be used!");
        }
        return new IndexesExporterTaskResult(sharedIndexMetadata, indexVersion);
    }

    private static final boolean copyIjxRecursively$lambda$0(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return !Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean copyIjxRecursively$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit copyIjxRecursively$lambda$2(Path $target, Path it) {
        Path currentTarget = $target.resolve(((Object)it).toString());
        Path path = currentTarget.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        PathKt.createDirectories((Path)path);
        Files.copy(it, currentTarget, new CopyOption[0]);
        return Unit.INSTANCE;
    }

    private static final void copyIjxRecursively$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean generateIndexes$lambda$1(Integer count) {
        Integer n = count;
        return n == null || n != 0;
    }

    private static final boolean generateIndexes$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(IndexesExporterTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/indexing/shared/generator/IndexesExporterTask$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.indexing.shared.generator"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

