/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.generator.BaseIndex;
import com.intellij.indexing.shared.generator.IndexChunk;
import com.intellij.indexing.shared.generator.IndexesExporterRequest;
import com.intellij.indexing.shared.generator.MainArgs;
import com.intellij.indexing.shared.metadata.SharedIndexMetadataInfo;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureOs;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashProviders;
import com.intellij.platform.util.ArgsParser;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010E\u001a\u00020\u0018J\u0016\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KR\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u0010\u0010\tR\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000b\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000b\u001a\u0004\b\u001d\u0010\u001eR!\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u000b\u001a\u0004\b#\u0010$R!\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u000b\u001a\u0004\b'\u0010$R'\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0!8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b-\u0010\u000b\u0012\u0004\b*\u0010+\u001a\u0004\b,\u0010$R!\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0/8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u000b\u001a\u0004\b0\u00101R\u001b\u00103\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u000b\u001a\u0004\b4\u0010\u001eR\u001d\u00106\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010\u000b\u001a\u0004\b7\u0010\tR\u001d\u00109\u001a\u0004\u0018\u00010\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010\u000b\u001a\u0004\b:\u0010;R\u001b\u0010=\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010\u000b\u001a\u0004\b>\u0010\u001eR\u001b\u0010@\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010\u000b\u001a\u0004\bA\u0010\u001eR\u0014\u0010C\u001a\u00020\u00188TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u001a\u00a8\u0006L"}, d2={"Lcom/intellij/indexing/shared/generator/MainGenerateArgs;", "Lcom/intellij/indexing/shared/generator/MainArgs;", "parser", "Lcom/intellij/platform/util/ArgsParser;", "<init>", "(Lcom/intellij/platform/util/ArgsParser;)V", "outputDir", "Ljava/nio/file/Path;", "getOutputDir", "()Ljava/nio/file/Path;", "outputDir$delegate", "Lcom/intellij/platform/util/ArgsParser$TypedArg;", "tempDir", "getTempDir", "tempDir$delegate", "dumpProjectRoots", "getDumpProjectRoots", "dumpProjectRoots$delegate", "useXzCompression", "", "getUseXzCompression", "()Ljava/lang/Boolean;", "useXzCompression$delegate", "compression", "Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "getCompression", "()Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "compression$delegate", "excludeFilesWithHashCollision", "getExcludeFilesWithHashCollision", "()Z", "excludeFilesWithHashCollision$delegate", "additionalIndexes", "", "", "getAdditionalIndexes", "()Ljava/util/List;", "additionalIndexes$delegate", "noStubTreeFileTypes", "getNoStubTreeFileTypes", "noStubTreeFileTypes$delegate", "additionalSupportedOs", "getAdditionalSupportedOs$annotations", "()V", "getAdditionalSupportedOs", "additionalSupportedOs$delegate", "additionalHashProviders", "Ljava/util/SortedSet;", "getAdditionalHashProviders", "()Ljava/util/SortedSet;", "additionalHashProviders$delegate", "filterOutDuplicatesBeforeIndexing", "getFilterOutDuplicatesBeforeIndexing", "filterOutDuplicatesBeforeIndexing$delegate", "baseIndexPath", "getBaseIndexPath", "baseIndexPath$delegate", "lineupName", "getLineupName", "()Ljava/lang/String;", "lineupName$delegate", "addHashToOutputNames", "getAddHashToOutputNames", "addHashToOutputNames$delegate", "generateReproducibleMaps", "getGenerateReproducibleMaps", "generateReproducibleMaps$delegate", "defaultCompression", "getDefaultCompression", "resolveCompressionMethod", "createIndexesExporterRequest", "Lcom/intellij/indexing/shared/generator/IndexesExporterRequest;", "chunk", "Lcom/intellij/indexing/shared/generator/IndexChunk;", "addon", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nDumpSharedIndexStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpSharedIndexStarter.kt\ncom/intellij/indexing/shared/generator/MainGenerateArgs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n1586#2:353\n1661#2,3:354\n1#3:357\n*S KotlinDebug\n*F\n+ 1 DumpSharedIndexStarter.kt\ncom/intellij/indexing/shared/generator/MainGenerateArgs\n*L\n93#1:353\n93#1:354,3\n*E\n"})
public class MainGenerateArgs
extends MainArgs {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ArgsParser.TypedArg outputDir$delegate;
    @NotNull
    private final ArgsParser.TypedArg tempDir$delegate;
    @NotNull
    private final ArgsParser.TypedArg dumpProjectRoots$delegate;
    @NotNull
    private final ArgsParser.TypedArg useXzCompression$delegate;
    @NotNull
    private final ArgsParser.TypedArg compression$delegate;
    @NotNull
    private final ArgsParser.TypedArg excludeFilesWithHashCollision$delegate;
    @NotNull
    private final ArgsParser.TypedArg additionalIndexes$delegate;
    @NotNull
    private final ArgsParser.TypedArg noStubTreeFileTypes$delegate;
    @NotNull
    private final ArgsParser.TypedArg additionalSupportedOs$delegate;
    @NotNull
    private final ArgsParser.TypedArg additionalHashProviders$delegate;
    @NotNull
    private final ArgsParser.TypedArg filterOutDuplicatesBeforeIndexing$delegate;
    @NotNull
    private final ArgsParser.TypedArg baseIndexPath$delegate;
    @NotNull
    private final ArgsParser.TypedArg lineupName$delegate;
    @NotNull
    private final ArgsParser.TypedArg addHashToOutputNames$delegate;
    @NotNull
    private final ArgsParser.TypedArg generateReproducibleMaps$delegate;

    /*
     * WARNING - void declaration
     */
    public MainGenerateArgs(@NotNull ArgsParser parser) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        super(parser);
        this.outputDir$delegate = ArgsParser.ArgInfo.file$default((ArgsParser.ArgInfo)parser.arg("output", "location of the indexes output directory\nit will be updated with generated new indexes"), null, (int)1, null).andApply(MainGenerateArgs::outputDir_delegate$lambda$0);
        this.tempDir$delegate = parser.arg("temp", "optional temp directory to use during indexes generation").hidden().file(MainGenerateArgs::tempDir_delegate$lambda$0).andApply(MainGenerateArgs::tempDir_delegate$lambda$1);
        this.dumpProjectRoots$delegate = parser.arg("dump-project-roots", "Dumps project roots to the given file").hidden().fileOrNull();
        this.useXzCompression$delegate = parser.arg("use-xz-compression", "Shared index can be additionally compressed with xz").optional().deprecated("Please use 'compression=xz' or 'compression=plain instead").booleanOrNull();
        this.compression$delegate = parser.arg("compression", "Compress shared index using: " + CollectionsKt.joinToString$default((Iterable)((Iterable)SharedIndexCompression.getEntries()), (CharSequence)", ", null, null, (int)0, null, MainGenerateArgs::compression_delegate$lambda$0, (int)30, null)).optional().stringOrNull().andMap(MainGenerateArgs::compression_delegate$lambda$1);
        this.excludeFilesWithHashCollision$delegate = parser.arg("filter-out-collisions", "Shared index will not contain files with hash collision").hidden().optional().boolean(MainGenerateArgs::excludeFilesWithHashCollision_delegate$lambda$0);
        this.additionalIndexes$delegate = parser.arg("additional-indexes", "Additional indexes to generate").hidden().optional().strings();
        this.noStubTreeFileTypes$delegate = parser.arg("no-stub-tree-file-types", "File types for which stub trees will not be shared").hidden().optional().strings();
        Set set = IndexInfrastructureOs.textValues();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"textValues(...)");
        this.additionalSupportedOs$delegate = parser.arg("additional-os", "Claim to support " + CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " in addition to the host OS").hidden().optional().deprecated("Shared Indexes are OS-independent starting from 2020.3. There is no need to specify additional supported OS-es. This option will be ignored. See https://youtrack.jetbrains.com/issue/IDEA-248440").strings();
        Iterable iterable = SharedIndexHashProviders.getNonDefaultSharedIndexHashingProviders();
        String string = "additional-hash";
        ArgsParser argsParser = parser;
        MainGenerateArgs mainGenerateArgs = this;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SharedIndexContentHash sharedIndexContentHash = (SharedIndexContentHash)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProviderId());
        }
        collection = (List)destination$iv$iv;
        mainGenerateArgs.additionalHashProviders$delegate = argsParser.arg(string, "Include additional hash providers to the hash: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSortedSet((Iterable)collection), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).hidden().optional().strings().andMap(MainGenerateArgs::additionalHashProviders_delegate$lambda$1);
        this.filterOutDuplicatesBeforeIndexing$delegate = parser.arg("filter-out-duplicates", "Chooses only distinct (in terms of file's hash) files to indexing. Please do not use this option until you sure index implementations are file-based.").hidden().optional().boolean(MainGenerateArgs::filterOutDuplicatesBeforeIndexing_delegate$lambda$0);
        this.baseIndexPath$delegate = parser.arg("base-shared-index", "Specifies another shared index as base index for the command.\nThe implementation may use the supplied shared index as base").hidden().fileOrNull();
        this.lineupName$delegate = parser.arg("line-up", "Specifies project shared index line-up").hidden().stringOrNull();
        this.addHashToOutputNames$delegate = parser.arg("add-hash-to-output-names", "Adds a hash suffix for output files").hidden().optional().boolean(MainGenerateArgs::addHashToOutputNames_delegate$lambda$0);
        this.generateReproducibleMaps$delegate = parser.arg("generate-binary-reproducible-maps", "Make persistent maps binary reproducible").hidden().optional().boolean(MainGenerateArgs::generateReproducibleMaps_delegate$lambda$0);
    }

    @NotNull
    public final Path getOutputDir() {
        return (Path)this.outputDir$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final Path getTempDir() {
        return (Path)this.tempDir$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final Path getDumpProjectRoots() {
        return (Path)this.dumpProjectRoots$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final Boolean getUseXzCompression() {
        return (Boolean)this.useXzCompression$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final SharedIndexCompression getCompression() {
        return (SharedIndexCompression)this.compression$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    private final boolean getExcludeFilesWithHashCollision() {
        return (Boolean)this.excludeFilesWithHashCollision$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    private final List<String> getAdditionalIndexes() {
        return (List)this.additionalIndexes$delegate.getValue((Object)this, $$delegatedProperties[6]);
    }

    private final List<String> getNoStubTreeFileTypes() {
        return (List)this.noStubTreeFileTypes$delegate.getValue((Object)this, $$delegatedProperties[7]);
    }

    private final List<String> getAdditionalSupportedOs() {
        return (List)this.additionalSupportedOs$delegate.getValue((Object)this, $$delegatedProperties[8]);
    }

    @Deprecated(message="Remove this option when cross-platform shared indexes are battle-tested: IDEA-248440")
    private static /* synthetic */ void getAdditionalSupportedOs$annotations() {
    }

    private final SortedSet<String> getAdditionalHashProviders() {
        return (SortedSet)this.additionalHashProviders$delegate.getValue((Object)this, $$delegatedProperties[9]);
    }

    private final boolean getFilterOutDuplicatesBeforeIndexing() {
        return (Boolean)this.filterOutDuplicatesBeforeIndexing$delegate.getValue((Object)this, $$delegatedProperties[10]);
    }

    private final Path getBaseIndexPath() {
        return (Path)this.baseIndexPath$delegate.getValue((Object)this, $$delegatedProperties[11]);
    }

    private final String getLineupName() {
        return (String)this.lineupName$delegate.getValue((Object)this, $$delegatedProperties[12]);
    }

    public final boolean getAddHashToOutputNames() {
        return (Boolean)this.addHashToOutputNames$delegate.getValue((Object)this, $$delegatedProperties[13]);
    }

    private final boolean getGenerateReproducibleMaps() {
        return (Boolean)this.generateReproducibleMaps$delegate.getValue((Object)this, $$delegatedProperties[14]);
    }

    @NotNull
    protected SharedIndexCompression getDefaultCompression() {
        return SharedIndexCompression.XZ;
    }

    @NotNull
    public final SharedIndexCompression resolveCompressionMethod() {
        SharedIndexCompression sharedIndexCompression;
        SharedIndexCompression compression;
        SharedIndexCompression sharedIndexCompression2 = compression = this.getCompression();
        if (sharedIndexCompression2 != null) {
            return sharedIndexCompression2;
        }
        Boolean bl = this.getUseXzCompression();
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            sharedIndexCompression = SharedIndexCompression.XZ;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            sharedIndexCompression = SharedIndexCompression.PLAIN;
        } else if (bl == null) {
            sharedIndexCompression = this.getDefaultCompression();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sharedIndexCompression;
    }

    @NotNull
    public final IndexesExporterRequest createIndexesExporterRequest(@NotNull IndexChunk chunk, @NotNull SharedIndexMetadataInfo addon) {
        BaseIndex baseIndex;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        SharedIndexCompression sharedIndexCompression = this.resolveCompressionMethod();
        boolean bl = this.getExcludeFilesWithHashCollision();
        boolean bl2 = this.getFilterOutDuplicatesBeforeIndexing();
        Path path = this.getOutputDir();
        Path path2 = this.getTempDir();
        Path path3 = this.getDumpProjectRoots();
        List<String> list = this.getAdditionalIndexes();
        List<String> list2 = this.getNoStubTreeFileTypes();
        String string = this.getLineupName();
        if (string != null) {
            String it = string;
            boolean bl3 = false;
            baseIndex = new BaseIndex(this.getBaseIndexPath(), it);
        } else {
            baseIndex = null;
        }
        BaseIndex baseIndex2 = baseIndex;
        SortedSet<String> sortedSet = this.getAdditionalHashProviders();
        boolean bl4 = this.getAddHashToOutputNames();
        boolean bl5 = this.getGenerateReproducibleMaps();
        return new IndexesExporterRequest(chunk, sharedIndexCompression, path, null, bl, bl2, list, list2, path3, addon, path2, null, baseIndex2, sortedSet, bl4, bl5, 2056, null);
    }

    private static final Unit outputDir_delegate$lambda$0(Path $this$andApply) {
        Intrinsics.checkNotNullParameter((Object)$this$andApply, (String)"$this$andApply");
        Files.createDirectories($this$andApply, new FileAttribute[0]);
        return Unit.INSTANCE;
    }

    private static final Path tempDir_delegate$lambda$0() {
        Path path = Files.createTempDirectory("index-generation", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        return path;
    }

    private static final Unit tempDir_delegate$lambda$1(Path $this$andApply) {
        Intrinsics.checkNotNullParameter((Object)$this$andApply, (String)"$this$andApply");
        Files.createDirectories($this$andApply, new FileAttribute[0]);
        return Unit.INSTANCE;
    }

    private static final CharSequence compression_delegate$lambda$0(SharedIndexCompression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType();
    }

    private static final SharedIndexCompression compression_delegate$lambda$1(String it) {
        SharedIndexCompression sharedIndexCompression;
        if (it != null) {
            sharedIndexCompression = SharedIndexCompression.Companion.findByType(it);
            if (sharedIndexCompression == null) {
                throw new IllegalStateException(("Compression type " + it + " is not found").toString());
            }
        } else {
            sharedIndexCompression = null;
        }
        return sharedIndexCompression;
    }

    private static final boolean excludeFilesWithHashCollision_delegate$lambda$0() {
        return false;
    }

    private static final SortedSet additionalHashProviders_delegate$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.toSortedSet((Iterable)it);
    }

    private static final boolean filterOutDuplicatesBeforeIndexing_delegate$lambda$0() {
        return false;
    }

    private static final boolean addHashToOutputNames_delegate$lambda$0() {
        return true;
    }

    private static final boolean generateReproducibleMaps_delegate$lambda$0() {
        return false;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "outputDir", "getOutputDir()Ljava/nio/file/Path;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "tempDir", "getTempDir()Ljava/nio/file/Path;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "dumpProjectRoots", "getDumpProjectRoots()Ljava/nio/file/Path;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "useXzCompression", "getUseXzCompression()Ljava/lang/Boolean;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "compression", "getCompression()Lcom/intellij/indexing/shared/download/SharedIndexCompression;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "excludeFilesWithHashCollision", "getExcludeFilesWithHashCollision()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "additionalIndexes", "getAdditionalIndexes()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "noStubTreeFileTypes", "getNoStubTreeFileTypes()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "additionalSupportedOs", "getAdditionalSupportedOs()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "additionalHashProviders", "getAdditionalHashProviders()Ljava/util/SortedSet;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "filterOutDuplicatesBeforeIndexing", "getFilterOutDuplicatesBeforeIndexing()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "baseIndexPath", "getBaseIndexPath()Ljava/nio/file/Path;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "lineupName", "getLineupName()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "addHashToOutputNames", "getAddHashToOutputNames()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "generateReproducibleMaps", "getGenerateReproducibleMaps()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

