/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon;

import com.intellij.codeInsight.daemon.impl.EditorTrackerImpl;
import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EDT;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.daemon.RdServerEditorTrackerKt;
import com.jetbrains.rdserver.editors.BackendEditorHostListener;
import com.jetbrains.rdserver.editors.DocumentUtilKt;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010\t\u001a#\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\b0\b0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rdserver/daemon/RdServerEditorTracker;", "Lcom/intellij/codeInsight/daemon/impl/EditorTrackerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "currentEditors", "", "Lcom/intellij/openapi/editor/Editor;", "remoteTracedEditors", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/codeWithMe/ClientId;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "createEditorImpl", "", "editor", "update", "editorReleasedImpl", "value", "activeEditors", "getActiveEditors", "()Ljava/util/List;", "setActiveEditors", "(Ljava/util/List;)V", "collectActiveRemoteEditors", "isActive", "", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nRdServerEditorTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdServerEditorTracker.kt\ncom/jetbrains/rdserver/daemon/RdServerEditorTracker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n60#2,5:113\n60#2,5:118\n60#2,5:125\n60#2,5:130\n60#2,5:135\n873#3,2:123\n777#3:140\n873#3,2:141\n*S KotlinDebug\n*F\n+ 1 RdServerEditorTracker.kt\ncom/jetbrains/rdserver/daemon/RdServerEditorTracker\n*L\n52#1:113,5\n57#1:118,5\n70#1:125,5\n75#1:130,5\n88#1:135,5\n65#1:123,2\n100#1:140\n100#1:141,2\n*E\n"})
public final class RdServerEditorTracker
extends EditorTrackerImpl {
    @NotNull
    private List<? extends Editor> currentEditors;
    @NotNull
    private final MultiMap<ClientId, Editor> remoteTracedEditors;

    public RdServerEditorTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.currentEditors = CollectionsKt.emptyList();
        MultiMap multiMap = MultiMap.createLinkedSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createLinkedSet(...)");
        this.remoteTracedEditors = multiMap;
        MessageBusConnection connection = ApplicationKt.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(BackendEditorHostListener.Companion.getTOPIC(), (Object)new BackendEditorHostListener(){

            @Override
            public void editorBound(Lifetime lifetime, ClientAppSession appSession, ClientProjectSession projectSession, TextControlId textControlId, TextControlModel editorModel, Editor editor) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
                Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
                Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                editorModel.getVisibleChangedFromFrontend().advise(lifetime, arg_0 -> 1.editorBound$lambda$0(this, arg_0));
            }

            private static final Unit editorBound$lambda$0(RdServerEditorTracker this$0, boolean it) {
                this$0.update();
                return Unit.INSTANCE;
            }
        });
    }

    protected void createEditorImpl(@NotNull Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            Logger $this$debug_u24default$iv = RdServerEditorTrackerKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Add local editor. " + editor, t$iv);
            }
            super.createEditorImpl(editor, project);
            return;
        }
        Logger $this$debug_u24default$iv = RdServerEditorTrackerKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Add remote editor. " + editor, t$iv);
        }
        this.remoteTracedEditors.putValue((Object)ClientId.Companion.getCurrent(), (Object)editor);
        this.update();
    }

    /*
     * WARNING - void declaration
     */
    private final void update() {
        void $this$filterTo$iv;
        Iterable iterable = this.currentEditors;
        Collection collection = new ArrayList();
        RdServerEditorTracker rdServerEditorTracker = this;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            void destination$iv;
            Editor it = (Editor)element$iv;
            boolean bl = false;
            if (!ClientId.Companion.isLocal(DocumentUtilKt.clientId(it))) continue;
            destination$iv.add(element$iv);
        }
        rdServerEditorTracker.setActiveEditors((List)collection);
    }

    protected void editorReleasedImpl(@NotNull Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            Logger $this$debug_u24default$iv = RdServerEditorTrackerKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Release remote editor. " + editor, t$iv);
            }
            super.editorReleasedImpl(editor, project);
            return;
        }
        Logger $this$debug_u24default$iv = RdServerEditorTrackerKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Release remote editor. " + editor, t$iv);
        }
        this.remoteTracedEditors.remove((Object)ClientId.Companion.getCurrent(), (Object)editor);
    }

    @NotNull
    public List<Editor> getActiveEditors() {
        EDT.assertIsEdt();
        return CollectionsKt.toMutableList((Collection)this.currentEditors);
    }

    public void setActiveEditors(@NotNull List<? extends Editor> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        EDT.assertIsEdt();
        List allEditors = CollectionsKt.plus((Collection)value, (Iterable)this.collectActiveRemoteEditors());
        Logger $this$debug_u24default$iv = RdServerEditorTrackerKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("All active Editors. [" + CollectionsKt.joinToString$default((Iterable)allEditors, (CharSequence)" ,", null, null, (int)0, null, RdServerEditorTracker::_set_activeEditors_$lambda$0$0, (int)30, null) + "]", t$iv);
        }
        if (!Intrinsics.areEqual((Object)allEditors, this.currentEditors)) {
            this.currentEditors = allEditors;
            ((EditorTrackerListener)this.project.getMessageBus().syncPublisher(EditorTrackerListener.TOPIC)).activeEditorsChanged(this.currentEditors);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Editor> collectActiveRemoteEditors() {
        List remoteEditors = new ArrayList();
        for (Map.Entry entry : this.remoteTracedEditors.entrySet()) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNull((Object)entry);
            Collection editors = (Collection)entry.getValue();
            if (!this.isActive()) continue;
            Intrinsics.checkNotNull((Object)editors);
            Iterable $this$filter$iv = editors;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Editor it = (Editor)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.isActive(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List activeRemoteEditors = (List)destination$iv$iv;
            remoteEditors.addAll(activeRemoteEditors);
        }
        return remoteEditors;
    }

    private final boolean isActive(Editor editor) {
        return ComponentUtil.isShowing((Component)editor.getContentComponent(), (boolean)true);
    }

    private final boolean isActive() {
        return true;
    }

    private static final CharSequence _set_activeEditors_$lambda$0$0(Editor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }
}

