/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.jetbrains.codeWithMe.model.BreakpointPresentationUpdatedArgs;
import com.jetbrains.codeWithMe.model.BreakpointTypeModelBase;
import com.jetbrains.codeWithMe.model.BreakpointsModel;
import com.jetbrains.codeWithMe.model.BreakpointsModel_GeneratedKt;
import com.jetbrains.codeWithMe.model.CanPutAtArgs;
import com.jetbrains.codeWithMe.model.CustomBreakpointTypeModel;
import com.jetbrains.codeWithMe.model.DebuggerSessionModel;
import com.jetbrains.codeWithMe.model.LineBreakpointTypeModel;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.codeWithMe.debugger.CommonBreakpointHost;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.debugger.BackendDebuggerHost;
import com.jetbrains.rdserver.vfs.BackendVirtualFileSystemHostKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u0014\u0010\u0014\u001a\u00020\u000b2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rdserver/debugger/BackendBreakpointHost;", "Lcom/jetbrains/rd/platform/codeWithMe/debugger/CommonBreakpointHost;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "model", "Lcom/jetbrains/codeWithMe/model/BreakpointsModel;", "getModel", "()Lcom/jetbrains/codeWithMe/model/BreakpointsModel;", "bindWithModel", "", "listenBreakpointPresentationUpdates", "syncBreakpointTypes", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileId", "Lcom/jetbrains/rd/ide/model/RdFileId;", "findFileId", "file", "beforeBreakpointAdd", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "doIgnoreBreakpoint", "", "syncExistingBreakpointsToModel", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendBreakpointHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendBreakpointHost.kt\ncom/jetbrains/rdserver/debugger/BackendBreakpointHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,152:1\n1915#2,2:153\n812#2,12:157\n777#2:169\n873#2,2:170\n1586#2:172\n1661#2,3:173\n14060#3,2:155\n13#4:176\n13#5:177\n*S KotlinDebug\n*F\n+ 1 BackendBreakpointHost.kt\ncom/jetbrains/rdserver/debugger/BackendBreakpointHost\n*L\n110#1:153,2\n53#1:157,12\n54#1:169\n54#1:170,2\n55#1:172\n55#1:173,3\n144#1:155,2\n148#1:176\n148#1:177\n*E\n"})
public final class BackendBreakpointHost
extends CommonBreakpointHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private static final Logger logger;

    public BackendBreakpointHost(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session.getProject());
        this.session = session;
        RdCoroutinesUtilKt.launchOnUi$default((Lifetime)this.getServiceLifetime(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BackendBreakpointHost this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.bindWithModel();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    protected BreakpointsModel getModel() {
        return BreakpointsModel_GeneratedKt.getBreakpointsModel((Solution)RemoteSessionKt.getProtocolModel(this.session));
    }

    protected void bindWithModel() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.session.isController()) {
            return;
        }
        super.bindWithModel();
        this.syncBreakpointTypes();
        this.syncExistingBreakpointsToModel();
        this.listenBreakpointPresentationUpdates();
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.getModel().getGetCanPutAtTypes()), null, null, arg_0 -> BackendBreakpointHost.bindWithModel$lambda$0(this, arg_0), (int)3, null);
    }

    private final void listenBreakpointPresentationUpdates() {
        MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
        Topic topic = XBreakpointListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new XBreakpointListener<XBreakpoint<?>>(this){
            final /* synthetic */ BackendBreakpointHost this$0;
            {
                this.this$0 = $receiver;
            }

            public void breakpointPresentationUpdated(XBreakpoint<?> breakpoint, XDebugSession session) {
                Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
                if (session == null) {
                    return;
                }
                String string = (String)BackendBreakpointHost.access$getBreakpointMap(this.this$0).get(breakpoint);
                if (string == null) {
                    return;
                }
                String breakpointId = string;
                BackendDebuggerHost debuggerHost = BackendDebuggerHost.Companion.getInstance(BackendBreakpointHost.access$getSession$p(this.this$0));
                BackendDebuggerHost.Companion.DebugProcessInfo debugProcessInfo = (BackendDebuggerHost.Companion.DebugProcessInfo)debuggerHost.getProcessMap().get((Object)session.getDebugProcess());
                if (debugProcessInfo == null) {
                    return;
                }
                DebuggerSessionModel sessionModel = debugProcessInfo.component1();
                XBreakpointBase xBreakpointBase = breakpoint instanceof XBreakpointBase ? (XBreakpointBase)breakpoint : null;
                Icon icon2 = xBreakpointBase != null ? xBreakpointBase.getIcon() : null;
                XBreakpointBase xBreakpointBase2 = breakpoint instanceof XBreakpointBase ? (XBreakpointBase)breakpoint : null;
                String errorMessage = xBreakpointBase2 != null ? xBreakpointBase2.getErrorMessage() : null;
                Icon icon3 = icon2;
                sessionModel.getBreakpointPresentationUpdated().fire((Object)new BreakpointPresentationUpdatedArgs(breakpointId, (IconModel)(icon3 != null ? UtilKt.toModel((Icon)icon3) : null), errorMessage));
            }
        });
    }

    private final void syncBreakpointTypes() {
        Iterable $this$forEach$iv = XBreakpointType.EXTENSION_POINT_NAME.getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XBreakpointType it = (XBreakpointType)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            BackendBreakpointHost.syncBreakpointTypes$addBreakpointTypeToModel(this, it);
        }
        XBreakpointType.EXTENSION_POINT_NAME.addExtensionPointListener(new ExtensionPointListener<XBreakpointType<?, ?>>(this){
            final /* synthetic */ BackendBreakpointHost this$0;
            {
                this.this$0 = $receiver;
            }

            public void extensionAdded(XBreakpointType<?, ?> extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                BackendBreakpointHost.access$syncBreakpointTypes$addBreakpointTypeToModel(this.this$0, extension);
            }

            public void extensionRemoved(XBreakpointType<?, ?> extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                BackendBreakpointHost.access$syncBreakpointTypes$removeBreakpointTypeFromModel(this.this$0, extension);
            }
        }, (Disposable)this);
    }

    @Nullable
    public VirtualFile findFile(@NotNull RdFileId fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        return BackendVirtualFileSystemHostKt.fromModel(fileId, this.session.getAppSession());
    }

    @Nullable
    public RdFileId findFileId(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return BackendVirtualFileSystemHostKt.bind(file2, this.session.getAppSession(), false);
    }

    public void beforeBreakpointAdd(@NotNull XBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
    }

    public boolean doIgnoreBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        return false;
    }

    private final void syncExistingBreakpointsToModel() {
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)this.getProject()).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"getBreakpointManager(...)");
        XBreakpointManager breakpointManager = xBreakpointManager;
        XBreakpoint[] xBreakpointArray = breakpointManager.getAllBreakpoints();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointArray, (String)"getAllBreakpoints(...)");
        Object[] $this$forEach$iv = xBreakpointArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XBreakpoint p0 = (XBreakpoint)element$iv;
            boolean bl = false;
            this.addBreakpointToModel(p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List bindWithModel$lambda$0(BackendBreakpointHost this$0, CanPutAtArgs args) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        XLineBreakpointType it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        VirtualFile virtualFile = this$0.findFile(args.getFileId());
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile file2 = virtualFile;
        ExtensionPoint point = XBreakpointType.EXTENSION_POINT_NAME.getPoint();
        List list = point.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExtensionList(...)");
        Iterable iterable = list;
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof XLineBreakpointType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (XLineBreakpointType)element$iv$iv;
            boolean bl = false;
            if (!it.canPutAt(file2, args.getLine(), this$0.getProject())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (XLineBreakpointType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    private static final void syncBreakpointTypes$addBreakpointTypeToModel(BackendBreakpointHost this$0, XBreakpointType<?, ?> type) {
        try {
            BreakpointTypeModelBase breakpointTypeModelBase;
            Icon icon2 = type.getEnabledIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getEnabledIcon(...)");
            IconModel enabledIcon = UtilKt.toModel((Icon)icon2);
            Icon icon3 = type.getDisabledIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getDisabledIcon(...)");
            IconModel disabledIcon = UtilKt.toModel((Icon)icon3);
            Icon icon4 = type.getSuspendNoneIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"getSuspendNoneIcon(...)");
            IconModel suspendNoneIcon = UtilKt.toModel((Icon)icon4);
            Icon icon5 = type.getMutedEnabledIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"getMutedEnabledIcon(...)");
            IconModel mutedEnabledIcon = UtilKt.toModel((Icon)icon5);
            Icon icon6 = type.getMutedDisabledIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"getMutedDisabledIcon(...)");
            IconModel mutedDisabledIcon = UtilKt.toModel((Icon)icon6);
            Icon icon7 = type.getPendingIcon();
            IconModel pendingIcon = icon7 != null ? UtilKt.toModel((Icon)icon7) : null;
            Icon icon8 = type.getInactiveDependentIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"getInactiveDependentIcon(...)");
            IconModel inactiveDependentIcon = UtilKt.toModel((Icon)icon8);
            if (type instanceof XLineBreakpointType) {
                Icon icon9 = ((XLineBreakpointType)type).getTemporaryIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"getTemporaryIcon(...)");
                IconModel iconModel = UtilKt.toModel((Icon)icon9);
                String string = ((XLineBreakpointType)type).getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                String string2 = ((XLineBreakpointType)type).getTitle();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTitle(...)");
                breakpointTypeModelBase = (BreakpointTypeModelBase)new LineBreakpointTypeModel(iconModel, string, string2, enabledIcon, disabledIcon, suspendNoneIcon, mutedEnabledIcon, mutedDisabledIcon, pendingIcon, inactiveDependentIcon, ((XLineBreakpointType)type).isSuspendThreadSupported());
            } else {
                String string = type.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                String string3 = type.getTitle();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTitle(...)");
                breakpointTypeModelBase = (BreakpointTypeModelBase)new CustomBreakpointTypeModel(string, string3, enabledIcon, disabledIcon, suspendNoneIcon, mutedEnabledIcon, mutedDisabledIcon, pendingIcon, inactiveDependentIcon, type.isSuspendThreadSupported());
            }
            BreakpointTypeModelBase typeModel = breakpointTypeModelBase;
            ((Map)this$0.getModel().getBreakpointTypes()).put(typeModel.getId(), typeModel);
        }
        catch (Throwable t) {
            logger.error("Failed to add the breakpoint type: " + type, t);
        }
    }

    private static final void syncBreakpointTypes$removeBreakpointTypeFromModel(BackendBreakpointHost this$0, XBreakpointType<?, ?> type) {
        this$0.getModel().getBreakpointTypes().remove((Object)type.getId());
    }

    public static final /* synthetic */ BidirectionalMap access$getBreakpointMap(BackendBreakpointHost $this) {
        return $this.getBreakpointMap();
    }

    public static final /* synthetic */ ClientProjectSession access$getSession$p(BackendBreakpointHost $this) {
        return $this.session;
    }

    public static final /* synthetic */ void access$syncBreakpointTypes$addBreakpointTypeToModel(BackendBreakpointHost this$0, XBreakpointType type) {
        BackendBreakpointHost.syncBreakpointTypes$addBreakpointTypeToModel(this$0, type);
    }

    public static final /* synthetic */ void access$syncBreakpointTypes$removeBreakpointTypeFromModel(BackendBreakpointHost this$0, XBreakpointType type) {
        BackendBreakpointHost.syncBreakpointTypes$removeBreakpointTypeFromModel(this$0, type);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendBreakpointHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BackendBreakpointHost.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/debugger/BackendBreakpointHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdserver/debugger/BackendBreakpointHost;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendBreakpointHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendBreakpointHost.kt\ncom/jetbrains/rdserver/debugger/BackendBreakpointHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,152:1\n23#2:153\n*S KotlinDebug\n*F\n+ 1 BackendBreakpointHost.kt\ncom/jetbrains/rdserver/debugger/BackendBreakpointHost$Companion\n*L\n150#1:153\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendBreakpointHost getInstance(@NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(BackendBreakpointHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (BackendBreakpointHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

