/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.document;

import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rdserver.document.BackendDocumentHostKt;
import com.jetbrains.rdserver.document.BackendPatchDocumentItemHandlerKt;
import com.jetbrains.rdserver.rdPatchHandlers.BackendRdPatchContext;
import com.jetbrains.rdserver.rdPatchHandlers.BackendRdPatchItemHandler;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/document/BackendPatchDocumentItemHandler;", "Lcom/jetbrains/rdserver/rdPatchHandlers/BackendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchDocumentVersion;", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "<init>", "()V", "validate", "", "version", "context", "Lcom/jetbrains/rdserver/rdPatchHandlers/BackendRdPatchContext;", "update", "", "apply", "step", "(Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;Lcom/jetbrains/rdserver/rdPatchHandlers/BackendRdPatchContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.backend.split"})
public final class BackendPatchDocumentItemHandler
implements BackendRdPatchItemHandler<RdPatchDocumentVersion, RdDocumentChangeBase> {
    @Override
    public boolean validate(@NotNull RdPatchDocumentVersion version, @NotNull BackendRdPatchContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RdDocumentVersion expectedVersion = version.getVersion();
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        RdDocumentId documentId = (RdDocumentId)rdPatchItemId;
        DocumentSynchronizer documentSynchronizer = BackendDocumentHostKt.toSynchronizerOrNull(documentId, context.getSession());
        if (documentSynchronizer == null || (documentSynchronizer = documentSynchronizer.getVersion()) == null) {
            return false;
        }
        DocumentSynchronizer actualVersion = documentSynchronizer;
        if (!Intrinsics.areEqual((Object)actualVersion, (Object)expectedVersion)) {
            BackendPatchDocumentItemHandlerKt.access$getLogger$p().warn("Not matched versions for " + version.getId() + " documentId, actual: " + (AbstractDocumentVersion)actualVersion + ", expected: " + expectedVersion);
            return false;
        }
        return true;
    }

    @Override
    public void update(@NotNull RdPatchDocumentVersion version, @NotNull BackendRdPatchContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BackendPatchDocumentItemHandlerKt.access$getLogger$p().trace("Update document version: " + version.getId() + " to " + version.getVersion());
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        RdDocumentId documentId = (RdDocumentId)rdPatchItemId;
        DocumentSynchronizer documentSynchronizer = BackendDocumentHostKt.toSynchronizerOrNull(documentId, context.getSession());
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = documentSynchronizer instanceof PatchEngineDocumentSynchronizer ? (PatchEngineDocumentSynchronizer)documentSynchronizer : null;
        if (patchEngineDocumentSynchronizer == null) {
            return;
        }
        PatchEngineDocumentSynchronizer synchronizer = patchEngineDocumentSynchronizer;
        synchronizer.updateLastKnownVersion(version.getVersion());
    }

    @Override
    @Nullable
    public Object apply(@NotNull RdDocumentChangeBase step2, @NotNull BackendRdPatchContext context, @NotNull Continuation<? super Boolean> $completion) {
        PatchEngineDocumentSynchronizer synchronizer;
        BackendPatchDocumentItemHandlerKt.access$getLogger$p().trace("Apply editor step: " + step2);
        DocumentSynchronizer documentSynchronizer = BackendDocumentHostKt.toSynchronizerOrNull(step2.getDocumentId(), context.getSession());
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = synchronizer = documentSynchronizer instanceof PatchEngineDocumentSynchronizer ? (PatchEngineDocumentSynchronizer)documentSynchronizer : null;
        if (synchronizer == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        PatchEngineDocumentSynchronizer.receiveDocumentChange$default((PatchEngineDocumentSynchronizer)synchronizer, (RdDocumentChangeBase)step2, (boolean)false, (int)2, null);
        return Boxing.boxBoolean((boolean)true);
    }
}

