/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.services;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.WindowFocusFrontendService;
import com.intellij.idea.AppMode;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ApplicationKt;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.ide.model.LuxLayoutSource;
import com.jetbrains.rd.ide.model.LxIdeFrameRef;
import com.jetbrains.rd.ide.model.LxLuxWindowRef;
import com.jetbrains.rd.ide.model.LxNonLuxWindowRef;
import com.jetbrains.rd.ide.model.LxWindowRef;
import com.jetbrains.rd.platform.codeWithMe.lux.LuxImageCache;
import com.jetbrains.rd.platform.util.ListenersKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.ui.bindable.UtilsKt;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.lux.adapter.LuxComponentAdapter;
import com.jetbrains.rdserver.lux.adapter.LuxDialogAdapter;
import com.jetbrains.rdserver.lux.adapter.LuxFrameAdapter;
import com.jetbrains.rdserver.lux.adapter.LuxPanelAdapter;
import com.jetbrains.rdserver.lux.awt.LuxHostPanelDialog;
import com.jetbrains.rdserver.lux.awt.LuxHostPanelWindow;
import com.jetbrains.rdserver.lux.awt.LuxWindowWithAdapter;
import com.jetbrains.rdserver.lux.services.LuxFontLayoutService;
import com.jetbrains.rdserver.lux.services.LuxHostConnection;
import com.jetbrains.rdserver.lux.util.RenderingContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 I2\u00020\u0001:\u0001IB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0015\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020\nH\u0002J\u0010\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u0010H\u0002J\u000e\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u0013Jb\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010.2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u00101\u001a\u00020\b2\b\b\u0002\u00102\u001a\u00020\b2\b\b\u0002\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\b2\n\b\u0002\u00106\u001a\u0004\u0018\u000107J\u000f\u00108\u001a\t\u0018\u000109\u00a2\u0006\u0002\b:H\u0002J\u0018\u0010;\u001a\u00020.2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010-\u001a\u00020.H\u0002J\u0016\u0010>\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u0010J\u000e\u0010?\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u0010J\u0012\u0010@\u001a\u0004\u0018\u00010\u00102\b\u0010*\u001a\u0004\u0018\u00010\u0013J\u0012\u0010A\u001a\u0004\u0018\u00010B2\b\u0010*\u001a\u0004\u0018\u00010\u0013J\u0010\u0010C\u001a\u0004\u0018\u00010\u00102\u0006\u0010D\u001a\u00020\rJ\b\u0010E\u001a\u0004\u0018\u00010FJ\b\u0010G\u001a\u0004\u0018\u00010HR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R>\u0010\u0018\u001a2\u0012\u000e\u0012\f0\u0013\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u001b \u001d*\u0017\u0012\u000e\u0012\f0\u0013\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u001b0\u001c\u00a2\u0006\u0002\b\u001a0\u0019\u00a2\u0006\u0002\b\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006J"}, d2={"Lcom/jetbrains/rdserver/lux/services/LuxHostService;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "paranoidLogger", "welcomeFramePostponed", "", "postponeWelcomeFrameShowing", "", "showWelcomeFrameIfPostponed", "componentCounter", "", "adapters", "Ljava/util/HashMap;", "Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter;", "Lkotlin/collections/HashMap;", "windowToAdapter", "Ljava/awt/Window;", "imageCache", "Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$Backend;", "getImageCache", "()Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$Backend;", "ignoredWindows", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "attachConnection", "connection", "Lcom/jetbrains/rdserver/lux/services/LuxHostConnection;", "attachConnection$intellij_platform_backend_split", "updateUIForLuxComponents", "shouldBindAdapter", "adapter", "doNotLuxifyWindow", "window", "luxifyComponent", "Lcom/jetbrains/rdserver/lux/adapter/LuxPanelAdapter;", "component", "Ljava/awt/Component;", "fosterParent", "explicitOwner", "trackVisibility", "useDialogHost", "layoutSource", "Lcom/jetbrains/rd/ide/model/LuxLayoutSource;", "focusableOnFrontend", "preRenderInfo", "Lcom/jetbrains/rdserver/lux/util/RenderingContext;", "fallbackParentWindow", "Ljavax/swing/JFrame;", "Lorg/jetbrains/annotations/Nullable;", "substituteComponent", "generatePlaceholder", "Ljavax/swing/JComponent;", "register", "bindIfPossible", "getAdapterByWindow", "wrapWindowToLxRef", "Lcom/jetbrains/rd/ide/model/LxWindowRef;", "getAdapter", "id", "getMainWindow", "Lcom/jetbrains/rdserver/lux/adapter/LuxFrameAdapter;", "getCurrentModalWindow", "Lcom/jetbrains/rdserver/lux/adapter/LuxDialogAdapter;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLuxHostService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxHostService.kt\ncom/jetbrains/rdserver/lux/services/LuxHostService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 util.kt\ncom/jetbrains/rd/platform/codeWithMe/lux/UtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,339:1\n23#2:340\n67#2,4:342\n67#2,4:346\n67#2,4:350\n67#2,4:354\n67#2,4:360\n67#2,4:364\n67#2,4:368\n67#2,4:372\n74#2,4:376\n67#2,4:393\n67#2,4:397\n74#2,4:401\n67#2,4:437\n67#2,4:441\n67#2,4:445\n67#2,4:449\n67#2,4:453\n67#2,4:457\n201#3:341\n1915#4,2:358\n812#4,12:405\n777#4:417\n873#4,2:418\n812#4,12:420\n777#4:432\n873#4,2:433\n1915#4,2:435\n1#5:380\n4253#6,12:381\n*S KotlinDebug\n*F\n+ 1 LuxHostService.kt\ncom/jetbrains/rdserver/lux/services/LuxHostService\n*L\n69#1:340\n104#1:342,4\n82#1:346,4\n88#1:350,4\n122#1:354,4\n129#1:360,4\n132#1:364,4\n153#1:368,4\n178#1:372,4\n179#1:376,4\n198#1:393,4\n305#1:397,4\n306#1:401,4\n210#1:437,4\n221#1:441,4\n257#1:445,4\n263#1:449,4\n272#1:453,4\n246#1:457,4\n70#1:341\n123#1:358,2\n333#1:405,12\n333#1:417\n333#1:418,2\n337#1:420,12\n337#1:432\n337#1:433,2\n139#1:435,2\n188#1:381,12\n*E\n"})
public final class LuxHostService
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Logger paranoidLogger;
    private boolean welcomeFramePostponed;
    private int componentCounter;
    @NotNull
    private final HashMap<Integer, LuxComponentAdapter> adapters;
    @NotNull
    private final HashMap<Window, LuxComponentAdapter> windowToAdapter;
    @NotNull
    private final LuxImageCache.Backend imageCache;
    @NotNull
    private final Set<Window> ignoredWindows;

    public LuxHostService() {
        LuxHostService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(LuxHostService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        LuxHostService $this$paranoidLogger$iv = this;
        boolean $i$f$paranoidLogger = false;
        Logger logger2 = Logger.getInstance((String)("paranoid#" + LuxHostService.class.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.paranoidLogger = logger2;
        if (AppMode.isRemoteDevHost()) {
            FontLayoutService.Companion.setInstanceInternal((FontLayoutService)new LuxFontLayoutService(FontLayoutService.Companion.getInstance()));
            ApplicationKt.getApplication().invokeLater(() -> ((EditorFactory)EditorFactory.getInstance()).refreshAllEditors(), ModalityState.any());
        }
        this.adapters = new HashMap();
        this.windowToAdapter = new HashMap();
        this.imageCache = new LuxImageCache.Backend();
        Set set = ContainerUtil.createWeakSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createWeakSet(...)");
        this.ignoredWindows = set;
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger3 = $this$trace$iv;
            boolean bl = false;
            logger3.trace("INIT");
        }
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        Lifetime lifetime = this.getLifetime();
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ListenersKt.subscribe((MessageBus)messageBus, (Lifetime)lifetime, (Topic)topic, arg_0 -> LuxHostService._init_$lambda$1(this, arg_0));
        MessageBus messageBus2 = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus2, (String)"getMessageBus(...)");
        Lifetime lifetime2 = this.getLifetime();
        Topic topic2 = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        ListenersKt.subscribe((MessageBus)messageBus2, (Lifetime)lifetime2, (Topic)topic2, arg_0 -> LuxHostService._init_$lambda$2(this, arg_0));
        this.imageCache.onItemsRemoved(arg_0 -> LuxHostService._init_$lambda$3(this, arg_0));
    }

    public final void postponeWelcomeFrameShowing() {
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Postpone welcome frame");
        }
        this.welcomeFramePostponed = true;
    }

    public final void showWelcomeFrameIfPostponed() {
        if (this.welcomeFramePostponed) {
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Show postponed welcome frame");
            }
            WelcomeFrame.Companion.showIfNoProjectOpened$default((WelcomeFrame.Companion)WelcomeFrame.Companion, null, (int)1, null);
        }
    }

    @NotNull
    public final LuxImageCache.Backend getImageCache() {
        return this.imageCache;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.getServiceLifetime();
    }

    public final void attachConnection$intellij_platform_backend_split(@NotNull LuxHostConnection connection) {
        Intrinsics.checkNotNullParameter((Object)((Object)connection), (String)"connection");
        if (!connection.isControllerConnection()) {
            this.logger.error("Lux can not work only with single controller connection");
            return;
        }
        this.showWelcomeFrameIfPostponed();
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Attaching connection " + connection);
        }
        Collection<LuxComponentAdapter> collection = this.adapters.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LuxComponentAdapter it = (LuxComponentAdapter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.bindIfPossible(it);
        }
    }

    private final void updateUIForLuxComponents() {
        LuxHostConnection connection = LuxHostConnection.Companion.getControllerInstance();
        if (connection == null) {
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("No controller, skipping update component tree");
            }
            return;
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Update UI for LUX");
        }
        ClientId.Companion.withExplicitClientId(connection.getSession().getClientId(), () -> LuxHostService.updateUIForLuxComponents$lambda$2(this));
    }

    private final boolean shouldBindAdapter(LuxComponentAdapter adapter) {
        Window window = adapter.getWindow();
        return !(window instanceof IdeFrameImpl) && !this.ignoredWindows.contains(window);
    }

    public final void doNotLuxifyWindow(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Forbid luxifying for window " + window);
        }
        this.ignoredWindows.add(window);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LuxPanelAdapter luxifyComponent(@NotNull Lifetime lifetime, @NotNull Component component, @Nullable Component fosterParent, @Nullable Window explicitOwner, boolean trackVisibility, boolean useDialogHost, @NotNull LuxLayoutSource layoutSource, boolean focusableOnFrontend, @Nullable RenderingContext preRenderInfo) {
        Window window;
        Component substitute;
        Container realParent;
        Logger logger;
        block20: {
            Window hostWindowParent;
            Window parentWindow;
            block17: {
                Window window2;
                block19: {
                    block18: {
                        Window window3;
                        Component component2;
                        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                        Intrinsics.checkNotNullParameter((Object)layoutSource, (String)"layoutSource");
                        if (RLifetimeKt.isNotAlive((Lifetime)lifetime)) {
                            this.logger.error("Try to luxify component with expired lifetime!");
                        }
                        Logger $this$trace$iv = this.logger;
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            logger = $this$trace$iv;
                            boolean bl = false;
                            logger.trace("Luxifying component " + component);
                        }
                        Logger $this$traceThrowable$iv = this.paranoidLogger;
                        boolean $i$f$traceThrowable = false;
                        if ($this$traceThrowable$iv.isTraceEnabled()) {
                            logger = $this$traceThrowable$iv;
                            boolean bl = false;
                            logger.trace(new Throwable());
                        }
                        Container container = realParent = component.getParent();
                        if (container != null) {
                            Container it = container;
                            boolean bl = false;
                            component2 = this.substituteComponent(lifetime, component);
                        } else {
                            component2 = null;
                        }
                        substitute = component2;
                        MnemonicHelper.init((Component)component);
                        Container container2 = realParent;
                        if (container2 != null) {
                            Container it = container2;
                            boolean bl = false;
                            window3 = SwingUtilities.windowForComponent(it);
                        } else {
                            window3 = null;
                        }
                        Window componentWindow = window3;
                        this.logger.assertTrue(!(componentWindow instanceof LuxWindowWithAdapter), (Object)"Component was already luxified");
                        Window window4 = explicitOwner;
                        if (window4 == null && (window4 = componentWindow) == null) {
                            void $this$filterIsInstanceTo$iv$iv;
                            Object[] objectArray = LaterInvocator.getCurrentModalEntities();
                            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getCurrentModalEntities(...)");
                            Object[] $this$filterIsInstance$iv = objectArray;
                            boolean $i$f$filterIsInstance = false;
                            Object[] objectArray2 = $this$filterIsInstance$iv;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$filterIsInstanceTo = false;
                            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                if (!(element$iv$iv instanceof Dialog)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            window4 = parentWindow = (Window)CollectionsKt.lastOrNull((List)((List)destination$iv$iv));
                        }
                        if (!useDialogHost) break block17;
                        window2 = parentWindow;
                        if (window2 == null) break block18;
                        Window it = window2;
                        boolean bl = false;
                        Frame frame2 = it instanceof Frame ? (Frame)it : null;
                        Window window5 = frame2 != null ? (Window)frame2 : (Window)(it instanceof Dialog ? (Dialog)it : null);
                        window2 = window5;
                        if (window5 != null) break block19;
                    }
                    window2 = this.fallbackParentWindow();
                }
                hostWindowParent = window2;
                window = new LuxHostPanelDialog(lifetime, hostWindowParent, component, realParent, layoutSource, focusableOnFrontend);
                break block20;
            }
            Window window6 = parentWindow;
            if (window6 == null) {
                window6 = this.fallbackParentWindow();
            }
            hostWindowParent = window6;
            window = new LuxHostPanelWindow(lifetime, hostWindowParent, component, realParent, layoutSource, focusableOnFrontend);
        }
        Window hostWindow = window;
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Created " + hostWindow + "\n provided owner:" + explicitOwner + "\n used owner:" + ((Component)hostWindow).getParent());
        }
        LuxPanelAdapter adapter = ((LuxWindowWithAdapter)((Object)hostWindow)).getAdapter();
        this.bindIfPossible(adapter);
        Window window7 = hostWindow;
        Component component3 = fosterParent;
        if (component3 == null) {
            component3 = realParent;
        }
        UIUtil.setFosterParent((Window)window7, (Component)component3);
        lifetime.onTerminationIfAlive(() -> LuxHostService.luxifyComponent$lambda$6(this, hostWindow, realParent, component));
        if (trackVisibility && substitute != null) {
            UtilsKt.showingProperty((Component)substitute).advise(lifetime, arg_0 -> LuxHostService.luxifyComponent$lambda$7(this, hostWindow, component, arg_0));
        }
        if (preRenderInfo != null) {
            adapter.preConfigure(preRenderInfo);
        }
        return adapter;
    }

    public static /* synthetic */ LuxPanelAdapter luxifyComponent$default(LuxHostService luxHostService, Lifetime lifetime, Component component, Component component2, Window window, boolean bl, boolean bl2, LuxLayoutSource luxLayoutSource, boolean bl3, RenderingContext renderingContext, int n, Object object) {
        if ((n & 4) != 0) {
            component2 = null;
        }
        if ((n & 8) != 0) {
            window = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        if ((n & 0x40) != 0) {
            luxLayoutSource = LuxLayoutSource.Frontend;
        }
        if ((n & 0x80) != 0) {
            bl3 = true;
        }
        if ((n & 0x100) != 0) {
            renderingContext = null;
        }
        return luxHostService.luxifyComponent(lifetime, component, component2, window, bl, bl2, luxLayoutSource, bl3, renderingContext);
    }

    private final JFrame fallbackParentWindow() {
        return WindowManagerEx.getInstanceEx().findVisibleFrame();
    }

    private final Component substituteComponent(Lifetime lifetime, Component component) {
        JComponent placeholderComponent = this.generatePlaceholder(component);
        Container realParent = component.getParent();
        Ref.ObjectRef syntheticParent = new Ref.ObjectRef();
        HierarchyListener hierarchyListener = arg_0 -> LuxHostService.substituteComponent$lambda$0(syntheticParent, component, arg_0);
        lifetime.bracketIfAlive(() -> LuxHostService.substituteComponent$lambda$1(this, component, placeholderComponent, realParent, hierarchyListener), () -> LuxHostService.substituteComponent$lambda$2(this, component, hierarchyListener, syntheticParent, placeholderComponent, realParent));
        return placeholderComponent;
    }

    private final JComponent generatePlaceholder(Component component) {
        BorderLayoutPanel borderLayoutPanel;
        JBLabel label = new JBLabel(SplitBackendBundle.INSTANCE.message("lux.component.is.projected.label", new Object[0]));
        label.setHorizontalAlignment(0);
        BorderLayoutPanel $this$generatePlaceholder_u24lambda_u240 = borderLayoutPanel = JBUI.Panels.simplePanel((Component)((Component)label));
        boolean bl = false;
        $this$generatePlaceholder_u24lambda_u240.setBounds(component.getBounds());
        $this$generatePlaceholder_u24lambda_u240.setBackground(component.getBackground());
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel;
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"apply(...)");
        return (JComponent)borderLayoutPanel2;
    }

    public final int register(@NotNull Lifetime lifetime, @NotNull LuxComponentAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        int n = this.componentCounter;
        this.componentCounter = n + 1;
        int id = n;
        CollectionExKt.addUnique((Map)this.adapters, (Lifetime)lifetime, (Object)id, (Object)adapter);
        CollectionExKt.addUnique((Map)this.windowToAdapter, (Lifetime)lifetime, (Object)adapter.getWindow(), (Object)adapter);
        return id;
    }

    public final void bindIfPossible(@NotNull LuxComponentAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        if (this.shouldBindAdapter(adapter)) {
            LuxHostConnection controllerConnection = LuxHostConnection.Companion.getControllerInstance();
            if (controllerConnection == null) {
                Logger logger;
                Logger $this$trace$iv = this.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Can not bind " + adapter + ", because controller is not connected");
                }
                Logger $this$traceThrowable$iv = this.paranoidLogger;
                boolean $i$f$traceThrowable = false;
                if ($this$traceThrowable$iv.isTraceEnabled()) {
                    logger = $this$traceThrowable$iv;
                    boolean bl = false;
                    logger.trace(new Throwable());
                }
                return;
            }
            adapter.bindTo(controllerConnection);
        }
    }

    @Nullable
    public final LuxComponentAdapter getAdapterByWindow(@Nullable Window window) {
        return (LuxComponentAdapter)((Map)this.windowToAdapter).get(window);
    }

    @Nullable
    public final LxWindowRef wrapWindowToLxRef(@Nullable Window window) {
        LuxComponentAdapter adapter = (LuxComponentAdapter)((Map)this.windowToAdapter).get(window);
        return WindowFocusFrontendService.Companion.getInstance().isFrontendFocused() ? (LxWindowRef)new LxNonLuxWindowRef() : (window == null ? null : (window instanceof IdeFrame ? (LxWindowRef)new LxIdeFrameRef() : (window instanceof Frame ? (LxWindowRef)new LxNonLuxWindowRef() : (adapter != null ? (LxWindowRef)new LxLuxWindowRef(adapter.getLuxId()) : (LxWindowRef)new LxNonLuxWindowRef()))));
    }

    @Nullable
    public final LuxComponentAdapter getAdapter(int id) {
        return this.adapters.get(id);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LuxFrameAdapter getMainWindow() {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Collection<LuxComponentAdapter> collection = this.adapters.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LuxFrameAdapter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LuxFrameAdapter it = (LuxFrameAdapter)element$iv$iv;
            boolean bl = false;
            if (!(it.getWindow() instanceof IdeFrameImpl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (LuxFrameAdapter)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LuxDialogAdapter getCurrentModalWindow() {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Collection<LuxComponentAdapter> collection = this.adapters.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LuxDialogAdapter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LuxDialogAdapter it = (LuxDialogAdapter)element$iv$iv;
            boolean bl = false;
            if (!it.isModal()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (LuxDialogAdapter)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    private static final void _init_$lambda$1(LuxHostService this$0, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateUIForLuxComponents();
    }

    private static final void _init_$lambda$2(LuxHostService this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateUIForLuxComponents();
    }

    private static final Unit _init_$lambda$3(LuxHostService this$0, List items) {
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        CoroutineScope coroutineScope = this$0.getLifetime().getCoroutineScope();
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<Integer>)items, null){
            int label;
            final /* synthetic */ List<Integer> $items;
            {
                this.$items = $items;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable iterable = LuxHostConnection.Companion.getAllInstances();
                        List<Integer> list = this.$items;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            LuxHostConnection it = (LuxHostConnection)((Object)element$iv);
                            boolean bl = false;
                            it.removeItemsFromCache(list);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit updateUIForLuxComponents$lambda$2(LuxHostService this$0) {
        Collection<LuxComponentAdapter> collection = this$0.adapters.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        List adaptersToUpdate = CollectionsKt.toList((Iterable)collection);
        Iterable $this$forEach$iv = adaptersToUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LuxComponentAdapter it = (LuxComponentAdapter)element$iv;
            boolean bl = false;
            if (!RLifetimeKt.isAlive((Lifetime)((Lifetime)it.getLifetime()))) continue;
            IJSwingUtilities.updateComponentTreeUI((Component)it.getWindow());
        }
        return Unit.INSTANCE;
    }

    private static final Unit luxifyComponent$lambda$6(LuxHostService this$0, Object $hostWindow, Container $realParent, Component $component) {
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Dispose host window " + $hostWindow + " for component " + $component);
        }
        UIUtil.setFosterParent((Window)((Window)$hostWindow), null);
        ((Window)$hostWindow).dispose();
        if ($realParent == null && SwingUtilities.isDescendingFrom($component, (Component)$hostWindow)) {
            $component.getParent().remove($component);
        }
        return Unit.INSTANCE;
    }

    private static final Unit luxifyComponent$lambda$7(LuxHostService this$0, Object $hostWindow, Component $component, boolean it) {
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Marking " + $component + " as " + (!it ? "not" : "") + " showing");
        }
        ((RootPaneContainer)$hostWindow).getContentPane().setVisible(it);
        return Unit.INSTANCE;
    }

    private static final Unit substituteComponent$lambda$2$0(LuxHostService this$0, Component $component, HierarchyListener $hierarchyListener, Ref.ObjectRef $syntheticParent, JComponent $placeholderComponent, Container $realParent) {
        Logger logger;
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Returning parent to component " + $component);
        }
        $component.removeHierarchyListener($hierarchyListener);
        if ($component.getParent() == $syntheticParent.element) {
            Container container = $component.getParent();
            if (container != null) {
                container.remove($component);
            }
        } else {
            $this$trace$iv = this$0.logger;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Component was re-attached to " + $component.getParent() + ", see exception from LuxContentPaneWrapper");
            }
        }
        if (Intrinsics.areEqual((Object)$placeholderComponent.getParent(), (Object)$realParent)) {
            $realParent.remove($placeholderComponent);
            if ($component.getParent() == null) {
                $realParent.add($component);
            }
        } else {
            $this$trace$iv = this$0.logger;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Component's original parent has removed the placeholder, not re-attaching component to it");
            }
        }
        JComponent jComponent = $component instanceof JComponent ? (JComponent)$component : null;
        if (jComponent != null) {
            jComponent.putClientProperty("BE_CONTROLS_SUBSTITUTED_MARKER", null);
        }
        $placeholderComponent.putClientProperty("BE_CONTROLS_SUBSTITUTED_MARKER", null);
        return Unit.INSTANCE;
    }

    private static final void substituteComponent$lambda$0(Ref.ObjectRef $syntheticParent, Component $component, HierarchyEvent it) {
        if ($syntheticParent.element == null) {
            $syntheticParent.element = $component.getParent();
        }
    }

    private static final Unit substituteComponent$lambda$1(LuxHostService this$0, Component $component, JComponent $placeholderComponent, Container $realParent, HierarchyListener $hierarchyListener) {
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Substituting parent " + $component);
        }
        JComponent jComponent = $component instanceof JComponent ? (JComponent)$component : null;
        if (jComponent != null) {
            jComponent.putClientProperty("BE_CONTROLS_SUBSTITUTED_MARKER", true);
        }
        $placeholderComponent.putClientProperty("BE_CONTROLS_SUBSTITUTED_MARKER", true);
        $realParent.remove($component);
        $realParent.add($placeholderComponent);
        $component.addHierarchyListener($hierarchyListener);
        return Unit.INSTANCE;
    }

    private static final Unit substituteComponent$lambda$2(LuxHostService this$0, Component $component, HierarchyListener $hierarchyListener, Ref.ObjectRef $syntheticParent, JComponent $placeholderComponent, Container $realParent) {
        ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> LuxHostService.substituteComponent$lambda$2$0(this$0, $component, $hierarchyListener, $syntheticParent, $placeholderComponent, $realParent));
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final LuxHostService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/lux/services/LuxHostService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdserver/lux/services/LuxHostService;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nLuxHostService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxHostService.kt\ncom/jetbrains/rdserver/lux/services/LuxHostService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,339:1\n42#2,3:340\n*S KotlinDebug\n*F\n+ 1 LuxHostService.kt\ncom/jetbrains/rdserver/lux/services/LuxHostService$Companion\n*L\n66#1:340,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LuxHostService getInstance() {
            boolean $i$f$service = false;
            Class<LuxHostService> serviceClass$iv = LuxHostService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LuxHostService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

