/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding.internal;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.codeWithMe.model.PortForwardingModel;
import com.jetbrains.codeWithMe.model.PortForwardingModel_GeneratedKt;
import com.jetbrains.codeWithMe.model.PortStrategy;
import com.jetbrains.codeWithMe.model.RdExposedPort;
import com.jetbrains.codeWithMe.model.RdForwardedPort;
import com.jetbrains.codeWithMe.model.RdPortId;
import com.jetbrains.codeWithMe.model.RdPortState;
import com.jetbrains.codeWithMe.model.RdSocketAddress;
import com.jetbrains.codeWithMe.model.SocketState;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.framework.base.RdExtBase;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPortListener;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PerClientPortForwardingManager;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfiguration;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortDirectionType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortAttributes;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortPickingStrategy;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortState;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketWrapper;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.SocketWrapperForPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.utils.PortForwardingUtilsKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.PermittedModalityProtocolEntities;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.portForwarding.PortForwardingConfiguration;
import com.jetbrains.rdserver.portForwarding.internal.ForwardedPortImpl;
import com.jetbrains.rdserver.portForwarding.internal.PerClientPortForwardingManagerImpl;
import com.jetbrains.rdserver.portForwarding.internal.configuration.PerClientTcpForwardingConfigurationImpl;
import com.jetbrains.rdserver.portForwarding.internal.configuration.PerClientTcpReversedForwardingConfigurationImpl;
import com.jetbrains.rdserver.portForwarding.internal.configuration.UrlExposureConfigurationImpl;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdserver/portForwarding/internal/BackendPortForwardingModelHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;Lkotlinx/coroutines/CoroutineScope;)V", "createRdForwardedPort", "Lcom/jetbrains/codeWithMe/model/RdForwardedPort;", "port", "Lcom/jetbrains/rdserver/portForwarding/internal/ForwardedPortImpl;", "attributes", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketPortAttributes;", "portType", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortType;", "directionType", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortDirectionType;", "handlePerClientTcpDirectForwarding", "", "portLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "configuration", "Lcom/jetbrains/rdserver/portForwarding/internal/configuration/PerClientTcpForwardingConfigurationImpl;", "handlePerClientTcpReversedForwarding", "Lcom/jetbrains/rdserver/portForwarding/internal/configuration/PerClientTcpReversedForwardingConfigurationImpl;", "handleUrlExposure", "Lcom/jetbrains/rdserver/portForwarding/internal/configuration/UrlExposureConfigurationImpl;", "Companion", "intellij.platform.backend.split"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBackendPortForwardingModelHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendPortForwardingModelHost.kt\ncom/jetbrains/rdserver/portForwarding/internal/BackendPortForwardingModelHost\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,216:1\n37#2,2:217\n13#3:219\n*S KotlinDebug\n*F\n+ 1 BackendPortForwardingModelHost.kt\ncom/jetbrains/rdserver/portForwarding/internal/BackendPortForwardingModelHost\n*L\n105#1:217,2\n42#1:219\n*E\n"})
public final class BackendPortForwardingModelHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final Logger LOG;

    public BackendPortForwardingModelHost(@NotNull ClientAppSession session, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.session = session;
        this.coroutineScope = coroutineScope;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BackendPortForwardingModelHost this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Protocol protocol = RemoteSessionKt.getProtocol(this.this$0.session);
                        PortForwardingModel model2 = PortForwardingModel_GeneratedKt.getPortForwardingModel((IProtocol)((IProtocol)protocol));
                        PermittedModalityProtocolEntities.Companion.getInstance().allowAnyModalityPumpingUnder(this.this$0.getServiceLifetime(), (RdExtBase)model2);
                        PerClientPortForwardingManager perClientPortForwardingManager = PerClientPortForwardingManager.Companion.getInstance(this.this$0.session);
                        Intrinsics.checkNotNull((Object)perClientPortForwardingManager, (String)"null cannot be cast to non-null type com.jetbrains.rdserver.portForwarding.internal.PerClientPortForwardingManagerImpl");
                        PerClientPortForwardingManagerImpl manager = (PerClientPortForwardingManagerImpl)perClientPortForwardingManager;
                        SourceExKt.flowInto((ISource)((ISource)manager.getPortForwardingEnabled()), (Lifetime)this.this$0.getServiceLifetime(), (IMutablePropertyBase)((IMutablePropertyBase)model2.getEnabled()));
                        BoolPropertyExKt.whenTrue((IViewable)((IViewable)model2.getEnabled()), (Lifetime)this.this$0.getServiceLifetime(), arg_0 -> 1.invokeSuspend$lambda$0(manager, this.this$0, arg_0));
                        PortForwardingConfiguration.INSTANCE.addPersistReverseForwardedPortFrontendConfigListener$intellij_platform_backend_split(this.this$0.getServiceLifetime(), model2);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0$0(BackendPortForwardingModelHost this$0, Lifetime portLifetime, int n, ForwardedPortImpl port) {
                PortConfiguration configuration = port.getConfiguration();
                if (configuration instanceof PerClientTcpForwardingConfigurationImpl) {
                    this$0.handlePerClientTcpDirectForwarding(portLifetime, port, (PerClientTcpForwardingConfigurationImpl)configuration);
                } else if (configuration instanceof PerClientTcpReversedForwardingConfigurationImpl) {
                    this$0.handlePerClientTcpReversedForwarding(portLifetime, port, (PerClientTcpReversedForwardingConfigurationImpl)configuration);
                } else if (configuration instanceof UrlExposureConfigurationImpl) {
                    this$0.handleUrlExposure(portLifetime, port, (UrlExposureConfigurationImpl)configuration);
                } else {
                    throw new IllegalStateException(("Unable to handle forwarded port: <" + port.getTargetPortNumber() + ">. Unhandled port configuration: <" + configuration + ">").toString());
                }
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$0(PerClientPortForwardingManagerImpl $manager, BackendPortForwardingModelHost this$0, Lifetime enabledLifetime) {
                $manager.getForwardedPorts$intellij_platform_backend_split().view(enabledLifetime, (arg_0, arg_1, arg_2) -> 1.invokeSuspend$lambda$0$0(this$0, arg_0, arg_1, arg_2));
                return Unit.INSTANCE;
            }
        }), (int)2, null);
    }

    private final RdForwardedPort createRdForwardedPort(ForwardedPortImpl port, ServerSocketPortAttributes attributes, PortType portType, PortDirectionType directionType) {
        RdSocketAddress socketAddress = new RdSocketAddress("127.0.0.1", attributes.getPreferredPortNumber());
        PortStrategy strategy = PortForwardingUtilsKt.toModel((ServerSocketPortPickingStrategy)attributes.getStrategy());
        int n = port.getTargetPortNumber();
        UUID uUID = port.getMyUuid$intellij_platform_backend_split();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-myUuid>(...)");
        RdPortId portId = new RdPortId(n, uUID);
        Collection $this$toTypedArray$iv = port.getLabels();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        RdForwardedPort rdPort = new RdForwardedPort(portId, PortForwardingUtilsKt.toRdPortType((PortType)portType), PortForwardingUtilsKt.toRdPortDirectionType((PortDirectionType)directionType), port.getTargetPortNumber(), strategy, thisCollection$iv.toArray(new String[0]), socketAddress);
        rdPort.getRdPortState().set((Object)new RdPortState(SocketState.NOT_INITIALIZED, null, null));
        return rdPort;
    }

    private final void handlePerClientTcpDirectForwarding(Lifetime portLifetime, ForwardedPortImpl port, PerClientTcpForwardingConfigurationImpl configuration) {
        RdForwardedPort rdPort = this.createRdForwardedPort(port, configuration.getAttributes(), configuration.getType(), PortDirectionType.DIRECT);
        rdPort.getRdPortState().getChange().advise(portLifetime, arg_0 -> BackendPortForwardingModelHost.handlePerClientTcpDirectForwarding$lambda$0(configuration, arg_0));
        new SocketWrapperForPort(portLifetime, rdPort);
        CollectionExKt.addUnique((Collection)((Collection)PortForwardingModel_GeneratedKt.getPortForwardingModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol(this.session))).getPorts()), (Lifetime)portLifetime, (Object)rdPort);
    }

    private final void handlePerClientTcpReversedForwarding(Lifetime portLifetime, ForwardedPortImpl port, PerClientTcpReversedForwardingConfigurationImpl configuration) {
        ServerSocketWrapper serverSocketWrapper;
        RdForwardedPort rdPort = this.createRdForwardedPort(port, configuration.getAttributes(), configuration.getType(), PortDirectionType.REVERSED);
        rdPort.getRdPortState().getChange().advise(portLifetime, arg_0 -> BackendPortForwardingModelHost.handlePerClientTcpReversedForwarding$lambda$0(configuration, arg_0));
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        ServerSocketWrapper $this$handlePerClientTcpReversedForwarding_u24lambda_u241 = serverSocketWrapper = new ServerSocketWrapper(portLifetime, rdPort, string);
        boolean bl = false;
        $this$handlePerClientTcpReversedForwarding_u24lambda_u241.start();
        CollectionExKt.addUnique((Collection)((Collection)PortForwardingModel_GeneratedKt.getPortForwardingModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol(this.session))).getPorts()), (Lifetime)portLifetime, (Object)rdPort);
    }

    private final void handleUrlExposure(Lifetime portLifetime, ForwardedPortImpl port, UrlExposureConfigurationImpl configuration) {
        int n = port.getTargetPortNumber();
        UUID uUID = port.getMyUuid$intellij_platform_backend_split();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-myUuid>(...)");
        RdPortId portId = new RdPortId(n, uUID);
        RdExposedPort exposedPort = new RdExposedPort(portId, port.getTargetPortNumber());
        exposedPort.getExposedUrl().set((Object)configuration.getExposedUrl());
        port.addPortListener(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)portLifetime, null, (int)1, null), new ForwardedPortListener(exposedPort){
            final /* synthetic */ RdExposedPort $exposedPort;
            {
                this.$exposedPort = $exposedPort;
            }

            public void exposedUrlChanged(ForwardedPort port, String newUrl) {
                Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                Intrinsics.checkNotNullParameter((Object)newUrl, (String)"newUrl");
                this.$exposedPort.getExposedUrl().set((Object)newUrl);
            }
        });
        CollectionExKt.addUnique((Collection)((Collection)PortForwardingModel_GeneratedKt.getPortForwardingModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol(this.session))).getExposedPorts()), (Lifetime)portLifetime, (Object)exposedPort);
    }

    private static final Unit handlePerClientTcpDirectForwarding$lambda$0(PerClientTcpForwardingConfigurationImpl $configuration, RdPortState clientSocketState) {
        Intrinsics.checkNotNullParameter((Object)clientSocketState, (String)"clientSocketState");
        switch (WhenMappings.$EnumSwitchMapping$0[clientSocketState.getSocketState().ordinal()]) {
            case 1: {
                $configuration.setServerSocketPortState$intellij_platform_backend_split((ServerSocketPortState)ServerSocketPortState.NotAssigned.INSTANCE);
                break;
            }
            case 2: {
                RdSocketAddress rdSocketAddress = clientSocketState.getSocketAddress();
                Intrinsics.checkNotNull((Object)rdSocketAddress);
                String networkInterface = rdSocketAddress.getNetworkInterface();
                RdSocketAddress rdSocketAddress2 = clientSocketState.getSocketAddress();
                Intrinsics.checkNotNull((Object)rdSocketAddress2);
                int clientPort = rdSocketAddress2.getPort();
                $configuration.setServerSocketPortState$intellij_platform_backend_split((ServerSocketPortState)new ServerSocketPortState.Assigned(clientPort, networkInterface));
                break;
            }
            case 3: {
                String string = clientSocketState.getFailedReason();
                if (string == null) {
                    string = "Unknown";
                }
                $configuration.setServerSocketPortState$intellij_platform_backend_split((ServerSocketPortState)new ServerSocketPortState.FailedToAssign(string));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit handlePerClientTcpReversedForwarding$lambda$0(PerClientTcpReversedForwardingConfigurationImpl $configuration, RdPortState serverSocketState) {
        Intrinsics.checkNotNullParameter((Object)serverSocketState, (String)"serverSocketState");
        switch (WhenMappings.$EnumSwitchMapping$0[serverSocketState.getSocketState().ordinal()]) {
            case 1: {
                $configuration.setServerSocketPortState$intellij_platform_backend_split((ServerSocketPortState)ServerSocketPortState.NotAssigned.INSTANCE);
                break;
            }
            case 2: {
                RdSocketAddress rdSocketAddress = serverSocketState.getSocketAddress();
                if (rdSocketAddress == null) {
                    throw new IllegalStateException("Server socket address is not defined".toString());
                }
                RdSocketAddress serverSocketAddress = rdSocketAddress;
                $configuration.setServerSocketPortState$intellij_platform_backend_split((ServerSocketPortState)new ServerSocketPortState.Assigned(serverSocketAddress.getPort(), serverSocketAddress.getNetworkInterface()));
                break;
            }
            case 3: {
                String string = serverSocketState.getFailedReason();
                if (string == null) {
                    string = "Unknown";
                }
                $configuration.setServerSocketPortState$intellij_platform_backend_split((ServerSocketPortState)new ServerSocketPortState.FailedToAssign(string));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendPortForwardingModelHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/portForwarding/internal/BackendPortForwardingModelHost$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdserver/portForwarding/internal/BackendPortForwardingModelHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendPortForwardingModelHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendPortForwardingModelHost.kt\ncom/jetbrains/rdserver/portForwarding/internal/BackendPortForwardingModelHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,216:1\n30#2,2:217\n*S KotlinDebug\n*F\n+ 1 BackendPortForwardingModelHost.kt\ncom/jetbrains/rdserver/portForwarding/internal/BackendPortForwardingModelHost$Companion\n*L\n45#1:217,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final BackendPortForwardingModelHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session;
            boolean $i$f$service = false;
            Class<BackendPortForwardingModelHost> serviceClass$iv = BackendPortForwardingModelHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (BackendPortForwardingModelHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SocketState.values().length];
            try {
                nArray[SocketState.NOT_INITIALIZED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SocketState.LISTENING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SocketState.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

