/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeControlSize;
import com.jetbrains.ide.model.uiautomation.BeControlSizePredefined;
import com.jetbrains.ide.model.uiautomation.BeControlSizeType;
import com.jetbrains.ide.model.uiautomation.BeEditorImpl;
import com.jetbrains.ide.model.uiautomation.BeScrollablePanel;
import com.jetbrains.ide.model.uiautomation.BeScrollbarPolicy;
import com.jetbrains.ide.model.uiautomation.BeSize;
import com.jetbrains.ide.model.uiautomation.BeSpacer;
import com.jetbrains.ide.model.uiautomation.BeTreeGrid;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.ui.converters.BeConversionContext;
import com.jetbrains.rdserver.ui.converters.ConverterRegistryKt;
import com.jetbrains.rdserver.ui.converters.JPanelConverterKt;
import com.jetbrains.rdserver.ui.converters.RdConverter;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdserver/ui/converters/JScrollPaneConverter;", "Lcom/jetbrains/rdserver/ui/converters/RdConverter;", "Ljavax/swing/JScrollPane;", "<init>", "()V", "convert", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "component", "trackOptions", "Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "buildView", "Ljavax/swing/JViewport;", "hasOwnScrollPane", "", "getHasOwnScrollPane", "(Lcom/jetbrains/ide/model/uiautomation/BeControl;)Z", "intellij.platform.backend.split"})
public final class JScrollPaneConverter
implements RdConverter<JScrollPane> {
    @Override
    @NotNull
    public BeControl convert(@NotNull JScrollPane component, @NotNull TrackOptions trackOptions, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)trackOptions, (String)"trackOptions");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        JViewport jViewport = component.getViewport();
        Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"getViewport(...)");
        return (BeControl)JPanelConverterKt.createDynamicContainer((Container)jViewport, trackOptions, lifetime, (Function3)new Function3<JViewport, TrackOptions, Lifetime, BeControl>((Object)this){

            public final BeControl invoke(JViewport p0, TrackOptions p1, Lifetime p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return JScrollPaneConverter.access$buildView((JScrollPaneConverter)this.receiver, p0, p1, p2);
            }
        });
    }

    private final BeControl buildView(JViewport component, TrackOptions trackOptions, Lifetime lifetime) {
        boolean hasVertical;
        Container container = component.getParent();
        JScrollPane jScrollPane = container instanceof JScrollPane ? (JScrollPane)container : null;
        if (jScrollPane == null) {
            return (BeControl)new BeSpacer();
        }
        JScrollPane scrollPane = jScrollPane;
        Component component2 = component.getView();
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getView(...)");
        BeControl viewportModel = ConverterRegistryKt.toBeModel(component2, trackOptions, lifetime, BeConversionContext.SCROLL_PANE);
        if (this.getHasOwnScrollPane(viewportModel)) {
            return viewportModel;
        }
        boolean hasHorizontal = scrollPane.getHorizontalScrollBarPolicy() != 31;
        boolean bl = hasVertical = scrollPane.getVerticalScrollBarPolicy() != 21;
        BeScrollbarPolicy scrollBarPolicy = hasHorizontal ? (hasVertical ? BeScrollbarPolicy.BOTH : BeScrollbarPolicy.HORIZONTAL) : (hasVertical ? BeScrollbarPolicy.VERTICAL : BeScrollbarPolicy.NONE);
        BeControlSizePredefined size = new BeControlSizePredefined(new BeSize(BeControlSizeType.FIT_TO_CONTENT, 1), new BeSize(BeControlSizeType.FIT_TO_CONTENT, 1));
        return (BeControl)new BeScrollablePanel(scrollBarPolicy, (BeControlSize)size, viewportModel);
    }

    private final boolean getHasOwnScrollPane(BeControl $this$hasOwnScrollPane) {
        return BeGetterExtensionsKt.innerControl((BeControl)$this$hasOwnScrollPane) instanceof BeTreeGrid || BeGetterExtensionsKt.innerControl((BeControl)$this$hasOwnScrollPane) instanceof BeEditorImpl;
    }

    public static final /* synthetic */ BeControl access$buildView(JScrollPaneConverter $this, JViewport component, TrackOptions trackOptions, Lifetime lifetime) {
        return $this.buildView(component, trackOptions, lifetime);
    }
}

