/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.vfs;

import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.CoroutineHelpersKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ApplicationKt;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.codeWithMe.model.RdFileIconParams;
import com.jetbrains.codeWithMe.model.RdFileProperties;
import com.jetbrains.codeWithMe.model.RdFileSnapshot;
import com.jetbrains.codeWithMe.model.RdFindFileParams;
import com.jetbrains.codeWithMe.model.VfsModel;
import com.jetbrains.codeWithMe.model.VfsModel_GeneratedKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.model.RdFileIdInMem;
import com.jetbrains.rd.ide.model.RdFileIdNew;
import com.jetbrains.rd.ide.model.RdFileIdOld;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.lang.ProtocolLanguageManagerKt;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.platform.util.ListenersKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdserver.core.RemoteClientSessionListener;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.permissions.ClientPermissionListener;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import com.jetbrains.rdserver.permissions.PermissionModel;
import com.jetbrains.rdserver.vfs.BackendVirtualFileSystemHost;
import com.jetbrains.rdserver.vfs.BackendVirtualFileSystemHostListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000 :2\u00020\u0001:\u00039:;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0080@\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u0004\u0018\u00010\u00142\u0006\u0010(\u001a\u00020\fJ\u0012\u0010)\u001a\u0004\u0018\u00010\u00142\u0006\u0010(\u001a\u00020\fH\u0002J\u0014\u0010*\u001a\u00020+*\u00020\u00142\u0006\u0010,\u001a\u00020-H\u0002J\f\u0010.\u001a\u00020/*\u00020\u0014H\u0002J\f\u00100\u001a\u00020/*\u00020\u0014H\u0002J\u001a\u00101\u001a\u0004\u0018\u00010\f2\u0006\u00102\u001a\u00020\u00142\b\b\u0002\u0010,\u001a\u00020-J\"\u00103\u001a\u0002042\u0006\u0010(\u001a\u00020\f2\b\u00102\u001a\u0004\u0018\u00010\u00142\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00105\u001a\u00020\f2\u0006\u00106\u001a\u00020\u0014H\u0002J\f\u00107\u001a\b\u0012\u0004\u0012\u00020\f08R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u0010\u001a'\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013\u0012\u000e\u0012\f0\u0014\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u00130\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\u0015\u001aN\u0012\u000e\u0012\f0\u0014\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\f0\f \u0016*%\u0012\u000e\u0012\f0\u0014\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\f0\f0\u0017\u00a2\u0006\u0002\b\u00120\u000b\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006<"}, d2={"Lcom/jetbrains/rdserver/vfs/BackendVirtualFileSystemHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "secretNumber", "", "lock", "", "syncedFiles", "", "Lcom/jetbrains/rd/ide/model/RdFileId;", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "pendingFiles", "", "idToLightVirtualFile", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/openapi/vfs/VirtualFile;", "lightVirtualFileToId", "kotlin.jvm.PlatformType", "", "bindToModel", "", "vfsModel", "Lcom/jetbrains/codeWithMe/model/VfsModel;", "permissionManager", "Lcom/jetbrains/rdserver/permissions/ClientPermissionManager;", "getPermissionManager", "()Lcom/jetbrains/rdserver/permissions/ClientPermissionManager;", "getVfsModel", "()Lcom/jetbrains/codeWithMe/model/VfsModel;", "awaitProtocolVfsConnection", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "awaitProtocolVfsConnection$intellij_platform_backend_split", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findVirtualFile", "fileId", "findVirtualFileImpl", "toModel", "Lcom/jetbrains/codeWithMe/model/RdFileProperties;", "sendContent", "", "contentsToByteArraySafe", "", "contentsToByteArrayDecompileIfNeeded", "bindFile", "file", "syncFile", "Lcom/jetbrains/codeWithMe/model/RdFileSnapshot;", "createId", "virtualFile", "getSyncedFileIds", "", "EarlyModelInitializer", "Companion", "Listener", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendVirtualFileSystemHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendVirtualFileSystemHost.kt\ncom/jetbrains/rdserver/vfs/BackendVirtualFileSystemHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n*L\n1#1,368:1\n82#2,3:369\n60#2,5:372\n67#2,4:377\n67#2,4:381\n13#2:388\n66#3,3:385\n*S KotlinDebug\n*F\n+ 1 BackendVirtualFileSystemHost.kt\ncom/jetbrains/rdserver/vfs/BackendVirtualFileSystemHost\n*L\n197#1:369,3\n268#1:372,5\n296#1:377,4\n303#1:381,4\n342#1:388\n320#1:385,3\n*E\n"})
public final class BackendVirtualFileSystemHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    private final int secretNumber;
    @NotNull
    private final Object lock;
    @NotNull
    private final Map<RdFileId, LifetimeDefinition> syncedFiles;
    @NotNull
    private final Set<RdFileId> pendingFiles;
    @NotNull
    private final ConcurrentMap<RdFileId, VirtualFile> idToLightVirtualFile;
    @NotNull
    private final Map<VirtualFile, RdFileId> lightVirtualFileToId;
    @NotNull
    private static final Logger LOG;

    public BackendVirtualFileSystemHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.secretNumber = RandomKt.Random((long)System.currentTimeMillis()).nextInt(0, Integer.MAX_VALUE);
        this.lock = new Object();
        this.syncedFiles = new LinkedHashMap();
        this.pendingFiles = new LinkedHashSet();
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        this.idToLightVirtualFile = concurrentMap;
        Map map2 = ContainerUtil.createSoftKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSoftKeySoftValueMap(...)");
        this.lightVirtualFileToId = map2;
    }

    private final void bindToModel(VfsModel vfsModel) {
        BackendVirtualFileSystemHostListener fileSystemHostListener = (BackendVirtualFileSystemHostListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(BackendVirtualFileSystemHostListener.TOPIC);
        CoroutineHelpersKt.setSuspend$default((IRdEndpoint)((IRdEndpoint)vfsModel.getFindFile()), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function3)((Function3)new Function3<Lifetime, RdFindFileParams, Continuation<? super RdFileSnapshot>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ BackendVirtualFileSystemHost this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                RdFindFileParams rdFindFileParams = (RdFindFileParams)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void params;
                        ResultKt.throwOnFailure((Object)$result);
                        RdFileId fileId = params.getId();
                        if (fileId != null) {
                            VirtualFile virtualFile = this.this$0.findVirtualFile(fileId);
                            if (virtualFile == null) {
                                return null;
                            }
                            VirtualFile file2 = virtualFile;
                            return BackendVirtualFileSystemHost.access$syncFile(this.this$0, fileId, file2, params.getSendContent());
                        }
                        String string = params.getPath();
                        if (string == null) {
                            return null;
                        }
                        String path = string;
                        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
                        if (virtualFile == null) {
                            return null;
                        }
                        VirtualFile fileByPath = virtualFile;
                        if (!BackendVirtualFileSystemHost.access$getPermissionManager(this.this$0).isVisible(fileByPath)) {
                            return null;
                        }
                        return BackendVirtualFileSystemHost.access$syncFile(this.this$0, BackendVirtualFileSystemHost.access$createId(this.this$0, fileByPath), fileByPath, params.getSendContent());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(Lifetime p1, RdFindFileParams p2, Continuation<? super RdFileSnapshot> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        CoroutineHelpersKt.adviseSuspend$default((ISource)((ISource)vfsModel.getStartSyncing()), (Lifetime)this.getServiceLifetime(), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<RdFileId, Continuation<? super Unit>, Object>(this, fileSystemHostListener, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ BackendVirtualFileSystemHost this$0;
            final /* synthetic */ BackendVirtualFileSystemHostListener $fileSystemHostListener;
            {
                this.this$0 = $receiver;
                this.$fileSystemHostListener = $fileSystemHostListener;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                RdFileId rdFileId = (RdFileId)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        LifetimeDefinition lifetimeDefinition = new LifetimeDefinition(BackendVirtualFileSystemHost.access$getServiceLifetime(this.this$0));
                        Object object = BackendVirtualFileSystemHost.access$getLock$p(this.this$0);
                        BackendVirtualFileSystemHost backendVirtualFileSystemHost = this.this$0;
                        Object object2 = object;
                        synchronized (object2) {
                            boolean bl = false;
                            BackendVirtualFileSystemHost.access$getPendingFiles$p(backendVirtualFileSystemHost).remove(it);
                            BackendVirtualFileSystemHost.access$getSyncedFiles$p(backendVirtualFileSystemHost).put(it, lifetimeDefinition);
                            Logger $this$debug_u24default$iv = BackendVirtualFileSystemHost.access$getLOG$cp();
                            Throwable t$iv = null;
                            boolean $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                Logger logger = $this$debug_u24default$iv;
                                boolean bl2 = false;
                                logger.debug("Starting to sync file " + (RdFileId)it, t$iv);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        this.$fileSystemHostListener.fileSynchronized(BackendVirtualFileSystemHost.access$getSession$p(this.this$0), (RdFileId)it, lifetimeDefinition.getLifetime());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(RdFileId p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)4, null);
        CoroutineHelpersKt.adviseSuspend$default((ISource)((ISource)vfsModel.getStopSyncing()), (Lifetime)this.getServiceLifetime(), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<List<? extends RdFileId>, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ BackendVirtualFileSystemHost this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                List list = (List)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object = BackendVirtualFileSystemHost.access$getLock$p(this.this$0);
                        BackendVirtualFileSystemHost backendVirtualFileSystemHost = this.this$0;
                        Object object2 = object;
                        synchronized (object2) {
                            void it;
                            boolean bl = false;
                            for (RdFileId fileToRemove : CollectionsKt.toSet((Iterable)((Iterable)it))) {
                                LifetimeDefinition lifetimeDefinition = (LifetimeDefinition)BackendVirtualFileSystemHost.access$getSyncedFiles$p(backendVirtualFileSystemHost).remove(fileToRemove);
                                if (lifetimeDefinition == null) continue;
                                Boxing.boxBoolean((boolean)LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null));
                            }
                            Logger $this$debug_u24default$iv = BackendVirtualFileSystemHost.access$getLOG$cp();
                            Throwable t$iv = null;
                            boolean $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                Logger logger = $this$debug_u24default$iv;
                                boolean bl2 = false;
                                logger.debug("Stopped syncing of files " + CollectionsKt.joinToString$default((Iterable)((Iterable)it), null, null, null, (int)0, null, null, (int)63, null), t$iv);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(List<? extends RdFileId> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)4, null);
        MessageBus messageBus = ApplicationKt.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        Lifetime lifetime = this.getServiceLifetime();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        ListenersKt.subscribe((MessageBus)messageBus, (Lifetime)lifetime, (Topic)topic, (Object)new BulkFileListener(this, vfsModel){
            final /* synthetic */ BackendVirtualFileSystemHost this$0;
            final /* synthetic */ VfsModel $vfsModel;
            {
                this.this$0 = $receiver;
                this.$vfsModel = $vfsModel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    Set set;
                    VirtualFile file2;
                    if ((!(vFileEvent instanceof VFilePropertyChangeEvent) || !Intrinsics.areEqual((Object)((VFilePropertyChangeEvent)vFileEvent).getPropertyName(), (Object)"writable") && !Intrinsics.areEqual((Object)((VFilePropertyChangeEvent)vFileEvent).getPropertyName(), (Object)"name")) && !(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileDeleteEvent) || vFileEvent.getFile() == null) continue;
                    RdFileId fileId = BackendVirtualFileSystemHost.access$createId(this.this$0, file2);
                    Object object = BackendVirtualFileSystemHost.access$getLock$p(this.this$0);
                    BackendVirtualFileSystemHost backendVirtualFileSystemHost = this.this$0;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        set = SetsKt.plus(BackendVirtualFileSystemHost.access$getSyncedFiles$p(backendVirtualFileSystemHost).keySet(), (Iterable)BackendVirtualFileSystemHost.access$getPendingFiles$p(backendVirtualFileSystemHost));
                    }
                    if (!set.contains(fileId)) continue;
                    RdFileSnapshot snapshot2 = new RdFileSnapshot(fileId, BackendVirtualFileSystemHost.access$toModel(this.this$0, file2, false));
                    this.$vfsModel.getUpdates().fire((Object)snapshot2);
                }
            }
        });
        CoroutineHelpersKt.setSuspend$default((IRdEndpoint)((IRdEndpoint)vfsModel.getGetFileIcon()), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function3)((Function3)new Function3<Lifetime, RdFileIconParams, Continuation<? super IconModel>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ BackendVirtualFileSystemHost this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                RdFileIconParams rdFileIconParams = (RdFileIconParams)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void param;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)param);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super IconModel>, Object>(this.this$0, (RdFileIconParams)param, null){
                            Object L$0;
                            Object L$1;
                            int label;
                            final /* synthetic */ BackendVirtualFileSystemHost this$0;
                            final /* synthetic */ RdFileIconParams $param;
                            {
                                this.this$0 = $receiver;
                                this.$param = $param;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ReadConstraint[] readConstraintArray;
                                        Project project;
                                        ResultKt.throwOnFailure((Object)$result);
                                        ClientProjectSession clientProjectSession = SessionUtilKt.getProjectSession((ClientAppSession)BackendVirtualFileSystemHost.access$getSession$p(this.this$0), (RdProjectId)this.$param.getProjectId());
                                        Project project2 = project = clientProjectSession != null ? clientProjectSession.getProject() : null;
                                        if (project2 != null) {
                                            Project it = project2;
                                            boolean bl = false;
                                            ReadConstraint[] readConstraintArray2 = new ReadConstraint[]{ReadConstraint.Companion.withDocumentsCommitted(it)};
                                            readConstraintArray = readConstraintArray2;
                                        } else {
                                            readConstraintArray = new ReadConstraint[]{};
                                        }
                                        ReadConstraint[] constraints = readConstraintArray;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)constraints);
                                        this.label = 1;
                                        Object object2 = CoroutinesKt.constrainedReadAction((ReadConstraint[])Arrays.copyOf(constraints, constraints.length), () -> bindToModel.1.invokeSuspend$lambda$1(this.this$0, this.$param, project), (Continuation)((Continuation)this));
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ReadConstraint[] constraints = (ReadConstraint[])this.L$1;
                                        Project project = (Project)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super IconModel> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final IconModel invokeSuspend$lambda$1(BackendVirtualFileSystemHost this$0, RdFileIconParams $param, Project $project) {
                                Logger $this$trace$iv = BackendVirtualFileSystemHost.access$getLOG$cp();
                                boolean $i$f$trace = false;
                                if ($this$trace$iv.isTraceEnabled()) {
                                    Logger logger = $this$trace$iv;
                                    boolean bl = false;
                                    logger.trace("getFileIcon request for " + $param + "...");
                                }
                                VirtualFile virtualFile = this$0.findVirtualFile($param.getFileId());
                                if (virtualFile == null) {
                                    return null;
                                }
                                VirtualFile file2 = virtualFile;
                                Icon icon2 = IconUtil.getIcon((VirtualFile)file2, (int)$param.getFlags(), (Project)$project);
                                return UtilKt.toModel((Icon)icon2);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(Lifetime p1, RdFileIconParams p2, Continuation<? super IconModel> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        CoroutineHelpersKt.setSuspend$default((IRdEndpoint)((IRdEndpoint)vfsModel.getGetContent()), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function3)((Function3)new Function3<Lifetime, RdFileId, Continuation<? super byte[]>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ BackendVirtualFileSystemHost this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                RdFileId rdFileId = (RdFileId)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        byte[] byArray;
                        void fileId;
                        ResultKt.throwOnFailure((Object)$result);
                        VirtualFile file2 = this.this$0.findVirtualFile((RdFileId)fileId);
                        return file2 != null && (byArray = BackendVirtualFileSystemHost.access$contentsToByteArrayDecompileIfNeeded(this.this$0, file2)) != null ? byArray : new byte[]{};
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(Lifetime p1, RdFileId p2, Continuation<? super byte[]> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.getServiceLifetime(), null, (int)1, null);
        ApplicationKt.getApplication().getMessageBus().connect(disposable).subscribe(ClientPermissionListener.Companion.getTOPIC(), (Object)new ClientPermissionListener(this, vfsModel){
            final /* synthetic */ BackendVirtualFileSystemHost this$0;
            final /* synthetic */ VfsModel $vfsModel;
            {
                this.this$0 = $receiver;
                this.$vfsModel = $vfsModel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void permissionsChanged(ClientAppSession session, PermissionModel old, PermissionModel permissionModel) {
                Set $i$a$-synchronized-BackendVirtualFileSystemHost$bindToModel$7$permissionsChanged$22;
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)old, (String)"old");
                Intrinsics.checkNotNullParameter((Object)permissionModel, (String)"new");
                if (!Intrinsics.areEqual((Object)BackendVirtualFileSystemHost.access$getSession$p(this.this$0), (Object)session)) {
                    return;
                }
                Object object = BackendVirtualFileSystemHost.access$getLock$p(this.this$0);
                BackendVirtualFileSystemHost backendVirtualFileSystemHost = this.this$0;
                Object object2 = object;
                synchronized (object2) {
                    boolean $i$a$-synchronized-BackendVirtualFileSystemHost$bindToModel$7$permissionsChanged$22 = false;
                    $i$a$-synchronized-BackendVirtualFileSystemHost$bindToModel$7$permissionsChanged$22 = SetsKt.plus(BackendVirtualFileSystemHost.access$getSyncedFiles$p(backendVirtualFileSystemHost).keySet(), (Iterable)BackendVirtualFileSystemHost.access$getPendingFiles$p(backendVirtualFileSystemHost));
                }
                for (RdFileId fileId : $i$a$-synchronized-BackendVirtualFileSystemHost$bindToModel$7$permissionsChanged$22) {
                    VirtualFile file2 = this.this$0.findVirtualFile(fileId);
                    RdFileProperties properties = file2 != null ? BackendVirtualFileSystemHost.access$toModel(this.this$0, file2, false) : null;
                    RdFileSnapshot snapshot2 = new RdFileSnapshot(fileId, properties);
                    this.$vfsModel.getUpdates().fire((Object)snapshot2);
                }
            }
        });
    }

    private final ClientPermissionManager getPermissionManager() {
        return ClientPermissionManager.Companion.getInstance(this.session);
    }

    private final VfsModel getVfsModel() {
        return VfsModel_GeneratedKt.getVfsModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol(this.session)));
    }

    @Nullable
    public final Object awaitProtocolVfsConnection$intellij_platform_backend_split(@NotNull Lifetime lifetime, @NotNull Continuation<? super Unit> $completion) {
        CompletableDeferred vfsConnected = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        SourceExKt.adviseUntil((ISource)((ISource)this.getVfsModel().getConnected()), (Lifetime)lifetime, arg_0 -> BackendVirtualFileSystemHost.awaitProtocolVfsConnection$lambda$0(vfsConnected, arg_0));
        Object object = vfsConnected.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final VirtualFile findVirtualFile(@NotNull RdFileId fileId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Logger $this$runAndLogException$iv = LOG;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            object = Result.constructor-impl((Object)this.findVirtualFileImpl(fileId));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (VirtualFile)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    private final VirtualFile findVirtualFileImpl(RdFileId fileId) {
        VirtualFile virtualFile;
        RdFileId rdFileId = fileId;
        if (rdFileId instanceof RdFileIdNew) {
            if (((RdFileIdNew)fileId).getManagingFsCreationTimestamp() != ManagingFS.getInstance().getCreationTimestamp()) {
                return null;
            }
            virtualFile = VirtualFileManager.getInstance().findFileById(((RdFileIdNew)fileId).getBackendId());
            if (virtualFile == null) {
                return null;
            }
        } else if (rdFileId instanceof RdFileIdOld) {
            VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem(((RdFileIdOld)fileId).getProtocol());
            if (fileSystem == null) {
                LOG.error("file system is not found for " + fileId);
                return null;
            }
            virtualFile = fileSystem.findFileByPath(((RdFileIdOld)fileId).getPath());
            if (virtualFile == null) {
                return null;
            }
        } else if (rdFileId instanceof RdFileIdInMem) {
            VirtualFile cachedLightFile = (VirtualFile)this.idToLightVirtualFile.get(fileId);
            if (cachedLightFile == null) {
                return null;
            }
            virtualFile = cachedLightFile;
        } else {
            return null;
        }
        VirtualFile file2 = virtualFile;
        if (!this.getPermissionManager().isVisible(file2)) {
            return null;
        }
        return file2;
    }

    private final RdFileProperties toModel(VirtualFile $this$toModel, boolean sendContent) {
        String string = $this$toModel.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = $this$toModel.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String string3 = $this$toModel.getFileSystem().getProtocol();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProtocol(...)");
        boolean bl = this.getPermissionManager().isVisible($this$toModel) && $this$toModel.isValid();
        long l = $this$toModel.getTimeStamp();
        long l2 = $this$toModel.getModificationStamp();
        long l3 = $this$toModel.getLength();
        byte[] byArray = sendContent ? this.contentsToByteArraySafe($this$toModel) : null;
        boolean bl2 = $this$toModel.isWritable();
        FileType fileType = $this$toModel.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return new RdFileProperties(string, string2, string3, bl, l, l2, l3, byArray, bl2, ProtocolLanguageManagerKt.toModel((FileType)fileType), FileEditorManagerImpl.Companion.forbidSplitFor($this$toModel));
    }

    private final byte[] contentsToByteArraySafe(VirtualFile $this$contentsToByteArraySafe) {
        byte[] byArray;
        try {
            byArray = $this$contentsToByteArraySafe.contentsToByteArray();
            Intrinsics.checkNotNull((Object)byArray);
        }
        catch (IOException ioException) {
            LOG.warn("IO exception occurred while reading content of file '" + $this$contentsToByteArraySafe + "'. Empty byte array will be returned", (Throwable)ioException);
            byArray = new byte[]{};
        }
        catch (UnsupportedOperationException uoException) {
            LOG.warn("Virtual file '" + $this$contentsToByteArraySafe + "' doesn't support reading content. Empty byte array will be returned", (Throwable)uoException);
            byArray = new byte[]{};
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception occurred while reading content of file '" + $this$contentsToByteArraySafe + "'. Empty byte array will be returned", t);
            byArray = new byte[]{};
        }
        return byArray;
    }

    private final byte[] contentsToByteArrayDecompileIfNeeded(VirtualFile $this$contentsToByteArrayDecompileIfNeeded) {
        if (!$this$contentsToByteArrayDecompileIfNeeded.getFileType().isBinary()) {
            return this.contentsToByteArraySafe($this$contentsToByteArrayDecompileIfNeeded);
        }
        try {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.getInstance().forFileType($this$contentsToByteArrayDecompileIfNeeded.getFileType());
            if (decompiler != null) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("decompiling file " + $this$contentsToByteArrayDecompileIfNeeded + "...", t$iv);
                }
                CharSequence charSequence = decompiler.decompile($this$contentsToByteArrayDecompileIfNeeded);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"decompile(...)");
                CharSequence text = charSequence;
                String string = ((Object)text).toString();
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                return byArray;
            }
        }
        catch (Throwable t) {
            LOG.warn("error while decompiling file " + $this$contentsToByteArrayDecompileIfNeeded, t);
        }
        return this.contentsToByteArraySafe($this$contentsToByteArrayDecompileIfNeeded);
    }

    @Nullable
    public final RdFileId bindFile(@NotNull VirtualFile file2, boolean sendContent) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.getPermissionManager().isVisible(file2)) {
            LOG.warn("Read-access denied for " + this.session + " virtualFile=" + file2);
            return null;
        }
        RdFileId fileId = this.createId(file2);
        this.syncFile(fileId, file2, sendContent);
        return fileId;
    }

    public static /* synthetic */ RdFileId bindFile$default(BackendVirtualFileSystemHost backendVirtualFileSystemHost, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return backendVirtualFileSystemHost.bindFile(virtualFile, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RdFileSnapshot syncFile(RdFileId fileId, VirtualFile file2, boolean sendContent) {
        Logger logger;
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Syncing file with fileId=" + fileId + " for file=" + file2);
        }
        VirtualFile virtualFile = file2;
        RdFileSnapshot snapshot2 = new RdFileSnapshot(fileId, virtualFile != null ? this.toModel(virtualFile, sendContent) : null);
        Object bl = this.lock;
        synchronized (bl) {
            boolean $i$a$-synchronized-BackendVirtualFileSystemHost$syncFile$32 = false;
            if (!this.syncedFiles.containsKey(fileId)) {
                this.pendingFiles.add(fileId);
            }
            Unit $i$a$-synchronized-BackendVirtualFileSystemHost$syncFile$32 = Unit.INSTANCE;
        }
        Logger $this$trace$iv2 = LOG;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl2 = false;
            logger.trace("Sending file snapshot: " + snapshot2);
        }
        this.getVfsModel().getUpdates().fire((Object)snapshot2);
        return snapshot2;
    }

    /*
     * WARNING - void declaration
     */
    private final RdFileId createId(VirtualFile virtualFile) {
        RdFileId rdFileId;
        VirtualFile file2 = null;
        file2 = virtualFile;
        while (file2 instanceof BackedVirtualFile) {
            Intrinsics.checkNotNullExpressionValue((Object)((BackedVirtualFile)file2).getOriginFile(), (String)"getOriginFile(...)");
        }
        VirtualFile virtualFile2 = file2;
        if (virtualFile2 instanceof NewVirtualFile) {
            int backendId = ((NewVirtualFile)file2).getId();
            int frontendId = this.session.isController() && Registry.Companion.is("editor.rd.reopen.editors.on.frontend") ? ((NewVirtualFile)file2).getId() : ((NewVirtualFile)file2).getId() ^ this.secretNumber;
            rdFileId = (RdFileId)new RdFileIdNew(backendId, frontendId, ManagingFS.getInstance().getCreationTimestamp());
        } else if (virtualFile2 instanceof LightVirtualFileBase || virtualFile2 instanceof VcsVirtualFile) {
            void $this$getOrCreate$iv;
            Map<VirtualFile, RdFileId> frontendId = this.lightVirtualFileToId;
            VirtualFile key$iv = file2;
            boolean $i$f$getOrCreate = false;
            Object object = $this$getOrCreate$iv.get(key$iv);
            if (object == null) {
                VirtualFile it = key$iv;
                boolean bl = false;
                String string = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                RdFileIdInMem id = new RdFileIdInMem(string);
                ((Map)this.idToLightVirtualFile).put(id, file2);
                RdFileId it$iv = (RdFileId)id;
                boolean bl2 = false;
                $this$getOrCreate$iv.put(key$iv, it$iv);
                object = it$iv;
            }
            Object backendId = object;
            Intrinsics.checkNotNull(backendId);
            rdFileId = (RdFileId)backendId;
        } else {
            String string = file2.getFileSystem().getProtocol();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProtocol(...)");
            String protocol = string;
            String string2 = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            rdFileId = (RdFileId)new RdFileIdOld(protocol, string2);
        }
        return rdFileId;
    }

    @NotNull
    public final List<RdFileId> getSyncedFileIds() {
        return CollectionsKt.toList((Iterable)this.syncedFiles.keySet());
    }

    private static final boolean awaitProtocolVfsConnection$lambda$0(CompletableDeferred $vfsConnected, boolean connected) {
        if (!connected) {
            return false;
        }
        $vfsConnected.complete((Object)Unit.INSTANCE);
        return true;
    }

    public static final /* synthetic */ RdFileSnapshot access$syncFile(BackendVirtualFileSystemHost $this, RdFileId fileId, VirtualFile file2, boolean sendContent) {
        return $this.syncFile(fileId, file2, sendContent);
    }

    public static final /* synthetic */ ClientPermissionManager access$getPermissionManager(BackendVirtualFileSystemHost $this) {
        return $this.getPermissionManager();
    }

    public static final /* synthetic */ RdFileId access$createId(BackendVirtualFileSystemHost $this, VirtualFile virtualFile) {
        return $this.createId(virtualFile);
    }

    public static final /* synthetic */ Lifetime access$getServiceLifetime(BackendVirtualFileSystemHost $this) {
        return $this.getServiceLifetime();
    }

    public static final /* synthetic */ Object access$getLock$p(BackendVirtualFileSystemHost $this) {
        return $this.lock;
    }

    public static final /* synthetic */ Set access$getPendingFiles$p(BackendVirtualFileSystemHost $this) {
        return $this.pendingFiles;
    }

    public static final /* synthetic */ Map access$getSyncedFiles$p(BackendVirtualFileSystemHost $this) {
        return $this.syncedFiles;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ ClientAppSession access$getSession$p(BackendVirtualFileSystemHost $this) {
        return $this.session;
    }

    public static final /* synthetic */ RdFileProperties access$toModel(BackendVirtualFileSystemHost $this, VirtualFile $receiver, boolean sendContent) {
        return $this.toModel($receiver, sendContent);
    }

    public static final /* synthetic */ byte[] access$contentsToByteArrayDecompileIfNeeded(BackendVirtualFileSystemHost $this, VirtualFile $receiver) {
        return $this.contentsToByteArrayDecompileIfNeeded($receiver);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendVirtualFileSystemHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/vfs/BackendVirtualFileSystemHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdserver/vfs/BackendVirtualFileSystemHost;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendVirtualFileSystemHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendVirtualFileSystemHost.kt\ncom/jetbrains/rdserver/vfs/BackendVirtualFileSystemHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,368:1\n23#2:369\n*S KotlinDebug\n*F\n+ 1 BackendVirtualFileSystemHost.kt\ncom/jetbrains/rdserver/vfs/BackendVirtualFileSystemHost$Companion\n*L\n341#1:369\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="use helper functions bind/fromModel")
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public final BackendVirtualFileSystemHost getInstance(@NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session.getAppSession();
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(BackendVirtualFileSystemHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (BackendVirtualFileSystemHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/vfs/BackendVirtualFileSystemHost$EarlyModelInitializer;", "Lcom/jetbrains/rdserver/core/RemoteClientSessionListener;", "<init>", "()V", "beforeAppSessionInitialized", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendVirtualFileSystemHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendVirtualFileSystemHost.kt\ncom/jetbrains/rdserver/vfs/BackendVirtualFileSystemHost$EarlyModelInitializer\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,368:1\n23#2:369\n*S KotlinDebug\n*F\n+ 1 BackendVirtualFileSystemHost.kt\ncom/jetbrains/rdserver/vfs/BackendVirtualFileSystemHost$EarlyModelInitializer\n*L\n88#1:369\n*E\n"})
    public static final class EarlyModelInitializer
    implements RemoteClientSessionListener {
        @Override
        public void beforeAppSessionInitialized(@NotNull Lifetime lifetime, @NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Protocol protocol = RemoteSessionKt.getProtocol(session);
            VfsModel model2 = VfsModel_GeneratedKt.getVfsModel((IProtocol)((IProtocol)protocol));
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(BackendVirtualFileSystemHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            ((BackendVirtualFileSystemHost)((Object)object)).bindToModel(model2);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/vfs/BackendVirtualFileSystemHost$Listener;", "Ljava/util/EventListener;", "onSyncedFileAdded", "", "fileId", "Lcom/jetbrains/rd/ide/model/RdFileId;", "onSyncedFileRemoved", "intellij.platform.backend.split"})
    public static interface Listener
    extends EventListener {
        public void onSyncedFileAdded(@NotNull RdFileId var1);

        public void onSyncedFileRemoved(@NotNull RdFileId var1);
    }
}

