/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.codeInsight.attributes;

import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 \u00042\u00020\u0001:\u0005\u0004\u0005\u0006\u0007\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\t"}, d2={"Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser;", "", "<init>", "()V", "Companion", "VueAttributeInfo", "VueDirectiveInfo", "VueAttributeKind", "VueDirectiveKind", "intellij.vuejs.common"})
@SourceDebugExtension(value={"SMAP\nVueAttributeNameParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueAttributeNameParser.kt\norg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,292:1\n1342#2,2:293\n*S KotlinDebug\n*F\n+ 1 VueAttributeNameParser.kt\norg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser\n*L\n137#1:293,2\n*E\n"})
public final class VueAttributeNameParser {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final MultiMap<String, VueAttributeKind> attributeKindMap;
    @NotNull
    private static final Map<String, VueDirectiveKind> directiveKindMap;

    private VueAttributeNameParser() {
    }

    private static final boolean _init_$lambda$0(VueAttributeKind it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getAttributeName() != null;
    }

    static {
        Map map;
        Companion = new Companion(null);
        attributeKindMap = new MultiMap();
        Map $this$directiveKindMap_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (VueDirectiveKind directive : VueDirectiveKind.getEntries()) {
            String name;
            if (directive.getDirectiveName() == null) continue;
            $this$directiveKindMap_u24lambda_u240.put(name, directive);
        }
        directiveKindMap = MapsKt.build((Map)map);
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)VueAttributeKind.getEntries())), VueAttributeNameParser::_init_$lambda$0);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VueAttributeKind it = (VueAttributeKind)((Object)element$iv);
            boolean bl2 = false;
            attributeKindMap.putValue((Object)it.getAttributeName(), (Object)it);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fJ$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$Companion;", "", "<init>", "()V", "parse", "Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueAttributeInfo;", "attributeName", "", "context", "", "isTopLevel", "", "Lcom/intellij/psi/xml/XmlTag;", "isValid", "Lkotlin/Function1;", "Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueAttributeKind;", "parseModifiers", "", "modifiers", "startPos", "", "attributeKindMap", "Lcom/intellij/util/containers/MultiMap;", "directiveKindMap", "", "Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueDirectiveKind;", "intellij.vuejs.common"})
    @SourceDebugExtension(value={"SMAP\nVueAttributeNameParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueAttributeNameParser.kt\norg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,292:1\n161#2,6:293\n*S KotlinDebug\n*F\n+ 1 VueAttributeNameParser.kt\norg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$Companion\n*L\n50#1:293,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VueAttributeInfo parse(@NotNull CharSequence attributeName, @Nullable String context, boolean isTopLevel) {
            Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
            return this.parse(attributeName, (Function1<? super VueAttributeKind, Boolean>)((Function1)arg_0 -> Companion.parse$lambda$0(context, isTopLevel, arg_0)));
        }

        public static /* synthetic */ VueAttributeInfo parse$default(Companion companion, CharSequence charSequence, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.parse(charSequence, string, bl);
        }

        @NotNull
        public final VueAttributeInfo parse(@NotNull CharSequence attributeName, @NotNull XmlTag context) {
            Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.parse(attributeName, (Function1<? super VueAttributeKind, Boolean>)((Function1)arg_0 -> Companion.parse$lambda$1(context, arg_0)));
        }

        private final VueAttributeInfo parse(CharSequence attributeName, Function1<? super VueAttributeKind, Boolean> isValid) {
            int n;
            if (attributeName.length() == 0) {
                return new VueAttributeInfo("", VueAttributeKind.PLAIN, null, 4, null);
            }
            String name = null;
            VueDirectiveKind kind = null;
            int paramsPos = 0;
            boolean isShorthand = false;
            if (StringsKt.startsWith$default((CharSequence)attributeName, (char)'@', (boolean)false, (int)2, null)) {
                name = "on";
                kind = VueDirectiveKind.ON;
                paramsPos = 0;
                isShorthand = true;
            } else if (StringsKt.startsWith$default((CharSequence)attributeName, (char)':', (boolean)false, (int)2, null)) {
                name = "bind";
                kind = VueDirectiveKind.BIND;
                paramsPos = 0;
                isShorthand = true;
            } else if (StringsKt.startsWith$default((CharSequence)attributeName, (char)'#', (boolean)false, (int)2, null)) {
                name = "slot";
                kind = VueDirectiveKind.SLOT;
                paramsPos = 0;
                isShorthand = true;
            } else if (StringsKt.startsWith$default((CharSequence)attributeName, (CharSequence)"v-", (boolean)false, (int)2, null) && attributeName.length() > 2) {
                int nameEnd;
                int $i$f$indexOfFirst;
                CharSequence $this$indexOfFirst$iv;
                block21: {
                    int n2;
                    $this$indexOfFirst$iv = attributeName;
                    $i$f$indexOfFirst = 0;
                    n = $this$indexOfFirst$iv.length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it = $this$indexOfFirst$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it == '.' || it == ':')) continue;
                        n2 = index$iv;
                        break block21;
                    }
                    n2 = nameEnd = -1;
                }
                if (nameEnd < 0) {
                    nameEnd = attributeName.length();
                }
                $this$indexOfFirst$iv = attributeName;
                $i$f$indexOfFirst = 2;
                name = ((Object)$this$indexOfFirst$iv.subSequence($i$f$indexOfFirst, nameEnd)).toString();
                VueDirectiveKind vueDirectiveKind = (VueDirectiveKind)((Object)directiveKindMap.get(name));
                if (vueDirectiveKind == null) {
                    vueDirectiveKind = VueDirectiveKind.CUSTOM;
                }
                kind = vueDirectiveKind;
                paramsPos = nameEnd;
            } else {
                VueAttributeKind vueAttributeKind;
                Object v3;
                int nameEnd;
                block22: {
                    nameEnd = StringsKt.indexOf$default((CharSequence)attributeName, (char)'.', (int)0, (boolean)false, (int)6, null);
                    if (nameEnd < 0) {
                        nameEnd = attributeName.length();
                    }
                    CharSequence $this$indexOfFirst$iv = attributeName;
                    int $i$f$indexOfFirst = 0;
                    name = ((Object)$this$indexOfFirst$iv.subSequence($i$f$indexOfFirst, nameEnd)).toString();
                    Collection collection = attributeKindMap.get((Object)name);
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                    Iterable iterable = collection;
                    for (Object t : iterable) {
                        if (!((Boolean)isValid.invoke(t)).booleanValue()) continue;
                        v3 = t;
                        break block22;
                    }
                    v3 = null;
                }
                if ((vueAttributeKind = (VueAttributeKind)v3) == null) {
                    vueAttributeKind = VueAttributeKind.PLAIN;
                }
                VueAttributeKind attributeKind = vueAttributeKind;
                return new VueAttributeInfo(name, attributeKind, this.parseModifiers(attributeName, nameEnd));
            }
            if (paramsPos >= attributeName.length() || attributeName.charAt(paramsPos) != '@' && attributeName.charAt(paramsPos) != ':' && attributeName.charAt(paramsPos) != '#' && attributeName.charAt(paramsPos) != '.') {
                return new VueDirectiveInfo(name, kind, null, isShorthand, null, 20, null);
            }
            String arguments = null;
            if (attributeName.charAt(paramsPos) == '.') {
                return new VueDirectiveInfo(name, kind, null, isShorthand, this.parseModifiers(attributeName, paramsPos));
            }
            int lastBracket = StringsKt.lastIndexOf$default((CharSequence)attributeName, (char)']', (int)0, (boolean)false, (int)6, null);
            if (lastBracket >= ++paramsPos && attributeName.charAt(paramsPos) == '[') {
                CharSequence $i$f$indexOfFirst = attributeName;
                int n3 = lastBracket + 1;
                arguments = ((Object)$i$f$indexOfFirst.subSequence(paramsPos, n3)).toString();
                paramsPos = lastBracket + 1;
            } else {
                int firstDot = StringsKt.indexOf$default((CharSequence)attributeName, (char)'.', (int)paramsPos, (boolean)false, (int)4, null);
                if (firstDot > 0) {
                    arguments = ((Object)attributeName.subSequence(paramsPos, firstDot)).toString();
                    paramsPos = firstDot;
                } else {
                    CharSequence charSequence = attributeName;
                    n = charSequence.length();
                    arguments = ((Object)charSequence.subSequence(paramsPos, n)).toString();
                    paramsPos = attributeName.length();
                }
            }
            return new VueDirectiveInfo(name, kind, arguments, isShorthand, this.parseModifiers(attributeName, paramsPos));
        }

        private final Set<String> parseModifiers(CharSequence modifiers, int startPos) {
            if (startPos >= modifiers.length() || modifiers.charAt(startPos) != '.') {
                return SetsKt.emptySet();
            }
            Set result = new LinkedHashSet();
            int currentIndex = startPos;
            int prevDot = startPos;
            while (++currentIndex < modifiers.length()) {
                if (modifiers.charAt(currentIndex) != '.') continue;
                if (prevDot < currentIndex) {
                    result.add(((Object)modifiers.subSequence(prevDot + 1, currentIndex)).toString());
                }
                prevDot = currentIndex;
            }
            if (prevDot < modifiers.length()) {
                CharSequence charSequence = modifiers;
                int n = prevDot + 1;
                int n2 = charSequence.length();
                result.add(((Object)charSequence.subSequence(n, n2)).toString());
            }
            return result;
        }

        private static final boolean parse$lambda$0(String $context, boolean $isTopLevel, VueAttributeKind it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return it.isValidIn($context, $isTopLevel);
        }

        private static final boolean parse$lambda$1(XmlTag $context, VueAttributeKind it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return it.isValidIn($context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0018\u001a\u00020\u0019H\u0096\u0080\u0004J\n\u0010\u001a\u001a\u00020\u0003H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueAttributeInfo;", "", "name", "", "kind", "Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueAttributeKind;", "modifiers", "", "<init>", "(Ljava/lang/String;Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueAttributeKind;Ljava/util/Set;)V", "getName", "()Ljava/lang/String;", "getKind", "()Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueAttributeKind;", "getModifiers", "()Ljava/util/Set;", "requiresValue", "", "getRequiresValue", "()Z", "injectJS", "getInjectJS", "equals", "other", "hashCode", "", "toString", "intellij.vuejs.common"})
    public static class VueAttributeInfo {
        @NotNull
        private final String name;
        @NotNull
        private final VueAttributeKind kind;
        @NotNull
        private final Set<String> modifiers;

        public VueAttributeInfo(@NotNull String name, @NotNull VueAttributeKind kind, @NotNull Set<String> modifiers) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
            this.name = name;
            this.kind = kind;
            this.modifiers = modifiers;
        }

        public /* synthetic */ VueAttributeInfo(String string, VueAttributeKind vueAttributeKind, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                set = SetsKt.emptySet();
            }
            this(string, vueAttributeKind, set);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final VueAttributeKind getKind() {
            return this.kind;
        }

        @NotNull
        public final Set<String> getModifiers() {
            return this.modifiers;
        }

        public boolean getRequiresValue() {
            return this.kind.getRequiresValue() && this.modifiers.isEmpty();
        }

        public boolean getInjectJS() {
            return this.kind.getInjectJS();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Object object2 = other;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.vuejs.codeInsight.attributes.VueAttributeNameParser.VueAttributeInfo");
            VueAttributeInfo cfr_ignored_0 = (VueAttributeInfo)object2;
            return Intrinsics.areEqual((Object)this.name, (Object)((VueAttributeInfo)other).name) && this.kind == ((VueAttributeInfo)other).kind && Intrinsics.areEqual(this.modifiers, ((VueAttributeInfo)other).modifiers);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.kind.hashCode();
            result = 31 * result + ((Object)this.modifiers).hashCode();
            return result;
        }

        @NotNull
        public String toString() {
            return this.name + " [" + this.kind + ", modifiers=" + this.modifiers + "]";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b'\n\u0002\u0018\u0002\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BG\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010*\u001a\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u0010,\u001a\u00020\u0005J\u000e\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020-R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fj\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)\u00a8\u0006."}, d2={"Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueAttributeKind;", "", "attributeName", "", "injectJS", "", "requiresValue", "deprecated", "requiresTag", "onlyTopLevelTag", "<init>", "(Ljava/lang/String;ILjava/lang/String;ZZZLjava/lang/String;Z)V", "getAttributeName", "()Ljava/lang/String;", "getInjectJS", "()Z", "getRequiresValue", "getDeprecated", "getRequiresTag", "getOnlyTopLevelTag", "PLAIN", "DIRECTIVE", "SLOT", "REF", "IS", "KEY", "SCOPE", "SLOT_SCOPE", "SLOT_NAME", "STYLE_SCOPED", "STYLE_MODULE", "STYLE_SRC", "STYLE_LANG", "TEMPLATE_FUNCTIONAL", "TEMPLATE_SRC", "TEMPLATE_LANG", "SCRIPT_ID", "SCRIPT_SRC", "SCRIPT_LANG", "SCRIPT_SETUP", "SCRIPT_VAPOR", "SCRIPT_GENERIC", "isValidIn", "context", "isTopLevel", "Lcom/intellij/psi/xml/XmlTag;", "intellij.vuejs.common"})
    public static final class VueAttributeKind
    extends Enum<VueAttributeKind> {
        @Nullable
        private final String attributeName;
        private final boolean injectJS;
        private final boolean requiresValue;
        private final boolean deprecated;
        @Nullable
        private final String requiresTag;
        private final boolean onlyTopLevelTag;
        public static final /* enum */ VueAttributeKind PLAIN = new VueAttributeKind("PLAIN", 0, null, false, false, false, null, false, 62, null);
        public static final /* enum */ VueAttributeKind DIRECTIVE = new VueAttributeKind("DIRECTIVE", 1, null, false, false, false, null, false, 62, null);
        public static final /* enum */ VueAttributeKind SLOT = new VueAttributeKind("SLOT", 2, "slot", false, false, true, null, false, 54, null);
        public static final /* enum */ VueAttributeKind REF = new VueAttributeKind("REF", 3, "ref", false, false, false, null, false, 62, null);
        public static final /* enum */ VueAttributeKind IS = new VueAttributeKind("IS", 4, "is", false, false, false, null, false, 62, null);
        public static final /* enum */ VueAttributeKind KEY = new VueAttributeKind("KEY", 5, "key", false, false, false, null, false, 62, null);
        public static final /* enum */ VueAttributeKind SCOPE = new VueAttributeKind("SCOPE", 6, "scope", true, false, true, "template", false, 4, null);
        public static final /* enum */ VueAttributeKind SLOT_SCOPE = new VueAttributeKind("SLOT_SCOPE", 7, "slot-scope", true, false, true, null, false, 52, null);
        public static final /* enum */ VueAttributeKind SLOT_NAME = new VueAttributeKind("SLOT_NAME", 8, "name", false, false, false, "slot", false, 12, null);
        public static final /* enum */ VueAttributeKind STYLE_SCOPED = new VueAttributeKind("STYLE_SCOPED", 9, "scoped", false, false, false, "style", false, 42, null);
        public static final /* enum */ VueAttributeKind STYLE_MODULE = new VueAttributeKind("STYLE_MODULE", 10, "module", false, false, false, "style", false, 42, null);
        public static final /* enum */ VueAttributeKind STYLE_SRC = new VueAttributeKind("STYLE_SRC", 11, "src", false, false, false, "style", false, 46, null);
        public static final /* enum */ VueAttributeKind STYLE_LANG = new VueAttributeKind("STYLE_LANG", 12, "lang", false, false, false, "style", false, 46, null);
        public static final /* enum */ VueAttributeKind TEMPLATE_FUNCTIONAL = new VueAttributeKind("TEMPLATE_FUNCTIONAL", 13, "functional", false, false, false, "template", false, 42, null);
        public static final /* enum */ VueAttributeKind TEMPLATE_SRC = new VueAttributeKind("TEMPLATE_SRC", 14, "src", false, false, false, "template", false, 46, null);
        public static final /* enum */ VueAttributeKind TEMPLATE_LANG = new VueAttributeKind("TEMPLATE_LANG", 15, "lang", false, false, false, "template", false, 46, null);
        public static final /* enum */ VueAttributeKind SCRIPT_ID = new VueAttributeKind("SCRIPT_ID", 16, "id", false, false, false, "script", false, 14, null);
        public static final /* enum */ VueAttributeKind SCRIPT_SRC = new VueAttributeKind("SCRIPT_SRC", 17, "src", false, false, false, "script", false, 46, null);
        public static final /* enum */ VueAttributeKind SCRIPT_LANG = new VueAttributeKind("SCRIPT_LANG", 18, "lang", false, false, false, "script", false, 46, null);
        public static final /* enum */ VueAttributeKind SCRIPT_SETUP = new VueAttributeKind("SCRIPT_SETUP", 19, "setup", false, false, false, "script", false, 40, null);
        public static final /* enum */ VueAttributeKind SCRIPT_VAPOR = new VueAttributeKind("SCRIPT_VAPOR", 20, "vapor", false, false, false, "script", false, 40, null);
        public static final /* enum */ VueAttributeKind SCRIPT_GENERIC = new VueAttributeKind("SCRIPT_GENERIC", 21, "generic", true, true, false, "script", false, 8, null);
        private static final /* synthetic */ VueAttributeKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private VueAttributeKind(String attributeName, boolean injectJS, boolean requiresValue, boolean deprecated, String requiresTag, boolean onlyTopLevelTag) {
            this.attributeName = attributeName;
            this.injectJS = injectJS;
            this.requiresValue = requiresValue;
            this.deprecated = deprecated;
            this.requiresTag = requiresTag;
            this.onlyTopLevelTag = onlyTopLevelTag;
        }

        /* synthetic */ VueAttributeKind(String string, int n, String string2, boolean bl, boolean bl2, boolean bl3, String string3, boolean bl4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            if ((n2 & 4) != 0) {
                bl2 = true;
            }
            if ((n2 & 8) != 0) {
                bl3 = false;
            }
            if ((n2 & 0x10) != 0) {
                string3 = null;
            }
            if ((n2 & 0x20) != 0) {
                bl4 = true;
            }
            this(string2, bl, bl2, bl3, string3, bl4);
        }

        @Nullable
        public final String getAttributeName() {
            return this.attributeName;
        }

        public final boolean getInjectJS() {
            return this.injectJS;
        }

        public final boolean getRequiresValue() {
            return this.requiresValue;
        }

        public final boolean getDeprecated() {
            return this.deprecated;
        }

        @Nullable
        public final String getRequiresTag() {
            return this.requiresTag;
        }

        public final boolean getOnlyTopLevelTag() {
            return this.onlyTopLevelTag;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isValidIn(@Nullable String context, boolean isTopLevel) {
            String string;
            if (this.requiresTag == null) return true;
            if (this.onlyTopLevelTag) {
                if (!isTopLevel) return false;
            }
            String string2 = context;
            if (string2 != null) {
                String string3 = string2;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string4 = string3.toLowerCase(locale);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            } else {
                string = null;
            }
            if (!Intrinsics.areEqual(string, (Object)this.requiresTag)) return false;
            return true;
        }

        public final boolean isValidIn(@NotNull XmlTag context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.isValidIn(context.getName(), context.getParentTag() == null);
        }

        public static VueAttributeKind[] values() {
            return (VueAttributeKind[])$VALUES.clone();
        }

        public static VueAttributeKind valueOf(String value) {
            return Enum.valueOf(VueAttributeKind.class, value);
        }

        @NotNull
        public static EnumEntries<VueAttributeKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = vueAttributeKindArray = new VueAttributeKind[]{VueAttributeKind.PLAIN, VueAttributeKind.DIRECTIVE, VueAttributeKind.SLOT, VueAttributeKind.REF, VueAttributeKind.IS, VueAttributeKind.KEY, VueAttributeKind.SCOPE, VueAttributeKind.SLOT_SCOPE, VueAttributeKind.SLOT_NAME, VueAttributeKind.STYLE_SCOPED, VueAttributeKind.STYLE_MODULE, VueAttributeKind.STYLE_SRC, VueAttributeKind.STYLE_LANG, VueAttributeKind.TEMPLATE_FUNCTIONAL, VueAttributeKind.TEMPLATE_SRC, VueAttributeKind.TEMPLATE_LANG, VueAttributeKind.SCRIPT_ID, VueAttributeKind.SCRIPT_SRC, VueAttributeKind.SCRIPT_LANG, VueAttributeKind.SCRIPT_SETUP, VueAttributeKind.SCRIPT_VAPOR, VueAttributeKind.SCRIPT_GENERIC};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B?\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0082\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004J\n\u0010\u001b\u001a\u00020\u0003H\u0096\u0080\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueDirectiveInfo;", "Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueAttributeInfo;", "name", "", "directiveKind", "Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueDirectiveKind;", "arguments", "isShorthand", "", "modifiers", "", "<init>", "(Ljava/lang/String;Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueDirectiveKind;Ljava/lang/String;ZLjava/util/Set;)V", "getDirectiveKind", "()Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueDirectiveKind;", "getArguments", "()Ljava/lang/String;", "()Z", "requiresValue", "getRequiresValue", "injectJS", "getInjectJS", "equals", "other", "", "hashCode", "", "toString", "intellij.vuejs.common"})
    public static final class VueDirectiveInfo
    extends VueAttributeInfo {
        @NotNull
        private final VueDirectiveKind directiveKind;
        @Nullable
        private final String arguments;
        private final boolean isShorthand;

        public VueDirectiveInfo(@NotNull String name, @NotNull VueDirectiveKind directiveKind, @Nullable String arguments, boolean isShorthand, @NotNull Set<String> modifiers) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)directiveKind), (String)"directiveKind");
            Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
            super(name, VueAttributeKind.DIRECTIVE, modifiers);
            this.directiveKind = directiveKind;
            this.arguments = arguments;
            this.isShorthand = isShorthand;
        }

        public /* synthetic */ VueDirectiveInfo(String string, VueDirectiveKind vueDirectiveKind, String string2, boolean bl, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                set = SetsKt.emptySet();
            }
            this(string, vueDirectiveKind, string2, bl, set);
        }

        @NotNull
        public final VueDirectiveKind getDirectiveKind() {
            return this.directiveKind;
        }

        @Nullable
        public final String getArguments() {
            return this.arguments;
        }

        public final boolean isShorthand() {
            return this.isShorthand;
        }

        @Override
        public boolean getRequiresValue() {
            return this.directiveKind.getRequiresValue() && this.getModifiers().isEmpty();
        }

        @Override
        public boolean getInjectJS() {
            return this.directiveKind.getInjectJS();
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            if (!super.equals(other)) {
                return false;
            }
            Object object2 = other;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.vuejs.codeInsight.attributes.VueAttributeNameParser.VueDirectiveInfo");
            VueDirectiveInfo cfr_ignored_0 = (VueDirectiveInfo)object2;
            return this.directiveKind == ((VueDirectiveInfo)other).directiveKind && Intrinsics.areEqual((Object)this.arguments, (Object)((VueDirectiveInfo)other).arguments);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.directiveKind.hashCode();
            String string = this.arguments;
            result = 31 * result + (string != null ? string.hashCode() : 0);
            return result;
        }

        @Override
        @NotNull
        public String toString() {
            return this.getName() + " [" + this.getKind() + ", args=" + this.arguments + ", isShorthand=" + this.isShorthand + ", modifiers=" + this.getModifiers() + "]";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeNameParser$VueDirectiveKind;", "", "hasName", "", "injectJS", "requiresValue", "<init>", "(Ljava/lang/String;IZZZ)V", "getInjectJS", "()Z", "getRequiresValue", "CUSTOM", "BIND", "ON", "CLOAK", "ELSE", "ELSE_IF", "FOR", "HTML", "IF", "MODEL", "ONCE", "PRE", "SHOW", "SLOT", "TEXT", "directiveName", "", "getDirectiveName", "()Ljava/lang/String;", "intellij.vuejs.common"})
    public static final class VueDirectiveKind
    extends Enum<VueDirectiveKind> {
        private final boolean hasName;
        private final boolean injectJS;
        private final boolean requiresValue;
        public static final /* enum */ VueDirectiveKind CUSTOM = new VueDirectiveKind("CUSTOM", 0, false, false, false, 2, null);
        public static final /* enum */ VueDirectiveKind BIND = new VueDirectiveKind("BIND", 1, false, false, false, 7, null);
        public static final /* enum */ VueDirectiveKind ON = new VueDirectiveKind("ON", 2, false, false, false, 7, null);
        public static final /* enum */ VueDirectiveKind CLOAK = new VueDirectiveKind("CLOAK", 3, false, false, false, 1, null);
        public static final /* enum */ VueDirectiveKind ELSE = new VueDirectiveKind("ELSE", 4, false, false, false, 1, null);
        public static final /* enum */ VueDirectiveKind ELSE_IF = new VueDirectiveKind("ELSE_IF", 5, false, false, false, 7, null);
        public static final /* enum */ VueDirectiveKind FOR = new VueDirectiveKind("FOR", 6, false, false, false, 7, null);
        public static final /* enum */ VueDirectiveKind HTML = new VueDirectiveKind("HTML", 7, false, false, false, 7, null);
        public static final /* enum */ VueDirectiveKind IF = new VueDirectiveKind("IF", 8, false, false, false, 7, null);
        public static final /* enum */ VueDirectiveKind MODEL = new VueDirectiveKind("MODEL", 9, false, false, false, 7, null);
        public static final /* enum */ VueDirectiveKind ONCE = new VueDirectiveKind("ONCE", 10, false, false, false, 1, null);
        public static final /* enum */ VueDirectiveKind PRE = new VueDirectiveKind("PRE", 11, false, false, false, 1, null);
        public static final /* enum */ VueDirectiveKind SHOW = new VueDirectiveKind("SHOW", 12, false, false, false, 7, null);
        public static final /* enum */ VueDirectiveKind SLOT = new VueDirectiveKind("SLOT", 13, false, false, false, 3, null);
        public static final /* enum */ VueDirectiveKind TEXT = new VueDirectiveKind("TEXT", 14, false, false, false, 7, null);
        private static final /* synthetic */ VueDirectiveKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private VueDirectiveKind(boolean hasName, boolean injectJS, boolean requiresValue) {
            this.hasName = hasName;
            this.injectJS = injectJS;
            this.requiresValue = requiresValue;
        }

        /* synthetic */ VueDirectiveKind(String string, int n, boolean bl, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = true;
            }
            if ((n2 & 2) != 0) {
                bl2 = true;
            }
            if ((n2 & 4) != 0) {
                bl3 = true;
            }
            this(bl, bl2, bl3);
        }

        public final boolean getInjectJS() {
            return this.injectJS;
        }

        public final boolean getRequiresValue() {
            return this.requiresValue;
        }

        @Nullable
        public final String getDirectiveName() {
            String string;
            if (this.hasName) {
                String string2 = this.name();
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = StringsKt.replace$default((String)string3, (char)'_', (char)'-', (boolean)false, (int)4, null);
            } else {
                string = null;
            }
            return string;
        }

        public static VueDirectiveKind[] values() {
            return (VueDirectiveKind[])$VALUES.clone();
        }

        public static VueDirectiveKind valueOf(String value) {
            return Enum.valueOf(VueDirectiveKind.class, value);
        }

        @NotNull
        public static EnumEntries<VueDirectiveKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = vueDirectiveKindArray = new VueDirectiveKind[]{VueDirectiveKind.CUSTOM, VueDirectiveKind.BIND, VueDirectiveKind.ON, VueDirectiveKind.CLOAK, VueDirectiveKind.ELSE, VueDirectiveKind.ELSE_IF, VueDirectiveKind.FOR, VueDirectiveKind.HTML, VueDirectiveKind.IF, VueDirectiveKind.MODEL, VueDirectiveKind.ONCE, VueDirectiveKind.PRE, VueDirectiveKind.SHOW, VueDirectiveKind.SLOT, VueDirectiveKind.TEXT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

