/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.backend.split;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.completion.backend.split.BackendCompletionLoggerKt;
import com.intellij.platform.completion.common.protocol.RpcCompletionRequest;
import com.intellij.platform.completion.common.protocol.RpcCompletionResponseEvent;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fJ\u0006\u0010\u0010\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/completion/backend/split/ResponseChannel;", "", "request", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionRequest;", "<init>", "(Lcom/intellij/platform/completion/common/protocol/RpcCompletionRequest;)V", "getRequest", "()Lcom/intellij/platform/completion/common/protocol/RpcCompletionRequest;", "channel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionResponseEvent;", "send", "", "event", "flow", "Lkotlinx/coroutines/flow/Flow;", "close", "intellij.platform.completion.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendCompletionSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendCompletionSession.kt\ncom/intellij/platform/completion/backend/split/ResponseChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,608:1\n67#2,4:609\n*S KotlinDebug\n*F\n+ 1 BackendCompletionSession.kt\ncom/intellij/platform/completion/backend/split/ResponseChannel\n*L\n589#1:609,4\n*E\n"})
final class ResponseChannel {
    @NotNull
    private final RpcCompletionRequest request;
    @NotNull
    private final Channel<RpcCompletionResponseEvent> channel;

    public ResponseChannel(@NotNull RpcCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        this.channel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
    }

    @NotNull
    public final RpcCompletionRequest getRequest() {
        return this.request;
    }

    public final void send(@NotNull RpcCompletionResponseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Logger $this$trace$iv = BackendCompletionLoggerKt.getBcLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Sending " + event + " for " + this.request.getId());
        }
        Object result = this.channel.trySend-JP2dKIU((Object)event);
        Throwable throwable = ChannelResult.exceptionOrNull-impl((Object)result);
        if (throwable == null) {
            return;
        }
        Throwable exception = throwable;
        if (exception instanceof CancellationException) {
            return;
        }
        BackendCompletionLoggerKt.getBcLogger().error(exception);
    }

    @NotNull
    public final Flow<RpcCompletionResponseEvent> flow() {
        return FlowKt.consumeAsFlow((ReceiveChannel)((ReceiveChannel)this.channel));
    }

    public final void close() {
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.channel), null, (int)1, null);
    }
}

