/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.toolsets.general;

import com.intellij.mcpserver.toolsets.general.ConflictsFoundException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\t2\u0010\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013H\u0014\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J \u0010\u0019\u001a\u00020\t2\u0016\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u00130\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/mcpserver/toolsets/general/McpRenameProcessor;", "Lcom/intellij/refactoring/rename/RenameProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "newName", "", "isSearchInComments", "", "isSearchTextOccurrences", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;Ljava/lang/String;ZZ)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getNewName", "()Ljava/lang/String;", "isPreviewUsages", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Z", "showAutomaticRenamingDialog", "automaticVariableRenamer", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "preprocessUsages", "refUsages", "Lcom/intellij/openapi/util/Ref;", "intellij.mcpserver"})
final class McpRenameProcessor
extends RenameProcessor {
    @NotNull
    private final PsiElement element;
    @NotNull
    private final String newName;

    public McpRenameProcessor(@NotNull Project project, @NotNull PsiElement element, @NotNull String newName, boolean isSearchInComments, boolean isSearchTextOccurrences) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        super(project, element, newName, isSearchInComments, isSearchTextOccurrences);
        this.element = element;
        this.newName = newName;
    }

    @NotNull
    public final PsiElement getElement() {
        return this.element;
    }

    @NotNull
    public final String getNewName() {
        return this.newName;
    }

    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return false;
    }

    protected boolean showAutomaticRenamingDialog(@Nullable AutomaticRenamer automaticVariableRenamer) {
        return false;
    }

    public boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        Intrinsics.checkNotNullParameter(refUsages, (String)"refUsages");
        UsageInfo[] usageInfoArray = (UsageInfo[])refUsages.get();
        if (usageInfoArray == null) {
            return false;
        }
        UsageInfo[] usagesIn = usageInfoArray;
        MultiMap conflicts = new MultiMap();
        RenameUtil.addConflictDescriptions((UsageInfo[])usagesIn, (MultiMap)conflicts);
        RenamePsiElementProcessor.forElement((PsiElement)this.element).findExistingNameConflicts(this.element, this.newName, conflicts, (Map)this.myAllRenames);
        if (!conflicts.isEmpty()) {
            throw new ConflictsFoundException();
        }
        return true;
    }
}

