/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.externalDependencies.ProjectExternalDependency;
import com.intellij.externalDependencies.impl.CheckRequiredPluginsActivity;
import com.intellij.externalDependencies.impl.DependencyOnPluginState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@State(name="ExternalDependencies", storages={@Storage(value="externalDependencies.xml")})
public final class ExternalDependenciesManagerImpl
extends ExternalDependenciesManager
implements PersistentStateComponent<ExternalDependenciesState> {
    private final Project myProject;
    private static final Comparator<ProjectExternalDependency> DEPENDENCY_COMPARATOR = (o1, o2) -> {
        int i2 = o1.getClass().getSimpleName().compareToIgnoreCase(o2.getClass().getSimpleName());
        if (i2 != 0) {
            return i2;
        }
        return ((Comparable)((Object)o1)).compareTo(o2);
    };
    private final List<ProjectExternalDependency> myDependencies;

    ExternalDependenciesManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            ExternalDependenciesManagerImpl.$$$reportNull$$$0(0);
        }
        this.myDependencies = new ArrayList<ProjectExternalDependency>();
        this.myProject = project2;
    }

    @Override
    public <T extends ProjectExternalDependency> @Unmodifiable @NotNull List<T> getDependencies(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ExternalDependenciesManagerImpl.$$$reportNull$$$0(1);
        }
        List list2 = ContainerUtil.filterIsInstance(this.myDependencies, aClass);
        if (list2 == null) {
            ExternalDependenciesManagerImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<ProjectExternalDependency> getAllDependencies() {
        List<ProjectExternalDependency> list2 = Collections.unmodifiableList(this.myDependencies);
        if (list2 == null) {
            ExternalDependenciesManagerImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    public void setAllDependencies(@NotNull List<? extends ProjectExternalDependency> dependencies) {
        if (dependencies == null) {
            ExternalDependenciesManagerImpl.$$$reportNull$$$0(4);
        }
        this.myDependencies.clear();
        this.myDependencies.addAll(dependencies);
        this.myDependencies.sort(DEPENDENCY_COMPARATOR);
    }

    @NotNull
    public ExternalDependenciesState getState() {
        ExternalDependenciesState state2 = new ExternalDependenciesState();
        for (DependencyOnPlugin dependency : this.getDependencies(DependencyOnPlugin.class)) {
            state2.myDependencies.add(new DependencyOnPluginState(dependency));
        }
        ExternalDependenciesState externalDependenciesState = state2;
        if (externalDependenciesState == null) {
            ExternalDependenciesManagerImpl.$$$reportNull$$$0(5);
        }
        return externalDependenciesState;
    }

    public void loadState(@NotNull ExternalDependenciesState state2) {
        if (state2 == null) {
            ExternalDependenciesManagerImpl.$$$reportNull$$$0(6);
        }
        ArrayList<ProjectExternalDependency> oldDependencies = new ArrayList<ProjectExternalDependency>(this.myDependencies);
        this.myDependencies.clear();
        for (DependencyOnPluginState dependency : state2.myDependencies) {
            this.myDependencies.add(new DependencyOnPlugin(dependency.myId, dependency.myMinVersion, dependency.myMaxVersion));
        }
        if (!(oldDependencies.equals(this.myDependencies) || this.myDependencies.isEmpty() || ApplicationManager.getApplication().isUnitTestMode())) {
            NonUrgentExecutor.getInstance().execute(() -> {
                try {
                    StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> CheckRequiredPluginsActivity.runCheck(this.myProject, this));
                }
                catch (AlreadyDisposedException alreadyDisposedException) {
                    // empty catch block
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/externalDependencies/impl/ExternalDependenciesManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/externalDependencies/impl/ExternalDependenciesManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAllDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }

    public static final class ExternalDependenciesState {
        @Property(surroundWithTag=false)
        @XCollection
        public final List<DependencyOnPluginState> myDependencies = new ArrayList<DependencyOnPluginState>();
    }
}

