/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DarculaTableHeaderUI
extends BasicTableHeaderUI {
    public static final String SKIP_DRAWING_VERTICAL_CELL_SEPARATOR_KEY = "TableHeaderUI.skipDrawingVerticalCellSeparator";

    public static ComponentUI createUI(JComponent c) {
        return new DarculaTableHeaderUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        boolean skipDrawingVerticalCellSeparator = Objects.equals(c.getClientProperty(SKIP_DRAWING_VERTICAL_CELL_SEPARATOR_KEY), true);
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config = new GraphicsConfig((Graphics)g);
        Color bg = c.getBackground();
        g.setPaint(bg);
        TableColumnModel model2 = this.header.getColumnModel();
        int h = this.header.getHeight();
        int w = model2.getTotalColumnWidth();
        g.fillRect(0, 0, w, h);
        JBColor bottomSeparatorColor = JBColor.namedColor((String)"TableHeader.bottomSeparatorColor", (Color)ColorUtil.shift((Color)bg, (double)0.75));
        g.setPaint((Paint)bottomSeparatorColor);
        LinePainter2D.paint((Graphics2D)g, (double)0.0, (double)(h - 1), (double)w, (double)(h - 1));
        JBColor lineColor = JBColor.namedColor((String)"TableHeader.separatorColor", (Color)ColorUtil.shift((Color)bg, (double)0.7));
        config.restore();
        int first = 0;
        int last = model2.getColumnCount() - 1;
        if (last >= first) {
            Rectangle clip = g.getClipBounds();
            int columnAtLeft = this.header.columnAtPoint(new Point(clip.x, clip.y));
            int columnAtRight = this.header.columnAtPoint(new Point(clip.x + clip.width - 1, clip.y));
            boolean focused = TableUtil.isFocused((JTableHeader)this.header);
            boolean ltr = this.header.getComponentOrientation().isLeftToRight();
            TableColumn draggedColumn = this.header.getDraggedColumn();
            if (ltr) {
                if (columnAtLeft == -1) {
                    columnAtLeft = first;
                }
                if (columnAtRight == -1) {
                    columnAtRight = last;
                }
                bounds = this.header.getHeaderRect(columnAtLeft);
                --bounds.height;
                for (index = columnAtLeft; columnAtRight >= index; ++index) {
                    if (!skipDrawingVerticalCellSeparator && index != first) {
                        DarculaTableHeaderUI.paintLine(g, bounds, (Color)lineColor);
                    }
                    this.paintCell(g, bounds, model2, index, focused, draggedColumn);
                    bounds.x += bounds.width;
                }
            } else {
                if (columnAtRight == -1) {
                    columnAtRight = first;
                }
                if (columnAtLeft == -1) {
                    columnAtLeft = last;
                }
                bounds = this.header.getHeaderRect(columnAtLeft);
                --bounds.height;
                for (index = columnAtLeft; columnAtRight <= index; --index) {
                    if (!skipDrawingVerticalCellSeparator && index != last) {
                        DarculaTableHeaderUI.paintLine(g, bounds, (Color)lineColor);
                    }
                    this.paintCell(g, bounds, model2, index, focused, draggedColumn);
                    bounds.x += bounds.width;
                }
            }
            if (draggedColumn != null) {
                int index = TableUtil.getColumnIndex((JTableHeader)this.header, (TableColumn)draggedColumn);
                Rectangle bounds = this.header.getHeaderRect(index);
                g.setColor(this.header.getParent().getBackground());
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                bounds.x += this.header.getDraggedDistance();
                g.setColor(this.header.getBackground());
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                this.paintCell(g, bounds, draggedColumn, index, focused);
            }
            this.rendererPane.removeAll();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size2 = super.getPreferredSize(c);
        if (size2.height == 0) {
            return size2;
        }
        JBValue.UIInteger height = new JBValue.UIInteger("TableHeader.height", 25);
        return new Dimension(size2.width, Math.max(height.get(), size2.height));
    }

    private static void paintLine(Graphics g, Rectangle bounds, Color color) {
        g.setColor(color);
        g.fillRect(bounds.x, bounds.y + 1, 1, bounds.height - 2);
    }

    private void paintCell(Graphics g, Rectangle bounds, TableColumnModel model2, int index, boolean focused, TableColumn draggedColumn) {
        TableColumn column = model2.getColumn(index);
        bounds.width = column.getWidth();
        if (column != draggedColumn) {
            this.paintCell(g, bounds, column, index, focused);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintCell(Graphics g, Rectangle bounds, TableColumn column, int index, boolean focused) {
        Component component2 = TableUtil.getRendererComponent((JTableHeader)this.header, (TableColumn)column, (int)index, (boolean)focused);
        if (component2 != null && this.isExpandableHintShown(column)) {
            Graphics cg = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
            try {
                int width = Math.max(component2.getPreferredSize().width, bounds.width);
                this.rendererPane.paintComponent(cg, component2, this.header, 0, 0, width, bounds.height, true);
            }
            finally {
                cg.dispose();
            }
        } else {
            this.rendererPane.paintComponent(g, component2, this.header, bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
    }

    private boolean isExpandableHintShown(TableColumn column) {
        JTableHeader jTableHeader;
        if (column != null && (jTableHeader = this.header) instanceof ComponentWithExpandableItems) {
            ComponentWithExpandableItems c = (ComponentWithExpandableItems)jTableHeader;
            return column == ContainerUtil.getFirstItem((Collection)c.getExpandableItemsHandler().getExpandedItems());
        }
        return false;
    }
}

