/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl.islands;

import com.intellij.openapi.application.impl.islands.IslandsTabPainter;
import com.intellij.openapi.fileEditor.impl.EditorTabPainterAdapter;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.DefaultTabPainterAdapter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/application/impl/islands/IslandsTabPainterAdapter;", "Lcom/intellij/ui/tabs/impl/TabPainterAdapter;", "isDefault", "", "debugger", "isEnabled", "<init>", "(ZZZ)V", "()Z", "setEnabled", "(Z)V", "editorAdapter", "islandsAdapter", "Lcom/intellij/openapi/application/impl/islands/IslandsTabPainter;", "tabPainter", "Lcom/intellij/ui/tabs/JBTabPainter;", "getTabPainter", "()Lcom/intellij/ui/tabs/JBTabPainter;", "paintBackground", "", "label", "Lcom/intellij/ui/tabs/impl/TabLabel;", "g", "Ljava/awt/Graphics;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "calcTabLabelWidth", "", "intellij.platform.ide.impl"})
public final class IslandsTabPainterAdapter
implements TabPainterAdapter {
    private boolean isEnabled;
    @NotNull
    private final TabPainterAdapter editorAdapter;
    @NotNull
    private final IslandsTabPainter islandsAdapter;

    public IslandsTabPainterAdapter(boolean isDefault, boolean debugger, boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.editorAdapter = isDefault ? (TabPainterAdapter)new DefaultTabPainterAdapter(debugger ? JBTabPainter.Companion.getDEBUGGER() : JBTabPainter.Companion.getDEFAULT()) : (TabPainterAdapter)new EditorTabPainterAdapter();
        this.islandsAdapter = new IslandsTabPainter(isDefault, debugger);
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @NotNull
    public JBTabPainter getTabPainter() {
        return this.isEnabled ? (JBTabPainter)this.islandsAdapter : this.editorAdapter.getTabPainter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBackground(@NotNull TabLabel label2, @NotNull Graphics g, @NotNull JBTabsImpl tabs) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        if (!this.isEnabled) {
            tabs.setFirstTabOffset(0);
            this.editorAdapter.paintBackground(label2, g, tabs);
            return;
        }
        TabInfo info = label2.getInfo();
        boolean selected = Intrinsics.areEqual((Object)info, (Object)tabs.getSelectedInfo());
        boolean active = tabs.isActiveTabs(info);
        boolean hovered = tabs.isHoveredTab(label2);
        int tabLabelWidth = this.calcTabLabelWidth(label2);
        Rectangle rect = new Rectangle(tabLabelWidth, label2.getHeight());
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            GraphicsUtil.setupAAPainting((Graphics)g2);
            tabs.setFirstTabOffset(JBUI.scale((int)3));
            JBTabPainter jBTabPainter = this.getTabPainter();
            Intrinsics.checkNotNull((Object)jBTabPainter, (String)"null cannot be cast to non-null type com.intellij.openapi.application.impl.islands.IslandsTabPainter");
            ((IslandsTabPainter)jBTabPainter).paintTab(g2, tabs.getTabsPosition(), rect, info.getTabColor(), active, hovered, selected);
        }
        finally {
            g2.dispose();
        }
    }

    private final int calcTabLabelWidth(TabLabel label2) {
        Rectangle rect = null;
        Component[] componentArray = label2.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component component2 : componentArray) {
            rect = rect == null ? component2.getBounds() : rect.union(component2.getBounds());
        }
        Rectangle rectangle = rect;
        int contentWidth = rectangle == null ? 0 : rectangle.x + rect.width;
        return contentWidth + label2.getInsets().right;
    }
}

