/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.UpdateData;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.BuildRange;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0014\u0010'\u001a\u0004\u0018\u00010\u00172\b\u0010&\u001a\u0004\u0018\u00010\u0005H\u0002J\n\u0010(\u001a\u00020\u0005H\u0096\u0080\u0004R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010#\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "", "node", "Lorg/jdom/Element;", "productCode", "", "<init>", "(Lorg/jdom/Element;Ljava/lang/String;)V", "number", "Lcom/intellij/openapi/util/BuildNumber;", "getNumber", "()Lcom/intellij/openapi/util/BuildNumber;", "apiVersion", "getApiVersion", "version", "getVersion", "()Ljava/lang/String;", "message", "Lcom/intellij/openapi/util/NlsSafe;", "getMessage", "blogPost", "getBlogPost", "releaseDate", "Ljava/util/Date;", "getReleaseDate", "()Ljava/util/Date;", "target", "Lcom/intellij/openapi/util/BuildRange;", "getTarget", "()Lcom/intellij/openapi/util/BuildRange;", "patches", "", "Lcom/intellij/openapi/updateSettings/impl/PatchInfo;", "getPatches", "()Ljava/util/List;", "downloadUrl", "getDownloadUrl", "parseBuildNumber", "value", "parseDate", "toString", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nUpdateInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateInfo.kt\ncom/intellij/openapi/updateSettings/impl/BuildInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,93:1\n1#2:94\n1586#3:95\n1661#3,3:96\n13#4:99\n*S KotlinDebug\n*F\n+ 1 UpdateInfo.kt\ncom/intellij/openapi/updateSettings/impl/BuildInfo\n*L\n56#1:95\n56#1:96,3\n70#1:99\n*E\n"})
public final class BuildInfo {
    @NotNull
    private final BuildNumber number;
    @NotNull
    private final BuildNumber apiVersion;
    @NotNull
    private final String version;
    @NotNull
    private final String message;
    @Nullable
    private final String blogPost;
    @Nullable
    private final Date releaseDate;
    @Nullable
    private final BuildRange target;
    @NotNull
    private final List<PatchInfo> patches;
    @Nullable
    private final String downloadUrl;

    /*
     * WARNING - void declaration
     */
    public BuildInfo(@NotNull Element node, @NotNull String productCode) {
        Object v8;
        block7: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            String string;
            BuildInfo buildInfo;
            block9: {
                String string2;
                BuildInfo buildInfo2;
                block8: {
                    void it;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
                    this.number = this.parseBuildNumber(UpdateData.access$getMandatoryAttributeValue(node, "fullNumber", "number"), productCode);
                    buildInfo2 = this;
                    string2 = node.getAttributeValue("apiVersion");
                    if (string2 == null) break block8;
                    String string3 = string2;
                    buildInfo = buildInfo2;
                    boolean bl = false;
                    BuildNumber buildNumber = BuildNumber.fromStringWithProductCode((String)it, (String)this.number.getProductCode());
                    buildInfo2 = buildInfo;
                    string2 = buildNumber;
                    if (buildNumber != null) break block9;
                }
                string2 = buildInfo2.apiVersion = this.number;
            }
            if ((string = node.getAttributeValue("version")) == null) {
                string = this.version = "";
            }
            if ((object = node.getChild("message")) == null || (object = object.getValue()) == null) {
                object = "";
            }
            this.message = object;
            Element element = node.getChild("blogPost");
            this.blogPost = element != null ? element.getAttributeValue("url") : null;
            this.releaseDate = this.parseDate(node.getAttributeValue("releaseDate"));
            this.target = BuildRange.fromStrings((String)node.getAttributeValue("targetSince"), (String)node.getAttributeValue("targetUntil"));
            List list2 = node.getChildren("patch");
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
            Iterable iterable = list2;
            buildInfo = this;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Element element2 = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PatchInfo((Element)p0));
            }
            buildInfo.patches = (List)destination$iv$iv;
            List list3 = node.getChildren("button");
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getChildren(...)");
            Iterable iterable3 = list3;
            buildInfo = this;
            iterable2 = iterable3;
            for (Object e : iterable2) {
                Element it = (Element)e;
                boolean bl = false;
                if (!(it.getAttributeValue("download") != null)) continue;
                v8 = e;
                break block7;
            }
            v8 = null;
        }
        Element element = v8;
        buildInfo.downloadUrl = element != null ? UpdateData.access$getMandatoryAttributeValue(element, "url") : null;
    }

    @NotNull
    public final BuildNumber getNumber() {
        return this.number;
    }

    @NotNull
    public final BuildNumber getApiVersion() {
        return this.apiVersion;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final String getBlogPost() {
        return this.blogPost;
    }

    @Nullable
    public final Date getReleaseDate() {
        return this.releaseDate;
    }

    @Nullable
    public final BuildRange getTarget() {
        return this.target;
    }

    @NotNull
    public final List<PatchInfo> getPatches() {
        return this.patches;
    }

    @Nullable
    public final String getDownloadUrl() {
        return this.downloadUrl;
    }

    private final BuildNumber parseBuildNumber(String value, String productCode) {
        BuildNumber buildNumber;
        BuildNumber buildNumber2 = BuildNumber.fromString((String)value);
        Intrinsics.checkNotNull((Object)buildNumber2);
        BuildNumber buildNumber3 = buildNumber2;
        String string = buildNumber3.getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        if (((CharSequence)string).length() > 0) {
            buildNumber = buildNumber3;
        } else {
            int[] nArray = buildNumber3.getComponents();
            BuildNumber buildNumber4 = new BuildNumber(productCode, Arrays.copyOf(nArray, nArray.length));
            buildNumber = buildNumber4;
        }
        return buildNumber;
    }

    private final Date parseDate(String value) {
        Date date;
        if (value == null) {
            date = null;
        } else {
            Date date2;
            try {
                date2 = new SimpleDateFormat("yyyyMMdd", Locale.US).parse(value);
            }
            catch (ParseException parseException) {
                boolean $i$f$logger = false;
                Logger logger2 = Logger.getInstance(BuildInfo.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.info("invalid build release date: " + value);
                date2 = null;
            }
            date = date2;
        }
        return date;
    }

    @NotNull
    public String toString() {
        return this.number + "/" + this.version;
    }
}

