/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.mapped.MappedFileStorageHelper;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.util.io.CleanableStorage;
import com.intellij.util.io.Unmappable;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@ApiStatus.Internal
public final class SpecializedFileAttributes {
    public static ByteFileAttributeAccessor specializeAsByte(@NotNull FileAttribute attribute) {
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(0);
        }
        return SpecializedFileAttributes.specializeAsByte(FSRecords.getInstance(), attribute);
    }

    public static ByteFileAttributeAccessor specializeAsByte(final @NotNull FSRecordsImpl vfs, final @NotNull FileAttribute attribute) {
        if (vfs == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(1);
        }
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(2);
        }
        return new ByteFileAttributeAccessor(){

            @Override
            public byte read(int fileId, byte defaultValue) {
                Byte value = (Byte)vfs.readAttributeRaw(fileId, attribute, ByteBuffer::get);
                return value == null ? defaultValue : value;
            }

            @Override
            public void write(int fileId, byte value) throws IOException {
                try (AttributeOutputStream stream = vfs.writeAttribute(fileId, attribute);){
                    stream.write((int)value);
                }
            }
        };
    }

    public static ShortFileAttributeAccessor specializeAsShort(@NotNull FileAttribute attribute) {
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(3);
        }
        return SpecializedFileAttributes.specializeAsShort(FSRecords.getInstance(), attribute);
    }

    public static ShortFileAttributeAccessor specializeAsShort(final @NotNull FSRecordsImpl vfs, final @NotNull FileAttribute attribute) {
        if (vfs == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(4);
        }
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(5);
        }
        return new ShortFileAttributeAccessor(){

            @Override
            public short read(int fileId, short defaultValue) {
                Short value = (Short)vfs.readAttributeRaw(fileId, attribute, buffer2 -> buffer2.order(ByteOrder.BIG_ENDIAN).getShort());
                return value == null ? defaultValue : value;
            }

            @Override
            public void write(int fileId, short value) throws IOException {
                try (AttributeOutputStream stream = vfs.writeAttribute(fileId, attribute);){
                    stream.writeShort((int)value);
                }
            }
        };
    }

    public static IntFileAttributeAccessor specializeAsInt(@NotNull FileAttribute attribute) {
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(6);
        }
        return SpecializedFileAttributes.specializeAsInt(FSRecords.getInstance(), attribute);
    }

    public static IntFileAttributeAccessor specializeAsInt(final @NotNull FSRecordsImpl vfs, final @NotNull FileAttribute attribute) {
        if (vfs == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(7);
        }
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(8);
        }
        return new IntFileAttributeAccessor(){

            @Override
            public void close() {
            }

            @Override
            public int read(int fileId, int defaultValue) {
                Integer value = (Integer)vfs.readAttributeRaw(fileId, attribute, buffer2 -> buffer2.order(ByteOrder.BIG_ENDIAN).getInt());
                return value == null ? defaultValue : value;
            }

            @Override
            public void write(int fileId, int value) throws IOException {
                try (AttributeOutputStream stream = vfs.writeAttribute(fileId, attribute);){
                    stream.writeInt(value);
                }
            }

            @Override
            public void update(int fileId, @NotNull IntUnaryOperator updater) throws IOException {
                if (updater == null) {
                    3.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException("Method not implemented yet");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes$3", "update"));
            }
        };
    }

    public static LongFileAttributeAccessor specializeAsLong(@NotNull FileAttribute attribute) {
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(9);
        }
        return SpecializedFileAttributes.specializeAsLong(FSRecords.getInstance(), attribute);
    }

    public static LongFileAttributeAccessor specializeAsLong(final @NotNull FSRecordsImpl vfs, final @NotNull FileAttribute attribute) {
        if (vfs == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(10);
        }
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(11);
        }
        if (!attribute.isFixedSize()) {
            throw new IllegalArgumentException(String.valueOf(attribute) + " must be fixedSize");
        }
        return new LongFileAttributeAccessor(){

            @Override
            public long read(int fileId, long defaultValue) throws IOException {
                Long value = (Long)vfs.readAttributeRaw(fileId, attribute, buffer2 -> buffer2.order(ByteOrder.BIG_ENDIAN).getLong());
                return value == null ? defaultValue : value;
            }

            @Override
            public void write(int fileId, long value) throws IOException {
                try (AttributeOutputStream stream = vfs.writeAttribute(fileId, attribute);){
                    stream.writeLong(value);
                }
            }

            @Override
            public void update(int fileId, @NotNull LongUnaryOperator updater) throws IOException {
                if (updater == null) {
                    4.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException("Method is not implemented");
            }

            @Override
            public void close() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes$4", "update"));
            }
        };
    }

    public static LongFileAttributeAccessor specializeAsFastLong(@NotNull FileAttribute attribute) throws IOException {
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(12);
        }
        return SpecializedFileAttributes.specializeAsFastLong(FSRecords.getInstance(), attribute);
    }

    public static LongFileAttributeAccessor specializeAsFastLong(@NotNull FSRecordsImpl vfs, @NotNull FileAttribute attribute) throws IOException {
        if (vfs == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(13);
        }
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(14);
        }
        String attributeId = attribute.getId();
        MappedFileStorageHelper storageHelper = MappedFileStorageHelper.openHelperAndVerifyVersions(vfs, attributeId, attribute.getVersion(), 8);
        return SpecializedFileAttributes.specializeAsFastLong(vfs, storageHelper);
    }

    @NotNull
    private static FastLongFileAttributeAccessor specializeAsFastLong(@NotNull FSRecordsImpl vfs, @NotNull MappedFileStorageHelper storageHelper) {
        if (vfs == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(15);
        }
        if (storageHelper == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(16);
        }
        FastLongFileAttributeAccessor accessor = new FastLongFileAttributeAccessor(storageHelper);
        vfs.addCloseable(accessor);
        vfs.addFileIdIndexedStorage(accessor);
        FastLongFileAttributeAccessor fastLongFileAttributeAccessor = accessor;
        if (fastLongFileAttributeAccessor == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(17);
        }
        return fastLongFileAttributeAccessor;
    }

    public static LongFileAttributeAccessor specializeAsFastLong(@NotNull FSRecordsImpl vfs, @NotNull FileAttribute attribute, @NotNull Path absolutePath) throws IOException {
        if (vfs == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(18);
        }
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(19);
        }
        if (absolutePath == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(20);
        }
        MappedFileStorageHelper storageHelper = MappedFileStorageHelper.openHelperAndVerifyVersions(vfs, absolutePath, attribute.getVersion(), 8, true);
        return SpecializedFileAttributes.specializeAsFastLong(vfs, storageHelper);
    }

    public static IntFileAttributeAccessor specializeAsFastInt(@NotNull FileAttribute attribute) throws IOException {
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(21);
        }
        return SpecializedFileAttributes.specializeAsFastInt(FSRecords.getInstance(), attribute);
    }

    public static IntFileAttributeAccessor specializeAsFastInt(@NotNull FSRecordsImpl vfs, @NotNull FileAttribute attribute, @NotNull Path absolutePath) throws IOException {
        if (vfs == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(22);
        }
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(23);
        }
        if (absolutePath == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(24);
        }
        MappedFileStorageHelper storageHelper = MappedFileStorageHelper.openHelperAndVerifyVersions(vfs, absolutePath, attribute.getVersion(), 4, true);
        return SpecializedFileAttributes.specializeAsFastInt(vfs, storageHelper);
    }

    public static IntFileAttributeAccessor specializeAsFastInt(@NotNull FSRecordsImpl vfs, @NotNull FileAttribute attribute) throws IOException {
        if (vfs == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(25);
        }
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(26);
        }
        MappedFileStorageHelper storageHelper = MappedFileStorageHelper.openHelperAndVerifyVersions(vfs, attribute.getId(), attribute.getVersion(), 4);
        return SpecializedFileAttributes.specializeAsFastInt(vfs, storageHelper);
    }

    private static IntFileAttributeAccessor specializeAsFastInt(@NotNull FSRecordsImpl vfs, MappedFileStorageHelper storageHelper) throws IOException {
        if (vfs == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(27);
        }
        FastIntFileAttributeAccessor accessor = new FastIntFileAttributeAccessor(storageHelper);
        vfs.addCloseable(accessor);
        vfs.addFileIdIndexedStorage(accessor);
        return accessor;
    }

    public static ShortFileAttributeAccessor specializeAsFastShort(@NotNull FileAttribute attribute) throws IOException {
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(28);
        }
        return SpecializedFileAttributes.specializeAsFastShort(FSRecords.getInstance(), attribute);
    }

    public static ShortFileAttributeAccessor specializeAsFastShort(@NotNull FSRecordsImpl vfs, @NotNull FileAttribute attribute) throws IOException {
        if (vfs == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(29);
        }
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(30);
        }
        String attributeId = attribute.getId();
        MappedFileStorageHelper storageHelper = MappedFileStorageHelper.openHelperAndVerifyVersions(vfs, attributeId, attribute.getVersion(), 2);
        FastShortFileAttributeAccessor accessor = new FastShortFileAttributeAccessor(storageHelper);
        vfs.addCloseable(accessor);
        vfs.addFileIdIndexedStorage(accessor);
        return accessor;
    }

    public static ByteFileAttributeAccessor specializeAsFastByte(@NotNull FileAttribute attribute) throws IOException {
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(31);
        }
        return SpecializedFileAttributes.specializeAsFastByte(FSRecords.getInstance(), attribute);
    }

    public static ByteFileAttributeAccessor specializeAsFastByte(@NotNull FSRecordsImpl vfs, @NotNull FileAttribute attribute) throws IOException {
        if (vfs == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(32);
        }
        if (attribute == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(33);
        }
        String attributeId = attribute.getId();
        MappedFileStorageHelper storageHelper = MappedFileStorageHelper.openHelperAndVerifyVersions(vfs, attributeId, attribute.getVersion(), 2);
        FastByteFileAttributeAccessor accessor = new FastByteFileAttributeAccessor(storageHelper);
        vfs.addCloseable(accessor);
        vfs.addFileIdIndexedStorage(accessor);
        return accessor;
    }

    private static int extractFileId(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SpecializedFileAttributes.$$$reportNull$$$0(34);
        }
        if (!(vFile instanceof VirtualFileWithId)) {
            throw new IllegalArgumentException(String.valueOf(vFile) + " must be instance of VirtualFileWithId");
        }
        return ((VirtualFileWithId)vFile).getId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfs";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageHelper";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePath";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "specializeAsFastLong";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "specializeAsByte";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "specializeAsShort";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "specializeAsInt";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "specializeAsLong";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "specializeAsFastLong";
                break;
            }
            case 17: {
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "specializeAsFastInt";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "specializeAsFastShort";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "specializeAsFastByte";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "extractFileId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17 -> new IllegalStateException(string);
        };
    }

    public static interface ByteFileAttributeAccessor {
        default public byte read(@NotNull VirtualFile vFile) throws IOException {
            if (vFile == null) {
                ByteFileAttributeAccessor.$$$reportNull$$$0(0);
            }
            return this.read(vFile, (byte)0);
        }

        default public byte read(@NotNull VirtualFile vFile, byte defaultValue) throws IOException {
            if (vFile == null) {
                ByteFileAttributeAccessor.$$$reportNull$$$0(1);
            }
            return this.read(SpecializedFileAttributes.extractFileId(vFile), defaultValue);
        }

        default public void write(@NotNull VirtualFile vFile, byte value) throws IOException {
            if (vFile == null) {
                ByteFileAttributeAccessor.$$$reportNull$$$0(2);
            }
            this.write(SpecializedFileAttributes.extractFileId(vFile), value);
        }

        public byte read(int var1, byte var2) throws IOException;

        public void write(int var1, byte var2) throws IOException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "vFile";
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes$ByteFileAttributeAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ShortFileAttributeAccessor {
        default public short read(@NotNull VirtualFile vFile) throws IOException {
            if (vFile == null) {
                ShortFileAttributeAccessor.$$$reportNull$$$0(0);
            }
            return this.read(vFile, (short)0);
        }

        default public short read(@NotNull VirtualFile vFile, short defaultValue) throws IOException {
            if (vFile == null) {
                ShortFileAttributeAccessor.$$$reportNull$$$0(1);
            }
            return this.read(SpecializedFileAttributes.extractFileId(vFile), defaultValue);
        }

        default public void write(@NotNull VirtualFile vFile, short value) throws IOException {
            if (vFile == null) {
                ShortFileAttributeAccessor.$$$reportNull$$$0(2);
            }
            this.write(SpecializedFileAttributes.extractFileId(vFile), value);
        }

        public short read(int var1, short var2) throws IOException;

        public void write(int var1, short var2) throws IOException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "vFile";
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes$ShortFileAttributeAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface IntFileAttributeAccessor
    extends Closeable {
        default public int read(@NotNull VirtualFile vFile) throws IOException {
            if (vFile == null) {
                IntFileAttributeAccessor.$$$reportNull$$$0(0);
            }
            return this.read(vFile, 0);
        }

        default public int read(@NotNull VirtualFile vFile, int defaultValue) throws IOException {
            if (vFile == null) {
                IntFileAttributeAccessor.$$$reportNull$$$0(1);
            }
            return this.read(SpecializedFileAttributes.extractFileId(vFile), defaultValue);
        }

        default public void write(@NotNull VirtualFile vFile, int value) throws IOException {
            if (vFile == null) {
                IntFileAttributeAccessor.$$$reportNull$$$0(2);
            }
            this.write(SpecializedFileAttributes.extractFileId(vFile), value);
        }

        default public void update(@NotNull VirtualFile vFile, @NotNull IntUnaryOperator updater) throws IOException {
            if (vFile == null) {
                IntFileAttributeAccessor.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                IntFileAttributeAccessor.$$$reportNull$$$0(4);
            }
            this.update(SpecializedFileAttributes.extractFileId(vFile), updater);
        }

        public int read(@Range(from=1L, to=0x7FFFFFFFL) int var1, int var2) throws IOException;

        public void write(@Range(from=1L, to=0x7FFFFFFFL) int var1, int var2) throws IOException;

        public void update(@Range(from=1L, to=0x7FFFFFFFL) int var1, @NotNull IntUnaryOperator var2) throws IOException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes$IntFileAttributeAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface LongFileAttributeAccessor
    extends Closeable {
        default public long read(@NotNull VirtualFile vFile) throws IOException {
            if (vFile == null) {
                LongFileAttributeAccessor.$$$reportNull$$$0(0);
            }
            return this.read(vFile, 0L);
        }

        default public long read(@NotNull VirtualFile vFile, long defaultValue) throws IOException {
            if (vFile == null) {
                LongFileAttributeAccessor.$$$reportNull$$$0(1);
            }
            return this.read(SpecializedFileAttributes.extractFileId(vFile), defaultValue);
        }

        default public void write(@NotNull VirtualFile vFile, long value) throws IOException {
            if (vFile == null) {
                LongFileAttributeAccessor.$$$reportNull$$$0(2);
            }
            this.write(SpecializedFileAttributes.extractFileId(vFile), value);
        }

        default public void update(@NotNull VirtualFile vFile, @NotNull LongUnaryOperator updater) throws IOException {
            if (vFile == null) {
                LongFileAttributeAccessor.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                LongFileAttributeAccessor.$$$reportNull$$$0(4);
            }
            this.update(SpecializedFileAttributes.extractFileId(vFile), updater);
        }

        public long read(int var1, long var2) throws IOException;

        public void write(int var1, long var2) throws IOException;

        public void update(int var1, @NotNull LongUnaryOperator var2) throws IOException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes$LongFileAttributeAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FastLongFileAttributeAccessor
    extends FastAttributeAccessorHelper
    implements LongFileAttributeAccessor {
        private static final int FIELD_OFFSET = 0;

        private FastLongFileAttributeAccessor(@NotNull MappedFileStorageHelper storageHelper) {
            if (storageHelper == null) {
                FastLongFileAttributeAccessor.$$$reportNull$$$0(0);
            }
            super(storageHelper);
        }

        @Override
        public long read(int fileId, long defaultValue) throws IOException {
            if (defaultValue != 0L) {
                throw new UnsupportedOperationException("defaultValue=" + defaultValue + ": so far only 0 is supported default value for fast-attributes");
            }
            return this.helper.readLongField(fileId, 0);
        }

        @Override
        public void write(int fileId, long value) throws IOException {
            this.helper.writeLongField(fileId, 0, value);
        }

        @Override
        public void update(int fileId, @NotNull LongUnaryOperator updater) throws IOException {
            if (updater == null) {
                FastLongFileAttributeAccessor.$$$reportNull$$$0(1);
            }
            this.helper.updateLongField(fileId, 0, updater);
        }

        @Override
        public void clear(int fileId) throws IOException {
            this.helper.writeLongField(fileId, 0, 0L);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storageHelper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes$FastLongFileAttributeAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FastIntFileAttributeAccessor
    extends FastAttributeAccessorHelper
    implements IntFileAttributeAccessor {
        private static final int FIELD_OFFSET = 0;

        private FastIntFileAttributeAccessor(@NotNull MappedFileStorageHelper storageHelper) {
            if (storageHelper == null) {
                FastIntFileAttributeAccessor.$$$reportNull$$$0(0);
            }
            super(storageHelper);
        }

        @Override
        public int read(int fileId, int defaultValue) throws IOException {
            if (defaultValue != 0) {
                throw new UnsupportedOperationException("defaultValue=" + defaultValue + ": so far only 0 is supported default value for fast-attributes");
            }
            return this.helper.readIntField(fileId, 0);
        }

        @Override
        public void write(int fileId, int value) throws IOException {
            this.helper.writeIntField(fileId, 0, value);
        }

        @Override
        public void update(int fileId, @NotNull IntUnaryOperator updater) throws IOException {
            if (updater == null) {
                FastIntFileAttributeAccessor.$$$reportNull$$$0(1);
            }
            this.helper.updateIntField(fileId, 0, updater);
        }

        @Override
        public void clear(int fileId) throws IOException {
            this.helper.writeIntField(fileId, 0, 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storageHelper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes$FastIntFileAttributeAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FastShortFileAttributeAccessor
    extends FastAttributeAccessorHelper
    implements ShortFileAttributeAccessor {
        private static final int FIELD_OFFSET = 0;

        private FastShortFileAttributeAccessor(@NotNull MappedFileStorageHelper helper) {
            if (helper == null) {
                FastShortFileAttributeAccessor.$$$reportNull$$$0(0);
            }
            super(helper);
        }

        @Override
        public short read(int fileId, short defaultValue) throws IOException {
            if (defaultValue != 0) {
                throw new UnsupportedOperationException("defaultValue=" + defaultValue + ": so far only 0 is supported default value for fast-attributes");
            }
            return this.helper.readShortField(fileId, 0);
        }

        @Override
        public void write(int fileId, short value) throws IOException {
            this.helper.writeShortField(fileId, 0, value);
        }

        @Override
        public void clear(int fileId) throws IOException {
            this.helper.writeShortField(fileId, 0, (short)0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes$FastShortFileAttributeAccessor", "<init>"));
        }
    }

    private static class FastByteFileAttributeAccessor
    extends FastAttributeAccessorHelper
    implements ByteFileAttributeAccessor {
        private static final int FIELD_OFFSET = 0;

        private FastByteFileAttributeAccessor(@NotNull MappedFileStorageHelper helper) {
            if (helper == null) {
                FastByteFileAttributeAccessor.$$$reportNull$$$0(0);
            }
            super(helper);
            if (helper.bytesPerRow() != 2) {
                throw new AssertionError((Object)("Bug: helper must have 2 bytes per row, not " + helper.bytesPerRow()));
            }
        }

        @Override
        public byte read(int fileId, byte defaultValue) throws IOException {
            if (defaultValue != 0) {
                throw new UnsupportedOperationException("defaultValue=" + defaultValue + ": so far only 0 is supported default value for fast-attributes");
            }
            return (byte)this.helper.readShortField(fileId, 0);
        }

        @Override
        public void write(int fileId, byte value) throws IOException {
            this.helper.writeShortField(fileId, 0, value);
        }

        @Override
        public void clear(int fileId) throws IOException {
            this.helper.writeShortField(fileId, 0, (short)0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes$FastByteFileAttributeAccessor", "<init>"));
        }
    }

    private static abstract class FastAttributeAccessorHelper
    implements FileAttributeAccessorEx,
    Closeable,
    Unmappable,
    CleanableStorage {
        @NotNull
        protected final MappedFileStorageHelper helper;

        private FastAttributeAccessorHelper(@NotNull MappedFileStorageHelper helper) {
            if (helper == null) {
                FastAttributeAccessorHelper.$$$reportNull$$$0(0);
            }
            this.helper = helper;
        }

        @Override
        public void clear() throws IOException {
            this.helper.clearRecords();
        }

        @Override
        public void flush() throws IOException {
            if (MMappedFileStorage.FSYNC_ON_FLUSH_BY_DEFAULT) {
                this.helper.fsync();
            }
        }

        @Override
        public void close() throws IOException {
            this.helper.close();
        }

        public void closeAndUnsafelyUnmap() throws IOException {
            this.helper.closeAndUnsafelyUnmap();
        }

        public void closeAndClean() throws IOException {
            this.helper.closeAndClean();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/openapi/vfs/newvfs/persistent/SpecializedFileAttributes$FastAttributeAccessorHelper", "<init>"));
        }
    }

    public static interface FileAttributeAccessorEx
    extends FSRecordsImpl.FileIdIndexedStorage {
        @Override
        public void clear(int var1) throws IOException;

        public void clear() throws IOException;

        public void flush() throws IOException;
    }
}

