/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UiThemeParserKt;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.ShowUIDefaultsAction;
import com.intellij.ui.ShowUIDefaultsAddValue;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.speedSearch.FilteringTableModel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.text.matching.MatchingMode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ui/ShowUIDefaultsContent;", "", "table", "Lcom/intellij/ui/table/JBTable;", "<init>", "(Lcom/intellij/ui/table/JBTable;)V", "searchField", "Lcom/intellij/ui/components/JBTextField;", "getSearchField", "()Lcom/intellij/ui/components/JBTextField;", "setSearchField", "(Lcom/intellij/ui/components/JBTextField;)V", "colorsOnly", "Lcom/intellij/ui/components/JBCheckBox;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "storeState", "", "addNewValue", "updateFilter", "restoreLastSelected", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nShowUIDefaultsContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowUIDefaultsContent.kt\ncom/intellij/ui/ShowUIDefaultsContent\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n23#2:133\n*S KotlinDebug\n*F\n+ 1 ShowUIDefaultsContent.kt\ncom/intellij/ui/ShowUIDefaultsContent\n*L\n86#1:133\n*E\n"})
public final class ShowUIDefaultsContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final JBTable table;
    public JBTextField searchField;
    private JBCheckBox colorsOnly;
    @JvmField
    @NotNull
    public final DialogPanel panel;
    @NotNull
    public static final String LAST_SELECTED_KEY = "LaFDialog.lastSelectedElement";
    @NotNull
    private static final String COLORS_ONLY_KEY = "LaFDialog.ColorsOnly";
    @NotNull
    private static final String SEARCH_FIELD_HISTORY_KEY = "LaFDialog.filter";

    public ShowUIDefaultsContent(@NotNull JBTable table2) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        this.table = table2;
        this.panel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> ShowUIDefaultsContent.panel$lambda$0(this, arg_0)));
        ScrollingUtil.installActions((JTable)((JTable)this.table), (boolean)true, (JComponent)((JComponent)this.getSearchField()));
        this.updateFilter();
        this.restoreLastSelected();
    }

    @NotNull
    public final JBTextField getSearchField() {
        JBTextField jBTextField = this.searchField;
        if (jBTextField != null) {
            return jBTextField;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"searchField");
        return null;
    }

    public final void setSearchField(@NotNull JBTextField jBTextField) {
        Intrinsics.checkNotNullParameter((Object)jBTextField, (String)"<set-?>");
        this.searchField = jBTextField;
    }

    public final void storeState() {
        PropertiesComponent.getInstance().setValue(SEARCH_FIELD_HISTORY_KEY, this.getSearchField().getText());
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        JBCheckBox jBCheckBox = this.colorsOnly;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"colorsOnly");
            jBCheckBox = null;
        }
        propertiesComponent.setValue(COLORS_ONLY_KEY, jBCheckBox.isSelected(), false);
        Object selected = this.table.getValueAt(this.table.getSelectedRow(), 0);
        if (selected instanceof Pair) {
            PropertiesComponent.getInstance().setValue(LAST_SELECTED_KEY, ((Pair)selected).first.toString());
        }
    }

    private final void addNewValue() {
        ApplicationManager.getApplication().invokeLater(() -> ShowUIDefaultsContent.addNewValue$lambda$0(this));
    }

    private final void updateFilter() {
        TableModel tableModel2 = this.table.getModel();
        Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.intellij.ui.speedSearch.FilteringTableModel<*>");
        FilteringTableModel model2 = (FilteringTableModel)tableModel2;
        if (StringUtil.isEmpty((String)this.getSearchField().getText())) {
            JBCheckBox jBCheckBox = this.colorsOnly;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"colorsOnly");
                jBCheckBox = null;
            }
            if (!jBCheckBox.isSelected()) {
                model2.setFilter(null);
                return;
            }
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)("*" + this.getSearchField().getText()), (MatchingMode)MatchingMode.IGNORE_CASE);
        Intrinsics.checkNotNullExpressionValue((Object)minusculeMatcher, (String)"buildMatcher(...)");
        MinusculeMatcher matcher = minusculeMatcher;
        model2.setFilter((Condition)new Condition<Object>(this, matcher){
            final /* synthetic */ ShowUIDefaultsContent this$0;
            final /* synthetic */ MinusculeMatcher $matcher;
            {
                this.this$0 = $receiver;
                this.$matcher = $matcher;
            }

            public boolean value(Object pair) {
                String string;
                Object obj2;
                Intrinsics.checkNotNull((Object)pair, (String)"null cannot be cast to non-null type com.intellij.openapi.util.Pair<*, *>");
                Object object = obj2 = ((Pair)pair).second;
                if (object == null) {
                    string = "null";
                } else if (object instanceof Color) {
                    String string2 = ColorUtil.toHtmlColor((Color)((Color)obj2));
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHtmlColor(...)");
                } else {
                    string = obj2.toString();
                }
                Object value = string;
                value = ((Pair)pair).first + " " + (String)value;
                JBCheckBox jBCheckBox = ShowUIDefaultsContent.access$getColorsOnly$p(this.this$0);
                if (jBCheckBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"colorsOnly");
                    jBCheckBox = null;
                }
                return (!jBCheckBox.isSelected() || obj2 instanceof Color) && this.$matcher.matches((String)value);
            }
        });
    }

    private final void restoreLastSelected() {
        String key = PropertiesComponent.getInstance().getValue(LAST_SELECTED_KEY);
        if (key != null) {
            int n = this.table.getRowCount();
            for (int i2 = 0; i2 < n; ++i2) {
                Object valueAt = this.table.getModel().getValueAt(i2, 0);
                if (!(valueAt instanceof Pair) || !Intrinsics.areEqual((Object)key, (Object)((Pair)valueAt).first)) continue;
                this.table.getSelectionModel().setLeadSelectionIndex(i2);
                this.table.getSelectionModel().setSelectionInterval(i2, i2);
                ScrollingUtil.ensureIndexIsVisible((JTable)((JTable)this.table), (int)i2, (int)1);
                return;
            }
            ScrollingUtil.ensureSelectionExists((JTable)((JTable)this.table));
        }
    }

    private static final Unit panel$lambda$0$0$0(ShowUIDefaultsContent this$0, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateFilter();
        return Unit.INSTANCE;
    }

    private static final void panel$lambda$0$1$0(ShowUIDefaultsContent this$0, AnActionButton anActionButton) {
        this$0.addNewValue();
    }

    private static final Unit panel$lambda$0$2$0(ShowUIDefaultsContent this$0, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateFilter();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0(ShowUIDefaultsContent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell<JBTextField> cell = TextFieldKt.columns($this$row.textField(), 40);
        String string = PropertiesComponent.getInstance().getValue(SEARCH_FIELD_HISTORY_KEY, "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        this$0.setSearchField(TextFieldKt.text(cell, string).onChanged((Function1<JBTextField, Unit>)((Function1)arg_0 -> ShowUIDefaultsContent.panel$lambda$0$0$0(this$0, arg_0))).align(AlignX.FILL.INSTANCE).focused().getComponent());
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1(ShowUIDefaultsContent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)this$0.table)).setToolbarPosition(ActionToolbarPosition.BOTTOM).setAddAction(arg_0 -> ShowUIDefaultsContent.panel$lambda$0$1$0(this$0, arg_0)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel pane2 = jPanel;
        $this$row.cell((JComponent)pane2).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$2(ShowUIDefaultsContent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"checkbox.colors.only", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.colorsOnly = ButtonKt.selected($this$row.checkBox(string), PropertiesComponent.getInstance().getBoolean(COLORS_ONLY_KEY, false)).onChanged((Function1<JBCheckBox, Unit>)((Function1)arg_0 -> ShowUIDefaultsContent.panel$lambda$0$2$0(this$0, arg_0))).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0(ShowUIDefaultsContent this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = IdeBundle.message((String)"label.ui.filter", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, (Function1<? super Row, Unit>)((Function1)arg_0 -> ShowUIDefaultsContent.panel$lambda$0$0(this$0, arg_0)));
        Panel.row$default($this$panel, null, arg_0 -> ShowUIDefaultsContent.panel$lambda$0$1(this$0, arg_0), 1, null).resizableRow();
        Panel.row$default($this$panel, null, arg_0 -> ShowUIDefaultsContent.panel$lambda$0$2(this$0, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit addNewValue$lambda$0$0$0(ShowUIDefaultsContent this$0, String message, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ShowUIDefaultsContent $this$thisLogger$iv = this$0;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(ShowUIDefaultsContent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.warn(message, throwable);
        return Unit.INSTANCE;
    }

    private static final Unit addNewValue$lambda$0$0(ShowUIDefaultsContent this$0, String name2, String value) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String trimmedKey = ((Object)StringsKt.trim((CharSequence)name2)).toString();
        String trimmedValue = ((Object)StringsKt.trim((CharSequence)value)).toString();
        if (!(((CharSequence)trimmedKey).length() == 0) && !(((CharSequence)trimmedValue).length() == 0)) {
            UIManager.put(trimmedKey, UiThemeParserKt.parseUiThemeValue(trimmedKey, trimmedValue, LafManager.getInstance().getCurrentUIThemeLookAndFeel().getProviderClassLoader(), (Function2<? super String, ? super Throwable, Unit>)((Function2)(arg_0, arg_1) -> ShowUIDefaultsContent.addNewValue$lambda$0$0$0(this$0, arg_0, arg_1))));
            this$0.table.setModel((TableModel)ShowUIDefaultsAction.createFilteringModel());
            this$0.updateFilter();
        }
        return Unit.INSTANCE;
    }

    private static final void addNewValue$lambda$0(ShowUIDefaultsContent this$0) {
        new ShowUIDefaultsAddValue((Component)this$0.table, true, (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> ShowUIDefaultsContent.addNewValue$lambda$0$0(this$0, arg_0, arg_1))).show();
    }

    public static final /* synthetic */ JBCheckBox access$getColorsOnly$p(ShowUIDefaultsContent $this) {
        return $this.colorsOnly;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ui/ShowUIDefaultsContent$Companion;", "", "<init>", "()V", "LAST_SELECTED_KEY", "", "COLORS_ONLY_KEY", "SEARCH_FIELD_HISTORY_KEY", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

