/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ui.colorpicker.ColorDocument;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/colorpicker/DigitColorDocument;", "Lcom/intellij/ui/colorpicker/ColorDocument;", "src", "Ljavax/swing/JTextField;", "valueRange", "Lkotlin/ranges/IntRange;", "<init>", "(Ljavax/swing/JTextField;Lkotlin/ranges/IntRange;)V", "getValueRange", "()Lkotlin/ranges/IntRange;", "isLegalCharacter", "", "c", "", "isLegalValue", "str", "", "intellij.platform.ide.impl"})
final class DigitColorDocument
extends ColorDocument {
    @NotNull
    private final IntRange valueRange;

    public DigitColorDocument(@NotNull JTextField src, @NotNull IntRange valueRange) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)valueRange, (String)"valueRange");
        super(src);
        this.valueRange = valueRange;
    }

    @NotNull
    public final IntRange getValueRange() {
        return this.valueRange;
    }

    @Override
    public boolean isLegalCharacter(char c) {
        return Character.isDigit(c);
    }

    @Override
    public boolean isLegalValue(@NotNull String str) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        try {
            IntRange intRange = this.valueRange;
            int n = intRange.getFirst();
            int n2 = intRange.getLast();
            int n3 = Integer.parseInt(str);
            bl = n <= n3 ? n3 <= n2 : false;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }
}

