/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.filterField;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.filterField.FilterCompletionPopupType;
import com.intellij.ui.filterField.SearchPopupCallback;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u00108\u001a\u0002092\u0006\u0010&\u001a\u00020'2\u0006\u0010:\u001a\u00020-J\u0006\u0010@\u001a\u000209J\b\u0010A\u001a\u000209H\u0002J\u0006\u0010B\u001a\u000209J\u0010\u0010C\u001a\u0002092\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u0002092\u0006\u0010D\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u0002092\u0006\u0010D\u001a\u00020GH\u0016J\b\u0010I\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010 \u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001c\u00102\u001a\u0004\u0018\u000103X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0014\u0010;\u001a\u00020<8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0011\u0010?\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010/\u00a8\u0006J"}, d2={"Lcom/intellij/ui/filterField/FilterSearchPopup;", "Ljava/awt/event/ComponentAdapter;", "Ljavax/swing/event/CaretListener;", "searchTextField", "Lcom/intellij/ui/SearchTextField;", "listener", "Lcom/intellij/openapi/ui/popup/JBPopupListener;", "completionPlace", "Lcom/intellij/ui/filterField/FilterCompletionPopupType;", "model", "Lcom/intellij/ui/CollectionListModel;", "", "caretPosition", "", "<init>", "(Lcom/intellij/ui/SearchTextField;Lcom/intellij/openapi/ui/popup/JBPopupListener;Lcom/intellij/ui/filterField/FilterCompletionPopupType;Lcom/intellij/ui/CollectionListModel;I)V", "getCompletionPlace", "()Lcom/intellij/ui/filterField/FilterCompletionPopupType;", "getModel", "()Lcom/intellij/ui/CollectionListModel;", "getCaretPosition", "()I", "setCaretPosition", "(I)V", "editor", "Lcom/intellij/ui/components/JBTextField;", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "event", "Lcom/intellij/openapi/ui/popup/LightweightWindowEvent;", "dialogComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "getList", "()Ljavax/swing/JList;", "setList", "(Ljavax/swing/JList;)V", "callback", "Lcom/intellij/ui/filterField/SearchPopupCallback;", "getCallback", "()Lcom/intellij/ui/filterField/SearchPopupCallback;", "setCallback", "(Lcom/intellij/ui/filterField/SearchPopupCallback;)V", "skipCaretEvent", "", "getSkipCaretEvent", "()Z", "setSkipCaretEvent", "(Z)V", "data", "", "getData", "()Ljava/lang/Object;", "setData", "(Ljava/lang/Object;)V", "createAndShow", "", "async", "popupLocation", "Ljava/awt/Point;", "getPopupLocation", "()Ljava/awt/Point;", "isValid", "update", "show", "hide", "caretUpdate", "e", "Ljavax/swing/event/CaretEvent;", "componentMoved", "Ljava/awt/event/ComponentEvent;", "componentResized", "getXOffset", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nFilterSearchPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterSearchPopup.kt\ncom/intellij/ui/filterField/FilterSearchPopup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class FilterSearchPopup
extends ComponentAdapter
implements CaretListener {
    @NotNull
    private final JBPopupListener listener;
    @NotNull
    private final FilterCompletionPopupType completionPlace;
    @NotNull
    private final CollectionListModel<String> model;
    private int caretPosition;
    @NotNull
    private final JBTextField editor;
    @Nullable
    private JBPopup popup;
    @Nullable
    private LightweightWindowEvent event;
    @Nullable
    private Component dialogComponent;
    @Nullable
    private JList<String> list;
    @Nullable
    private SearchPopupCallback callback;
    private boolean skipCaretEvent;
    @Nullable
    private Object data;

    public FilterSearchPopup(@NotNull SearchTextField searchTextField, @NotNull JBPopupListener listener2, @NotNull FilterCompletionPopupType completionPlace, @NotNull CollectionListModel<String> model2, int caretPosition) {
        Intrinsics.checkNotNullParameter((Object)searchTextField, (String)"searchTextField");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)((Object)completionPlace), (String)"completionPlace");
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        this.listener = listener2;
        this.completionPlace = completionPlace;
        this.model = model2;
        this.caretPosition = caretPosition;
        JBTextField jBTextField = searchTextField.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"getTextEditor(...)");
        this.editor = jBTextField;
    }

    @NotNull
    public final FilterCompletionPopupType getCompletionPlace() {
        return this.completionPlace;
    }

    @NotNull
    public final CollectionListModel<String> getModel() {
        return this.model;
    }

    public final int getCaretPosition() {
        return this.caretPosition;
    }

    public final void setCaretPosition(int n) {
        this.caretPosition = n;
    }

    @Nullable
    public final JList<String> getList() {
        return this.list;
    }

    public final void setList(@Nullable JList<String> jList) {
        this.list = jList;
    }

    @Nullable
    public final SearchPopupCallback getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable SearchPopupCallback searchPopupCallback) {
        this.callback = searchPopupCallback;
    }

    public final boolean getSkipCaretEvent() {
        return this.skipCaretEvent;
    }

    public final void setSkipCaretEvent(boolean bl) {
        this.skipCaretEvent = bl;
    }

    @Nullable
    public final Object getData() {
        return this.data;
    }

    public final void setData(@Nullable Object object) {
        this.data = object;
    }

    /*
     * WARNING - void declaration
     */
    public final void createAndShow(@NotNull SearchPopupCallback callback, boolean async2) {
        void it;
        JBList jBList;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callback = callback;
        ColoredListCellRenderer renderer2 = (ColoredListCellRenderer)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(JList<? extends String> list2, String value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                String string = value;
                if (string == null) {
                    string = "";
                }
                this.append(string);
            }
        };
        Insets insets = renderer2.getIpad();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getIpad(...)");
        Insets ipad = insets;
        ipad.left = ipad.right = this.getXOffset();
        renderer2.setFont(this.editor.getFont());
        JBList jBList2 = jBList = new JBList((ListModel)this.model);
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        boolean bl = false;
        this.list = (JList)it;
        JBPopup jBPopup = jBPopupFactory.createListPopupBuilder((JList)jBList).setMovable(false).setResizable(false).setRequestFocus(false).setItemChosenCallback(arg_0 -> FilterSearchPopup.createAndShow$lambda$1((Function1)new Function1<String, Unit>((Object)callback){

            public final void invoke(String p0) {
                ((SearchPopupCallback)this.receiver).accept(p0);
            }
        }, arg_0)).setFont(this.editor.getFont()).setRenderer((ListCellRenderer)renderer2).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup2 = jBPopup;
        popup2.addListener(this.listener);
        this.popup = popup2;
        this.event = new LightweightWindowEvent((LightweightWindow)popup2);
        this.skipCaretEvent = true;
        this.editor.addCaretListener((CaretListener)this);
        Component component2 = this.dialogComponent = (Component)this.editor.getRootPane().getParent();
        if (component2 != null) {
            component2.addComponentListener(this);
        }
        if (async2) {
            SwingUtilities.invokeLater(() -> FilterSearchPopup.createAndShow$lambda$2(this));
        } else {
            this.show();
        }
    }

    private final Point getPopupLocation() {
        Point point;
        try {
            Rectangle2D view2 = this.editor.modelToView2D(this.caretPosition);
            point = new Point((int)view2.getMaxX(), (int)view2.getMaxY());
        }
        catch (BadLocationException ignore) {
            Point point2 = this.editor.getCaret().getMagicCaretPosition();
            Intrinsics.checkNotNull((Object)point2);
            point = point2;
        }
        Point location = point;
        SwingUtilities.convertPointToScreen(location, (Component)this.editor);
        location.x -= this.getXOffset() + JBUIScale.scale((int)2);
        location.y += 2;
        return location;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValid() {
        JBPopup jBPopup = this.popup;
        Intrinsics.checkNotNull((Object)jBPopup);
        if (!jBPopup.isVisible()) return false;
        JBPopup jBPopup2 = this.popup;
        Intrinsics.checkNotNull((Object)jBPopup2);
        if (jBPopup2.getContent().getParent() == null) return false;
        return true;
    }

    public final void update() {
        block0: {
            JBPopup jBPopup;
            this.skipCaretEvent = true;
            JBPopup jBPopup2 = this.popup;
            if (jBPopup2 == null) break block0;
            JBPopup $this$update_u24lambda_u240 = jBPopup = jBPopup2;
            boolean bl = false;
            $this$update_u24lambda_u240.setLocation(this.getPopupLocation());
            $this$update_u24lambda_u240.pack(true, true);
        }
    }

    private final void show() {
        block3: {
            JList<String> currentList = this.list;
            if (currentList != null) {
                if (currentList.getModel().getSize() > 0) {
                    currentList.setSelectedIndex(0);
                } else {
                    currentList.clearSelection();
                }
            }
            JBPopup jBPopup = this.popup;
            if (jBPopup == null) break block3;
            jBPopup.showInScreenCoordinates((Component)this.editor, this.getPopupLocation());
        }
    }

    public final void hide() {
        this.editor.removeCaretListener((CaretListener)this);
        if (this.dialogComponent != null) {
            Component component2 = this.dialogComponent;
            if (component2 != null) {
                component2.removeComponentListener(this);
            }
            this.dialogComponent = null;
        }
        if (this.popup != null) {
            JBPopup jBPopup = this.popup;
            if (jBPopup != null) {
                jBPopup.cancel();
            }
            this.popup = null;
        }
    }

    @Override
    public void caretUpdate(@NotNull CaretEvent e) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!this.skipCaretEvent) break block0;
                this.skipCaretEvent = false;
                break block1;
            }
            this.hide();
            LightweightWindowEvent lightweightWindowEvent = this.event;
            if (lightweightWindowEvent == null) break block1;
            LightweightWindowEvent it = lightweightWindowEvent;
            boolean bl = false;
            this.listener.onClosed(it);
        }
    }

    @Override
    public void componentMoved(@NotNull ComponentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.popup != null && this.isValid()) {
            this.update();
        }
    }

    @Override
    public void componentResized(@NotNull ComponentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.componentMoved(e);
    }

    private final int getXOffset() {
        return JBUIScale.scale((int)UIUtil.getListCellHPadding());
    }

    private static final void createAndShow$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void createAndShow$lambda$2(FilterSearchPopup this$0) {
        this$0.show();
    }
}

