/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.oracle.generator.producers.OraMatViewProducersKt;
import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraClusterIndex;
import com.intellij.database.dialects.oracle.model.OraDataFile;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraInnerRoutine;
import com.intellij.database.dialects.oracle.model.OraMatLog;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSchemaObject;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraSynonym;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.dialects.oracle.model.OraTablespace;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.OraUser;
import com.intellij.database.dialects.oracle.model.properties.OraDataFileAvailabilityStatus;
import com.intellij.database.dialects.oracle.model.properties.OraDataFileOnlineStatus;
import com.intellij.database.dialects.oracle.model.properties.OraTableType;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceContentCategory;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceLogging;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceStatus;
import com.intellij.database.dialects.oracle.model.properties.OraTenantCategory;
import com.intellij.database.dialects.oracle.model.properties.TableOrganization;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionOptions;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.DvTreeNodeDecoration;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.Level;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbSynonym;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.common.StringFun;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import icons.DatabaseIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 h2\u00020\u0001:\u0001hB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0015\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0082\u0004J.\u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0004\u001a\u00020'H\u0016J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050)2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u001cH\u0016J\u0018\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010.\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020/2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u0002022\u0006\u0010\b\u001a\u00020\tH\u0003J\u0014\u00103\u001a\u00020\u001c2\n\u0010#\u001a\u0006\u0012\u0002\b\u000304H\u0014J\u0018\u00100\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00101\u001a\u000202H\u0002J\u0018\u00105\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u0002062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u0002092\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020<2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010@\u001a\u00020\u00052\u0006\u0010>\u001a\u00020A2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020D2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010B\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010C\u001a\u00020DH\u0002J\u000e\u0010E\u001a\u0004\u0018\u00010\u0005*\u00020DH\u0003J\u0018\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020H2\u0006\u0010\b\u001a\u00020\tH\u0003J\u0018\u0010I\u001a\u00020\u00052\u0006\u0010G\u001a\u00020J2\u0006\u0010\b\u001a\u00020\tH\u0003J\u0018\u0010I\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010K\u001a\u00020JH\u0002J\u0018\u0010L\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010K\u001a\u00020MH\u0002J\u0018\u0010N\u001a\u00020\u00052\u0006\u0010O\u001a\u00020P2\u0006\u0010\b\u001a\u00020\tH\u0003J \u0010N\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020PH\u0002J\u001e\u0010Q\u001a\u00020\u0005*\u00020P2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010R\u001a\u00020\u001cH\u0003J\u0018\u0010S\u001a\u0004\u0018\u00010\u0016*\u00020P2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010T\u001a\u00020\u00052\u0006\u0010U\u001a\u00020V2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010T\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010U\u001a\u00020VH\u0002J\f\u0010W\u001a\u00020\u0005*\u00020VH\u0003J\u000e\u0010X\u001a\u0004\u0018\u00010\u0005*\u00020VH\u0003J\u0018\u0010Y\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020[2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010Y\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010\\\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020[H\u0003J\u0018\u0010]\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010^\u001a\u00020_H\u0002J\u0018\u0010]\u001a\u00020\u00052\u0006\u0010^\u001a\u00020_2\u0006\u0010\b\u001a\u00020\tH\u0003J\u0018\u0010`\u001a\u00020\u00052\u0006\u0010a\u001a\u00020_2\u0006\u0010*\u001a\u00020\u001cH\u0002J\u0018\u0010b\u001a\u00020\u00052\u0006\u0010c\u001a\u00020d2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010e\u001a\u0004\u0018\u00010\u00052\u0006\u0010f\u001a\u00020gH\u0016R\u0018\u0010\u001f\u001a\u00020\u001c*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006i"}, d2={"Lcom/intellij/database/dialects/oracle/model/OraDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "<init>", "()V", "options", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeIdentity", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "content", "getElementDecoration", "Lcom/intellij/database/model/DvTreeNodeDecoration;", "element", "updatePresentation", "", "project", "Lcom/intellij/openapi/project/Project;", "o", "Lcom/intellij/database/model/DasObject;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "ge", "", "Ljava/util/Date;", "that", "exists", "getExists", "(Ljava/util/Date;)Z", "formatAdditionalPropertyValue", "property", "Lcom/intellij/database/model/meta/BasicMetaPropertyId;", "value", "", "Lcom/intellij/database/model/DescriptionOptions;", "getDependsOnNames", "", "withSurrogates", "describeOraCluster", "cluster", "Lcom/intellij/database/dialects/oracle/model/OraCluster;", "describeOraClusterColumn", "Lcom/intellij/database/dialects/oracle/model/OraClusterColumn;", "describeOraTable", "table", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "shouldAutoDescribe", "Lcom/intellij/database/model/meta/BasicMetaField;", "describeOraTableColumn", "Lcom/intellij/database/dialects/oracle/model/OraTableColumn;", "describeOraMatLog", "ml", "Lcom/intellij/database/dialects/oracle/model/OraMatLog;", "describeOraMatView", "view", "Lcom/intellij/database/dialects/oracle/model/OraMatView;", "describeOraIndex", "index", "Lcom/intellij/database/dialects/oracle/model/OraIndex;", "describeOraClusterIndex", "Lcom/intellij/database/dialects/oracle/model/OraClusterIndex;", "describeOraSequence", "sequence", "Lcom/intellij/database/dialects/oracle/model/OraSequence;", "presentInfo", "describeOraSingleRoutine", "routine", "Lcom/intellij/database/dialects/oracle/model/OraSingleRoutine;", "describeOraInnerRoutine", "Lcom/intellij/database/dialects/oracle/model/OraInnerRoutine;", "r", "describeOraRoutine", "Lcom/intellij/database/dialects/oracle/model/OraRoutine;", "describeOraSynonym", "synonym", "Lcom/intellij/database/dialects/oracle/model/OraSynonym;", "presentTarget", "forceKind", "resolveWithCache", "describeDbLink", "dbLink", "Lcom/intellij/database/dialects/oracle/model/OraDbLink;", "presentRemote", "presentRemoteDB", "describeTablespace", "tablespace", "Lcom/intellij/database/dialects/oracle/model/OraTablespace;", "describeTablespaceDetails", "describeDataFile", "dataFile", "Lcom/intellij/database/dialects/oracle/model/OraDataFile;", "describeDataFileDetails", "df", "describeOraRoot", "root", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "getMinorObjectSchemaName", "obj", "Lcom/intellij/database/model/basic/BasicMinorObject;", "Companion", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraDescriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraDescriptionService.kt\ncom/intellij/database/dialects/oracle/model/OraDescriptionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 6 DescriptionService.kt\ncom/intellij/database/model/DescriptionService$Context\n*L\n1#1,567:1\n1651#2:568\n1915#2:569\n1916#2:571\n1652#2:572\n1#3:570\n1#3:574\n14#4:573\n19#5:575\n74#6:576\n*S KotlinDebug\n*F\n+ 1 OraDescriptionService.kt\ncom/intellij/database/dialects/oracle/model/OraDescriptionService\n*L\n155#1:568\n155#1:569\n155#1:571\n155#1:572\n155#1:570\n260#1:573\n409#1:575\n526#1:576\n*E\n"})
public final class OraDescriptionService
extends DescriptionService {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<RegexOption> REGEX_OPTIONS;
    @NotNull
    private static final Regex REMOTE_DESC_HOST_PATTERN;
    @NotNull
    private static final Regex REMOTE_DESC_PORT_PATTERN;
    @NotNull
    private static final Regex REMOTE_DESC_SERV_PATTERN;
    @NotNull
    private static final Regex SPACES_PATTERN;
    @NotNull
    private static final Regex HEX_PATTERN;

    @NotNull
    public String options(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ((Collection)context.getDescribed()).add(OraSourceAware.OBFUSCATED);
        ((Collection)context.getDescribed()).add(OraMatView.PREBUILT);
        ((Collection)context.getDescribed()).add(OraSynonym.INVALID);
        ((Collection)context.getDescribed()).add(OraTableColumn.HIDDEN);
        return super.options(e, context) + (e instanceof OraSourceAware && ((OraSourceAware)e).isObfuscated() ? " [obfuscated]" : "") + (e instanceof OraMatView && ((OraMatView)e).isPrebuilt() ? " [prebuilt]" : "") + (e instanceof OraSynonym && ((OraSynonym)e).isInvalid() ? " [invalid]" : "") + (e instanceof OraTableColumn && ((OraTableColumn)e).isHidden() ? " [hidden]" : "");
    }

    @Nullable
    protected String describeIdentity(@NotNull BasicLikeColumn column, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ((Collection)context.getDescribed()).add(OraTableColumn.SEQUENCE_REF);
        return super.describeIdentity(column, context);
    }

    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof OraCluster ? this.describeOraCluster((OraCluster)e, context) : (basicElement instanceof OraClusterColumn ? this.describeOraClusterColumn((OraClusterColumn)e, context) : (basicElement instanceof OraTable ? this.describeOraTable((OraTable)e, context) : (basicElement instanceof OraTableColumn ? this.describeOraTableColumn((OraTableColumn)e, context) : (basicElement instanceof OraMatLog ? this.describeOraMatLog((OraMatLog)e, context) : (basicElement instanceof OraMatView ? this.describeOraMatView((OraMatView)e, context) : (basicElement instanceof OraIndex ? this.describeOraIndex((OraIndex)e, context) : (basicElement instanceof OraClusterIndex ? this.describeOraClusterIndex((OraClusterIndex)e, context) : (basicElement instanceof OraSequence ? this.describeOraSequence((OraSequence)e, context) : (basicElement instanceof OraSingleRoutine ? this.describeOraSingleRoutine((OraSingleRoutine)e, context) : (basicElement instanceof OraInnerRoutine ? this.describeOraInnerRoutine((OraInnerRoutine)e, context) : (basicElement instanceof OraSynonym ? this.describeOraSynonym((OraSynonym)e, context) : (basicElement instanceof OraDbLink ? this.describeDbLink((OraDbLink)e, context) : (basicElement instanceof OraTablespace ? this.describeTablespace((OraTablespace)e, context) : (basicElement instanceof OraDataFile ? this.describeDataFile((OraDataFile)e, context) : (basicElement instanceof OraRoot ? this.describeOraRoot((OraRoot)e, context) : super.content(e, context))))))))))))))));
    }

    @NotNull
    public DvTreeNodeDecoration getElementDecoration(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DvTreeNodeDecoration d = super.getElementDecoration(element);
        if (element instanceof OraUser && (((OraUser)element).isExpired() || ((OraUser)element).isLocked())) {
            d = DvTreeNodeDecoration.copy$default((DvTreeNodeDecoration)d, (boolean)true, null, (int)2, null);
        }
        return d;
    }

    public void updatePresentation(@NotNull Project project, @NotNull DasObject o, @NotNull DvViewOptions viewOptions, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        DasObject dasObject = o;
        if (dasObject instanceof OraTable) {
            this.describeOraTable(presentation, (OraTable)o);
        } else if (dasObject instanceof OraSequence) {
            this.describeOraSequence(presentation, (OraSequence)o);
        } else if (dasObject instanceof OraInnerRoutine) {
            this.describeOraInnerRoutine(presentation, (OraInnerRoutine)o);
        } else if (dasObject instanceof OraRoutine) {
            this.describeOraRoutine(presentation, (OraRoutine)o);
        } else if (dasObject instanceof OraSynonym) {
            this.describeOraSynonym(project, presentation, (OraSynonym)o);
        } else if (dasObject instanceof OraDbLink) {
            this.describeDbLink(presentation, (OraDbLink)o);
        } else if (dasObject instanceof OraTablespace) {
            this.describeTablespace(presentation, (OraTablespace)o);
        } else if (dasObject instanceof OraDataFile) {
            this.describeDataFile(presentation, (OraDataFile)o);
        } else {
            super.updatePresentation(project, o, viewOptions, presentation);
        }
    }

    private final boolean ge(Date $this$ge, Date that) {
        return this.getExists($this$ge) && $this$ge.getTime() >= that.getTime();
    }

    private final boolean getExists(Date $this$exists) {
        return $this$exists.getTime() > BaseIntrospectionFunctions.AGES_AGO.getTime();
    }

    @NotNull
    public String formatAdditionalPropertyValue(@NotNull BasicElement e, @NotNull BasicMetaPropertyId<?> property, @Nullable Object value, @NotNull DescriptionOptions options) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        BasicMetaPropertyId<?> basicMetaPropertyId = property;
        if (Intrinsics.areEqual(basicMetaPropertyId, OraDbLink.CONNECT_USER_PASSWORD) || Intrinsics.areEqual(basicMetaPropertyId, OraDbLink.AUTH_USER_PASSWORD)) {
            CharSequence charSequence;
            String s = String.valueOf(value);
            string = !options.getWithSurrogates() && HEX_PATTERN.matches(charSequence = (CharSequence)s) ? "hashed password" : s;
        } else {
            string = super.formatAdditionalPropertyValue(e, property, value, options);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getDependsOnNames(@NotNull BasicElement e, boolean withSurrogates) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        OraSourceAware oraSourceAware = e instanceof OraSourceAware ? (OraSourceAware)e : null;
        if (oraSourceAware == null) {
            return SetsKt.emptySet();
        }
        OraSourceAware oraSourceAware2 = oraSourceAware;
        Set<Long> set = oraSourceAware2.getDependsOnIds();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getDependsOnIds(...)");
        Set<Long> ids = set;
        if (ids.isEmpty()) {
            return SetsKt.emptySet();
        }
        BasicDatabase basicDatabase = oraSourceAware2.getDatabase();
        Intrinsics.checkNotNull((Object)basicDatabase);
        BasicDatabase database = basicDatabase;
        BasicSchema basicSchema = oraSourceAware2.getSchema();
        Intrinsics.checkNotNull((Object)basicSchema);
        BasicSchema schema = basicSchema;
        Iterable iterable = ids;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Long it = (Long)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            OraSchemaObject o = (OraSchemaObject)database.findIdentifiedElement(it.longValue(), OraSchemaObject.class);
            if (o == null) {
                object = withSurrogates ? String.valueOf(it) : null;
            } else if (o.getSchema() == schema) {
                object = o.getName();
            } else {
                Object object2 = o.getSchema();
                if (object2 == null || (object2 = object2.getName()) == null) {
                    object2 = "<unknown-schema>";
                }
                object = (String)object2 + "." + o.getName();
            }
            if (object == null) continue;
            String it$iv = object;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        ArrayList items = (ArrayList)destination$iv;
        CollectionsKt.sort((List)items);
        return items;
    }

    private final String describeOraCluster(OraCluster cluster, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraCluster.CLUSTER_TYPE);
        ((Collection)context.getDescribed()).add(OraCluster.HASH_CARDINALITY);
        ((Collection)context.getDescribed()).add(OraCluster.HASH_EXPRESSION);
        ((Collection)context.getDescribed()).add(OraCluster.SINGLE_TABLE);
        ((Collection)context.getDescribed()).add(OraCluster.BLOCK_SIZE);
        ((Collection)context.getDescribed()).add(OraCluster.TABLESPACE_REF);
        ModPositioningNamingFamily<? extends OraClusterColumn> modPositioningNamingFamily = cluster.getColumns();
        Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
        String columns = CollectionsKt.joinToString$default((Iterable)((Iterable)modPositioningNamingFamily), null, null, null, (int)0, null, OraDescriptionService::describeOraCluster$lambda$0, (int)31, null);
        String s = null;
        switch (WhenMappings.$EnumSwitchMapping$0[cluster.getClusterType().ordinal()]) {
            case 1: {
                s = "index cluster (" + columns + ") block size " + cluster.getBlockSize();
                break;
            }
            case 2: {
                String exp = cluster.getHashExpression();
                String string = s = exp == null ? "hash cluster (" + columns + ") hash by column cardinality " + cluster.getHashCardinality() : "hash cluster (" + columns + ") hash by (" + exp + ") cardinality " + cluster.getHashCardinality();
                if (!cluster.isSingleTable()) break;
                s = (String)s + " (single table)";
                break;
            }
            default: {
                s = "cluster (" + columns + ")";
            }
        }
        return s;
    }

    private final String describeOraClusterColumn(OraClusterColumn column, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraClusterColumn.STORED_TYPE);
        ((Collection)context.getDescribed()).add(OraClusterColumn.SORTED);
        Object s = this.typeSpec((BasicTypedElement)column, context);
        if (column.isSorted()) {
            s = (String)s + " sort";
        }
        return s;
    }

    @NonNls
    private final String describeOraTable(OraTable table, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraTable.ORGANIZATION);
        ((Collection)context.getDescribed()).add(OraTable.TEMPORARY);
        ((Collection)context.getDescribed()).add(OraTable.TEMPORARY_PRESERVE);
        ((Collection)context.getDescribed()).add(OraTable.TABLE_TYPE);
        ((Collection)context.getDescribed()).add(OraTable.SECONDARY);
        ((Collection)context.getDescribed()).add(OraTable.TABLESPACE_REF);
        Object d = table.getOrganization() == TableOrganization.ORA_CLUSTERED_BY_INDEX ? "cluster table" : (table.getOrganization() == TableOrganization.ORA_CLUSTERED_BY_HASH ? "cluster table" : (table.isTemporary() && table.isTemporaryPreserve() ? "temporary table (preserve rows)" : (table.isTemporary() && !table.isTemporaryPreserve() ? "temporary table" : this.describeTable((BasicTable)table, context))));
        switch (WhenMappings.$EnumSwitchMapping$1[table.getTableType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                d = (String)d + " (mat.log)";
                break;
            }
            case 3: {
                d = (String)d + " (mat.log.temp)";
                break;
            }
            case 4: {
                d = (String)d + " (mat.view)";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (table.isSecondary()) {
            d = (String)d + " secondary";
        }
        return d;
    }

    protected boolean shouldAutoDescribe(@NotNull BasicMetaField<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return Intrinsics.areEqual((Object)property.getId(), OraTable.MASTER_TABLE_REF) || Intrinsics.areEqual((Object)property.getId(), (Object)OraIndex.CLUSTERING) || super.shouldAutoDescribe(property);
    }

    private final void describeOraTable(PresentationData presentation, OraTable table) {
        switch (WhenMappings.$EnumSwitchMapping$1[table.getTableType().ordinal()]) {
            case 1: {
                break;
            }
            case 4: {
                presentation.setIcon(DatabaseIcons.MaterializedView);
                break;
            }
            case 2: {
                presentation.setIcon(DatabaseIcons.MaterializedLog);
                break;
            }
            case 3: {
                presentation.setIcon(DatabaseIcons.MaterializedLog);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (table.getTableType() == OraTableType.MAT_VIEW) {
            boolean pb;
            ModNamingIdentifyingFamily<? extends OraMatView> schema = table.getSchema();
            ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily = schema;
            OraMatView mv = modNamingIdentifyingFamily != null && (modNamingIdentifyingFamily = modNamingIdentifyingFamily.getMatViews()) != null ? (OraMatView)modNamingIdentifyingFamily.get(table.getName()) : null;
            boolean bl = pb = mv != null && mv.isPrebuilt();
            if (pb) {
                presentation.addText("(pre-built)", DbPresentationCore.INFO_ATTRS);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String describeOraTableColumn(OraTableColumn column, DescriptionService.Context context) {
        void _true_$iv;
        void $this$choose$iv;
        ((Collection)context.getDescribed()).add(OraTableColumn.COMPUTED);
        ((Collection)context.getDescribed()).add(OraTableColumn.EXPLICIT_PRECISION);
        boolean computed = column.isComputed();
        boolean bl = computed;
        String string = "computed";
        String _false_$iv = "default";
        boolean $i$f$choose = false;
        Object s = this.describeColumn((BasicLikeColumn)column, context, (String)($this$choose$iv != false ? _true_$iv : _false_$iv));
        if (column.isExplicitPrecision()) {
            s = (String)s + " (explicit precision)";
        }
        return s;
    }

    private final String describeOraMatLog(OraMatLog ml, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraMatLog.WITH_NEW_VALUES);
        ((Collection)context.getDescribed()).add(OraMatLog.WITH_OBJECT_ID);
        ((Collection)context.getDescribed()).add(OraMatLog.WITH_PRIMARY_KEY);
        ((Collection)context.getDescribed()).add(OraMatLog.WITH_ROW_ID);
        ((Collection)context.getDescribed()).add(OraMatLog.WITH_SEQUENCE);
        Object s = ml.withOptions();
        if (ml.isWithNewValues()) {
            s = (String)s + " including new values";
        }
        String string = s;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final String describeOraMatView(OraMatView view, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraMatView.REFRESH_METHOD);
        ((Collection)context.getDescribed()).add(OraMatView.REFRESH_MODE);
        return this.describeView((BasicView)view, context) + " " + OraMatViewProducersKt.getRefreshSpecification(view);
    }

    private final String describeOraIndex(OraIndex index, DescriptionService.Context context) {
        Object desc;
        block1: {
            ((Collection)context.getDescribed()).add(OraIndex.INDEXTYPE_REF);
            ((Collection)context.getDescribed()).add(OraIndex.TABLESPACE_REF);
            ((Collection)context.getDescribed()).add(OraIndex.FUNCTION_BASED);
            desc = null;
            desc = super.describeIndex((BasicIndex)index, context);
            BasicReference basicReference = index.getIndextypeRef();
            if (basicReference == null) break block1;
            BasicReference it = basicReference;
            boolean bl = false;
            desc = desc + " indextype: ";
            if (it.getParentName() != null) {
                desc = desc + it.getParentName() + ".";
            }
            desc = desc + it.getName();
        }
        return desc;
    }

    private final String describeOraClusterIndex(OraClusterIndex index, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraIndex.TABLESPACE_REF);
        return super.describeBasicElement((BasicElement)index);
    }

    private final String describeOraSequence(OraSequence sequence, DescriptionService.Context context) {
        String sequenceInfo;
        ((Collection)context.getDescribed()).add(OraSequence.SEQUENCE_IDENTITY);
        String string = sequenceInfo = this.presentInfo(sequence);
        return string != null ? "sequence: " + string : "sequence";
    }

    private final void describeOraSequence(PresentationData presentation, OraSequence sequence) {
        String sequenceInfo = this.presentInfo(sequence);
        if (sequenceInfo != null) {
            presentation.addText(sequenceInfo, DbPresentationCore.INFO_ATTRS);
        }
    }

    @NlsSafe
    private final String presentInfo(OraSequence $this$presentInfo) {
        OraTableColumn hostColumn;
        Object s;
        if ($this$presentInfo.getDetailsLevel() == Level.L1) {
            return null;
        }
        Object object = $this$presentInfo.getSequenceIdentity().getSpecification();
        if (object == null) {
            object = s = "???";
        }
        if ((hostColumn = $this$presentInfo.getHostTableColumn()) != null) {
            s = (String)s + " (for " + hostColumn.getTableName() + "." + hostColumn.getName() + ")";
        }
        return s;
    }

    @NlsSafe
    private final String describeOraSingleRoutine(OraSingleRoutine routine, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraInnerRoutine.ROUTINE_NR);
        return this.describeRoutine((BasicRoutine)routine, context);
    }

    @NlsSafe
    private final String describeOraInnerRoutine(OraInnerRoutine routine, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraInnerRoutine.ROUTINE_NR);
        ((Collection)context.getDescribed()).add(OraInnerRoutine.OVERLOAD_NR);
        return this.describeRoutine((BasicRoutine)routine, context);
    }

    private final void describeOraInnerRoutine(PresentationData presentation, OraInnerRoutine r) {
        short ovr = r.getOverloadNr();
        if (ovr > 0) {
            presentation.addText("[" + ovr + "] ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        this.describeOraRoutine(presentation, r);
    }

    private final void describeOraRoutine(PresentationData presentation, OraRoutine r) {
        ModPositioningNamingFamily<? extends OraArgument> modPositioningNamingFamily = r.getArguments();
        Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getArguments(...)");
        ModPositioningNamingFamily<? extends OraArgument> arguments = modPositioningNamingFamily;
        StringBuilder b = new StringBuilder(arguments.size() * 16);
        OraArgument result = null;
        boolean was = false;
        if (arguments.isNotEmpty()) {
            b.append('(');
            for (OraArgument a : arguments) {
                ArgumentDirection d;
                Intrinsics.checkNotNullExpressionValue((Object)a.getArgumentDirection(), (String)"getArgumentDirection(...)");
                if (d == ArgumentDirection.RESULT || d == ArgumentDirection.RETURN) {
                    result = a;
                }
                if (d == ArgumentDirection.RESULT || d == ArgumentDirection.RETURN || d == ArgumentDirection.SELF) continue;
                if (was) {
                    b.append(',').append(' ');
                } else {
                    was = true;
                }
                b.append(a.getName());
                if (d == ArgumentDirection.INOUT) {
                    b.append(" in out");
                    continue;
                }
                if (d != ArgumentDirection.OUT) continue;
                b.append(" out");
            }
            b.append(')');
        }
        if (result != null) {
            DasType dasType = result.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            String t = DasTypeUtilsKt.getTypeName((DasType)dasType);
            StringFun.appendIf((StringBuilder)b, (!Intrinsics.areEqual((Object)t, (Object)"unknown") ? 1 : 0) != 0, (CharSequence)": ", (CharSequence)t);
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        presentation.addText(string2, DbPresentationCore.INFO_ATTRS);
    }

    @NlsSafe
    private final String describeOraSynonym(OraSynonym synonym, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraSynonym.TARGET_OBJECT_REF);
        return "synonym -> " + this.presentTarget(synonym, null, true);
    }

    private final void describeOraSynonym(Project project, PresentationData presentation, OraSynonym synonym) {
        String text = DbPresentationCore.arrow() + " " + this.presentTarget(synonym, project, false);
        presentation.addText(text, DbPresentationCore.INFO_ATTRS);
    }

    @NlsSafe
    private final String presentTarget(OraSynonym $this$presentTarget, Project project, boolean forceKind) {
        Object x;
        DasObject targetObject = this.resolveWithCache($this$presentTarget, project);
        if (targetObject != null) {
            return targetObject.getKind().code() + " " + targetObject.getName();
        }
        String dbLinkName = $this$presentTarget.getTargetDbLinkName();
        String schemaName = $this$presentTarget.getTargetSchemaName() != null && !Intrinsics.areEqual((Object)$this$presentTarget.getTargetSchemaName(), (Object)$this$presentTarget.getSchemaName()) ? $this$presentTarget.getTargetSchemaName() : null;
        String string = $this$presentTarget.getTargetObjectName();
        if (string == null) {
            string = "<unnamed-object>";
        }
        String objectName = string;
        String string2 = schemaName;
        Object object = x = string2 != null ? string2 + "." + objectName : objectName;
        if (dbLinkName != null) {
            x = (String)x + "@" + dbLinkName;
        }
        ObjectKind objectKind = $this$presentTarget.getTargetObjectKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getTargetObjectKind(...)");
        ObjectKind kind = objectKind;
        if (!Intrinsics.areEqual((Object)kind, (Object)ObjectKind.NONE)) {
            x = kind.code() + " " + (String)x;
        } else if (forceKind) {
            x = "<unknown> " + (String)x;
        }
        return x;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DasObject resolveWithCache(OraSynonym $this$resolveWithCache, Project project) {
        Object v3;
        block3: {
            if (project == null) return (DasObject)$this$resolveWithCache.getTargetObject();
            BasicModel basicModel = $this$resolveWithCache.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)basicModel, (String)"getModel(...)");
            BasicModModel m = (BasicModModel)basicModel;
            List list = DbPsiFacade.getInstance((Project)project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                DbDataSource it = (DbDataSource)t;
                boolean bl = false;
                RawDataSource rawDataSource = it.getDelegate();
                LocalDataSource localDataSource = rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
                if (!Intrinsics.areEqual((Object)(localDataSource != null ? localDataSource.getModel() : null), (Object)m)) continue;
                v3 = t;
                break block3;
            }
            v3 = null;
        }
        DbDataSource dbDataSource = v3;
        if (dbDataSource == null) return (DasObject)$this$resolveWithCache.getTargetObject();
        DbDataSource ds = dbDataSource;
        boolean bl = false;
        DbElement dbElement = ds.findElement((DasObject)$this$resolveWithCache);
        Object object = dbElement;
        if (dbElement == null) return null;
        DbElement $this$asSafely$iv = object;
        boolean $i$f$asSafely = false;
        DbElement dbElement2 = $this$asSafely$iv;
        if (!(dbElement2 instanceof DbSynonym)) {
            dbElement2 = null;
        }
        DbSynonym dbSynonym = (DbSynonym)dbElement2;
        object = dbSynonym;
        if (dbSynonym == null) return null;
        DbElement dbElement3 = object.resolveTarget();
        object = dbElement3;
        if (dbElement3 == null) return null;
        Object object = object.getDelegate();
        object = object;
        if (object2 == null) return null;
        Object object3 = object;
        boolean $i$f$asSafely2 = false;
        Object object4 = object3;
        if (!(object4 instanceof DasObject)) {
            object4 = null;
        }
        DasObject dasObject = (DasObject)object4;
        return dasObject;
    }

    private final String describeDbLink(OraDbLink dbLink, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraDbLink.CONNECT_USER_NAME);
        ((Collection)context.getDescribed()).add(OraDbLink.REMOTE_DATABASE_STRING);
        return "DB link -> " + this.presentRemote(dbLink);
    }

    private final void describeDbLink(PresentationData presentation, OraDbLink dbLink) {
        String text = DbPresentationCore.arrow() + " " + this.presentRemote(dbLink);
        presentation.addText(text, DbPresentationCore.INFO_ATTRS);
    }

    @NlsSafe
    private final String presentRemote(OraDbLink $this$presentRemote) {
        Object object = $this$presentRemote.getConnectUserName() != null ? $this$presentRemote.getConnectUserName() + "@" : "";
        String string = this.presentRemoteDB($this$presentRemote);
        if (string == null) {
            string = "???";
        }
        return (String)object + string;
    }

    @NlsSafe
    private final String presentRemoteDB(OraDbLink $this$presentRemoteDB) {
        String string = $this$presentRemoteDB.getRemoteDatabaseString();
        if (string == null) {
            return null;
        }
        String rdb = string;
        if (StringsKt.startsWith$default((CharSequence)rdb, (char)'(', (boolean)false, (int)2, null)) {
            String host = StringFun.extract((CharSequence)rdb, (Regex)REMOTE_DESC_HOST_PATTERN, (int)1);
            String port = StringFun.extract((CharSequence)rdb, (Regex)REMOTE_DESC_PORT_PATTERN, (int)1);
            String serv = StringFun.extract((CharSequence)rdb, (Regex)REMOTE_DESC_SERV_PATTERN, (int)2);
            if (host == null && port == null && serv == null) {
                CharSequence charSequence = rdb;
                Regex regex = SPACES_PATTERN;
                String string2 = " ";
                return regex.replace(charSequence, string2);
            }
            StringBuilder b = new StringBuilder();
            if (host != null) {
                b.append(host);
            }
            if (port != null || serv != null) {
                b.append(':');
            }
            if (port != null) {
                b.append(port);
            }
            if (serv != null) {
                b.append(':').append(serv);
            }
            return b.toString();
        }
        return rdb;
    }

    private final String describeTablespace(OraTablespace tablespace, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraTablespace.CONTENT_CATEGORY);
        ((Collection)context.getDescribed()).add(OraTablespace.STATUS);
        ((Collection)context.getDescribed()).add(OraTablespace.BLOCK_SIZE);
        ((Collection)context.getDescribed()).add(OraTablespace.BIG_FILE);
        ((Collection)context.getDescribed()).add(OraTablespace.LOGGING);
        return this.describeTablespaceDetails(tablespace);
    }

    private final void describeTablespace(PresentationData presentation, OraTablespace tablespace) {
        OraTablespaceStatus oraTablespaceStatus = tablespace.getStatus();
        switch (oraTablespaceStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$2[oraTablespaceStatus.ordinal()]) {
            case 1: {
                presentation.setForcedTextForeground(Color.GRAY);
                break;
            }
            case 2: {
                presentation.setForcedTextForeground(Color.BLUE);
                break;
            }
            case 3: {
                presentation.setForcedTextForeground(Color.ORANGE);
            }
        }
        String text = this.describeTablespaceDetails(tablespace);
        if (((CharSequence)text).length() > 0) {
            presentation.addText(text, DbPresentationCore.INFO_ATTRS);
        }
    }

    @NonNls
    private final String describeTablespaceDetails(OraTablespace tablespace) {
        Enum it;
        Enum enum_;
        StringBuilder b = new StringBuilder();
        OraTablespaceContentCategory oraTablespaceContentCategory = tablespace.getContentCategory();
        if (oraTablespaceContentCategory != null) {
            it = enum_ = oraTablespaceContentCategory;
            boolean bl = false;
            b.append(((OraTablespaceContentCategory)it).getDisplayName());
        }
        OraTablespaceStatus oraTablespaceStatus = tablespace.getStatus();
        if (oraTablespaceStatus != null) {
            it = enum_ = oraTablespaceStatus;
            boolean bl = false;
            StringFun.appendIfNotEmpty((StringBuilder)b, (String)", ").append(((OraTablespaceStatus)it).getDisplayName());
        }
        int blockSize = tablespace.getBlockSize();
        if (blockSize > 0) {
            StringFun.appendIfNotEmpty((StringBuilder)b, (String)", ").append("block size ").append(blockSize);
        }
        if (tablespace.isBigFile()) {
            StringFun.appendIfNotEmpty((StringBuilder)b, (String)", ").append("big file");
        }
        OraTablespaceLogging oraTablespaceLogging = tablespace.getLogging();
        if (oraTablespaceLogging != null) {
            OraTablespaceLogging oraTablespaceLogging2;
            OraTablespaceLogging it2 = oraTablespaceLogging2 = oraTablespaceLogging;
            boolean bl = false;
            StringFun.appendIfNotEmpty((StringBuilder)b, (String)", ").append(it2.getDisplayName());
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void describeDataFile(PresentationData presentation, OraDataFile dataFile) {
        Enum enum_;
        Color color;
        Color color2 = dataFile.getAvailabilityStatus() == OraDataFileAvailabilityStatus.DF_INVALID ? Color.RED : (dataFile.getAvailabilityStatus() == OraDataFileAvailabilityStatus.DF_UNDEFINED ? Color.ORANGE : (dataFile.getOnlineStatus() == OraDataFileOnlineStatus.DF_OFFLINE ? Color.GRAY : (color = dataFile.getOnlineStatus() == OraDataFileOnlineStatus.DF_RECOVER ? Color.MAGENTA : null)));
        if (color != null) {
            presentation.setForcedTextForeground(color);
        }
        OraTablespace oraTablespace = dataFile.getTablespace();
        if (oraTablespace == null) {
            return;
        }
        OraTablespace tablespace = oraTablespace;
        int bs = tablespace.getBlockSize();
        long size = dataFile.getFileSize() * (long)bs;
        String string = StringUtil.formatFileSize((long)size);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        String sizeStr = string;
        StringBuilder b = new StringBuilder();
        b.append(sizeStr);
        if (dataFile.isAutoExtensible()) {
            long incSize = dataFile.getIncrementBy() * (long)bs;
            long maxSize = dataFile.getMaxSize() * (long)bs;
            b.append("+ (inc by ").append(StringUtil.formatFileSize((long)incSize)).append(" max ").append(StringUtil.formatFileSize((long)maxSize)).append(')');
        }
        OraDataFileAvailabilityStatus oraDataFileAvailabilityStatus = dataFile.getAvailabilityStatus();
        if (oraDataFileAvailabilityStatus != null) {
            enum_ = oraDataFileAvailabilityStatus;
            OraDataFileAvailabilityStatus it = enum_;
            boolean bl = false;
            b.append(' ').append(it.getDisplayName());
        }
        OraDataFileOnlineStatus oraDataFileOnlineStatus = dataFile.getOnlineStatus();
        if (oraDataFileOnlineStatus != null) {
            Enum it = enum_ = oraDataFileOnlineStatus;
            boolean bl = false;
            b.append(' ').append(((OraDataFileOnlineStatus)it).getDisplayName());
        }
        String string2 = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String description = string2;
        presentation.addText(description, DbPresentationCore.INFO_ATTRS);
    }

    @NonNls
    private final String describeDataFile(OraDataFile dataFile, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraDataFile.FILE_ID);
        ((Collection)context.getDescribed()).add(OraDataFile.FILE_SIZE);
        ((Collection)context.getDescribed()).add(OraDataFile.USER_SIZE);
        ((Collection)context.getDescribed()).add(OraDataFile.AUTO_EXTENSIBLE);
        ((Collection)context.getDescribed()).add(OraDataFile.INCREMENT_BY);
        ((Collection)context.getDescribed()).add(OraDataFile.MAX_SIZE);
        ((Collection)context.getDescribed()).add(OraDataFile.AVAILABILITY_STATUS);
        ((Collection)context.getDescribed()).add(OraDataFile.ONLINE_STATUS);
        DescriptionService.Context this_$iv = context;
        boolean $i$f$getWithSurrogates = false;
        return this.describeDataFileDetails(dataFile, this_$iv.getOptions().getWithSurrogates());
    }

    private final String describeDataFileDetails(OraDataFile df, boolean withSurrogates) {
        Enum it;
        Enum enum_;
        StringBuilder b = new StringBuilder();
        if (withSurrogates) {
            b.append("id:").append(df.getFileId());
        }
        StringFun.appendIfNotEmpty((StringBuilder)b, (String)", ").append("size:").append(df.getFileSize());
        if (df.getUserSize() > 0L) {
            b.append(" (user ").append(df.getUserSize()).append(')');
        }
        if (df.isAutoExtensible()) {
            b.append(" +").append(df.getIncrementBy()).append(" max ").append(df.getMaxSize());
        }
        b.append(" blocks");
        OraDataFileAvailabilityStatus oraDataFileAvailabilityStatus = df.getAvailabilityStatus();
        if (oraDataFileAvailabilityStatus != null) {
            it = enum_ = oraDataFileAvailabilityStatus;
            boolean bl = false;
            b.append(", ").append(((OraDataFileAvailabilityStatus)it).getDisplayName());
        }
        OraDataFileOnlineStatus oraDataFileOnlineStatus = df.getOnlineStatus();
        if (oraDataFileOnlineStatus != null) {
            it = enum_ = oraDataFileOnlineStatus;
            boolean bl = false;
            b.append(", ").append(((OraDataFileOnlineStatus)it).getDisplayName());
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String describeOraRoot(OraRoot root, DescriptionService.Context context) {
        String s = this.describeRoot((BasicRoot)root, context);
        OraTenantCategory oraTenantCategory = root.getTenantCategory();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)oraTenantCategory), (String)"getTenantCategory(...)");
        OraTenantCategory tenantCategory = oraTenantCategory;
        if (tenantCategory.compareTo((Enum)OraTenantCategory.SOLID) > 0) {
            s = StringsKt.replace$default((String)s, (String)"root", (String)("root of " + tenantCategory), (boolean)false, (int)4, null);
        }
        return s;
    }

    @Nullable
    public String getMinorObjectSchemaName(@NotNull BasicMinorObject obj) {
        String string;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (obj instanceof OraTrigger) {
            BasicReferenceInfo<? extends OraSchema> basicReferenceInfo = ((OraTrigger)obj).getInSchemaRefInfo();
            string = basicReferenceInfo != null ? basicReferenceInfo.getName() : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final CharSequence describeOraCluster$lambda$0(OraClusterColumn it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    static {
        Object[] objectArray = new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL};
        REGEX_OPTIONS = SetsKt.setOf((Object[])objectArray);
        REMOTE_DESC_HOST_PATTERN = new Regex("\\(\\s*HOST\\s*=\\s*(.+?)\\s*\\)", REGEX_OPTIONS);
        REMOTE_DESC_PORT_PATTERN = new Regex("\\(\\s*PORT\\s*=\\s*(.+?)\\s*\\)", REGEX_OPTIONS);
        REMOTE_DESC_SERV_PATTERN = new Regex("\\(\\s*S(ID|ERVICE_NAME)\\s*=\\s*(.+?)\\s*\\)", REGEX_OPTIONS);
        SPACES_PATTERN = new Regex("\\s+", RegexOption.DOT_MATCHES_ALL);
        HEX_PATTERN = new Regex("[0-9A-Fa-f]+");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/oracle/model/OraDescriptionService$Companion;", "", "<init>", "()V", "REGEX_OPTIONS", "", "Lkotlin/text/RegexOption;", "getREGEX_OPTIONS", "()Ljava/util/Set;", "REMOTE_DESC_HOST_PATTERN", "Lkotlin/text/Regex;", "getREMOTE_DESC_HOST_PATTERN", "()Lkotlin/text/Regex;", "REMOTE_DESC_PORT_PATTERN", "getREMOTE_DESC_PORT_PATTERN", "REMOTE_DESC_SERV_PATTERN", "getREMOTE_DESC_SERV_PATTERN", "SPACES_PATTERN", "getSPACES_PATTERN", "HEX_PATTERN", "getHEX_PATTERN", "intellij.database.dialects.oracle"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<RegexOption> getREGEX_OPTIONS() {
            return REGEX_OPTIONS;
        }

        @NotNull
        public final Regex getREMOTE_DESC_HOST_PATTERN() {
            return REMOTE_DESC_HOST_PATTERN;
        }

        @NotNull
        public final Regex getREMOTE_DESC_PORT_PATTERN() {
            return REMOTE_DESC_PORT_PATTERN;
        }

        @NotNull
        public final Regex getREMOTE_DESC_SERV_PATTERN() {
            return REMOTE_DESC_SERV_PATTERN;
        }

        @NotNull
        public final Regex getSPACES_PATTERN() {
            return SPACES_PATTERN;
        }

        @NotNull
        public final Regex getHEX_PATTERN() {
            return HEX_PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ClusterType.values().length];
            try {
                nArray[ClusterType.INDEX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClusterType.HASH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OraTableType.values().length];
            try {
                nArray[OraTableType.BASIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTableType.MAT_LOG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTableType.MAT_LOG_TEMP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTableType.MAT_VIEW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[OraTablespaceStatus.values().length];
            try {
                nArray[OraTablespaceStatus.TS_OFFLINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTablespaceStatus.TS_READ_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTablespaceStatus.TS_UNDEFINED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

