/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.users;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.users.CWMUserFocusHost;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.cwm.plugin.join.JoinLinkData;
import com.intellij.cwm.plugin.session.CodeWithMeSessionListener;
import com.intellij.cwm.plugin.users.BackendCWMUserFocusHost;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileOpenedSyncListener;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.CwmActiveClientsModel_GeneratedKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.document.BackendDocumentHost;
import com.jetbrains.rdserver.toolWindow.BackendServerToolWindowManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/intellij/cwm/plugin/users/BackendCWMUserFocusHost;", "Lcom/intellij/cwm/plugin/common/users/CWMUserFocusHost;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "clientToActiveFileMap", "Ljava/util/HashMap;", "Lcom/intellij/codeWithMe/ClientId;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/collections/HashMap;", "serverNotify", "", "document", "Lcom/intellij/openapi/editor/Document;", "clientId", "getActiveClients", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "leadActiveToolWindowId", "", "getLeadActiveToolWindowId", "()Ljava/lang/String;", "Listener", "intellij.cwm.plugin"})
@SourceDebugExtension(value={"SMAP\nBackendCWMUserFocusHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendCWMUserFocusHost.kt\ncom/intellij/cwm/plugin/users/BackendCWMUserFocusHost\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,116:1\n540#2:117\n525#2,6:118\n129#3:124\n158#3,3:125\n*S KotlinDebug\n*F\n+ 1 BackendCWMUserFocusHost.kt\ncom/intellij/cwm/plugin/users/BackendCWMUserFocusHost\n*L\n65#1:117\n65#1:118,6\n65#1:124\n65#1:125,3\n*E\n"})
final class BackendCWMUserFocusHost
extends CWMUserFocusHost {
    @NotNull
    private final Project project;
    @NotNull
    private final MergingUpdateQueue queue;
    @NotNull
    private final HashMap<ClientId, VirtualFile> clientToActiveFileMap;

    public BackendCWMUserFocusHost(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(project);
        this.project = project;
        this.queue = MergingUpdateQueue.Companion.edtMergingUpdateQueue("queue", 50, coroutineScope, MergingUpdateQueue.ANY_COMPONENT);
        this.clientToActiveFileMap = new HashMap();
    }

    public void serverNotify(@NotNull Document document, @NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        ThreadingAssertions.assertEventDispatchThread();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        ((Map)this.clientToActiveFileMap).put(clientId, virtualFile2);
        this.queue.queue(new Update(clientId, document){
            final /* synthetic */ ClientId $clientId;
            final /* synthetic */ Document $document;
            {
                this.$clientId = $clientId;
                this.$document = $document;
                super((Object)$clientId, false, 0, 6, null);
            }

            public void run() {
                ClientSessionsUtil.forEachSession((Application)ApplicationKt.getApplication(), (ClientKind)ClientKind.REMOTE, arg_0 -> serverNotify.1.run$lambda$0(this.$document, this.$clientId, arg_0));
            }

            private static final Unit run$lambda$0(Document $document, ClientId $clientId, ClientAppSession appSession) {
                Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
                Iterable $this$forEach$iv = appSession.getProjectSessions();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ClientProjectSession projectSession = (ClientProjectSession)element$iv;
                    boolean bl = false;
                    IMutableViewableMap activeClients = CwmActiveClientsModel_GeneratedKt.getCwmActiveClientsModel((Solution)RemoteSessionKt.getProtocolModel((ClientProjectSession)projectSession)).getActiveClients();
                    DocumentSynchronizer synchronizer = BackendDocumentHost.Companion.getInstance(appSession).tryGetSynchronizer($document);
                    if (synchronizer != null) {
                        ((Map)activeClients).put($clientId.getValue(), synchronizer.getDocumentId());
                        continue;
                    }
                    activeClients.remove((Object)$clientId.getValue());
                }
                return Unit.INSTANCE;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ClientId> getActiveClients(@NotNull Editor editor, @Nullable VirtualFile file2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VirtualFile virtualFile = file2;
        if (virtualFile == null && (virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        Map $this$filter$iv = this.clientToActiveFileMap;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getValue(), (Object)virtualFile2)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add((ClientId)it.getKey());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public String getLeadActiveToolWindowId() {
        RdUserModel rdUserModel = (RdUserModel)UserManager.Companion.getInstance(this.project).getLead().getValue();
        if (rdUserModel == null || (rdUserModel = UserManagerKt.getClientId((RdUserModel)rdUserModel)) == null) {
            return null;
        }
        RdUserModel leadClientId = rdUserModel;
        ClientProjectSession clientProjectSession = ClientSessionsManager.Companion.getProjectSession(this.project, (ClientId)leadClientId);
        if (clientProjectSession == null) {
            return null;
        }
        ClientProjectSession session = clientProjectSession;
        return BackendServerToolWindowManager.Companion.getInstance(this.project).getActiveWindowId(session);
    }

    public static final /* synthetic */ HashMap access$getClientToActiveFileMap$p(BackendCWMUserFocusHost $this) {
        return $this.clientToActiveFileMap;
    }

    public static final /* synthetic */ MergingUpdateQueue access$getQueue$p(BackendCWMUserFocusHost $this) {
        return $this.queue;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/plugin/users/BackendCWMUserFocusHost$Listener;", "Lcom/intellij/cwm/plugin/session/CodeWithMeSessionListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sessionCreated", "", "joinLinkData", "Lcom/intellij/cwm/plugin/join/JoinLinkData;", "intellij.cwm.plugin"})
    public static final class Listener
    implements CodeWithMeSessionListener {
        @NotNull
        private final Project project;

        public Listener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Override
        public void sessionCreated(@NotNull JoinLinkData joinLinkData) {
            Intrinsics.checkNotNullParameter((Object)joinLinkData, (String)"joinLinkData");
            CWMUserFocusHost cWMUserFocusHost = CWMUserFocusHost.Companion.getInstance(this.project);
            BackendCWMUserFocusHost backendCWMUserFocusHost = cWMUserFocusHost instanceof BackendCWMUserFocusHost ? (BackendCWMUserFocusHost)cWMUserFocusHost : null;
            if (backendCWMUserFocusHost == null) {
                return;
            }
            BackendCWMUserFocusHost userFocusHost = backendCWMUserFocusHost;
            MessageBusConnection connection = this.project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)joinLinkData.getLifetime(), null, (int)1, null));
            connection.subscribe(FileOpenedSyncListener.TOPIC, (Object)new FileOpenedSyncListener(userFocusHost){
                final /* synthetic */ BackendCWMUserFocusHost $userFocusHost;
                {
                    this.$userFocusHost = $userFocusHost;
                }

                /*
                 * WARNING - void declaration
                 */
                public void fileOpenedSync(FileEditorManager source, VirtualFile file2, List<FileEditorWithProvider> editorsWithProviders) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Map.Entry<K, V> it;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    Intrinsics.checkNotNullParameter(editorsWithProviders, (String)"editorsWithProviders");
                    Document document = FileDocumentManager.getInstance().getDocument(file2);
                    if (document == null) {
                        return;
                    }
                    Document document2 = document;
                    Map $this$filter$iv = BackendCWMUserFocusHost.access$getClientToActiveFileMap$p(this.$userFocusHost);
                    boolean $i$f$filter = false;
                    Map map2 = $this$filter$iv;
                    Object destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$filterTo = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv$iv;
                        it = element$iv$iv = iterator.next();
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getValue(), (Object)file2)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    $this$filter$iv = destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    for (Map.Entry<K, V> item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                        it = item$iv$iv;
                        Object object = destination$iv$iv;
                        boolean bl = false;
                        object.add((ClientId)it.getKey());
                    }
                    List clientIds = (List)destination$iv$iv;
                    for (ClientId clientId : CollectionsKt.plus((Collection)clientIds, (Object)ClientId.Companion.getCurrent())) {
                        this.$userFocusHost.serverNotify(document2, clientId);
                    }
                }
            });
            Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
            connection.subscribe(topic, (Object)new FileEditorManagerListener(userFocusHost){
                final /* synthetic */ BackendCWMUserFocusHost $userFocusHost;
                {
                    this.$userFocusHost = $userFocusHost;
                }

                public void selectionChanged(FileEditorManagerEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    FileEditor fileEditor = event.getNewEditor();
                    if (fileEditor == null || (fileEditor = fileEditor.getFile()) == null) {
                        return;
                    }
                    FileEditor file2 = fileEditor;
                    Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)file2);
                    if (document == null) {
                        return;
                    }
                    Document document2 = document;
                    this.$userFocusHost.serverNotify(document2, ClientId.Companion.getCurrent());
                }

                public void fileClosed(FileEditorManager source, VirtualFile file2) {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    ClientId currentClientId = ClientId.Companion.getCurrent();
                    VirtualFile virtualFile = (VirtualFile)BackendCWMUserFocusHost.access$getClientToActiveFileMap$p(this.$userFocusHost).get(currentClientId);
                    if (!Intrinsics.areEqual((Object)virtualFile, (Object)file2)) {
                        return;
                    }
                    BackendCWMUserFocusHost.access$getClientToActiveFileMap$p(this.$userFocusHost).remove(currentClientId);
                    BackendCWMUserFocusHost.access$getQueue$p(this.$userFocusHost).queue(new Update(currentClientId){
                        final /* synthetic */ ClientId $currentClientId;
                        {
                            this.$currentClientId = $currentClientId;
                            super((Object)$currentClientId, false, 0, 6, null);
                        }

                        public void run() {
                            ClientSessionsUtil.forEachSession((Application)ApplicationKt.getApplication(), (ClientKind)ClientKind.REMOTE, arg_0 -> sessionCreated.fileClosed.1.run$lambda$0(this.$currentClientId, arg_0));
                        }

                        private static final Unit run$lambda$0(ClientId $currentClientId, ClientAppSession appSession) {
                            Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
                            Iterable $this$forEach$iv = appSession.getProjectSessions();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                ClientProjectSession projectSession = (ClientProjectSession)element$iv;
                                boolean bl = false;
                                IMutableViewableMap activeClients = CwmActiveClientsModel_GeneratedKt.getCwmActiveClientsModel((Solution)RemoteSessionKt.getProtocolModel((ClientProjectSession)projectSession)).getActiveClients();
                                activeClients.remove((Object)$currentClientId.getValue());
                            }
                            return Unit.INSTANCE;
                        }
                    });
                }
            });
        }
    }
}

