/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseGeneratedModelUtil;
import com.intellij.database.dialects.postgresbase.model.PgBaseOperator;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrantController;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReferenceId;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.references.BasicByColumnNamesReference;
import com.intellij.database.model.properties.references.BasicByColumnPositionsOrNamesReference;
import com.intellij.database.model.properties.references.BasicByColumnPositionsReference;
import com.intellij.database.model.properties.references.BasicIdOrNameReference;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Pair;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J4\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J4\u0010\u001f\u001a\u00020\u0005\"\b\b\u0000\u0010 *\u00020\u00132\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"2\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0%0$H\u0016R\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "<init>", "()V", "resolveReference", "", "key", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;", "refTable", "Lcom/intellij/database/model/basic/BasicTable;", "updateRefNames", "sequenceTypeSince", "Lcom/intellij/database/util/Version;", "getSequenceTypeSince", "()Lcom/intellij/database/util/Version;", "getDocumentationLink", "Lcom/intellij/openapi/util/Pair;", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "getGrantController", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgObjectGrantController;", "fillPropertiesWithExamples", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "vars", "", "modifyParent", "", "reorderProperties", "E", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "fields", "", "Lcom/intellij/database/model/meta/BasicMetaField;", "intellij.database.dialects.postgresbase"})
@SourceDebugExtension(value={"SMAP\nPgBaseModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseModelHelper.kt\ncom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public abstract class PgBaseModelHelper
extends ModelHelper {
    public final void resolveReference(@NotNull PgBaseForeignKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        BasicTable refTable = key.getRefTable();
        if (refTable == null) {
            return;
        }
        this.resolveReference(key, refTable);
    }

    public final void resolveReference(@NotNull PgBaseForeignKey key, @NotNull BasicTable refTable) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)refTable, (String)"refTable");
        this.updateRefNames(key, refTable);
    }

    private final void updateRefNames(PgBaseForeignKey key, BasicTable refTable) {
        key.setRefTableRef(BasicIdOrNameReference.create((BasicIdReference)PgBaseGeneratedModelUtil.getIdReference((BasicReference)key.getRefTableRef()), (BasicReference)BasicMetaUtils.createPortableReference((BasicElement)((BasicElement)key), (BasicElement)((BasicElement)refTable), (BasicMetaReferenceId)BasicModForeignKey.REF_TABLE_REF)));
        BasicKey basicKey = key.getRefKey();
        if (basicKey == null) {
            return;
        }
        BasicKey refKey = basicKey;
        key.setRefKeyRef(BasicByColumnPositionsOrNamesReference.create((BasicByColumnPositionsReference)PgBaseGeneratedModelUtil.getByColumnPositionsReference((BasicReference)key.getRefKeyRef()), (BasicByColumnNamesReference)BasicByColumnNamesReference.create((List)refKey.getColNames())));
    }

    @NotNull
    public abstract Version getSequenceTypeSince();

    @Nullable
    public Pair<String, String> getDocumentationLink(@NotNull BasicElement element) {
        ObjectKind objectKind;
        ObjectKind objectKind2;
        String string;
        Object object;
        Version root;
        Version version;
        Object object2;
        BasicModel it;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object4 = element.getSchema();
        if (object4 == null || (object4 = object4.getName()) == null) {
            return null;
        }
        Object schemaName = object4;
        BasicModel basicModel = element.getModel();
        if (basicModel != null && (basicModel = basicModel.getRoot()) != null) {
            it = object3 = basicModel;
            boolean bl = false;
            object2 = Intrinsics.areEqual((Object)it.getDbms(), (Object)Dbms.POSTGRES) ? object3 : null;
        } else {
            object2 = null;
        }
        if ((version = (root = object2)) != null && (version = version.getServerVersion()) != null) {
            it = object3 = version;
            boolean bl = false;
            int[] nArray = new int[]{7, 1};
            object = it.isOrGreater(nArray) ? object3 : null;
        } else {
            object = null;
        }
        Object ver = object;
        if (ver == null) {
            string = "current";
        } else {
            object3 = new int[1];
            object3[0] = (BasicModel)10;
            if (ver.isOrGreater((int[])object3)) {
                String string2 = ver.toString(1, 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            } else {
                String string3 = ver.toString(2, 2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            }
        }
        String versionRef = string;
        String p = "https://www.postgresql.org/docs/" + versionRef + "/static";
        ObjectKind objectKind3 = element.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"getKind(...)");
        ObjectKind kind = objectKind3;
        String kindName = kind.getPresentableName();
        String string4 = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        String name2 = string4;
        if (ModelSerializationFun.startsWith((String)name2, (char)'_')) {
            return null;
        }
        String name22 = StringsKt.replace$default((String)name2, (char)'_', (char)'-', (boolean)false, (int)4, null);
        Object object5 = schemaName;
        Object object6 = Intrinsics.areEqual((Object)object5, (Object)"pg_catalog") ? (Intrinsics.areEqual((Object)(objectKind2 = kind), (Object)ObjectKind.TABLE) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.VIEW) ? ModelHelper.link((String)(kindName + " " + name2), (String)(p + "/catalog-" + name22 + ".html")) : (Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.SCHEMA) ? ModelHelper.link((String)DatabaseBundle.message((String)"postgres.system.catalog.name", (Object[])new Object[0]), (String)(p + "/catalogs.html")) : null)) : (Intrinsics.areEqual((Object)object5, (Object)"information_schema") ? (Intrinsics.areEqual((Object)(objectKind = kind), (Object)ObjectKind.TABLE) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? ModelHelper.link((String)(kindName + " " + name2), (String)(p + "/infoschema-" + name22 + ".html")) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA) ? ModelHelper.link((String)DatabaseBundle.message((String)"postgres.information.schema.name", (Object[])new Object[0]), (String)(p + "/information-schema.html")) : null)) : null);
        return object6;
    }

    @NotNull
    public PgObjectGrantController getGrantController() {
        return PgObjectGrantController.INSTANCE;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e, variant, vars, modifyParent);
        if (e instanceof PgBaseOperator) {
            ((PgBaseOperator)e).setCallRoutineRef((BasicReference)BasicNameReference.create((String)"operator_routine"));
            vars.put("operator_routine", "operator_routine");
        }
    }

    public <E extends BasicElement> void reorderProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        super.reorderProperties(meta, fields);
        if (meta.kindOf(PgBaseOperator.class)) {
            BasicMetaId[] basicMetaIdArray = new BasicMetaId[]{PgBaseOperator.CALL_ROUTINE_REF, PgBaseOperator.OPERATOR_KIND, PgBaseOperator.LEFT_STORED_TYPE, PgBaseOperator.RIGHT_STORED_TYPE, PgBaseOperator.RESTRICT_ROUTINE_REF, PgBaseOperator.JOIN_ROUTINE_REF, PgBaseOperator.COMMUTE_OPERATOR_REF, PgBaseOperator.NEGATE_OPERATOR_REF, PgBaseOperator.HASHES};
            ModelHelper.moveTo(fields, (int)2, (BasicMetaId[])basicMetaIdArray);
        }
    }
}

