/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeArgumentsOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentsListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddGenericArgumentsFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public TypeScriptAddGenericArgumentsFix(@NotNull TypeScriptTypeArgumentsListOwner singleType) {
        if (singleType == null) {
            TypeScriptAddGenericArgumentsFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)singleType);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"typescript.validate.generic.types.fix.add", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptAddGenericArgumentsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptAddGenericArgumentsFix.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            TypeScriptAddGenericArgumentsFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            TypeScriptAddGenericArgumentsFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            TypeScriptAddGenericArgumentsFix.$$$reportNull$$$0(5);
        }
        if (!(startElement instanceof JSTypeArgumentsOwner)) {
            return;
        }
        if (editor == null) {
            return;
        }
        JSReferenceExpression referenceExpression = TypeScriptAddGenericArgumentsFix.getReferenceExpression(startElement);
        if (referenceExpression == null) {
            return;
        }
        Object[] results = referenceExpression.multiResolve(false);
        ResolveResult result2 = (ResolveResult)ArrayUtil.getFirstElement((Object[])results);
        if (result2 == null) {
            return;
        }
        PsiElement element = result2.getElement();
        if (!(element instanceof TypeScriptTypeParameterListOwner)) {
            return;
        }
        TypeScriptTypeParameterListOwner resolveElement = (TypeScriptTypeParameterListOwner)element;
        TypeScriptTypeParameterList typeParameterList = resolveElement.getTypeParameterList();
        if (typeParameterList == null) {
            return;
        }
        JSCompletionUtil.createAndStartAddGenericsTemplate((Project)project, (Editor)editor, (JSTypeArgumentsOwner)((JSTypeArgumentsOwner)startElement), (TypeScriptTypeParameterList)typeParameterList);
    }

    @Nullable
    private static JSReferenceExpression getReferenceExpression(@NotNull PsiElement element) {
        JSExpression expression;
        if (element == null) {
            TypeScriptAddGenericArgumentsFix.$$$reportNull$$$0(6);
        }
        if (element instanceof TypeScriptSingleType) {
            return ((TypeScriptSingleType)element).getReferenceExpression();
        }
        if (element instanceof JSReferenceListMember && (expression = ((JSReferenceListMember)element).getExpression()) instanceof JSReferenceExpression) {
            return (JSReferenceExpression)expression;
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"typescript.validate.generic.types.fix.add", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptAddGenericArgumentsFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleType";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/TypeScriptAddGenericArgumentsFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/TypeScriptAddGenericArgumentsFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7 -> new IllegalStateException(string);
        };
    }
}

