/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file.singleFile;

import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileDocumentManagerListener;", "Lcom/intellij/openapi/fileEditor/FileDocumentManagerListener;", "<init>", "()V", "fileContentReloaded", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.jupyter.core"})
public final class JupyterFileDocumentManagerListener
implements FileDocumentManagerListener {
    public void fileContentReloaded(@NotNull VirtualFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        JupyterNotebook jupyterNotebook = JupyterFileExtensionsKt.getJupyterNotebookOrNull(file);
        if (jupyterNotebook == null) {
            return;
        }
        JupyterNotebook notebook = jupyterNotebook;
        JupyterNotebookBase jupyterNotebookBase = JupyterFileUtils.INSTANCE.readNotebookOrNull(file);
        if (jupyterNotebookBase == null) {
            return;
        }
        JupyterNotebookBase newLoaded = jupyterNotebookBase;
        notebook.getJson().removeAll();
        notebook.getJson().setAll(newLoaded.getJson());
        JupyterListenersKt.notifyNotebookChanged(notebook);
        JupyterListenersKt.allOutputsUpdated(notebook);
    }
}

