/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.idea.AppModeAssertions;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.javascript.JSBuiltInTypeEngineEvaluation;
import com.intellij.javascript.typeEngine.JSServicePoweredTypeEngineUsageContext;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.actionscript.psi.ActionScriptConditionalCompileBlock;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.actionscript.psi.impl.ActionScriptVariableImpl;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.ProjectFileIndexSupport;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.flex.AnnotationBackedDescriptor;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSElementProxy;
import com.intellij.lang.javascript.index.JSImplicitElementsIndexHolder;
import com.intellij.lang.javascript.index.JSIndexContentSupport;
import com.intellij.lang.javascript.index.JSIndexedRootProviderSupport;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSPredefinedLibraryManagerSupport;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLocalVariable;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassProvider;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptClassBase;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptClassImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCollectMembersToImplementProcessor;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSElementResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationCache;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSOverrideHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveCacheKt;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorEx;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSScopeNamesCache;
import com.intellij.lang.javascript.psi.resolve.JSServicePoweredTypeEngineEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSSinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.typescript.TSSymbolDeclaration;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.CollectionQuery;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JSResolveUtil {
    @NonNls
    public static final String PROTOTYPE_FIELD_NAME = "prototype";
    public static final String CONSTRUCTOR_FIELD_NAME = "constructor";
    public static final String USE_STRICT = "use strict";
    public static final String QUOTED_USE_STRICT = "\"use strict\"";
    public static final String SINGLE_QUOTED_USE_STRICT = "'use strict'";
    private static final Key<GlobalSearchScope> PROJECT_SCOPE_WITH_PREDEFINED_KEY = Key.create((String)"object.default.scope");
    public static final String VECTOR$OBJECT_TYPE_NAME = "Vector$object";
    public static final String EXCLUDE_CLASS_METADATA = "ExcludeClass";
    public static final String FLASH_UTILS_PROXY = "flash.utils.Proxy";
    public static final String BINDABLE_ATTR_NAME = "Bindable";
    private static final Logger LOG = Logger.getInstance(JSResolveUtil.class);
    public static final Comparator<PsiElement> FILE_PATH_COMPARATOR = Comparator.nullsLast(Comparator.comparing(PsiElement::getContainingFile, Comparator.nullsLast(Comparator.comparing(file -> {
        String name = file.getViewProvider().getVirtualFile().getName();
        return !"lib.es5.d.ts".equals(name);
    }).thenComparing(file -> file.getViewProvider().getVirtualFile().getPath()))));
    public static final Comparator<PsiElement> RESOLVE_RESULT_ELEMENTS_COMPARATOR = Comparator.nullsLast(FILE_PATH_COMPARATOR.thenComparing(PsiElement::getTextOffset));
    private static final Comparator<ResolveResult> RESOLVE_RESULT_COMPARATOR = Comparator.comparing(o -> JSResolveUtil.explicifyElement(o.getElement()), RESOLVE_RESULT_ELEMENTS_COMPARATOR);
    private static final Key<ParameterizedCachedValue<PsiElement[], PsiElement>> CHILDREN_TO_PROCESS_KEY = Key.create((String)"js.children.to.process");
    private static final ParameterizedCachedValueProvider<PsiElement[], PsiElement> CHILDREN_TO_PROCESS_PROVIDER = element -> {
        Object[] children = element instanceof JSSwitchStatement ? ((JSSwitchStatement)element).getAllStatementListItems() : element.getChildren();
        return new CachedValueProvider.Result((Object)children, new Object[]{element});
    };
    public static final Key<PsiElement> contextKey = Key.create((String)"context.key");

    public static void processInjectedFileForTag(@NotNull XmlTag tag, @NotNull JSInjectedFilesVisitor visitor) {
        if (tag == null) {
            JSResolveUtil.$$$reportNull$$$0(0);
        }
        if (visitor == null) {
            JSResolveUtil.$$$reportNull$$$0(1);
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)tag.getProject());
        for (XmlTagChild child : tag.getValue().getChildren()) {
            if (!(child instanceof XmlText)) continue;
            manager.enumerate((PsiElement)child, (PsiLanguageInjectionHost.InjectedPsiVisitor)visitor);
        }
    }

    public static String getExpectedPackageNameFromFile(VirtualFile file, Project project) {
        VirtualFile rootForFile;
        if (file == null) {
            return null;
        }
        ProjectFileIndexSupport projectFileIndex = ProjectFileIndexSupport.getInstance(project);
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        if ((rootForFile = projectFileIndex.getSourceRootForFile(file)) != null) {
            return VfsUtilCore.getRelativePath((VirtualFile)(file.isDirectory() ? file : file.getParent()), (VirtualFile)rootForFile, (char)'.');
        }
        return null;
    }

    public static void processInterfaceMembers(JSClass clazz, JSCollectMembersToImplementProcessor implementedMethodProcessor) {
        clazz.processDeclarations(implementedMethodProcessor, ResolveState.initial(), clazz, clazz);
    }

    @Nullable
    public static JSType getExpressionJSType(@Nullable JSExpression expression) {
        return JSResolveUtil.getExpressionJSType(expression, false);
    }

    @Nullable
    public static JSType getExpressionJSType(@Nullable JSExpression expression, boolean isContextual) {
        if (expression instanceof JSDefinitionExpression) {
            expression = ((JSDefinitionExpression)expression).getExpression();
        }
        return JSResolveUtil.getElementJSType((PsiElement)expression, isContextual);
    }

    @Nullable
    public static JSType getElementJSType(@Nullable PsiElement expression) {
        return JSResolveUtil.getElementJSType(expression, false);
    }

    @Nullable
    public static JSType getElementJSType(@Nullable PsiElement expression, boolean isContextual) {
        if (expression == null) {
            return null;
        }
        JSType servicePoweredType = JSResolveUtil.getServicePoweredType(expression, JSServicePoweredTypeEngineUsageContext.DEFAULT);
        if (servicePoweredType != null) {
            return servicePoweredType;
        }
        return JSResolveUtil.getBuiltInEngineType(expression, isContextual);
    }

    @Nullable
    public static JSType getServicePoweredOrBuiltInEngineQualifierType(@NotNull PsiElement expression) {
        JSType typeFromService;
        if (expression == null) {
            JSResolveUtil.$$$reportNull$$$0(2);
        }
        if ((typeFromService = JSResolveUtil.getServicePoweredType(expression, JSServicePoweredTypeEngineUsageContext.QUALIFIERS)) != null) {
            return typeFromService;
        }
        return JSResolveUtil.getBuiltInEngineType(expression, false);
    }

    @Nullable
    private static JSType getServicePoweredType(@NotNull PsiElement expression, @NotNull JSServicePoweredTypeEngineUsageContext usageContext) {
        if (expression == null) {
            JSResolveUtil.$$$reportNull$$$0(3);
        }
        if (usageContext == null) {
            JSResolveUtil.$$$reportNull$$$0(4);
        }
        return (JSType)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(expression, () -> JSServicePoweredTypeEngineEvaluator.INSTANCE.getResultFromService(expression, usageContext));
    }

    @Nullable
    public static JSType getBuiltInEngineType(@NotNull PsiElement expression) {
        if (expression == null) {
            JSResolveUtil.$$$reportNull$$$0(5);
        }
        return JSResolveUtil.getBuiltInEngineType(expression, false);
    }

    @Nullable
    public static JSType getBuiltInEngineType(@NotNull PsiElement expression, boolean isContextual) {
        if (expression == null) {
            JSResolveUtil.$$$reportNull$$$0(6);
        }
        return (JSType)JSBuiltInTypeEngineEvaluation.INSTANCE.forceTypeEngine(() -> JSResolveUtil.doGetBuiltInEngineType(expression, isContextual));
    }

    @Nullable
    private static JSType doGetBuiltInEngineType(@NotNull PsiElement expression, boolean isContextual) {
        JSEvaluateContext context;
        JSTypeEvaluationResult result;
        if (expression == null) {
            JSResolveUtil.$$$reportNull$$$0(7);
        }
        if ((result = JSEvaluationCache.getElementType(expression, context = new JSEvaluateContext(expression.getContainingFile(), isContextual))) == null) {
            return null;
        }
        JSSimpleTypeProcessor processor = new JSSimpleTypeProcessor();
        result.applyToProcessor(processor);
        return processor.getType();
    }

    @NotNull
    public static String getShortTypeName(String type, boolean withSignature) {
        int i2;
        String str = type;
        int i = str.indexOf(60);
        String signature = null;
        if (i != -1) {
            int index = str.lastIndexOf(46, i);
            if (index == -1) {
                String string = type;
                if (string == null) {
                    JSResolveUtil.$$$reportNull$$$0(8);
                }
                return string;
            }
            signature = str.substring(index);
            str = str.substring(0, index);
        }
        if ((i2 = str.lastIndexOf(46)) != -1) {
            str = str.substring(i2 + 1);
        }
        String string = str + (withSignature && signature != null ? signature : "");
        if (string == null) {
            JSResolveUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static PsiElement getClassReferenceForXmlFromContext(PsiElement parent) {
        PsiElement context;
        PsiElement psiElement = context = parent != null ? parent.getContext() : null;
        if (context instanceof XmlElement && context.getContainingFile() instanceof XmlFile) {
            return XmlBackedJSClassImpl.getContainingComponent((XmlElement)context);
        }
        return parent;
    }

    @Nullable
    public static XmlBackedJSClass getXmlBackedClass(@NotNull JSFile injectedJsFile) {
        PsiElement context;
        if (injectedJsFile == null) {
            JSResolveUtil.$$$reportNull$$$0(10);
        }
        if ((context = injectedJsFile.getContext()) instanceof XmlAttributeValue || context instanceof XmlText) {
            return XmlBackedJSClassImpl.getContainingComponent((XmlElement)context);
        }
        return null;
    }

    public static boolean isResolveDynamic(@NotNull PsiReference reference, @NotNull Collection<PsiElement> targets) {
        if (reference == null) {
            JSResolveUtil.$$$reportNull$$$0(11);
        }
        if (targets == null) {
            JSResolveUtil.$$$reportNull$$$0(12);
        }
        if (reference instanceof JSReferenceExpression && JSResolveUtil.isDummyResolve((JSReferenceExpression)reference)) {
            return true;
        }
        if (reference instanceof JSPropertyNameReference && JSResolveUtil.isDummyResolve((JSPropertyNameReference)reference)) {
            return true;
        }
        if (!JSResolveUtil.isResolveStrict(reference)) {
            return true;
        }
        if (reference instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)reference;
            if (!targets.isEmpty() && referenceExpression.getReferenceName() != null) {
                for (PsiElement target : targets) {
                    if (!referenceExpression.isReferenceTo(target)) {
                        return false;
                    }
                    if (!referenceExpression.isReferenceToElement(target)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isResolveStrict(@NotNull PsiReference reference) {
        if (reference == null) {
            JSResolveUtil.$$$reportNull$$$0(13);
        }
        if (!(reference instanceof PsiPolyVariantReference)) {
            return true;
        }
        if (!(reference instanceof JSPsiReferenceElement) && !(reference instanceof JSReferenceSetElement)) {
            return true;
        }
        ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
        return JSResolveUtil.isResolveStrict(reference, results);
    }

    public static boolean isResolveStrict(@NotNull PsiReference reference, ResolveResult @NotNull [] resolveResults) {
        if (reference == null) {
            JSResolveUtil.$$$reportNull$$$0(14);
        }
        if (resolveResults == null) {
            JSResolveUtil.$$$reportNull$$$0(15);
        }
        if (JSResolveResult.isTooManyCandidatesResult(resolveResults)) {
            return false;
        }
        PsiElement refElement = reference.getElement();
        if (DialectDetector.isTypeScript(refElement)) {
            JSExpression qualifier = null;
            if (refElement instanceof JSReferenceExpression) {
                qualifier = ((JSReferenceExpression)reference).getQualifier();
            } else if (refElement instanceof JSLiteralExpression && refElement.getParent() instanceof JSIndexedPropertyAccessExpression) {
                qualifier = ((JSIndexedPropertyAccessExpression)refElement.getParent()).getQualifier();
            }
            if (!TypeScriptUtil.isStrictResolveQualifier(qualifier)) {
                return false;
            }
        }
        return JSResolveUtil.areResolveResultsStrict(resolveResults);
    }

    public static boolean areResolveResultsStrict(@NotNull @NotNull ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSResolveUtil.$$$reportNull$$$0(16);
        }
        return Arrays.stream(resolveResults).filter(resolveResult -> resolveResult instanceof JSResolveResult).map(resolveResult -> ((JSResolveResult)resolveResult).getStatus()).noneMatch(status -> status.isPartial());
    }

    public static boolean isTypeScriptDeclarationMerging(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSResolveUtil.$$$reportNull$$$0(17);
        }
        for (ResolveResult result : resolveResults) {
            PsiElement element = result.getElement();
            if (element instanceof TypeScriptModule || element instanceof TypeScriptInterface || element instanceof TypeScriptFunction || element instanceof TypeScriptImplicitOverloadedAliasElement || element instanceof TypeScriptClass || element instanceof TypeScriptEnum || element instanceof TypeScriptVariable || element instanceof JSLocalImplicitElementImpl) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiElement findType(String type, @Nullable PsiElement context, boolean ecma) {
        if (type == null || context == null) {
            return null;
        }
        PsiElement typeClass = null;
        if (ecma) {
            if (context.getParent() instanceof JSNewExpression) {
                context = context.getParent();
            }
            JSSinkResolveProcessor processor = JSDialectSpecificHandlersFactory.forLanguage(FlexSupportLoader.ECMA_SCRIPT_L4).createSinkResolveProcessor(new ResolveResultSink(context, type));
            processor.setLocalResolve(true);
            processor.setTypeContext(true);
            processor.setToProcessHierarchy(false);
            processor.setToProcessMembers(false);
            JSResolveUtil.treeWalkUp(processor, (PsiElement)context.getContainingFile(), null, context);
            typeClass = processor.getResultSink().getResult();
        }
        if (typeClass == null) {
            typeClass = JSDialectSpecificHandlersFactory.forElement(context).getClassResolver().findClassByQName(type, context);
        }
        return typeClass;
    }

    public static boolean isAssignableJSType(@Nullable JSType lOpType, @Nullable JSType rOpType, @Nullable ProcessingContext context) {
        return lOpType == null || lOpType.isDirectlyAssignableType(rOpType, context);
    }

    @Deprecated
    public static boolean isAssignableType(@NonNls String expectedType, @NonNls String type, @NotNull PsiElement context) {
        if (context == null) {
            JSResolveUtil.$$$reportNull$$$0(18);
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(context, true);
        JSType lOpType = JSTypeParser.createType(context.getProject(), expectedType, source);
        JSType rOpType = JSTypeParser.createType(context.getProject(), type, source);
        return JSResolveUtil.isAssignableJSType(lOpType, rOpType, null);
    }

    public static boolean isEcmaScript5(@Nullable PsiElement decl) {
        return decl != null && JSResolveUtil.hasUseStrictPragmaUp(decl);
    }

    public static boolean hasUseStrictPragmaUp(@NotNull PsiElement decl) {
        if (decl == null) {
            JSResolveUtil.$$$reportNull$$$0(19);
        }
        for (PsiElement parent = decl; parent != null; parent = parent.getParent()) {
            if (!JSResolveUtil.hasUseStrictPragma(parent)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUseStrictPragma(@NotNull PsiElement scope) {
        if (scope == null) {
            JSResolveUtil.$$$reportNull$$$0(20);
        }
        if (scope instanceof JSModuleStatusOwner && ((JSModuleStatusOwner)scope).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.ES6) {
            return true;
        }
        ASTNode node = scope.getNode();
        return node != null && JSTreeUtil.hasUseStrictPragma(node);
    }

    public static @Unmodifiable Collection<VirtualFile> sortFiles(@Unmodifiable Collection<? extends VirtualFile> virtualFiles) {
        return ContainerUtil.sorted(virtualFiles, (o1, o2) -> (int)(o1.getLength() - o2.getLength()));
    }

    public static boolean calculateStaticFromContext(@Nullable PsiElement psiElement) {
        JSAttributeList attributeList;
        JSAttributeListOwner attributeListOwner = (JSAttributeListOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSAttributeListOwner.class});
        while (attributeListOwner != null && !JSResolveUtil.changesThisValue(attributeListOwner)) {
            attributeListOwner = (JSAttributeListOwner)PsiTreeUtil.getParentOfType((PsiElement)attributeListOwner, JSAttributeListOwner.class);
        }
        return attributeListOwner != null && (attributeList = attributeListOwner.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
    }

    private static boolean changesThisValue(@NotNull JSAttributeListOwner scope) {
        if (scope == null) {
            JSResolveUtil.$$$reportNull$$$0(21);
        }
        if (scope instanceof JSFunction) {
            return !((JSFunction)scope).isArrowFunction();
        }
        if (scope instanceof JSVariable || scope instanceof JSVarStatement) {
            PsiElement grandParent = JSResolveUtil.findParent((PsiElement)scope);
            return grandParent instanceof JSFile || grandParent instanceof JSClass;
        }
        return true;
    }

    public static boolean shortReferenceIsAmbiguousOrUnequal(@NotNull String shortName, PsiElement context, String expectedFqn, Boolean forceInTypeContext) {
        ResolveResult[] results;
        if (shortName == null) {
            JSResolveUtil.$$$reportNull$$$0(22);
        }
        if ((results = JSReferenceExpressionImpl.resolveUnqualified(shortName, context, forceInTypeContext)).length > 1) {
            return true;
        }
        if (results.length == 0) {
            return false;
        }
        PsiElement element = results[0].getElement();
        if (context.getParent() instanceof JSNewExpression && element instanceof JSFunction && element.getParent() instanceof JSClass) {
            element = element.getParent();
        }
        return element instanceof JSQualifiedNamedElement && !expectedFqn.equals(((JSQualifiedNamedElement)element).getQualifiedName());
    }

    @NotNull
    public static Query<JSPsiElementBase> findOverridingFunctionsByNamespaces(JSPsiElementBase elt) {
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(elt);
        if (qName != null) {
            final ArrayList result = new ArrayList();
            final HashMap results = new HashMap();
            MyNamespaceProcessor namespaceProcessor = new MyNamespaceProcessor(new HashSet<JSPsiElementBase>(Collections.singletonList(elt)), true){

                @Override
                protected boolean doProcess(PsiElement elt) {
                    if (elt instanceof JSProperty) {
                        elt = ((JSProperty)elt).getValue();
                    }
                    if (!(elt instanceof JSPsiElementBase)) {
                        return true;
                    }
                    String qName = JSResolveUtil.getQNameToStartHierarchySearch((JSPsiElementBase)elt);
                    if (qName != null) {
                        ArrayList<JSPsiElementBase> list = (ArrayList<JSPsiElementBase>)results.get(qName);
                        if (list == null) {
                            list = new ArrayList<JSPsiElementBase>(2);
                            results.put(qName, list);
                        }
                        list.add((JSPsiElementBase)elt);
                    } else {
                        result.add((JSPsiElementBase)elt);
                    }
                    return true;
                }
            };
            namespaceProcessor.processDescendantsOf(qName, (PsiElement)elt);
            for (List funs : results.values()) {
                result.addAll(funs);
            }
            return new CollectionQuery(result);
        }
        return new CollectionQuery(Collections.emptyList());
    }

    public static boolean isFromPredefinedFile(@Nullable PsiFile containingFile) {
        if (containingFile == null) {
            return false;
        }
        return JSResolveUtil.isFromPredefinedFile(containingFile.getProject(), containingFile.getOriginalFile().getVirtualFile());
    }

    public static boolean isFromPredefinedFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            JSResolveUtil.$$$reportNull$$$0(23);
        }
        return JSPredefinedLibraryManagerSupport.getInstance(project).isPredefinedFile(file);
    }

    public static boolean ownerHasExplicitThisParameter(@Nullable JSExpression qualifier) {
        JSParameter thisParameter;
        JSFunction function = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)qualifier);
        return function != null && (thisParameter = TypeScriptPsiUtil.getThisParameter(function)) != null;
    }

    public static boolean hasMultipleOccurenceDelimiters(String expectedType) {
        String commentDelimiters = "|/";
        for (int i = 0; i < "|/".length(); ++i) {
            if (expectedType.indexOf("|/".charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        GlobalSearchScope scope;
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(24);
        }
        for (JSElementResolveScopeProvider provider : JSElementResolveScopeProvider.EP_NAME.getExtensionList()) {
            scope = provider.getElementResolveScope(element);
            if (scope == null) continue;
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                JSResolveUtil.$$$reportNull$$$0(25);
            }
            return globalSearchScope;
        }
        VirtualFile file = JSResolveUtil.getFileForScopeEvaluation(element);
        Project project = element.getProject();
        if (file != null && (scope = ResolveScopeManager.getInstance((Project)project).getDefaultResolveScope(file)).contains(file)) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                JSResolveUtil.$$$reportNull$$$0(26);
            }
            return globalSearchScope;
        }
        if (element.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            if (file == null) {
                Logger.getInstance(JSResolveUtil.class).error("Can't find resolve scope");
            }
            return JSResolveUtil.getJavaScriptSymbolsResolveScope(project);
        }
        GlobalSearchScope globalSearchScope = element.getResolveScope();
        if (globalSearchScope == null) {
            JSResolveUtil.$$$reportNull$$$0(27);
        }
        return globalSearchScope;
    }

    @Nullable
    public static VirtualFile getFileForScopeEvaluation(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(28);
        }
        if ((containingFile = JSResolveUtil.getOriginalFile(element)) == null) {
            return null;
        }
        return containingFile.getOriginalFile().getViewProvider().getVirtualFile();
    }

    @Nullable
    public static PsiElement getContext(@NotNull PsiElement element) {
        PsiElement result;
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(29);
        }
        if ((result = (PsiElement)element.getUserData(contextKey)) != null && !result.isValid()) {
            result = null;
        }
        return result;
    }

    public static boolean isObjectClass(@NotNull JSPsiElementBase aClass) {
        if (aClass == null) {
            JSResolveUtil.$$$reportNull$$$0(30);
        }
        return "Object".equals(aClass.getQualifiedName());
    }

    public static boolean processHierarchy(String qName, PsiFile containingFile, Processor<? super JSClass> processor, boolean visitInterfaces) {
        PsiElement clazz = JSDialectSpecificHandlersFactory.forElement((PsiElement)containingFile).getClassResolver().findClassByQName(qName, (PsiElement)containingFile);
        if (clazz instanceof JSClass) {
            return JSResolveUtil.processHierarchy((JSClass)clazz, processor, visitInterfaces);
        }
        return true;
    }

    public static boolean processHierarchy(@NotNull JSClass clazz, Processor<? super JSClass> processor, boolean visitInterfaces) {
        if (clazz == null) {
            JSResolveUtil.$$$reportNull$$$0(31);
        }
        return clazz.processDeclarations(new VisitAllTypesProcessor(processor, visitInterfaces), ResolveState.initial(), clazz, clazz);
    }

    public static void stableResolveOrder(ResolveResult @NotNull [] results) {
        if (results == null) {
            JSResolveUtil.$$$reportNull$$$0(32);
        }
        Arrays.sort(results, RESOLVE_RESULT_COMPARATOR);
    }

    @Nullable
    private static PsiElement explicifyElement(@Nullable PsiElement elt) {
        if (elt instanceof TypeScriptProxyImplicitElement) {
            TypeScriptProxyImplicitElement proxyImplicitElement = (TypeScriptProxyImplicitElement)elt;
            return proxyImplicitElement.getExplicitElement();
        }
        if (elt instanceof TSSymbolDeclaration) {
            TSSymbolDeclaration symbolDeclaration = (TSSymbolDeclaration)elt;
            return symbolDeclaration.getExplicitElement();
        }
        return elt;
    }

    @Nullable
    public static String getQualifiedTypeName(@Nullable String _typeName) {
        if (_typeName != null) {
            String typeName;
            GenericSignature signature = JSResolveUtil.extractGenericSignature(_typeName);
            String string = typeName = signature != null ? signature.elementType : _typeName;
            if (VECTOR$OBJECT_TYPE_NAME.equals(typeName)) {
                typeName = "Vector";
            }
            return GenericSignature.build(typeName, signature);
        }
        return null;
    }

    public static boolean isSelfReference(@NotNull PsiElement element) {
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(33);
        }
        return JSResolveUtil.isSelfReference(element.getParent(), element);
    }

    @Nullable
    public static GenericSignature extractGenericSignature(String type) {
        if (type == null) {
            return null;
        }
        int ltPos = type.indexOf(60);
        if (ltPos > 0 && type.charAt(ltPos - 1) == '.') {
            int gtPos = type.lastIndexOf(62);
            String genericType = type.substring(ltPos + 1, gtPos != -1 ? gtPos : type.length()).trim();
            type = type.substring(0, ltPos - 1).trim();
            return new GenericSignature(type, genericType);
        }
        return null;
    }

    public static PsiElement getTopReferenceParent(PsiElement parent) {
        PsiElement currentParent = parent;
        while (currentParent instanceof JSReferenceExpression) {
            currentParent = currentParent.getParent();
        }
        return currentParent;
    }

    @NotNull
    public static JSReferenceExpression getTopReferenceExpression(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            JSResolveUtil.$$$reportNull$$$0(34);
        }
        return (JSReferenceExpression)JSResolveUtil.getTopReferenceExpression((PsiElement)referenceExpression);
    }

    @NotNull
    public static PsiElement getTopReferenceExpression(@NotNull PsiElement element) {
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(35);
        }
        PsiElement currentParent = element.getParent();
        while (currentParent instanceof JSReferenceExpression) {
            element = currentParent;
            currentParent = currentParent.getParent();
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JSResolveUtil.$$$reportNull$$$0(36);
        }
        return psiElement;
    }

    @NotNull
    public static JSExpression getLeftmostQualifier(@NotNull JSExpression expr) {
        if (expr == null) {
            JSResolveUtil.$$$reportNull$$$0(37);
        }
        JSExpression current = expr;
        while (current instanceof JSQualifiedExpression) {
            JSExpression qualifier = ((JSQualifiedExpression)current).getQualifier();
            if (qualifier == null) {
                JSExpression jSExpression = current;
                if (jSExpression == null) {
                    JSResolveUtil.$$$reportNull$$$0(38);
                }
                return jSExpression;
            }
            current = qualifier;
        }
        JSExpression jSExpression = current;
        if (jSExpression == null) {
            JSResolveUtil.$$$reportNull$$$0(39);
        }
        return jSExpression;
    }

    public static boolean isSelfReference(PsiElement currentParent, PsiElement elt) {
        PsiElement nameIdentifier;
        if (currentParent instanceof ActionScriptClassImpl && (nameIdentifier = ((ActionScriptClassImpl)currentParent).getNameIdentifier()) != null && nameIdentifier.getParent() == elt) {
            return true;
        }
        return currentParent instanceof JSPackageStatement && ((JSPackageStatement)currentParent).getNameIdentifier() == elt || currentParent instanceof JSNamespaceDeclaration && ((JSNamespaceDeclaration)currentParent).getNameIdentifier() == elt || (currentParent instanceof JSLocalVariable || currentParent instanceof ActionScriptVariableImpl) && ((JSVariable)currentParent).getNameIdentifier() == elt;
    }

    public static boolean isSameReference(@NotNull JSReferenceExpression ref, @NotNull PsiElement resolve) {
        if (ref == null) {
            JSResolveUtil.$$$reportNull$$$0(40);
        }
        if (resolve == null) {
            JSResolveUtil.$$$reportNull$$$0(41);
        }
        if (ref.getContainingFile() != resolve.getContainingFile()) {
            return false;
        }
        JSExpression resolveRef = resolve instanceof JSDefinitionExpression ? ((JSDefinitionExpression)resolve).getExpression() : (resolve instanceof JSNamedElement ? ((JSNamedElement)resolve).getNameIdentifier() : resolve);
        return ref == resolveRef;
    }

    public static boolean isDummyResolve(@NotNull JSReferenceExpression ref) {
        PsiElement resolve;
        if (ref == null) {
            JSResolveUtil.$$$reportNull$$$0(42);
        }
        return (resolve = ref.resolve()) != null && JSResolveUtil.isSameReference(ref, resolve);
    }

    public static boolean isDummyResolve(@NotNull JSPropertyNameReference ref) {
        PsiElement resolve;
        if (ref == null) {
            JSResolveUtil.$$$reportNull$$$0(43);
        }
        return (resolve = ref.resolve()) != null && ref.getElement() == resolve;
    }

    public static boolean isDummyResolve(@NotNull JSLiteralTextReference ref) {
        PsiElement element;
        if (ref == null) {
            JSResolveUtil.$$$reportNull$$$0(44);
        }
        if (!((element = ref.getElement()) instanceof JSLiteralExpression)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof JSIndexedPropertyAccessExpression)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        return grandParent instanceof JSDefinitionExpression && ref.resolve() == grandParent;
    }

    @Nullable
    public static PsiElement findParent(@NotNull PsiElement element) {
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(45);
        }
        PsiElement parent = element.getContext();
        if (element instanceof JSVariable && (parent = JSDestructuringUtil.getParentSkippingDestructuring((JSVariable)element)) != null) {
            parent = parent.getContext();
        }
        if (parent instanceof TypeScriptObjectType && parent.getContext() instanceof TypeScriptInterface) {
            parent = parent.getContext();
        }
        if (parent instanceof JSBlockStatement) {
            XmlBackedJSClass xmlBackedClass;
            PsiElement grandParent = parent.getParent();
            if (parent instanceof ActionScriptConditionalCompileBlock) {
                parent = grandParent;
            } else if (grandParent instanceof JSClass) {
                parent = grandParent;
            } else if (grandParent instanceof JSFile && (xmlBackedClass = JSResolveUtil.getXmlBackedClass((JSFile)grandParent)) != null) {
                return xmlBackedClass;
            }
        }
        return parent instanceof JSFile ? JSResolveUtil.findParentClass((JSFile)parent) : parent;
    }

    public static PsiElement findParentClass(@NotNull JSFile file) {
        PsiFile containingFile;
        PsiFile psiFile;
        XmlBackedJSClass xmlBackedClass;
        if (file == null) {
            JSResolveUtil.$$$reportNull$$$0(46);
        }
        if ((xmlBackedClass = JSResolveUtil.getXmlBackedClass(file)) != null) {
            return xmlBackedClass;
        }
        PsiElement forcedContext = JSResolveUtil.getContext(file);
        if (forcedContext instanceof JSClass) {
            return forcedContext;
        }
        if (forcedContext instanceof JSFile) {
            JSFile jsFile = (JSFile)forcedContext;
            return JSResolveUtil.findParentClass(jsFile);
        }
        if (forcedContext instanceof PsiFile && FlexSupportLoader.isFlexMxmFile(psiFile = (PsiFile)forcedContext)) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)forcedContext);
        }
        if (forcedContext instanceof XmlElement && FlexSupportLoader.isFlexMxmFile(containingFile = forcedContext.getContainingFile())) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)containingFile);
        }
        if (forcedContext != null) {
            JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)forcedContext, JSClass.class);
            if (jsClass != null) {
                return jsClass;
            }
            PsiFile containingFile2 = forcedContext.getContainingFile();
            if (containingFile2 instanceof JSFile) {
                JSFile jsFile = (JSFile)containingFile2;
                if (containingFile2 != file) {
                    return JSResolveUtil.findParentClass(jsFile);
                }
            }
        }
        return file;
    }

    @Contract(value="null -> null")
    public static JSClass getClassOfContext(@Nullable PsiElement node) {
        return JSResolveUtil.getClassOfContext(node, false);
    }

    @Nullable
    public static JSClass getClassOfContext(@Nullable PsiElement node, boolean strict) {
        JSFunction fun;
        if (node == null) {
            return null;
        }
        if (strict && (fun = JSPsiImplUtils.getParentFunctionThroughLambdas(node)) != null) {
            PsiElement parent = JSResolveUtil.findParent(fun);
            return parent instanceof JSClass ? (JSClass)parent : null;
        }
        JSClass jsClass = (JSClass)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSClass.class});
        if (jsClass != null) {
            return jsClass;
        }
        PsiElement context = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)node.getContainingFile());
        if (context instanceof JSClass) {
            return (JSClass)context;
        }
        return null;
    }

    @Nullable
    public static JSClass getClassOfContextForPrivateMemberReference(@NotNull JSReferenceExpression node) {
        if (node == null) {
            JSResolveUtil.$$$reportNull$$$0(47);
        }
        if (!JSUtils.isPrivateNameReference((PsiElement)node)) {
            LOG.error("Must be private name reference: " + String.valueOf(node));
            return null;
        }
        String requiredPrivateName = node.getReferenceName();
        if (requiredPrivateName == null) {
            return null;
        }
        JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)node);
        while (jsClass != null && jsClass.findPrivateMembersByName(requiredPrivateName).isEmpty()) {
            ProgressManager.checkCanceled();
            jsClass = JSResolveUtil.getClassOfContext(jsClass);
        }
        return jsClass;
    }

    @Nullable
    public static Pair<? extends PsiElement, String> getElementThatShouldBeQualified(PsiElement element, String fqn) {
        PsiElement parent;
        JSReferenceExpression reference = (JSReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSReferenceExpression.class});
        if (reference != null && ((parent = reference.getParent()) instanceof JSImportStatement || parent instanceof JSReferenceListMember && reference.getContainingFile().getContext() != null)) {
            return Pair.create((Object)reference, (Object)fqn);
        }
        if (element.getContainingFile() instanceof JSExpressionCodeFragment) {
            return Pair.create((Object)reference, (Object)fqn);
        }
        return null;
    }

    public static boolean isArtificialClassUsedForReferenceList(JSClass clazz) {
        return clazz.getContainingFile().getContext() != null;
    }

    @Nullable
    public static JSType getTypeFromSetAccessor(JSFunctionItem fun) {
        JSParameterItem parameter = JSResolveUtil.getParameterFromSetAccessor(fun);
        return parameter != null ? parameter.getSimpleType() : null;
    }

    @Nullable
    public static JSParameterItem getParameterFromSetAccessor(@NotNull JSFunctionItem fun) {
        if (fun == null) {
            JSResolveUtil.$$$reportNull$$$0(48);
        }
        if (!fun.isSetProperty()) {
            return null;
        }
        JSParameterItem[] jsParameters = fun.getParameters();
        if (jsParameters.length != 1) {
            return null;
        }
        return jsParameters[0];
    }

    public static boolean isInsideArtificialAttrList(JSReferenceExpression place) {
        if (place.getParent() instanceof JSAttributeList) {
            PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)place);
            if (next instanceof PsiErrorElement) {
                next = PsiTreeUtil.nextLeaf((PsiElement)next);
            }
            return next instanceof PsiWhiteSpace && next.textContains('\n');
        }
        return false;
    }

    public static void processParametersForUsedArgument(@NotNull JSExpression mainOccurrence, @NotNull JSArgumentList parent, @NotNull Processor<? super JSParameterItem> processor) {
        JSParameterItem parameter;
        PsiElement declaration;
        XmlAttribute attr;
        XmlAttributeDescriptor descriptor;
        PsiElement context;
        if (mainOccurrence == null) {
            JSResolveUtil.$$$reportNull$$$0(49);
        }
        if (parent == null) {
            JSResolveUtil.$$$reportNull$$$0(50);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(51);
        }
        int _paramIndex = 0;
        for (JSExpression expr : parent.getArguments()) {
            if (expr == mainOccurrence) break;
            ++_paramIndex;
        }
        int paramIndex = _paramIndex;
        PsiElement firstChild = parent.getFirstChild();
        PsiElement originalFirstChild = PsiUtilCore.getOriginalElement((PsiElement)firstChild, (Class)firstChild.getClass());
        JSCallExpression originalElement = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)originalFirstChild, JSCallExpression.class);
        if (originalElement == null) {
            return;
        }
        JSExpression methodExpr = originalElement.getMethodExpression();
        if (methodExpr instanceof JSReferenceExpression) {
            ResolveResult[] results;
            for (ResolveResult r : results = ((JSReferenceExpression)methodExpr).multiResolve(false)) {
                JSParameterItem[] params;
                JSFunctionItem matchedFunction;
                PsiElement element = r.getElement();
                if (element == null || !element.isValid() || (matchedFunction = JSPsiImplUtils.calculatePossibleFunction(element, (PsiElement)methodExpr, false)) == null || !(paramIndex < (params = matchedFunction.getParameters()).length ? !processor.process((Object)params[paramIndex]) : params.length > 0 && params[params.length - 1].isRest() && !processor.process((Object)params[params.length - 1]))) continue;
                return;
            }
        } else if (methodExpr instanceof JSParenthesizedExpression && (context = methodExpr.getContainingFile().getContext()) instanceof XmlAttributeValue && (descriptor = (attr = (XmlAttribute)context.getParent()).getDescriptor()) instanceof AnnotationBackedDescriptor && (declaration = descriptor.getDeclaration()) instanceof JSFunction && (parameter = JSResolveUtil.getParameterFromSetAccessor((JSFunction)declaration)) != null) {
            processor.process((Object)parameter);
        }
    }

    @Nullable
    public static JSParameterItem findParameterForUsedArgument(@NotNull JSExpression mainOccurrence, @NotNull JSArgumentList parent) {
        if (mainOccurrence == null) {
            JSResolveUtil.$$$reportNull$$$0(52);
        }
        if (parent == null) {
            JSResolveUtil.$$$reportNull$$$0(53);
        }
        Ref result = new Ref();
        JSResolveUtil.processParametersForUsedArgument(mainOccurrence, parent, (Processor<? super JSParameterItem>)((Processor)jsParameter -> {
            result.set(jsParameter);
            return false;
        }));
        return (JSParameterItem)result.get();
    }

    public static String getPackageNameFromPlace(@NotNull PsiElement place) {
        String packageName2;
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(54);
        }
        JSQualifiedNamedElement namedElement = (JSQualifiedNamedElement)PsiTreeUtil.getContextOfType((PsiElement)place, (boolean)false, (Class[])Holder.PACKAGE_ELEMENTS);
        while (namedElement instanceof JSFunction || namedElement instanceof JSVariable || namedElement instanceof JSDefinitionExpression) {
            PsiElement namedElementParent = JSResolveUtil.findParent((PsiElement)namedElement);
            if (namedElementParent instanceof JSQualifiedNamedElement) {
                JSQualifiedNamedElement qualifiedParent;
                namedElement = qualifiedParent = (JSQualifiedNamedElement)namedElementParent;
                continue;
            }
            namedElement = (JSQualifiedNamedElement)PsiTreeUtil.getContextOfType((PsiElement)namedElementParent, (boolean)true, (Class[])new Class[]{JSQualifiedNamedElement.class});
        }
        if (namedElement == null) {
            PsiFile containingFile = place.getContainingFile().getOriginalFile();
            PsiElement context = containingFile.getContext();
            if (context != null) {
                containingFile = context.getContainingFile().getOriginalFile();
            }
            if (FlexSupportLoader.isMxmlOrFxgFile(containingFile)) {
                return JSResolveUtil.getExpectedPackageNameFromFile(containingFile.getVirtualFile(), containingFile.getProject());
            }
        }
        String string = namedElement instanceof JSPackageStatement || namedElement instanceof TypeScriptModule ? namedElement.getQualifiedName() : (packageName2 = namedElement != null ? JSResolveUtil.getPackageName((PsiElement)namedElement) : "");
        if (packageName2 == null) {
            packageName2 = "";
        }
        return packageName2;
    }

    @NotNull
    public static String getPackageName(PsiElement element) {
        PsiElement parent = JSResolveUtil.findParent(element);
        if (parent instanceof JSClass) {
            return JSResolveUtil.getPackageName(parent);
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        if (!(dialect == DialectOptionHolder.ECMA_4 || dialect != null && dialect.isTypeScript)) {
            return "";
        }
        JSQualifiedName namespace = ((JSQualifiedNamedElement)element).getNamespace();
        return namespace != null ? namespace.getQualifiedName() : "";
    }

    private JSResolveUtil() {
    }

    public static void treeWalkUp(JSResolveProcessor processor, PsiElement elt, PsiElement lastParent, PsiElement place) {
        JSResolveProcessorEx processorEx;
        boolean wasWalkingUpTree = processor instanceof JSResolveProcessorEx && (processorEx = (JSResolveProcessorEx)processor).setWalkingUpTree(true);
        JSResolveUtil.treeWalkUp(processor, elt, lastParent, place, null);
        if (processor instanceof JSResolveProcessorEx) {
            processorEx = (JSResolveProcessorEx)processor;
            processorEx.setWalkingUpTree(wasWalkingUpTree);
        }
    }

    public static void treeWalkUp(JSResolveProcessor processor, PsiElement elt, PsiElement lastParent, PsiElement place, PsiElement terminatingParent) {
        boolean isExecutionScopeChanged = false;
        while (true) {
            boolean finish;
            PsiElement parentElement;
            TreeWalkUpResult result;
            ProgressManager.checkCanceled();
            if (elt == null || elt instanceof PsiDirectory) {
                return;
            }
            if (elt instanceof JSExecutionScope) {
                isExecutionScopeChanged = true;
            }
            if ((result = JSResolveUtil.processSiblingsForElement(processor, elt, lastParent, place, terminatingParent, parentElement = elt.getContext(), isExecutionScopeChanged)) == TreeWalkUpResult.RETURN) {
                return;
            }
            boolean bl = finish = result == TreeWalkUpResult.RETURN_AFTER_POST_PROCESSING;
            if (elt instanceof PsiFile) {
                parentElement = JSResolveUtil.processFileElement(processor, elt, place, parentElement);
            }
            if (finish) {
                return;
            }
            lastParent = elt;
            elt = parentElement;
        }
    }

    @NotNull
    private static TreeWalkUpResult processSiblingsForElement(@NotNull JSResolveProcessor processor, @NotNull PsiElement elt, PsiElement lastParent, PsiElement place, PsiElement terminatingParent, PsiElement parentElement, boolean isExecutionScopeChanged) {
        int initialIndex;
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(55);
        }
        if (elt == null) {
            JSResolveUtil.$$$reportNull$$$0(56);
        }
        boolean parentIsClass = parentElement instanceof JSClass;
        PsiElement[] children = JSResolveUtil.getSiblingsToProcess(elt, parentElement, isExecutionScopeChanged);
        int index = initialIndex = JSResolveUtil.indexOfElement(elt, children);
        Object cur = elt;
        TreeWalkUpResult result = TreeWalkUpResult.CONTINUE;
        do {
            PsiElement actualLastParent;
            ProgressManager.checkCanceled();
            Object object = actualLastParent = cur == elt ? lastParent : null;
            if ((cur instanceof JSElement || cur instanceof XmlElement) && !cur.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), actualLastParent, place)) {
                if (!JSResolveUtil.canHaveDeclarationsBefore(cur) || actualLastParent != null) {
                    TreeWalkUpResult treeWalkUpResult = TreeWalkUpResult.RETURN;
                    if (treeWalkUpResult == null) {
                        JSResolveUtil.$$$reportNull$$$0(57);
                    }
                    return treeWalkUpResult;
                }
                result = TreeWalkUpResult.RETURN;
            }
            if (terminatingParent != cur) continue;
            TreeWalkUpResult treeWalkUpResult = TreeWalkUpResult.RETURN_AFTER_POST_PROCESSING;
            if (treeWalkUpResult == null) {
                JSResolveUtil.$$$reportNull$$$0(58);
            }
            return treeWalkUpResult;
        } while (!(cur instanceof PsiFile) && !parentIsClass && (!(cur instanceof JSStatement) || !(parentElement instanceof JSIfStatement)) && !(parentElement instanceof JSObjectLiteralExpression) && !(parentElement instanceof JSArrayLiteralExpression) && (cur = index == -1 ? cur.getPrevSibling() : (index == initialIndex + 1 ? null : (index == 0 ? ((index = children.length - 1) > initialIndex ? children[index] : null) : children[--index]))) != null);
        TreeWalkUpResult treeWalkUpResult = result;
        if (treeWalkUpResult == null) {
            JSResolveUtil.$$$reportNull$$$0(59);
        }
        return treeWalkUpResult;
    }

    private static boolean canHaveDeclarationsBefore(@Nullable PsiElement cur) {
        if (cur instanceof TypeScriptModule) {
            return true;
        }
        if (cur instanceof TypeScriptFunction || cur instanceof TypeScriptClass) {
            return TypeScriptPsiUtil.isAmbientDeclaration(cur);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PsiElement processFileElement(@NotNull JSResolveProcessor processor, @NotNull PsiElement elt, @NotNull PsiElement place, @Nullable PsiElement parentElement) {
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(60);
        }
        if (elt == null) {
            JSResolveUtil.$$$reportNull$$$0(61);
        }
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(62);
        }
        if (elt instanceof XmlFile) {
            JSResolveUtil.processXmlElement(processor, (XmlFile)elt, place);
            if (parentElement != null) {
                return parentElement.getContainingFile();
            }
        } else if (elt instanceof JSFile) {
            PsiFile psiFile;
            FileViewProvider provider;
            if (parentElement == null) return JSResolveUtil.getContext(elt);
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parentElement, XmlTag.class);
            if (tag != null) {
                PsiFile containingFile = parentElement.getContainingFile();
                while (tag != null) {
                    for (XmlBackedJSClassProvider provider2 : XmlBackedJSClassProvider.EP_NAME.getExtensionList()) {
                        if (!provider2.canCreateClassFromTag(tag)) continue;
                        XmlBackedJSClass clazz = XmlBackedJSClassFactory.getInstance().getXmlBackedClass(tag);
                        if (!clazz.processOuterDeclarations(processor)) {
                            return null;
                        }
                        clazz.processDeclarations(processor, ResolveState.initial(), clazz, place);
                        return null;
                    }
                    tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class);
                }
                return containingFile;
            }
            PsiElement topReasonableParent = PsiTreeUtil.getParentOfType((PsiElement)parentElement, (Class[])new Class[]{PsiFile.class, JSExecutionScope.class});
            if (topReasonableParent instanceof PsiFile && (provider = (psiFile = (PsiFile)topReasonableParent).getViewProvider()) instanceof MultiplePsiFilesPerDocumentFileViewProvider && topReasonableParent == provider.getPsi(provider.getBaseLanguage())) {
                return null;
            }
        } else if (parentElement != null) {
            return parentElement.getContainingFile();
        }
        if (elt instanceof JSExpressionCodeFragment || parentElement != null) return parentElement;
        return null;
    }

    private static int indexOfElement(@NotNull PsiElement elt, PsiElement @Nullable [] children) {
        if (elt == null) {
            JSResolveUtil.$$$reportNull$$$0(63);
        }
        int initialIndex = -1;
        if (children != null && children.length > 0) {
            initialIndex = 0;
            for (PsiElement el : children) {
                if (el == elt) break;
                ++initialIndex;
            }
        }
        return initialIndex;
    }

    private static void processXmlElement(PsiScopeProcessor processor, XmlFile xmlFile, PsiElement place) {
        XmlTag rootTag;
        XmlDocument document = xmlFile.getDocument();
        XmlTag xmlTag = rootTag = document != null ? document.getRootTag() : null;
        if (FlexSupportLoader.isFlexMxmFile((PsiFile)xmlFile)) {
            JSResolveUtil.processAllGlobalsInXmlFile(processor, xmlFile, place);
        } else if (rootTag != null && xmlFile.getFileType() == XmlFileType.INSTANCE) {
            JSResolveUtil.processAllGlobalsInXmlFile(processor, xmlFile, place);
        }
    }

    public static boolean processAllGlobalsInXmlFile(PsiScopeProcessor processor, XmlFile xmlFile, PsiElement place) {
        XmlBackedJSClass clazz = XmlBackedJSClassFactory.getXmlBackedClass(xmlFile);
        return clazz == null || clazz.processDeclarations(processor, ResolveState.initial(), clazz, place);
    }

    public static void tryProcessXmlFileImplicitElements(@NotNull PsiElement context, @NotNull WalkUpResolveProcessor processor) {
        if (context == null) {
            JSResolveUtil.$$$reportNull$$$0(64);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(65);
        }
        PsiFile file = context.getContainingFile();
        XmlFile xmlFile = null;
        if (file instanceof XmlFile) {
            xmlFile = (XmlFile)file;
        } else {
            PsiFile outerFile;
            PsiElement fileContext = file.getContext();
            if (fileContext != null && (outerFile = fileContext.getContainingFile()) instanceof XmlFile) {
                xmlFile = (XmlFile)outerFile;
            }
        }
        if (xmlFile == null) {
            return;
        }
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        if (virtualFile != null && JSImplicitElementsIndexHolder.containFileType(virtualFile.getFileType())) {
            return;
        }
        Map<String, Collection<JSElementProxy>> elements = JSIndexContentSupport.getInstance().getImplicitElements((PsiFile)xmlFile);
        Collection<JSElementProxy> proxies = elements.get(processor.getRequiredName());
        if (proxies != null) {
            for (JSElementProxy proxy : proxies) {
                processor.doQualifiedCheck(proxy.toOffsetBasedImplicitElement((PsiFile)xmlFile));
            }
        }
    }

    public static boolean tryProcessAllElementsInInjectedContext(@NotNull PsiFile file, final @NotNull Processor<? super JSPsiElementBase> processor) {
        if (file == null) {
            JSResolveUtil.$$$reportNull$$$0(66);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(67);
        }
        if (!(file instanceof JSFile) || InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file) == null) {
            return true;
        }
        final Ref stopped = Ref.create((Object)false);
        new JSRecursiveWalkingElementVisitor(){

            @Override
            public void visitJSElement(@NotNull JSElement node) {
                Collection<JSImplicitElement> elements;
                JSElementIndexingData data;
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (node instanceof JSFunctionExpression) {
                    return;
                }
                if (node instanceof JSPsiElementBase && !processor.process((Object)((JSPsiElementBase)node))) {
                    this.stopWalking();
                }
                if (node instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)node).getIndexingData()) != null && (elements = data.getImplicitElements()) != null) {
                    for (JSImplicitElement implicitElement : elements) {
                        if (processor.process((Object)implicitElement)) continue;
                        this.stopWalking();
                    }
                }
                super.visitJSElement(node);
            }

            @Override
            public void stopWalking() {
                super.stopWalking();
                stopped.set((Object)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$2", "visitJSElement"));
            }
        }.visitJSElement((JSFile)file);
        return (Boolean)stopped.get() == false;
    }

    private static PsiElement[] getSiblingsToProcess(PsiElement element, PsiElement parent, boolean isExecutionScopeChanged) {
        if (!(parent instanceof JSFile || parent instanceof JSBlockStatement && (isExecutionScopeChanged || parent.getParent() instanceof JSNamedElement) || parent instanceof JSSwitchStatement && element instanceof JSCaseClause)) {
            return null;
        }
        return (PsiElement[])CachedValuesManager.getManager((Project)parent.getProject()).getParameterizedCachedValue((UserDataHolder)parent, CHILDREN_TO_PROCESS_KEY, CHILDREN_TO_PROCESS_PROVIDER, false, (Object)parent);
    }

    @Deprecated
    @Nullable
    public static JSExpression getRealRefExprQualifier(JSReferenceExpression expr) {
        return expr != null ? expr.getQualifier() : null;
    }

    public static String findPackageStatementQualifier(PsiElement context) {
        String s;
        if (context instanceof JSClass && (s = ((JSClass)context).getQualifiedName()) != null) {
            int i = s.lastIndexOf(46);
            if (i != -1) {
                return s.substring(0, i);
            }
            return null;
        }
        JSQualifiedNamedElement packageOrModuleStatement = (JSQualifiedNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSPackageStatement.class, TypeScriptModule.class});
        if (packageOrModuleStatement != null) {
            return packageOrModuleStatement.getQualifiedName();
        }
        return null;
    }

    public static boolean isExprInStrictTypeContext(@NotNull JSReferenceExpression expr) {
        if (expr == null) {
            JSResolveUtil.$$$reportNull$$$0(68);
        }
        for (JSResolveHelper helper : JSResolveHelper.EP_NAME.getExtensionList()) {
            if (helper.isStrictTypeContext((PsiElement)expr)) continue;
            return false;
        }
        PsiElement parent = expr.getParent();
        if (parent instanceof JSReferenceListMember) {
            parent = parent.getParent();
        }
        if (parent instanceof TypeScriptParenthesizedType) {
            parent = TypeScriptPsiUtil.getParentSkipTypeParentheses((TypeScriptType)parent);
        }
        if (parent instanceof JSGenericSignature || parent instanceof JSImportStatement || parent instanceof JSReferenceList && !(parent instanceof ES6ReferenceList) || parent instanceof TypeScriptType && !(parent instanceof TypeScriptTypeofType) || parent instanceof JSExpressionCodeFragment && ((JSExpressionCodeFragment)parent).isTypeContext()) {
            return true;
        }
        if (parent instanceof JSFunction && ((JSFunction)parent).getReturnTypeElement() == expr) {
            return true;
        }
        return parent instanceof JSVariable && ((JSVariable)parent).getTypeElement() == expr;
    }

    public static boolean isExprInTypeContext(JSReferenceExpression expr) {
        PsiElement parent = expr.getParent();
        return JSResolveUtil.isExprInStrictTypeContext(expr) || parent instanceof JSNewExpression || parent instanceof JSBinaryExpression && ((JSBinaryExpression)parent).getROperand() == expr && (((JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.IS_KEYWORD || ((JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.AS_KEYWORD);
    }

    @NotNull
    public static GlobalSearchScope getJavaScriptSymbolsResolveScope(@NotNull Project project) {
        GlobalSearchScope allScope;
        if (project == null) {
            JSResolveUtil.$$$reportNull$$$0(69);
        }
        if ((allScope = (GlobalSearchScope)project.getUserData(PROJECT_SCOPE_WITH_PREDEFINED_KEY)) == null) {
            allScope = JSIndexedRootProviderSupport.getInstance().getJavaScriptSymbolsResolveScope(project);
            project.putUserData(PROJECT_SCOPE_WITH_PREDEFINED_KEY, (Object)allScope);
        }
        GlobalSearchScope globalSearchScope = allScope;
        if (globalSearchScope == null) {
            JSResolveUtil.$$$reportNull$$$0(70);
        }
        return globalSearchScope;
    }

    @NotNull
    public static JSNamespace buildNamespaceForQualifier(JSExpression qualifier) {
        List<String> nameIds;
        if (qualifier == null) {
            nameIds = JSSymbolUtil.buildNameIndexArray(null);
        } else {
            JSNamespace ns = JSSymbolUtil.evaluateNamespaceLocally(qualifier);
            if (ns != null && ns.getQualifiedName() != null) {
                JSNamespace jSNamespace = ns;
                if (jSNamespace == null) {
                    JSResolveUtil.$$$reportNull$$$0(71);
                }
                return jSNamespace;
            }
            nameIds = Collections.singletonList("");
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromComponents(nameIds), JSContext.UNKNOWN, (PsiElement)qualifier, true);
        if (jSNamespace == null) {
            JSResolveUtil.$$$reportNull$$$0(72);
        }
        return jSNamespace;
    }

    public static boolean iterateOverrides(@NotNull JSPsiElementBase node, @Nullable JSClass classToStartHierarchySearch, @NotNull JSOverrideHandler handler, boolean onlyFunctions) {
        String namespace;
        boolean processedClassOverrides;
        JSNamespace ns;
        JSClass context;
        JSClass parentClass;
        if (node == null) {
            JSResolveUtil.$$$reportNull$$$0(73);
        }
        if (handler == null) {
            JSResolveUtil.$$$reportNull$$$0(74);
        }
        JSClass jSClass = parentClass = classToStartHierarchySearch != null ? classToStartHierarchySearch : JSUtils.getMemberContainingClass((PsiElement)node);
        if (parentClass != null && node instanceof JSFunction && ((JSFunction)node).isConstructor()) {
            return true;
        }
        JSClass jSClass2 = context = parentClass != null ? parentClass : node.getContainingFile();
        if (classToStartHierarchySearch != null) {
            ns = JSNamedTypeFactory.buildProvidedNamespace(classToStartHierarchySearch, true);
            if (ns == null) {
                return true;
            }
            ns = JSNamedTypeFactory.copyWithJSContext(ns, JSContext.INSTANCE);
        } else {
            ns = node.getJSNamespace();
        }
        String name = node.getName();
        if (name == null || JSUtils.isPrivateSharpItem((PsiElement)node)) {
            return true;
        }
        if (!(parentClass == null || (processedClassOverrides = JSInheritanceUtil.processOverrides(parentClass, handler, name, namespace = ActionScriptPsiImplUtil.getNamespaceValue(((JSAttributeListOwner)((Object)node)).getAttributeList()), (PsiElement)node, onlyFunctions)) && DialectDetector.isJavaScript(parentClass))) {
            return processedClassOverrides;
        }
        GlobalSearchScope resolveScope = JSResolveUtil.getResolveScope(context);
        JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement(context).getClassResolver();
        HashSet visited = new HashSet();
        return JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(context, ns, true, true, (Processor<? super JSType>)((Processor)type -> {
            String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
            if (qName == null || !visited.add(qName)) {
                return true;
            }
            CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
            String className = qName + "." + name;
            resolver.processElementsByQNameIncludingImplicit(className, resolveScope, (Processor<? super JSPsiElementBase>)collectProcessor);
            ArrayList<JSPsiElementBase> results = new ArrayList<JSPsiElementBase>(collectProcessor.getResults().size());
            for (JSPsiElementBase result : collectProcessor.getResults()) {
                if (result.getAccessType() == JSAttributeList.AccessType.PRIVATE || result.getJSContext() == JSContext.STATIC) continue;
                results.add(result);
            }
            return results.isEmpty() || handler.process(results, context, qName);
        }));
    }

    @Nullable
    public static String getQNameToStartHierarchySearch(JSPsiElementBase node) {
        return JSNamespace.getQualifiedName(JSResolveUtil.getNamespaceToStartHierarchySearch(node));
    }

    @Nullable
    public static JSNamespace getNamespaceToStartHierarchySearch(@NotNull JSPsiElementBase node) {
        if (node == null) {
            JSResolveUtil.$$$reportNull$$$0(75);
        }
        if (node instanceof JSFunction && node.getNamespace() != null && !JSSymbolUtil.isConstructorSymbol(node)) {
            return node.getJSNamespace();
        }
        PsiElement parentNode = JSResolveUtil.findParent((PsiElement)node);
        if (parentNode instanceof JSClass) {
            if (ActionScriptResolveUtil.isActionScriptClassMemberExceptOverride(node)) {
                return null;
            }
            return node.getJSNamespace();
        }
        if (node instanceof JSFunctionExpression && !DialectDetector.isActionScript((PsiElement)node)) {
            return JSContextResolver.resolveContext(node.getFirstChild());
        }
        if (parentNode instanceof JSFile && !DialectDetector.isActionScript(parentNode)) {
            return JSNamedTypeFactory.buildProvidedNamespace(node, true);
        }
        if (node instanceof JSDefinitionExpression) {
            JSExpression expression = ((JSDefinitionExpression)node).getExpression();
            if (expression instanceof JSReferenceExpression) {
                JSExpression expr = JSSymbolUtil.isConstructorSymbol(node) ? expression : ((JSReferenceExpression)expression).getQualifier();
                return JSSymbolUtil.evaluateNamespaceLocally(expr);
            }
        } else if (node instanceof JSVariable) {
            return JSSymbolUtil.isConstructorSymbol(node) ? JSNamedTypeFactory.buildProvidedNamespace(node, true) : node.getJSNamespace();
        }
        return null;
    }

    public static boolean isInPlaceWhereTypeCanBeDuringCompletion(PsiElement expr) {
        PsiElement parent = expr.getParent();
        if (parent instanceof JSArgumentList || parent instanceof JSVariable && ((JSVariable)parent).getInitializer() == expr) {
            if (expr instanceof JSReferenceExpression) {
                JSExpression qualifier = ((JSReferenceExpression)expr).getQualifier();
                return qualifier == null || qualifier instanceof JSReferenceExpression;
            }
            return true;
        }
        if (parent instanceof JSExpressionStatement) {
            if (expr instanceof JSReferenceExpression) {
                return ((JSReferenceExpression)expr).getQualifier() == null;
            }
            return true;
        }
        return false;
    }

    public static boolean isPlaceWhereNsCanBe(PsiElement parent) {
        PsiElement grandParent = parent.getParent();
        return grandParent instanceof JSClass || grandParent instanceof JSPackageStatement || grandParent instanceof JSFile && grandParent.getContext() == null;
    }

    @Nullable
    public static String getTypeFromTagNameInMxml(@Nullable PsiElement psiElement) {
        JSClass clazz = JSResolveUtil.getClassFromTagNameInMxml(psiElement);
        return clazz != null ? clazz.getQualifiedName() : null;
    }

    public static JSClass getClassFromTagNameInMxml(PsiElement psiElement) {
        XmlTag tag;
        XmlTag xmlTag = tag = psiElement != null ? (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{XmlTag.class}) : null;
        if (tag != null && (!tag.getNamespacePrefix().isEmpty() || FlexSupportLoader.isFlexMxmFile(tag.getContainingFile()))) {
            XmlElementDescriptor descriptor;
            if ("Script".equals(tag.getLocalName())) {
                tag = ((XmlFile)tag.getContainingFile()).getDocument().getRootTag();
            }
            if ((descriptor = tag.getDescriptor()) != null) {
                PsiElement decl = descriptor.getDeclaration();
                if (decl instanceof JSClass) {
                    return (JSClass)decl;
                }
                if (decl instanceof XmlFile) {
                    return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)decl);
                }
            }
        }
        return null;
    }

    @NotNull
    public static <T extends PsiPolyVariantReference> @NotNull ResolveResult @NotNull [] resolve(PsiFile file, @NotNull T reference, @NotNull ResolveCache.PolyVariantResolver<T> resolver, boolean incompleteCode) {
        if (reference == null) {
            JSResolveUtil.$$$reportNull$$$0(76);
        }
        if (resolver == null) {
            JSResolveUtil.$$$reportNull$$$0(77);
        }
        if (file == null || !AppModeAssertions.checkBackend()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSResolveUtil.$$$reportNull$$$0(78);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] value = (ResolveResult[])JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)file, () -> JSResolveCacheKt.resolveWithCachingWithJSDependencies(resolver, reference, incompleteCode));
        ResolveResult[] resolveResultArray = value != null ? value : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            JSResolveUtil.$$$reportNull$$$0(79);
        }
        return resolveResultArray;
    }

    public static void clearResolveCaches(PsiFile file) {
        ResolveCache.getInstance((Project)file.getProject()).clearCache(true);
    }

    private static boolean isOutOfScope(@Nullable JSElement value, @NotNull JSElement _scope, @NotNull PsiElement place, PsiScopeProcessor processor) {
        if (_scope == null) {
            JSResolveUtil.$$$reportNull$$$0(80);
        }
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(81);
        }
        if (value != null && value.getParent() instanceof ES6ExportDefaultAssignment && !PsiTreeUtil.isAncestor((PsiElement)_scope, (PsiElement)place, (boolean)true)) {
            return true;
        }
        return !(processor instanceof SinkResolveProcessor && !(((SinkResolveProcessor)processor).getResultSink() instanceof ResolveResultSink) || value == null || !(place instanceof JSReferenceExpression) && !(place instanceof JSIndexedPropertyAccessExpression) || !JSResolveUtil.isIllegalPlaceForPrivate((PsiElement)value, place));
    }

    public static boolean isIllegalPlaceForPrivate(@Nullable PsiElement value, @NotNull PsiElement place) {
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(82);
        }
        return !JSUtils.isPrivateNameReference(place) == JSUtils.isPrivateSharpItem(value);
    }

    public static boolean processDeclarationsInScopeAndUp(@NotNull PsiElement place, @NotNull JSResolveProcessor processor) {
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(83);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(84);
        }
        JSElement scope = (JSElement)JSStubBasedPsiTreeUtil.getContextOfType(place, JSTreeUtil.ScopeTypesHolder.SCOPE_TYPES, true);
        while (scope != null) {
            if (!JSResolveUtil.processDeclarationsInScope(scope, processor, ResolveState.initial(), place, place)) {
                return false;
            }
            if (scope instanceof PsiFile || scope instanceof JSEmbeddedContent) {
                return true;
            }
            scope = (JSElement)JSStubBasedPsiTreeUtil.getContextOfType((PsiElement)scope, JSTreeUtil.ScopeTypesHolder.SCOPE_TYPES, true);
        }
        return true;
    }

    @Deprecated
    @ApiStatus.Internal
    public static boolean processDeclarationsInScope(JSElement _scope, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        JSResolveProcessorEx processorEx;
        JSElement scope = (JSElement)CompletionUtilCoreImpl.getOriginalElement((PsiElement)_scope);
        if (scope == null) {
            return true;
        }
        String requiredName = null;
        if (processor instanceof JSResolveProcessor) {
            requiredName = ((JSResolveProcessor)processor).getName();
        }
        boolean result = true;
        List<JSElement> elements = JSScopeNamesCache.getNamedElementsInScope(scope, requiredName, false);
        for (JSElement element : elements) {
            if (JSResolveUtil.isOutOfScope(element, _scope, place, processor)) continue;
            result &= element.processDeclarations(processor, state, null, place);
        }
        if (result && scope instanceof ActionScriptClassBase && processor instanceof JSResolveProcessorEx && (processorEx = (JSResolveProcessorEx)processor).isToProcessActionScriptImplicits()) {
            processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_STARTED, (Object)scope);
            for (JSClass clazz : ((ActionScriptClassBase)scope).getImplicitlyDeclaredInterfaces()) {
                result = clazz.processDeclarations(processor, state, lastParent, place);
            }
            processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_FINISHED, (Object)scope);
        }
        return result;
    }

    @NotNull
    public static Collection<JSElement> findNamedElementsInScope(@NotNull String name, @NotNull JSElement scope) {
        if (name == null) {
            JSResolveUtil.$$$reportNull$$$0(85);
        }
        if (scope == null) {
            JSResolveUtil.$$$reportNull$$$0(86);
        }
        if (scope.isValid()) {
            JSElement originalElement = (JSElement)CompletionUtilCoreImpl.getOriginalElement((PsiElement)scope);
            if (originalElement != null) {
                scope = originalElement;
            }
        } else {
            Logger.getInstance(JSResolveUtil.class).error("scope must be valid");
        }
        List<JSElement> list = JSScopeNamesCache.getNamedElementsInScope(scope, name, false);
        if (list == null) {
            JSResolveUtil.$$$reportNull$$$0(87);
        }
        return list;
    }

    @Nullable
    public static PsiElement getLocalVariableRef(@Nullable JSFunction function, JSReferenceExpression expr) {
        return expr.getQualifier() == null ? JSResolveUtil.getLocalVariableRef(function, expr.getReferenceName()) : null;
    }

    @Nullable
    public static PsiElement getLocalVariableRef(@Nullable JSFunction function, @Nullable String referencedName) {
        if (referencedName != null) {
            SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(referencedName, true, new ResolveResultSink(null, referencedName));
            while (function != null) {
                boolean val = function.processDeclarations(processor, ResolveState.initial(), (PsiElement)function.getParameterList(), function);
                if (!val) {
                    return processor.getResult();
                }
                if ((function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)function, JSFunction.class)) != null) continue;
                break;
            }
        }
        return null;
    }

    public static JSSourceElement[] getSourceElements(PsiElement owner) {
        if (owner instanceof JSStubElementImpl) {
            JSStubElementImpl stubElement = (JSStubElementImpl)owner;
            return (JSSourceElement[])stubElement.getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, JSSourceElement.ARRAY_FACTORY);
        }
        if (owner instanceof JSFile) {
            JSFile jsFile = (JSFile)owner;
            return jsFile.getStatements();
        }
        return JSSourceElement.EMPTY_ARRAY;
    }

    public static PsiElement[] getStubbedChildren(@Nullable PsiElement owner) {
        return JSResolveUtil.getStubbedChildren(owner, JSExtendedLanguagesTokenSetProvider.OUR_STUBBED_FILTER);
    }

    public static PsiElement[] getStubbedChildren(@Nullable PsiElement owner, @NotNull TokenSet filter) {
        if (filter == null) {
            JSResolveUtil.$$$reportNull$$$0(88);
        }
        if (owner instanceof JSStubElementImpl) {
            JSStubElementImpl element = (JSStubElementImpl)owner;
            StubElement stub = element.getStub();
            if (stub != null) {
                return stub.getChildrenByType(filter, PsiElement.EMPTY_ARRAY);
            }
            return JSResolveUtil.getChildrenFromTokenSet(element.getNode(), filter);
        }
        if (owner instanceof JSFile) {
            JSFile file = (JSFile)owner;
            StubElement stub = ((PsiFileImpl)file).getStub();
            if (stub != null) {
                return stub.getChildrenByType(filter, PsiElement.EMPTY_ARRAY);
            }
            return JSResolveUtil.getChildrenFromTokenSet((ASTNode)file.getNode(), filter);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static PsiElement[] getChildrenFromTokenSet(ASTNode astNode, TokenSet filter) {
        ASTNode[] astNodes = astNode.getChildren(filter);
        PsiElement[] result = new PsiElement[astNodes.length];
        for (int i = 0; i < astNodes.length; ++i) {
            result[i] = astNodes[i].getPsi();
        }
        return result;
    }

    @Nullable
    public static JSFunction getClassConstructor(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            JSResolveUtil.$$$reportNull$$$0(89);
        }
        if (jsClass.isInterface()) {
            return null;
        }
        for (JSElement jSElement : jsClass.getMembers()) {
            if (!(jSElement instanceof JSFunction) || !JSResolveUtil.isConstructorFunction((JSFunction)jSElement)) continue;
            return (JSFunction)jSElement;
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isConstructorFunction(@Nullable PsiElement element) {
        return element instanceof JSFunction && ((JSFunction)element).isConstructor();
    }

    @NotNull
    public static List<? extends PsiElement> getExportedElements(@NotNull JSExecutionScope module) {
        if (module == null) {
            JSResolveUtil.$$$reportNull$$$0(90);
        }
        return JSResolveUtil.getExportedElements((PsiElement)module);
    }

    @NotNull
    public static List<? extends PsiElement> getExportedElements(@NotNull PsiElement module) {
        TypeScriptExportAssignment assignment;
        List<JSPsiElementBase> candidates;
        if (module == null) {
            JSResolveUtil.$$$reportNull$$$0(91);
        }
        List<JSPsiElementBase> list = candidates = module instanceof JSExecutionScope ? CommonJSUtil.getModuleExports((JSExecutionScope)module) : ContainerUtil.emptyList();
        if (!candidates.isEmpty()) {
            List<JSPsiElementBase> list2 = candidates;
            if (list2 == null) {
                JSResolveUtil.$$$reportNull$$$0(92);
            }
            return list2;
        }
        if (DialectDetector.isTypeScript(module) && (assignment = TypeScriptPsiUtil.findExportAssignment(module)) != null) {
            List<TypeScriptExportAssignment> list3 = Collections.singletonList(assignment);
            if (list3 == null) {
                JSResolveUtil.$$$reportNull$$$0(93);
            }
            return list3;
        }
        List<JSPsiElementBase> list4 = candidates;
        if (list4 == null) {
            JSResolveUtil.$$$reportNull$$$0(94);
        }
        return list4;
    }

    public static boolean isEventListenerCall(JSCallExpression e) {
        String methodName;
        JSExpression methodExpression = e.getMethodExpression();
        return methodExpression instanceof JSReferenceExpression && ("addEventListener".equals(methodName = ((JSReferenceExpression)methodExpression).getReferenceName()) || "removeEventListener".equals(methodName));
    }

    @Nullable
    public static PsiElement getScopeToIncludeLocalMembers(@NotNull JSNamespace namespace) {
        if (namespace == null) {
            JSResolveUtil.$$$reportNull$$$0(95);
        }
        return namespace.getSource().getScope();
    }

    public static List<PsiElement> getValidResults(ResolveResult @NotNull [] results) {
        if (results == null) {
            JSResolveUtil.$$$reportNull$$$0(96);
        }
        return ContainerUtil.map((Collection)ContainerUtil.filter((Object[])results, ResolveResult::isValidResult), ResolveResult::getElement);
    }

    public static boolean isPredefinedExtensibleType(@NotNull JSType type) {
        if (type == null) {
            JSResolveUtil.$$$reportNull$$$0(97);
        }
        return JSNamedType.isNamedTypeWithName(type, "EventTarget") || JSNamedType.isNamedTypeWithName(type, "Node") || JSNamedType.isNamedTypeWithName(type, "Element") || JSNamedType.isNamedTypeWithName(type, "HTMLElement");
    }

    public static boolean isFrameworkPredefinedExtensibleType(@NotNull JSType type) {
        if (type == null) {
            JSResolveUtil.$$$reportNull$$$0(98);
        }
        return JSNamedType.isNamedTypeWithName(type, "kendo.data.ObservableObject") || JSNamedType.isNamedTypeWithName(type, "DefaultRootState");
    }

    @Nullable
    public static PsiFile getOriginalFile(@NotNull PsiElement psiElement) {
        PsiFile originalFile;
        if (psiElement == null) {
            JSResolveUtil.$$$reportNull$$$0(99);
        }
        if ((originalFile = (PsiFile)psiElement.getUserData(PsiFileFactory.ORIGINAL_FILE)) != null) {
            return originalFile;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        originalFile = (PsiFile)containingFile.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (originalFile != null) {
            return originalFile;
        }
        return containingFile.getOriginalFile();
    }

    public static void evaluateQualifierType(@NotNull JSExpression originalQualifier, @NotNull JSElvisOwner expression, @NotNull @NotNull Function<@NotNull PsiElement, @Nullable JSType> qualifierTypeProvider, @NotNull JSQualifiedItemProcessor processor) {
        JSType type;
        JSReferenceExpression refExpr;
        if (originalQualifier == null) {
            JSResolveUtil.$$$reportNull$$$0(100);
        }
        if (expression == null) {
            JSResolveUtil.$$$reportNull$$$0(101);
        }
        if (qualifierTypeProvider == null) {
            JSResolveUtil.$$$reportNull$$$0(102);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(103);
        }
        boolean supportsDirectTypeProcessing = DialectDetector.isTypeScript((PsiElement)originalQualifier) && (!(expression instanceof JSReferenceExpression) || !JSResolveUtil.isExprInStrictTypeContext(JSResolveUtil.getTopReferenceExpression(refExpr = (JSReferenceExpression)expression)));
        JSType jSType = type = supportsDirectTypeProcessing ? qualifierTypeProvider.apply((PsiElement)originalQualifier) : null;
        if (type != null && type.isSourceStrict()) {
            JSCallExpression callQualifier;
            if (expression.isElvis() || originalQualifier instanceof JSCallExpression && (callQualifier = (JSCallExpression)originalQualifier).isElvis()) {
                type = JSTypeUtils.removeNullableComponents(type);
            }
            processor.process(type, new JSEvaluateContext(originalQualifier.getContainingFile()));
        } else {
            JSResolveUtil.evaluateQualifierType(originalQualifier, originalQualifier.getContainingFile(), processor);
        }
    }

    public static void evaluateQualifierType(@NotNull JSExpression qualifier, @Nullable PsiFile targetFile, @NotNull JSQualifiedItemProcessor processor) {
        if (qualifier == null) {
            JSResolveUtil.$$$reportNull$$$0(104);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(105);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes((PsiElement)qualifier, targetFile, (JSTypeProcessor)processor, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 25, 26, 27, 36, 38, 39, 57, 58, 59, 70, 71, 72, 78, 79, 87, 92, 93, 94 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageContext";
                break;
            }
            case 8: 
            case 9: 
            case 25: 
            case 26: 
            case 27: 
            case 36: 
            case 38: 
            case 39: 
            case 57: 
            case 58: 
            case 59: 
            case 70: 
            case 71: 
            case 72: 
            case 78: 
            case 79: 
            case 87: 
            case 92: 
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedJsFile";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 18: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl";
                break;
            }
            case 20: 
            case 21: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 23: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 28: 
            case 29: 
            case 33: 
            case 35: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 32: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 37: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 40: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 46: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 47: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainOccurrence";
                break;
            }
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 51: 
            case 55: 
            case 60: 
            case 65: 
            case 67: 
            case 84: 
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 54: 
            case 62: 
            case 81: 
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 56: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_scope";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 90: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 97: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalQualifier";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierTypeProvider";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortTypeName";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopReferenceExpression";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftmostQualifier";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "processSiblingsForElement";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaScriptSymbolsResolveScope";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNamespaceForQualifier";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamedElementsInScope";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processInjectedFileForTag";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getServicePoweredOrBuiltInEngineQualifierType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getServicePoweredType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltInEngineType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGetBuiltInEngineType";
                break;
            }
            case 8: 
            case 9: 
            case 25: 
            case 26: 
            case 27: 
            case 36: 
            case 38: 
            case 39: 
            case 57: 
            case 58: 
            case 59: 
            case 70: 
            case 71: 
            case 72: 
            case 78: 
            case 79: 
            case 87: 
            case 92: 
            case 93: 
            case 94: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getXmlBackedClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isResolveDynamic";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isResolveStrict";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "areResolveResultsStrict";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptDeclarationMerging";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasUseStrictPragmaUp";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasUseStrictPragma";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "changesThisValue";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shortReferenceIsAmbiguousOrUnequal";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isFromPredefinedFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFileForScopeEvaluation";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isObjectClass";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processHierarchy";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "stableResolveOrder";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isSelfReference";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getTopReferenceExpression";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLeftmostQualifier";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isSameReference";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isDummyResolve";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findParent";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findParentClass";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getClassOfContextForPrivateMemberReference";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getParameterFromSetAccessor";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processParametersForUsedArgument";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findParameterForUsedArgument";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameFromPlace";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "processSiblingsForElement";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "processFileElement";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "indexOfElement";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "tryProcessXmlFileImplicitElements";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "tryProcessAllElementsInInjectedContext";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isExprInStrictTypeContext";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getJavaScriptSymbolsResolveScope";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "iterateOverrides";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceToStartHierarchySearch";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isOutOfScope";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isIllegalPlaceForPrivate";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScopeAndUp";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "findNamedElementsInScope";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getStubbedChildren";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getClassConstructor";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getExportedElements";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getScopeToIncludeLocalMembers";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getValidResults";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedExtensibleType";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isFrameworkPredefinedExtensibleType";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalFile";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "evaluateQualifierType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 25, 26, 27, 36, 38, 39, 57, 58, 59, 70, 71, 72, 78, 79, 87, 92, 93, 94 -> new IllegalStateException(string);
        };
    }

    public static abstract class MyNamespaceProcessor
    implements Processor<JSType> {
        private final Set<JSPsiElementBase> myFunctions;
        private final LinkedList<String> myDescendants = new LinkedList();
        private final Set<String> myProcessed = new HashSet<String>();
        protected JSPsiElementBase function;
        private final boolean myFindAll;

        public MyNamespaceProcessor(Set<JSPsiElementBase> functions, boolean findAll) {
            this.myFunctions = functions;
            this.myFindAll = findAll;
        }

        public boolean process(@NotNull JSType type) {
            if (type == null) {
                MyNamespaceProcessor.$$$reportNull$$$0(0);
            }
            if (type instanceof JSNamedType && ((JSNamedType)type).getTypeContext() == JSTypeContext.STATIC) {
                return true;
            }
            String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
            if (qName == null) {
                return true;
            }
            if (!this.myFindAll && this.myProcessed.contains(qName)) {
                return true;
            }
            if (this.myProcessed.add(qName)) {
                this.myDescendants.add(qName);
            }
            Collection<JSPsiElementBase> elements = null;
            PsiFile file = type.getSource().getScope();
            if (file == null) {
                Logger.getInstance(MyNamespaceProcessor.class).error("Null scope");
                return true;
            }
            GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)file);
            boolean result = false;
            Iterator<JSPsiElementBase> functionIterator = this.myFunctions.iterator();
            while (functionIterator.hasNext()) {
                Collection<JSPsiElementBase> elementsToProcess;
                this.function = functionIterator.next();
                if (JSSymbolUtil.isConstructorSymbol(this.function)) {
                    if (elements == null) {
                        elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(qName, scope);
                    }
                    elementsToProcess = elements;
                } else {
                    String descendantName = this.function.getName();
                    elementsToProcess = new ArrayList<JSPsiElementBase>();
                    if (descendantName != null) {
                        String memberName = qName + "." + descendantName;
                        Collection<JSPsiElementBase> members = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(memberName, scope);
                        elementsToProcess.addAll(members);
                    }
                }
                boolean skipImplicitElements = false;
                for (JSPsiElementBase elementToProcess : elementsToProcess) {
                    if (elementToProcess instanceof JSImplicitElement) continue;
                    skipImplicitElements = true;
                    break;
                }
                boolean b = true;
                for (JSPsiElementBase elementToProcess : elementsToProcess) {
                    if (skipImplicitElements && elementToProcess instanceof JSImplicitElement) continue;
                    b &= this.doProcess((PsiElement)elementToProcess);
                }
                if (!b) {
                    functionIterator.remove();
                }
                result |= b;
            }
            return result;
        }

        protected abstract boolean doProcess(PsiElement var1);

        public void processDescendantsOf(String qName, PsiElement context) {
            ProgressManager.checkCanceled();
            boolean b = JSTypeEvaluateManager.iterateSubclasses(context, qName, this);
            while (b && !this.myDescendants.isEmpty()) {
                ProgressManager.checkCanceled();
                b = JSTypeEvaluateManager.iterateSubclasses(context, this.myDescendants.removeFirst(), this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$MyNamespaceProcessor", "process"));
        }
    }

    public static final class VisitAllTypesProcessor
    extends ResolveProcessor {
        private final Processor<? super JSClass> myProcessor;
        private final boolean myVisitInterfaces;

        public VisitAllTypesProcessor(Processor<? super JSClass> processor, boolean visitInterfaces) {
            super((String)null);
            this.myProcessor = processor;
            this.setLocalResolve(true);
            this.setTypeContext(true);
            this.setToProcessHierarchy(true);
            this.setToProcessMembers(false);
            this.myVisitInterfaces = visitInterfaces;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                VisitAllTypesProcessor.$$$reportNull$$$0(0);
            }
            if (state == null) {
                VisitAllTypesProcessor.$$$reportNull$$$0(1);
            }
            if (element instanceof JSClass) {
                JSClass clazz = (JSClass)element;
                if (!this.myProcessor.process((Object)clazz)) {
                    return false;
                }
                if (this.myVisitInterfaces) {
                    for (JSClass im : clazz.getImplementedInterfaces()) {
                        if (im.processDeclarations(this, state, im, im)) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$VisitAllTypesProcessor";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class GenericSignature {
        public final String genericType;
        public final String elementType;

        public GenericSignature(String _type, String _genericType) {
            this.elementType = _type;
            this.genericType = _genericType;
        }

        public static String build(String typeName, @Nullable GenericSignature genericSignature) {
            if (genericSignature == null) {
                return typeName;
            }
            return typeName + ".<" + genericSignature.genericType + ">";
        }
    }

    private static final class Holder {
        private static final Class<? extends JSQualifiedNamedElement>[] PACKAGE_ELEMENTS = new Class[]{TypeScriptModule.class, JSVariable.class, JSNamespaceDeclaration.class, JSPackageStatement.class, JSPackage.class, JSFunction.class, JSClass.class};

        private Holder() {
        }
    }

    static enum TreeWalkUpResult {
        RETURN,
        RETURN_AFTER_POST_PROCESSING,
        CONTINUE;

    }

    public static class StructureProcessingOptions
    extends ResolveProcessor.ProcessingOptions {
        @Override
        public boolean toProcessFunctionArguments() {
            return false;
        }

        @Override
        public boolean toProcessFunctionBodyDeclarations(@Nullable PsiElement lastParent, @NotNull JSFunction fun) {
            if (fun == null) {
                StructureProcessingOptions.$$$reportNull$$$0(0);
            }
            return lastParent != null;
        }

        @Override
        public boolean toProcessPackageContent(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
            return lastParent != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$StructureProcessingOptions", "toProcessFunctionBodyDeclarations"));
        }
    }

    public static interface AllowFileLocalSymbols {
    }

    public static abstract class JSInjectedFilesVisitor
    implements PsiLanguageInjectionHost.InjectedPsiVisitor,
    XmlBackedJSClass.InjectedFileVisitor {
        public void visit(@NotNull PsiFile injectedPsi, @NotNull List<? extends PsiLanguageInjectionHost.Shred> places) {
            if (injectedPsi == null) {
                JSInjectedFilesVisitor.$$$reportNull$$$0(0);
            }
            if (places == null) {
                JSInjectedFilesVisitor.$$$reportNull$$$0(1);
            }
            if (injectedPsi instanceof JSFile) {
                this.process((JSFile)injectedPsi);
            }
        }

        protected abstract void process(JSFile var1);

        @Override
        public void visit(XmlTag rootTag, JSFile file) {
            this.process(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "injectedPsi";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "places";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$JSInjectedFilesVisitor";
            objectArray[2] = "visit";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static enum AssignableTypeStatus {
        OK,
        LANG_IMPLICIT_COERCION,
        COMPILE_TIME_FAIL;

    }
}

