/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeEvaluator;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSCacheableTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSDecoratorsOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSEmptyOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSInferDecoratorsContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSUnionOperation;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptNarrowTypeByAssignmentOperation
extends JSCacheableTypeOperation {
    @NotNull
    private final JSTypeOperation myPrev;
    @NotNull
    private final Set<JSDecoratedType.TypeDecoration> myInitializerDecorators;
    @Nullable
    private final JSType myInitializerExpressionType;
    private final boolean myForInStatement;
    private final boolean myIsEmptyArray;
    private final boolean myHasInitializer;
    private final boolean myDeclarationPlace;
    private final boolean myReadWrite;
    private final boolean myHasCircularThisPropertyAssignments;
    private final boolean myIsInConstructor;
    @Nullable
    private final IElementType myBinaryExpressionSign;

    public TypeScriptNarrowTypeByAssignmentOperation(@NotNull JSTypeOperation prev, @NotNull PsiElement element, @NotNull ReadWriteAccessDetector.Access access, boolean isDeclarationPlace, boolean hasCircularThisPropertyAssignments, boolean isInConstructor) {
        if (prev == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(1);
        }
        if (access == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(2);
        }
        this.myPrev = prev;
        this.myReadWrite = access == ReadWriteAccessDetector.Access.ReadWrite;
        JSExpression ownInitializer = null;
        if (element instanceof JSForInStatement) {
            JSExpression collectionExpression = ((JSForInStatement)element).getCollectionExpression();
            this.myInitializerExpressionType = collectionExpression == null ? null : JSTypeGuardUtil.getOperationType(collectionExpression);
            this.myHasInitializer = false;
        } else {
            Ref hasInitializer = Ref.create((Object)Boolean.FALSE);
            Ref ownInitializerRef = Ref.create();
            this.myInitializerExpressionType = this.getInitializerType(element, (Ref<Boolean>)hasInitializer, (Ref<JSExpression>)ownInitializerRef);
            this.myHasInitializer = (Boolean)hasInitializer.get();
            ownInitializer = (JSExpression)ownInitializerRef.get();
        }
        this.myInitializerDecorators = TypeScriptNarrowTypeByAssignmentOperation.getInitializerDecorators(ownInitializer);
        this.myForInStatement = element instanceof JSForInStatement;
        this.myDeclarationPlace = isDeclarationPlace;
        this.myIsEmptyArray = this.myDeclarationPlace || JSTypeGuardUtil.isEmptyArrayExpression(ownInitializer);
        this.myBinaryExpressionSign = element instanceof JSBinaryExpression ? ((JSBinaryExpression)element).getOperationSign() : null;
        this.myHasCircularThisPropertyAssignments = hasCircularThisPropertyAssignments;
        this.myIsInConstructor = isInConstructor;
    }

    @Nullable
    protected JSType getInitializerType(@NotNull PsiElement element, @NotNull Ref<Boolean> hasInitializer, @NotNull Ref<JSExpression> ownInitializer) {
        PsiElement parent;
        if (element == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(3);
        }
        if (hasInitializer == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(4);
        }
        if (ownInitializer == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(5);
        }
        if (JSDestructuringUtil.isDestructuring(parent = element.getContext()) || JSDestructuringUtil.isAssignmentPatternElement(parent)) {
            Ref initializerOwnType = Ref.create();
            Ref initializerRef = Ref.create();
            JSType result = JSDestructuringUtil.getTypeFromInitializer(element, expression -> {
                initializerRef.set(expression);
                JSType type = expression != null ? JSTypeGuardUtil.getOperationType(expression) : null;
                initializerOwnType.set((Object)type);
                return type;
            });
            hasInitializer.set((Object)(initializerRef.get() != null ? 1 : 0));
            ownInitializer.set(result != null && result == initializerOwnType.get() ? (JSExpression)initializerRef.get() : null);
            return result;
        }
        JSExpression expression2 = JSTypeGuardUtil.getInitializerExpression(element);
        ownInitializer.set((Object)expression2);
        hasInitializer.set((Object)(expression2 != null ? 1 : 0));
        return expression2 != null ? JSTypeGuardUtil.getOperationType(expression2) : null;
    }

    @NotNull
    private static Set<JSDecoratedType.TypeDecoration> getInitializerDecorators(@Nullable JSExpression initializer) {
        if (initializer == null) {
            Set<JSDecoratedType.TypeDecoration> set = Collections.emptySet();
            if (set == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(6);
            }
            return set;
        }
        boolean isUndefined = JSSymbolUtil.isUndefinedExpression(initializer);
        if (isUndefined) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED);
            if (enumSet == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(7);
            }
            return enumSet;
        }
        boolean isNull = JSSymbolUtil.isNullLiteral(initializer);
        if (isNull) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_NULL);
            if (enumSet == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(8);
            }
            return enumSet;
        }
        if (TypeScriptNarrowTypeByAssignmentOperation.isNonEmptyExpression(initializer)) {
            if (initializer instanceof JSLiteralExpression) {
                EnumSet<JSDecoratedType.TypeDecoration> enumSet = JSTypeGuardChecker.NOTNULL_UNDEFINED_PRIMITIVE;
                if (enumSet == null) {
                    TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(9);
                }
                return enumSet;
            }
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = JSTypeGuardChecker.NOTNULL_NOTUNDEFINED;
            if (enumSet == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(10);
            }
            return enumSet;
        }
        Set<JSDecoratedType.TypeDecoration> set = Collections.emptySet();
        if (set == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(11);
        }
        return set;
    }

    @Override
    @NotNull
    protected JSType applyWithoutCache(@NotNull JSApplyTypeOperationContext context, @NotNull JSType type) {
        JSType rType;
        if (context == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(12);
        }
        if (type == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(13);
        }
        if (this.myReadWrite) {
            JSType binaryExpressionType;
            IElementType signWithoutEq;
            JSType prevType = JSTypeGuardUtil.getBaseTypeOfLiteralType(this.myPrev.apply(context, type));
            Object object = this.myBinaryExpressionSign == JSTokenTypes.QUEST_QUEST_EQ ? JSTokenTypes.QUEST_QUEST : (this.myBinaryExpressionSign == JSTokenTypes.AND_AND_EQ ? JSTokenTypes.ANDAND : (signWithoutEq = this.myBinaryExpressionSign == JSTokenTypes.OR_OR_EQ ? JSTokenTypes.OROR : null));
            if (this.myInitializerExpressionType != null && signWithoutEq != null && (binaryExpressionType = TypeScriptTypeEvaluator.getAndOrOrOrQuestType(prevType, this.myInitializerExpressionType, signWithoutEq, context.getContextElement(), JSTypeCastUtil.strictNullChecks(context.getProcessingContext()))) != null) {
                JSType jSType = binaryExpressionType;
                if (jSType == null) {
                    TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(14);
                }
                return jSType;
            }
            JSType jSType = prevType;
            if (jSType == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(15);
            }
            return jSType;
        }
        if (this.myInitializerExpressionType == null) {
            JSType jSType = this.myPrev.apply(context, type);
            if (jSType == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(16);
            }
            return jSType;
        }
        if (context.isAutoArrayType()) {
            JSType initializerType;
            if (this.myDeclarationPlace || this.myIsEmptyArray) {
                JSType jSType = context.getEvolvingArrayType(JSNamedTypeFactory.createNeverType(context.getDefaultTypeSource()));
                if (jSType == null) {
                    TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(17);
                }
                return jSType;
            }
            if (this.myHasInitializer && (initializerType = this.evaluateInitializerType(context, this.myInitializerExpressionType)) != null) {
                JSType typeToUse = JSTypeGuardUtil.getBaseTypeOfLiteralType(initializerType);
                JSType jSType = TypeScriptTypeRelations.isTypeAssignableTo(typeToUse, context.getDeclaredType(), context.getProcessingContext()) ? typeToUse : JSNamedTypeFactory.createType("Array", context.getDefaultTypeSource(), JSContext.INSTANCE);
                if (jSType == null) {
                    TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(18);
                }
                return jSType;
            }
        }
        if ((rType = this.getAssignmentType(context, this.myInitializerExpressionType)) != null) {
            JSType jSType = rType;
            if (jSType == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(19);
            }
            return jSType;
        }
        JSType jSType = this.myPrev.apply(context, type);
        if (jSType == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(20);
        }
        return jSType;
    }

    @Nullable
    private JSType getAssignmentType(@NotNull JSApplyTypeOperationContext context, @NotNull JSType type) {
        JSType initializerType;
        if (context == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(21);
        }
        if (type == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(22);
        }
        if (context.isAutoVariableType() && !this.myDeclarationPlace) {
            JSType initializerType2;
            if (!(this.myIsInConstructor && this.myHasCircularThisPropertyAssignments || (initializerType2 = this.evaluateInitializerType(context, type)) == null)) {
                return JSTypeGuardUtil.getBaseTypeOfLiteralType(initializerType2);
            }
            return JSAnyType.get(context.getDefaultTypeSource());
        }
        JSType declared = context.getDeclaredType();
        if (declared instanceof JSUnionType && (initializerType = this.evaluateInitializerType(context, type)) != null) {
            return this.getAssignmentReducedType(context, (JSUnionType)declared, initializerType);
        }
        return declared;
    }

    @Override
    @NotNull
    protected Set<JSDecoratedType.TypeDecoration> inferTypeDecoratorsImpl(@NotNull JSInferDecoratorsContext context) {
        if (context == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(23);
        }
        if (this.myHasInitializer) {
            if (!this.myReadWrite || this.myInitializerDecorators.contains((Object)JSDecoratedType.TypeDecoration.INFERRED_NOTNULL) && this.myInitializerDecorators.contains((Object)JSDecoratedType.TypeDecoration.INFERRED_NOTUNDEFINED)) {
                Set<JSDecoratedType.TypeDecoration> set = this.myInitializerDecorators;
                if (set == null) {
                    TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(24);
                }
                return set;
            }
            JSTypeOperation withInitializer = JSDecoratorsOperation.create(JSEmptyOperation.NO_OPERATION, this.myInitializerDecorators);
            JSTypeOperation merged = JSUnionOperation.create(this.myPrev, withInitializer, false);
            Set<JSDecoratedType.TypeDecoration> set = merged.inferTypeDecorators(context);
            if (set == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(25);
            }
            return set;
        }
        Set<JSDecoratedType.TypeDecoration> set = this.myPrev.inferTypeDecorators(context);
        if (set == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(26);
        }
        return set;
    }

    private static boolean isNonEmptyExpression(@Nullable JSExpression initializer) {
        return initializer instanceof JSLiteralExpression || initializer instanceof JSObjectLiteralExpression || initializer instanceof JSArrayLiteralExpression || initializer instanceof JSNamedExpression;
    }

    @Nullable
    protected JSType evaluateInitializerType(@NotNull JSApplyTypeOperationContext context, @NotNull JSType expressionType) {
        if (context == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(27);
        }
        if (expressionType == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(28);
        }
        JSType type = context.expandOperationType(expressionType);
        if (this.myForInStatement) {
            return JSTypeUtils.getIndexableComponentType(type);
        }
        return type;
    }

    @NotNull
    protected JSType getAssignmentReducedType(@NotNull JSApplyTypeOperationContext context, @NotNull JSUnionType currentType, @NotNull JSType assignmentType) {
        if (context == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(29);
        }
        if (currentType == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(30);
        }
        if (assignmentType == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(31);
        }
        if (TypeScriptTypeRelations.getCanonicalType(currentType).isEquivalentTo(TypeScriptTypeRelations.getCanonicalType(assignmentType), context.getProcessingContext(), true)) {
            JSUnionType jSUnionType = currentType;
            if (jSUnionType == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(32);
            }
            return jSUnionType;
        }
        if (assignmentType instanceof TypeScriptNeverType) {
            JSType jSType = assignmentType;
            if (jSType == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(33);
            }
            return jSType;
        }
        if (assignmentType instanceof JSAnyType) {
            JSUnionType jSUnionType = currentType;
            if (jSUnionType == null) {
                TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(34);
            }
            return jSUnionType;
        }
        JSType resultType = TypeScriptTypeRelations.filterType(currentType, el -> TypeScriptTypeRelations.typeMaybeAssignableTo(assignmentType, el, context.getProcessingContext()), context.getContextElement());
        JSType jSType = resultType instanceof TypeScriptNeverType ? currentType : resultType;
        if (jSType == null) {
            TypeScriptNarrowTypeByAssignmentOperation.$$$reportNull$$$0(35);
        }
        return jSType;
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.myPrev.toString() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 14, 15, 16, 17, 18, 19, 20, 24, 25, 26, 32, 33, 34, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasInitializer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownInitializer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/TypeScriptNarrowTypeByAssignmentOperation";
                break;
            }
            case 12: 
            case 21: 
            case 23: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/TypeScriptNarrowTypeByAssignmentOperation";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializerDecorators";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "applyWithoutCache";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeDecoratorsImpl";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignmentReducedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInitializerType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyWithoutCache";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeDecoratorsImpl";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "evaluateInitializerType";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentReducedType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 14, 15, 16, 17, 18, 19, 20, 24, 25, 26, 32, 33, 34, 35 -> new IllegalStateException(string);
        };
    }
}

