/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0006\u0010 \u001a\u00020\u0016J&\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001bH\u0002J-\u0010)\u001a\u00020*2\u0006\u0010(\u001a\u00020\u001b2\u000b\u0010+\u001a\u00070,\u00a2\u0006\u0002\b-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00063"}, d2={"Lcom/intellij/diff/tools/simple/SimpleThreesideDiffChange;", "Lcom/intellij/diff/tools/simple/ThreesideDiffChangeBase;", "fragment", "Lcom/intellij/diff/fragments/MergeLineFragment;", "conflictType", "Lcom/intellij/diff/util/MergeConflictType;", "innerFragments", "Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;", "viewer", "Lcom/intellij/diff/tools/simple/SimpleThreesideDiffViewer;", "<init>", "(Lcom/intellij/diff/fragments/MergeLineFragment;Lcom/intellij/diff/util/MergeConflictType;Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;Lcom/intellij/diff/tools/simple/SimpleThreesideDiffViewer;)V", "getInnerFragments", "()Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;", "lineStarts", "", "lineEnds", "value", "", "isValid", "()Z", "reinstallHighlighters", "", "installOperations", "getStartLine", "", "side", "Lcom/intellij/diff/util/ThreeSide;", "getEndLine", "isResolved", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "markInvalid", "processChange", "oldLine1", "oldLine2", "shift", "createAcceptOperation", "Lcom/intellij/diff/util/DiffGutterOperation;", "sourceSide", "modifiedSide", "createIconRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "tooltipText", "", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "icon", "Ljavax/swing/Icon;", "perform", "Ljava/lang/Runnable;", "Companion", "intellij.platform.diff.impl"})
public final class SimpleThreesideDiffChange
extends ThreesideDiffChangeBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final MergeInnerDifferences innerFragments;
    @NotNull
    private final SimpleThreesideDiffViewer viewer;
    @NotNull
    private final int[] lineStarts;
    @NotNull
    private final int[] lineEnds;
    private boolean isValid;

    public SimpleThreesideDiffChange(@NotNull MergeLineFragment fragment, @NotNull MergeConflictType conflictType, @Nullable MergeInnerDifferences innerFragments, @NotNull SimpleThreesideDiffViewer viewer) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)conflictType, (String)"conflictType");
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        super(conflictType);
        this.innerFragments = innerFragments;
        this.viewer = viewer;
        this.lineStarts = new int[3];
        this.lineEnds = new int[3];
        this.isValid = true;
        for (ThreeSide side : ThreeSide.getEntries()) {
            this.lineStarts[side.getIndex()] = fragment.getStartLine(side);
            this.lineEnds[side.getIndex()] = fragment.getEndLine(side);
        }
        this.reinstallHighlighters();
    }

    @Override
    @Nullable
    protected MergeInnerDifferences getInnerFragments() {
        return this.innerFragments;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    @RequiresEdt
    public final void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
        this.destroyOperations();
        this.installOperations();
    }

    @Override
    protected void installOperations() {
        this.operations.add(this.createAcceptOperation(ThreeSide.LEFT, ThreeSide.BASE));
        this.operations.add(this.createAcceptOperation(ThreeSide.RIGHT, ThreeSide.BASE));
        this.operations.add(this.createAcceptOperation(ThreeSide.BASE, ThreeSide.LEFT));
        this.operations.add(this.createAcceptOperation(ThreeSide.BASE, ThreeSide.RIGHT));
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return side.select(this.lineStarts);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return side.select(this.lineEnds);
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return false;
    }

    @Override
    @NotNull
    protected Editor getEditor(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        EditorEx editorEx = this.viewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        return (Editor)editorEx;
    }

    public final void markInvalid() {
        this.isValid = false;
        this.destroyOperations();
    }

    public final boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange updatedLineRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        Intrinsics.checkNotNullExpressionValue((Object)updatedLineRange, (String)"updateRangeOnModification(...)");
        DiffUtil.UpdatedLineRange newRange = updatedLineRange;
        this.lineStarts[sideIndex] = newRange.startLine;
        this.lineEnds[sideIndex] = newRange.endLine;
        return newRange.damaged;
    }

    private final DiffGutterOperation createAcceptOperation(ThreeSide sourceSide, ThreeSide modifiedSide) {
        EditorEx editorEx = this.viewer.getEditor(sourceSide);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        int offset = DiffGutterOperation.lineToOffset((Editor)editor, this.getStartLine(sourceSide));
        return new DiffGutterOperation.Simple((Editor)editor, offset, () -> SimpleThreesideDiffChange.createAcceptOperation$lambda$0(this, modifiedSide, sourceSide));
    }

    private final GutterIconRenderer createIconRenderer(ThreeSide modifiedSide, String tooltipText, Icon icon, Runnable perform) {
        return new DiffGutterRenderer(icon, tooltipText, this, modifiedSide, perform){
            final /* synthetic */ SimpleThreesideDiffChange this$0;
            final /* synthetic */ ThreeSide $modifiedSide;
            final /* synthetic */ Runnable $perform;
            {
                this.this$0 = $receiver;
                this.$modifiedSide = $modifiedSide;
                this.$perform = $perform;
                super($icon, $tooltipText);
            }

            protected void handleMouseClick() {
                if (!this.this$0.isValid()) {
                    return;
                }
                Project project = SimpleThreesideDiffChange.access$getViewer$p(this.this$0).getProject();
                DocumentEx documentEx = SimpleThreesideDiffChange.access$getViewer$p(this.this$0).getEditor(this.$modifiedSide).getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
                Document document = (Document)documentEx;
                DiffUtil.executeWriteCommand(document, project, DiffBundle.message((String)"message.replace.change.command", (Object[])new Object[0]), this.$perform);
            }
        };
    }

    private static final void createAcceptOperation$lambda$0$0(SimpleThreesideDiffChange this$0, ThreeSide $sourceSide, ThreeSide $modifiedSide) {
        this$0.viewer.replaceChange(this$0, $sourceSide, $modifiedSide);
    }

    private static final GutterIconRenderer createAcceptOperation$lambda$0(SimpleThreesideDiffChange this$0, ThreeSide $modifiedSide, ThreeSide $sourceSide) {
        boolean isChanged;
        boolean isOtherEditable = this$0.viewer.isEditable($modifiedSide);
        if (!isOtherEditable) {
            return null;
        }
        boolean bl = isChanged = $sourceSide != ThreeSide.BASE && this$0.isChange($sourceSide) || $modifiedSide != ThreeSide.BASE && this$0.isChange($modifiedSide);
        if (!isChanged) {
            return null;
        }
        String text = Companion.getApplyActionText(this$0.viewer, $sourceSide, $modifiedSide);
        Side arrowDirection = Side.Companion.fromLeft($sourceSide == ThreeSide.LEFT || $modifiedSide == ThreeSide.RIGHT);
        Icon icon = DiffUtil.getArrowIcon(arrowDirection);
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getArrowIcon(...)");
        Icon icon2 = icon;
        return this$0.createIconRenderer($modifiedSide, text, icon2, () -> SimpleThreesideDiffChange.createAcceptOperation$lambda$0$0(this$0, $sourceSide, $modifiedSide));
    }

    @JvmStatic
    @NotNull
    public static final String getApplyActionText(@NotNull DiffViewerBase viewer, @NotNull ThreeSide sourceSide, @NotNull ThreeSide modifiedSide) {
        return Companion.getApplyActionText(viewer, sourceSide, modifiedSide);
    }

    public static final /* synthetic */ SimpleThreesideDiffViewer access$getViewer$p(SimpleThreesideDiffChange $this) {
        return $this.viewer;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/tools/simple/SimpleThreesideDiffChange$Companion;", "", "<init>", "()V", "getApplyActionText", "", "Lorg/jetbrains/annotations/Nls;", "viewer", "Lcom/intellij/diff/tools/util/base/DiffViewerBase;", "sourceSide", "Lcom/intellij/diff/util/ThreeSide;", "modifiedSide", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getApplyActionText(@NotNull DiffViewerBase viewer, @NotNull ThreeSide sourceSide, @NotNull ThreeSide modifiedSide) {
            String customValue;
            Key<String> key;
            Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
            Intrinsics.checkNotNullParameter((Object)sourceSide, (String)"sourceSide");
            Intrinsics.checkNotNullParameter((Object)modifiedSide, (String)"modifiedSide");
            Object object = sourceSide == ThreeSide.BASE && modifiedSide == ThreeSide.LEFT ? DiffUserDataKeysEx.VCS_DIFF_ACCEPT_BASE_TO_LEFT_ACTION_TEXT : (sourceSide == ThreeSide.BASE && modifiedSide == ThreeSide.RIGHT ? DiffUserDataKeysEx.VCS_DIFF_ACCEPT_BASE_TO_RIGHT_ACTION_TEXT : (sourceSide == ThreeSide.LEFT && modifiedSide == ThreeSide.BASE ? DiffUserDataKeysEx.VCS_DIFF_ACCEPT_LEFT_TO_BASE_ACTION_TEXT : (key = sourceSide == ThreeSide.RIGHT && modifiedSide == ThreeSide.BASE ? DiffUserDataKeysEx.VCS_DIFF_ACCEPT_RIGHT_TO_BASE_ACTION_TEXT : null)));
            if (key != null && (customValue = DiffUtil.getUserData((UserDataHolder)viewer.getRequest(), (UserDataHolder)viewer.getContext(), key)) != null) {
                return customValue;
            }
            String string = DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

