/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.side.OnesideContentPanel;
import com.intellij.diff.tools.util.side.ThreesideContentPanel;
import com.intellij.diff.tools.util.side.TwosideContentPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 \u00172\u00020\u0001:\u0007\u0011\u0012\u0013\u0014\u0015\u0016\u0017B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH&J\u001e\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/diff/tools/util/DiffTitleHandler;", "", "disposable", "Lcom/intellij/openapi/Disposable;", "modalityComponent", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/openapi/Disposable;Ljavax/swing/JComponent;)V", "updateAlarm", "Lcom/intellij/util/Alarm;", "scheduleUpdate", "", "updateTitles", "installListener", "contents", "", "Lcom/intellij/diff/contents/DiffContent;", "MyBulkFileListener", "OnesideDiffTitleHandler", "TwosideDiffTitleHandler", "ThreesideDiffTitleHandler", "DiffTitleProvider", "DiffTitlesProvider", "Companion", "intellij.platform.diff.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDiffTitleHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffTitleHandler.kt\ncom/intellij/diff/tools/util/DiffTitleHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1642#2,10:137\n1915#2:147\n1916#2:149\n1652#2:150\n1#3:148\n*S KotlinDebug\n*F\n+ 1 DiffTitleHandler.kt\ncom/intellij/diff/tools/util/DiffTitleHandler\n*L\n40#1:137,10\n40#1:147\n40#1:149\n40#1:150\n40#1:148\n*E\n"})
public abstract class DiffTitleHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JComponent modalityComponent;
    @NotNull
    private final Alarm updateAlarm;

    private DiffTitleHandler(Disposable disposable, JComponent modalityComponent) {
        this.modalityComponent = modalityComponent;
        this.updateAlarm = new Alarm(disposable);
    }

    public final void scheduleUpdate() {
        this.updateAlarm.cancelAllRequests();
        this.updateAlarm.addRequest(() -> DiffTitleHandler.scheduleUpdate$lambda$0(this), 300, ModalityState.stateForComponent((Component)this.modalityComponent));
    }

    public abstract void updateTitles();

    /*
     * WARNING - void declaration
     */
    private final void installListener(List<? extends DiffContent> contents, Disposable disposable) {
        void $this$mapNotNullTo$iv$iv;
        this.updateTitles();
        Iterable $this$mapNotNull$iv = contents;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DiffContent content = (DiffContent)element$iv$iv;
            boolean bl2 = false;
            if ((content instanceof FileContent ? ((FileContent)content).getFile() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List files = (List)destination$iv$iv;
        if (!files.isEmpty()) {
            MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(disposable);
            Topic topic = VirtualFileManager.VFS_CHANGES;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
            messageBusConnection.subscribe(topic, (Object)new MyBulkFileListener(files));
        }
    }

    private static final void scheduleUpdate$lambda$0(DiffTitleHandler this$0) {
        this$0.updateTitles();
    }

    @JvmStatic
    @NotNull
    public static final DiffTitleHandler createHandler(@NotNull DiffTitleProvider provider, @NotNull OnesideContentPanel panel, @NotNull ContentDiffRequest request, @NotNull Disposable disposable) {
        return Companion.createHandler(provider, panel, request, disposable);
    }

    @JvmStatic
    @NotNull
    public static final DiffTitleHandler createHandler(@NotNull DiffTitlesProvider provider, @NotNull TwosideContentPanel panel, @NotNull ContentDiffRequest request, @NotNull Disposable disposable) {
        return Companion.createHandler(provider, panel, request, disposable);
    }

    @JvmStatic
    @NotNull
    public static final DiffTitleHandler createHandler(@NotNull DiffTitlesProvider provider, @NotNull ThreesideContentPanel panel, @NotNull ContentDiffRequest request, @NotNull Disposable disposable) {
        return Companion.createHandler(provider, panel, request, disposable);
    }

    public /* synthetic */ DiffTitleHandler(Disposable disposable, JComponent modalityComponent, DefaultConstructorMarker $constructor_marker) {
        this(disposable, modalityComponent);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diff/tools/util/DiffTitleHandler$Companion;", "", "<init>", "()V", "createHandler", "Lcom/intellij/diff/tools/util/DiffTitleHandler;", "provider", "Lcom/intellij/diff/tools/util/DiffTitleHandler$DiffTitleProvider;", "panel", "Lcom/intellij/diff/tools/util/side/OnesideContentPanel;", "request", "Lcom/intellij/diff/requests/ContentDiffRequest;", "disposable", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/diff/tools/util/DiffTitleHandler$DiffTitlesProvider;", "Lcom/intellij/diff/tools/util/side/TwosideContentPanel;", "Lcom/intellij/diff/tools/util/side/ThreesideContentPanel;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DiffTitleHandler createHandler(@NotNull DiffTitleProvider provider, @NotNull OnesideContentPanel panel, @NotNull ContentDiffRequest request, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            DiffTitleHandler handler = new OnesideDiffTitleHandler(provider, disposable, panel);
            List list = request.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
            handler.installListener(list, disposable);
            return handler;
        }

        @JvmStatic
        @NotNull
        public final DiffTitleHandler createHandler(@NotNull DiffTitlesProvider provider, @NotNull TwosideContentPanel panel, @NotNull ContentDiffRequest request, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            DiffTitleHandler handler = new TwosideDiffTitleHandler(provider, disposable, panel);
            List list = request.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
            handler.installListener(list, disposable);
            return handler;
        }

        @JvmStatic
        @NotNull
        public final DiffTitleHandler createHandler(@NotNull DiffTitlesProvider provider, @NotNull ThreesideContentPanel panel, @NotNull ContentDiffRequest request, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            DiffTitleHandler handler = new ThreesideDiffTitleHandler(provider, disposable, panel);
            List list = request.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
            handler.installListener(list, disposable);
            return handler;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diff/tools/util/DiffTitleHandler$DiffTitleProvider;", "", "createTitle", "Ljavax/swing/JComponent;", "intellij.platform.diff.impl"})
    public static interface DiffTitleProvider {
        @Nullable
        public JComponent createTitle();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diff/tools/util/DiffTitleHandler$DiffTitlesProvider;", "", "createTitles", "", "Ljavax/swing/JComponent;", "intellij.platform.diff.impl"})
    public static interface DiffTitlesProvider {
        @NotNull
        public List<JComponent> createTitles();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diff/tools/util/DiffTitleHandler$MyBulkFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/diff/tools/util/DiffTitleHandler;Ljava/util/List;)V", "after", "", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.platform.diff.impl"})
    private final class MyBulkFileListener
    implements BulkFileListener {
        @NotNull
        private final List<VirtualFile> files;

        public MyBulkFileListener(List<? extends VirtualFile> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            this.files = files;
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            boolean shouldRefresh = false;
            for (VFileEvent vFileEvent : events) {
                VirtualFile file = vFileEvent.getFile();
                if (file == null || !this.files.contains(file)) continue;
                shouldRefresh = true;
                break;
            }
            if (shouldRefresh) {
                DiffTitleHandler.this.scheduleUpdate();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/tools/util/DiffTitleHandler$OnesideDiffTitleHandler;", "Lcom/intellij/diff/tools/util/DiffTitleHandler;", "provider", "Lcom/intellij/diff/tools/util/DiffTitleHandler$DiffTitleProvider;", "disposable", "Lcom/intellij/openapi/Disposable;", "panel", "Lcom/intellij/diff/tools/util/side/OnesideContentPanel;", "<init>", "(Lcom/intellij/diff/tools/util/DiffTitleHandler$DiffTitleProvider;Lcom/intellij/openapi/Disposable;Lcom/intellij/diff/tools/util/side/OnesideContentPanel;)V", "updateTitles", "", "intellij.platform.diff.impl"})
    private static final class OnesideDiffTitleHandler
    extends DiffTitleHandler {
        @NotNull
        private final DiffTitleProvider provider;
        @NotNull
        private final OnesideContentPanel panel;

        public OnesideDiffTitleHandler(@NotNull DiffTitleProvider provider, @NotNull Disposable disposable, @NotNull OnesideContentPanel panel) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            super(disposable, panel, null);
            this.provider = provider;
            this.panel = panel;
        }

        @Override
        public void updateTitles() {
            this.panel.setTitle(this.provider.createTitle());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/tools/util/DiffTitleHandler$ThreesideDiffTitleHandler;", "Lcom/intellij/diff/tools/util/DiffTitleHandler;", "provider", "Lcom/intellij/diff/tools/util/DiffTitleHandler$DiffTitlesProvider;", "disposable", "Lcom/intellij/openapi/Disposable;", "panel", "Lcom/intellij/diff/tools/util/side/ThreesideContentPanel;", "<init>", "(Lcom/intellij/diff/tools/util/DiffTitleHandler$DiffTitlesProvider;Lcom/intellij/openapi/Disposable;Lcom/intellij/diff/tools/util/side/ThreesideContentPanel;)V", "updateTitles", "", "intellij.platform.diff.impl"})
    private static final class ThreesideDiffTitleHandler
    extends DiffTitleHandler {
        @NotNull
        private final DiffTitlesProvider provider;
        @NotNull
        private final ThreesideContentPanel panel;

        public ThreesideDiffTitleHandler(@NotNull DiffTitlesProvider provider, @NotNull Disposable disposable, @NotNull ThreesideContentPanel panel) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            super(disposable, panel, null);
            this.provider = provider;
            this.panel = panel;
        }

        @Override
        public void updateTitles() {
            this.panel.setTitles(this.provider.createTitles());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/tools/util/DiffTitleHandler$TwosideDiffTitleHandler;", "Lcom/intellij/diff/tools/util/DiffTitleHandler;", "provider", "Lcom/intellij/diff/tools/util/DiffTitleHandler$DiffTitlesProvider;", "disposable", "Lcom/intellij/openapi/Disposable;", "panel", "Lcom/intellij/diff/tools/util/side/TwosideContentPanel;", "<init>", "(Lcom/intellij/diff/tools/util/DiffTitleHandler$DiffTitlesProvider;Lcom/intellij/openapi/Disposable;Lcom/intellij/diff/tools/util/side/TwosideContentPanel;)V", "updateTitles", "", "intellij.platform.diff.impl"})
    private static final class TwosideDiffTitleHandler
    extends DiffTitleHandler {
        @NotNull
        private final DiffTitlesProvider provider;
        @NotNull
        private final TwosideContentPanel panel;

        public TwosideDiffTitleHandler(@NotNull DiffTitlesProvider provider, @NotNull Disposable disposable, @NotNull TwosideContentPanel panel) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            super(disposable, panel, null);
            this.provider = provider;
            this.panel = panel;
        }

        @Override
        public void updateTitles() {
            this.panel.setTitles(this.provider.createTitles());
        }
    }
}

